/*
 * Decompiled with CFR 0.152.
 */
package visad.data.mcidas;

import edu.wisc.ssec.mcidas.GridDirectory;
import edu.wisc.ssec.mcidas.McIDASUtil;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import visad.CoordinateSystem;
import visad.data.mcidas.McIDASGridDirectory;

public class McIDASGridReader {
    ArrayList gridH = null;
    ArrayList gridD = null;
    int[] entry;
    RandomAccessFile fn;
    boolean needToSwap = false;

    public ArrayList getGridData(String filename) {
        try {
            this.fn = new RandomAccessFile(filename, "r");
            int numEntries = Math.abs(this.readInt(10));
            if (numEntries > 10000000) {
                this.needToSwap = true;
                numEntries = Math.abs(McIDASUtil.swbyt4(numEntries));
            }
            this.fn.seek(0L);
            int[] fileHeader = new int[8];
            for (int i = 0; i < 8; ++i) {
                fileHeader[i] = this.fn.readInt();
            }
            System.out.println("head=" + McIDASUtil.intBitsToString(fileHeader));
            int project = this.readInt(8);
            int date = this.readInt(9);
            this.entry = new int[numEntries];
            for (int i = 0; i < numEntries; ++i) {
                this.entry[i] = this.readInt(i + 11);
            }
            this.readEntry(0);
        }
        catch (Exception e) {
            System.out.println("exp=" + e);
        }
        return this.gridD;
    }

    private void readEntry(int ent) {
        try {
            int te = this.entry[ent] * 4;
            System.out.println("Entry 0 = " + te);
            int[] gridHeader = new int[64];
            this.fn.seek(te);
            for (int i = 0; i < 64; ++i) {
                gridHeader[i] = this.fn.readInt();
            }
            if (this.needToSwap) {
                this.swapGridHeader(gridHeader);
            }
            McIDASGridDirectory mgd = new McIDASGridDirectory(new GridDirectory(gridHeader));
            System.out.println("grid header =" + mgd.toString());
            CoordinateSystem c = mgd.getCoordinateSystem();
            int rows = mgd.getRows();
            int cols = mgd.getColumns();
            System.out.println("# rows & cols = " + rows + " " + cols);
            double scale = mgd.getParamScale();
            double[] data = new double[rows * cols];
            boolean n = false;
            for (int nc = 0; nc < cols; ++nc) {
                for (int nr = 0; nr < rows; ++nr) {
                    int temp = this.fn.readInt();
                    if (this.needToSwap) {
                        temp = McIDASUtil.swbyt4(temp);
                    }
                    data[(rows - nr - 1) * cols + nc] = temp == -2139062144 ? Double.NaN : (double)temp / scale;
                }
            }
            this.gridH = new ArrayList();
            this.gridD = new ArrayList();
            this.gridH.add(mgd);
            this.gridD.add(data);
        }
        catch (Exception esc) {
            System.out.println(esc);
        }
    }

    private void swapGridHeader(int[] gh) {
        McIDASUtil.flip(gh, 0, 5);
        McIDASUtil.flip(gh, 7, 7);
        McIDASUtil.flip(gh, 9, 10);
        McIDASUtil.flip(gh, 12, 14);
        McIDASUtil.flip(gh, 32, 51);
    }

    public ArrayList getGrid(int index) {
        this.readEntry(index);
        return this.gridD;
    }

    public ArrayList getGridHeaders() {
        return this.gridH;
    }

    public static void main(String[] args) {
        String file = "/src/visad/data/mcidas/GRID1715";
        if (args.length > 0) {
            file = args[0];
        }
        McIDASGridReader mg = new McIDASGridReader();
        mg.getGridData(file);
    }

    private int readInt(int word) throws IOException {
        if (this.fn == null) {
            throw new IOException("no file to read from");
        }
        this.fn.seek(word * 4);
        int idata = this.fn.readInt();
        if (this.needToSwap) {
            idata = McIDASUtil.swbyt4(idata);
        }
        return idata;
    }
}

