/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jdk.nashorn.internal.ir.annotations.Immutable;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionManager;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import thredds.inventory.partition.PartitionManagerFromIndexList;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateTime2D;
import ucar.coord.CoordinateTimeAbstract;
import ucar.nc2.grib.GribIndex;
import ucar.nc2.grib.GribIndexCache;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.GribCollectionMutable;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.util.CloseableIterator;
import ucar.unidata.util.StringUtil2;

abstract class GribCollectionBuilder {
    protected final MCollection dcm;
    protected final Logger logger;
    protected final boolean isGrib1;
    protected GribCollectionImmutable.Type type;
    protected String name;
    protected File directory;

    protected abstract List<? extends Group> makeGroups(List<MFile> var1, boolean var2, Formatter var3) throws IOException;

    protected abstract boolean writeIndex(String var1, String var2, CoordinateRuntime var3, List<? extends Group> var4, List<MFile> var5, CalendarDateRange var6) throws IOException;

    public GribCollectionBuilder(boolean isGrib1, String name, MCollection dcm, Logger logger) {
        this.dcm = dcm;
        this.logger = logger;
        this.isGrib1 = isGrib1;
        this.name = StringUtil2.replace(name, ' ', "_");
        this.directory = new File(dcm.getRoot());
    }

    public boolean updateNeeded(CollectionUpdateType ff) throws IOException {
        if (ff == CollectionUpdateType.never) {
            return false;
        }
        if (ff == CollectionUpdateType.always) {
            return true;
        }
        File collectionIndexFile = GribIndexCache.getExistingFileOrCache(this.dcm.getIndexFilename(".ncx4"));
        if (collectionIndexFile == null) {
            return true;
        }
        if (ff == CollectionUpdateType.nocheck) {
            return false;
        }
        return this.needsUpdate(ff, collectionIndexFile);
    }

    private boolean needsUpdate(CollectionUpdateType ff, File collectionIndexFile) throws IOException {
        long collectionLastModified = collectionIndexFile.lastModified();
        HashSet<String> newFileSet = new HashSet<String>();
        CollectionManager.ChangeChecker cc = GribIndex.getChangeChecker();
        try (CloseableIterator<MFile> iter = this.dcm.getFileIterator();){
            while (iter != null && iter.hasNext()) {
                MFile memberOfCollection = (MFile)iter.next();
                if (cc.hasChangedSince(memberOfCollection, collectionLastModified)) {
                    boolean bl = true;
                    return bl;
                }
                newFileSet.add(memberOfCollection.getPath());
            }
        }
        if (ff == CollectionUpdateType.testIndexOnly) {
            return false;
        }
        GribCdmIndex reader = new GribCdmIndex(this.logger);
        ArrayList<MFile> oldFiles = new ArrayList<MFile>();
        reader.readMFiles(collectionIndexFile.toPath(), oldFiles);
        HashSet<String> oldFileSet = new HashSet<String>();
        for (MFile oldFile : oldFiles) {
            if (!newFileSet.contains(oldFile.getPath())) {
                return true;
            }
            oldFileSet.add(oldFile.getPath());
        }
        for (String newFilename : newFileSet) {
            if (oldFileSet.contains(newFilename)) continue;
            return true;
        }
        return false;
    }

    public boolean createIndex(FeatureCollectionConfig.PartitionType ptype, Formatter errlog) throws IOException {
        if (ptype == FeatureCollectionConfig.PartitionType.all) {
            return this.createAllRuntimeCollections(errlog);
        }
        return this.createMultipleRuntimeCollections(errlog);
    }

    private boolean createMultipleRuntimeCollections(Formatter errlog) throws IOException {
        long start = System.currentTimeMillis();
        ArrayList<MFile> files = new ArrayList<MFile>();
        List<? extends Group> groups = this.makeGroups(files, false, errlog);
        List<MFile> allFiles = Collections.unmodifiableList(files);
        if (allFiles.size() == 0) {
            throw new IllegalStateException("No files in this collection =" + this.name + " topdir=" + this.dcm.getRoot());
        }
        if (groups.size() == 0) {
            throw new IllegalStateException("No records in this collection =" + this.name + " topdir=" + this.dcm.getRoot());
        }
        CalendarDateRange calendarDateRangeAll = null;
        boolean allTimesAreUnique = true;
        HashSet<Long> allRuntimes = new HashSet<Long>();
        for (Group group : groups) {
            for (Long cd : group.getCoordinateRuntimes()) {
                allRuntimes.add(cd);
            }
            for (Coordinate coord : group.getCoordinates()) {
                if (coord instanceof CoordinateTime2D) {
                    CoordinateTime2D coord2D = (CoordinateTime2D)coord;
                    if (allTimesAreUnique) {
                        allTimesAreUnique = coord2D.hasUniqueTimes();
                    }
                }
                if (!(coord instanceof CoordinateTimeAbstract)) continue;
                CalendarDateRange calendarDateRange = ((CoordinateTimeAbstract)coord).makeCalendarDateRange(null);
                if (calendarDateRangeAll == null) {
                    calendarDateRangeAll = calendarDateRange;
                    continue;
                }
                calendarDateRangeAll = calendarDateRangeAll.extend(calendarDateRange);
            }
        }
        ArrayList<Long> sortedList = new ArrayList<Long>();
        for (Long cd : allRuntimes) {
            sortedList.add(cd);
        }
        Collections.sort(sortedList);
        if (sortedList.size() == 0) {
            throw new IllegalArgumentException("No runtimes in this collection =" + this.name);
        }
        this.type = sortedList.size() == 1 ? GribCollectionImmutable.Type.SRC : (allTimesAreUnique ? GribCollectionImmutable.Type.MRUTC : GribCollectionImmutable.Type.MRC);
        CoordinateRuntime coordinateRuntime = new CoordinateRuntime(sortedList, null);
        MFile indexFileForRuntime = GribCollectionMutable.makeIndexMFile(this.name, this.directory);
        boolean ok = this.writeIndex(this.name, indexFileForRuntime.getPath(), coordinateRuntime, groups, allFiles, calendarDateRangeAll);
        long took = System.currentTimeMillis() - start;
        this.logger.debug("That took {} msecs", (Object)took);
        return ok;
    }

    private boolean createAllRuntimeCollections(Formatter errlog) throws IOException {
        long start = System.currentTimeMillis();
        this.type = GribCollectionImmutable.Type.SRC;
        boolean ok = true;
        ArrayList<MFile> files = new ArrayList<MFile>();
        List<? extends Group> groups = this.makeGroups(files, true, errlog);
        List<MFile> allFiles = Collections.unmodifiableList(files);
        HashMap runGroups = new HashMap();
        for (Group group : groups) {
            List runGroup = (List)runGroups.get(group.getRuntime().getMillis());
            if (runGroup == null) {
                runGroup = new ArrayList();
                runGroups.put(group.getRuntime().getMillis(), runGroup);
            }
            runGroup.add(group);
        }
        boolean multipleRuntimes = runGroups.values().size() > 1;
        ArrayList<MFile> arrayList = new ArrayList<MFile>();
        for (List runGroupList : runGroups.values()) {
            Group g = (Group)runGroupList.get(0);
            String gcname = multipleRuntimes ? GribCollectionMutable.makeName(this.name, g.getRuntime()) : this.name;
            MFile indexFileForRuntime = GribCollectionMutable.makeIndexMFile(gcname, this.directory);
            arrayList.add(indexFileForRuntime);
            ArrayList<Long> runtimes = new ArrayList<Long>(1);
            runtimes.add(g.getRuntime().getMillis());
            CoordinateRuntime masterRuntimes = new CoordinateRuntime(runtimes, null);
            CalendarDateRange calendarDateRangeAll = null;
            for (Coordinate coord : g.getCoordinates()) {
                if (!(coord instanceof CoordinateTimeAbstract)) continue;
                CalendarDateRange calendarDateRange = ((CoordinateTimeAbstract)coord).makeCalendarDateRange(null);
                if (calendarDateRangeAll == null) {
                    calendarDateRangeAll = calendarDateRange;
                    continue;
                }
                calendarDateRangeAll = calendarDateRangeAll.extend(calendarDateRange);
            }
            assert (calendarDateRangeAll != null);
            this.logger.info("GribCollectionBuilder write {} ok={}", (Object)indexFileForRuntime.getPath(), (Object)(ok &= this.writeIndex(gcname, indexFileForRuntime.getPath(), masterRuntimes, runGroupList, allFiles, calendarDateRangeAll)));
        }
        if (multipleRuntimes) {
            Collections.sort(arrayList);
            PartitionManagerFromIndexList part = new PartitionManagerFromIndexList(this.dcm, arrayList, this.logger);
            part.putAuxInfo("fcConfig", this.dcm.getAuxInfo("fcConfig"));
            ok &= GribCdmIndex.updateGribCollectionFromPCollection(this.isGrib1, part, CollectionUpdateType.always, errlog, this.logger);
        }
        long took = System.currentTimeMillis() - start;
        this.logger.debug("That took {} msecs", (Object)took);
        return ok;
    }

    @Immutable
    protected static class GroupAndRuntime {
        private final int hashCode;
        private final long runtime;

        GroupAndRuntime(int hashCode, long runtime) {
            this.hashCode = hashCode;
            this.runtime = runtime;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupAndRuntime that = (GroupAndRuntime)o;
            if (this.hashCode != that.hashCode) {
                return false;
            }
            return this.runtime == that.runtime;
        }

        public int hashCode() {
            int result = this.hashCode;
            result = 31 * result + (int)(this.runtime ^ this.runtime >>> 32);
            return result;
        }
    }

    public static interface Group {
        public CalendarDate getRuntime();

        public List<Coordinate> getCoordinates();

        public Set<Long> getCoordinateRuntimes();
    }
}

