/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.VariableIF;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.MultilineTooltip;

public class DatasetTreeView
extends JPanel {
    private JTree tree = new JTree(){

        @Override
        public JToolTip createToolTip() {
            return new MultilineTooltip();
        }
    };
    private DatasetTreeModel model;
    private NetcdfFile currentDataset = null;
    private boolean debugTree = false;

    public DatasetTreeView() {
        this.tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(null, false)));
        this.tree.setCellRenderer(new MyTreeCellRenderer());
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TreeNode node;
                int selRow = DatasetTreeView.this.tree.getRowForLocation(e.getX(), e.getY());
                if (selRow != -1 && (node = (TreeNode)DatasetTreeView.this.tree.getLastSelectedPathComponent()) instanceof VariableNode) {
                    VariableIF v = ((VariableNode)node).var;
                    DatasetTreeView.this.firePropertyChangeEvent(new PropertyChangeEvent(this, "Selection", null, v));
                }
                if (selRow == -1 || e.getClickCount() == 2) {
                    // empty if block
                }
            }
        });
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setToggleClickCount(1);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.tree), "Center");
    }

    private void firePropertyChangeEvent(PropertyChangeEvent event) {
        this.firePropertyChange(event.getPropertyName(), event.getOldValue(), event.getNewValue());
    }

    public void setFile(NetcdfFile ds) {
        if (ds != this.currentDataset) {
            this.currentDataset = ds;
            this.model = new DatasetTreeModel(ds);
            this.tree.setModel(this.model);
        }
    }

    public void clear() {
        this.currentDataset = null;
        this.model = null;
        this.tree.setModel(null);
    }

    public void setSelected(VariableIF v) {
        if (v == null) {
            return;
        }
        ArrayList<VariableIF> vchain = new ArrayList<VariableIF>();
        vchain.add(v);
        VariableIF vp = v;
        while (vp.isMemberOfStructure()) {
            vp = vp.getParentStructure();
            vchain.add(0, vp);
        }
        ArrayList<Group> gchain = new ArrayList<Group>();
        Group gp = vp.getParentGroup();
        gchain.add(gp);
        while (gp.getParentGroup() != null) {
            gp = gp.getParentGroup();
            gchain.add(0, gp);
        }
        ArrayList<TreeNode> pathList = new ArrayList<TreeNode>();
        GroupNode gnode = (GroupNode)this.model.getRoot();
        pathList.add(gnode);
        Group parentGroup = (Group)gchain.get(0);
        for (int i = 1; i < gchain.size(); ++i) {
            parentGroup = (Group)gchain.get(i);
            gnode = gnode.findNestedGroup(parentGroup);
            assert (gnode != null);
            pathList.add(gnode);
        }
        vp = (VariableIF)vchain.get(0);
        VariableNode vnode = gnode.findNestedVariable(vp);
        if (vnode == null) {
            return;
        }
        pathList.add(vnode);
        for (int i = 1; i < vchain.size(); ++i) {
            vp = (VariableIF)vchain.get(i);
            if ((vnode = vnode.findNestedVariable(vp)) == null) {
                return;
            }
            pathList.add(vnode);
        }
        Object[] paths = pathList.toArray();
        TreePath treePath = new TreePath(paths);
        this.tree.setSelectionPath(treePath);
        this.tree.scrollPathToVisible(treePath);
    }

    private static class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon structIcon = BAMutil.getIcon("Structure", true);
        ImageIcon dimIcon = BAMutil.getIcon("Dimension", true);
        String tooltipText = null;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof VariableNode) {
                VariableNode node = (VariableNode)value;
                this.tooltipText = node.getToolTipText();
                if (node.var instanceof Structure) {
                    Structure s = (Structure)node.var;
                    this.setIcon(this.structIcon);
                    this.tooltipText = s.getNameAndAttributes();
                } else {
                    this.tooltipText = node.getToolTipText();
                }
            } else if (value instanceof DimensionNode) {
                DimensionNode node = (DimensionNode)value;
                this.tooltipText = node.getToolTipText();
                this.setIcon(this.dimIcon);
            } else if (value instanceof GroupNode) {
                GroupNode node = (GroupNode)value;
                this.tooltipText = node.getToolTipText();
            }
            return c;
        }

        @Override
        public String getToolTipText() {
            return this.tooltipText;
        }
    }

    private static class DimensionNode
    implements TreeNode {
        private Dimension d;
        private TreeNode parent;

        DimensionNode(TreeNode parent, Dimension d) {
            this.parent = parent;
            this.d = d;
        }

        public Enumeration children() {
            return null;
        }

        @Override
        public boolean getAllowsChildren() {
            return false;
        }

        @Override
        public TreeNode getChildAt(int index) {
            return null;
        }

        @Override
        public int getChildCount() {
            return 0;
        }

        @Override
        public int getIndex(TreeNode child) {
            return 0;
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        public String toString() {
            return this.d.getShortName();
        }

        public String getToolTipText() {
            return this.d.toString();
        }
    }

    private class VariableNode
    implements TreeNode {
        private VariableIF var;
        private TreeNode parent;
        private List<Object> children = null;

        VariableNode(TreeNode parent, VariableIF var) {
            this.parent = parent;
            this.var = var;
            if (DatasetTreeView.this.debugTree) {
                System.out.println("new var=" + var.getShortName() + " ");
            }
        }

        public Enumeration children() {
            if (this.children == null) {
                this.makeChildren();
            }
            return Collections.enumeration(this.children);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public TreeNode getChildAt(int index) {
            return (TreeNode)this.children.get(index);
        }

        @Override
        public int getChildCount() {
            if (this.children == null) {
                this.makeChildren();
            }
            return this.children.size();
        }

        void makeChildren() {
            this.children = new ArrayList<Object>();
            if (this.var instanceof Structure) {
                Structure s = (Structure)this.var;
                List<Variable> vars = s.getVariables();
                for (int i = 0; i < vars.size(); ++i) {
                    this.children.add(new VariableNode(this, vars.get(i)));
                }
            }
            if (DatasetTreeView.this.debugTree) {
                System.out.println("children=" + this.var.getShortName() + " ");
            }
        }

        @Override
        public int getIndex(TreeNode child) {
            if (DatasetTreeView.this.debugTree) {
                System.out.println("getIndex=" + this.var.getShortName() + " " + child);
            }
            return this.children.indexOf(child);
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public boolean isLeaf() {
            return this.getChildCount() == 0;
        }

        public String toString() {
            return this.var.getShortName();
        }

        public VariableNode findNestedVariable(VariableIF v) {
            if (this.children == null) {
                this.makeChildren();
            }
            for (int i = 0; i < this.children.size(); ++i) {
                VariableNode elem = (VariableNode)this.children.get(i);
                if (elem.var != v) continue;
                return elem;
            }
            return null;
        }

        public String getToolTipText() {
            return this.var.toString();
        }
    }

    private class GroupNode
    implements TreeNode {
        private Group group;
        private GroupNode parent;
        private List<Object> children = null;

        GroupNode(GroupNode parent, Group group) {
            this.parent = parent;
            this.group = group;
            if (DatasetTreeView.this.debugTree) {
                System.out.println("new=" + group.getFullName() + " ");
            }
        }

        public Enumeration children() {
            if (this.children == null) {
                this.makeChildren();
            }
            return Collections.enumeration(this.children);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public TreeNode getChildAt(int index) {
            return (TreeNode)this.children.get(index);
        }

        @Override
        public int getChildCount() {
            if (this.children == null) {
                this.makeChildren();
            }
            return this.children.size();
        }

        void makeChildren() {
            this.children = new ArrayList<Object>();
            List<Dimension> dims = this.group.getDimensions();
            for (int i = 0; i < dims.size(); ++i) {
                this.children.add(new DimensionNode(this, dims.get(i)));
            }
            List<Variable> vars = this.group.getVariables();
            for (int i = 0; i < vars.size(); ++i) {
                this.children.add(new VariableNode(this, vars.get(i)));
            }
            List<Group> groups = this.group.getGroups();
            for (int i = 0; i < groups.size(); ++i) {
                this.children.add(new GroupNode(this, groups.get(i)));
            }
            if (DatasetTreeView.this.debugTree) {
                System.out.println("children=" + this.group.getFullName() + " ");
            }
        }

        @Override
        public int getIndex(TreeNode child) {
            if (DatasetTreeView.this.debugTree) {
                System.out.println("getIndex=" + this.group.getFullName() + " " + child);
            }
            return this.children.indexOf(child);
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        public String toString() {
            if (this.parent == null) {
                return DatasetTreeView.this.currentDataset.getLocation();
            }
            return this.group.getShortName();
        }

        public GroupNode findNestedGroup(Group g) {
            if (this.children == null) {
                this.makeChildren();
            }
            for (int i = 0; i < this.children.size(); ++i) {
                if (!(this.children.get(i) instanceof GroupNode)) continue;
                GroupNode elem = (GroupNode)this.children.get(i);
                if (elem.group != g) continue;
                return elem;
            }
            return null;
        }

        public VariableNode findNestedVariable(VariableIF v) {
            if (this.children == null) {
                this.makeChildren();
            }
            for (int i = 0; i < this.children.size(); ++i) {
                VariableNode vnode;
                TreeNode node = (TreeNode)this.children.get(i);
                if (!(node instanceof VariableNode) || (vnode = (VariableNode)node).var != v) continue;
                return vnode;
            }
            return null;
        }

        public String getToolTipText() {
            return this.group.getNameAndAttributes();
        }
    }

    private class DatasetTreeModel
    extends DefaultTreeModel {
        DatasetTreeModel(NetcdfFile file) {
            super(new GroupNode(null, file.getRootGroup()), false);
        }
    }
}

