/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.nc2.ft2.scan.FeatureScan;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTable;

public class FeatureScanPanel
extends JPanel {
    private PreferencesExt prefs;
    private BeanTable ftTable;
    private JSplitPane split;
    private TextHistoryPane dumpTA;
    private IndependentWindow infoWindow;

    public FeatureScanPanel(PreferencesExt prefs) {
        this.prefs = prefs;
        this.ftTable = new BeanTable(FeatureScan.Bean.class, (PreferencesExt)prefs.node("FeatureDatasetBeans"), false);
        this.ftTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FeatureScan.Bean ftb = (FeatureScan.Bean)FeatureScanPanel.this.ftTable.getSelectedBean();
                FeatureScanPanel.this.setSelectedFeatureDataset(ftb);
            }
        });
        PopupMenu varPopup = new PopupMenu(this.ftTable.getJTable(), "Options");
        varPopup.addAction("Open as NetcdfFile", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureScan.Bean ftb = (FeatureScan.Bean)FeatureScanPanel.this.ftTable.getSelectedBean();
                if (ftb == null) {
                    return;
                }
                FeatureScanPanel.this.firePropertyChange("openNetcdfFile", null, ftb.f.getPath());
            }
        });
        varPopup.addAction("Open in CoordSystems", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureScan.Bean ftb = (FeatureScan.Bean)FeatureScanPanel.this.ftTable.getSelectedBean();
                if (ftb == null) {
                    return;
                }
                FeatureScanPanel.this.firePropertyChange("openCoordSystems", null, ftb.f.getPath());
            }
        });
        varPopup.addAction("Open as PointDataset", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureScan.Bean ftb = (FeatureScan.Bean)FeatureScanPanel.this.ftTable.getSelectedBean();
                if (ftb == null) {
                    return;
                }
                FeatureScanPanel.this.firePropertyChange("openPointFeatureDataset", null, ftb.f.getPath());
            }
        });
        varPopup.addAction("Open as NcML", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureScan.Bean ftb = (FeatureScan.Bean)FeatureScanPanel.this.ftTable.getSelectedBean();
                if (ftb == null) {
                    return;
                }
                FeatureScanPanel.this.firePropertyChange("openNcML", null, ftb.f.getPath());
            }
        });
        varPopup.addAction("Open as GridDataset", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureScan.Bean ftb = (FeatureScan.Bean)FeatureScanPanel.this.ftTable.getSelectedBean();
                if (ftb == null) {
                    return;
                }
                FeatureScanPanel.this.firePropertyChange("openGridDataset", null, ftb.f.getPath());
            }
        });
        varPopup.addAction("Open as CoverageDataset", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureScan.Bean ftb = (FeatureScan.Bean)FeatureScanPanel.this.ftTable.getSelectedBean();
                if (ftb == null) {
                    return;
                }
                FeatureScanPanel.this.firePropertyChange("openCoverageDataset", null, ftb.f.getPath());
            }
        });
        varPopup.addAction("Open as RadialDataset", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureScan.Bean ftb = (FeatureScan.Bean)FeatureScanPanel.this.ftTable.getSelectedBean();
                if (ftb == null) {
                    return;
                }
                FeatureScanPanel.this.firePropertyChange("openRadialDataset", null, ftb.f.getPath());
            }
        });
        varPopup.addAction("Show Report on selected rows", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List selected = FeatureScanPanel.this.ftTable.getSelectedBeans();
                Formatter f = new Formatter();
                for (FeatureScan.Bean bean : selected) {
                    bean.toString(f, false);
                }
                FeatureScanPanel.this.dumpTA.setText(f.toString());
            }
        });
        varPopup.addAction("Run Coverage Classifier", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureScan.Bean ftb = (FeatureScan.Bean)FeatureScanPanel.this.ftTable.getSelectedBean();
                if (ftb == null) {
                    return;
                }
                FeatureScanPanel.this.dumpTA.setText(ftb.runClassifier());
            }
        });
        TextHistoryPane infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.dumpTA = new TextHistoryPane();
        this.split = new JSplitPane(0, false, this.ftTable, this.dumpTA);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    public PreferencesExt getPrefs() {
        return this.prefs;
    }

    public void save() {
        this.ftTable.saveState(false);
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
    }

    public void clear() {
        this.ftTable.setBeans(new ArrayList());
    }

    public boolean setScanDirectory(String dirName) {
        this.clear();
        FeatureScan scanner = new FeatureScan(dirName, true);
        Formatter errlog = new Formatter();
        List<FeatureScan.Bean> beans = scanner.scan(errlog);
        if (beans.size() == 0) {
            this.dumpTA.setText(errlog.toString());
            return false;
        }
        this.ftTable.setBeans(beans);
        return true;
    }

    private void setSelectedFeatureDataset(FeatureScan.Bean ftb) {
        this.dumpTA.setText(ftb.toString());
        this.dumpTA.gotoTop();
    }
}

