/*
 * Decompiled with CFR 0.152.
 */
package visad.cluster;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.ConstantMap;
import visad.Data;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded1DDoubleSet;
import visad.Gridded2DSet;
import visad.GriddedSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.RemoteDataReferenceImpl;
import visad.ScalarMap;
import visad.Set;
import visad.Tuple;
import visad.TupleType;
import visad.UnionSet;
import visad.Unit;
import visad.VisADException;
import visad.data.mcidas.BaseMapAdapter;
import visad.data.netcdf.Plain;
import visad.java3d.DisplayImplJ3D;
import visad.util.AnimationWidget;

public class TestROMS {
    private RemoteDataReferenceImpl remote_ref = null;

    public TestROMS(String[] args) throws VisADException, RemoteException, IOException {
        Plain plain;
        Tuple grid_file;
        if (args == null || args.length < 2) {
            System.out.println("usage: 'java visad.cluster.TestROMS grid_file history_file'");
        }
        if ((grid_file = (Tuple)(plain = new Plain()).open(args[0])) == null) {
            System.out.println("cannot open " + args[0]);
            return;
        }
        Tuple history_file = (Tuple)plain.open(args[1]);
        if (history_file == null) {
            System.out.println("cannot open " + args[1]);
            return;
        }
        FlatField rho_ff = (FlatField)grid_file.getComponent(16);
        float[][] rho_floats = rho_ff.getFloats(false);
        float[][] rho_latlon = new float[][]{rho_floats[8], rho_floats[9]};
        int n = rho_latlon[1].length;
        int[] rho_lengths = ((GriddedSet)rho_ff.getDomainSet()).getLengths();
        rho_ff = null;
        rho_floats = null;
        FlatField psi_ff = (FlatField)grid_file.getComponent(17);
        float[][] psi_floats = psi_ff.getFloats(false);
        float[][] psi_latlon = new float[][]{psi_floats[2], psi_floats[3]};
        int[] psi_lengths = ((GriddedSet)psi_ff.getDomainSet()).getLengths();
        psi_ff = null;
        psi_floats = null;
        FlatField u_ff = (FlatField)grid_file.getComponent(18);
        float[][] u_floats = u_ff.getFloats(false);
        float[][] u_latlon = new float[][]{u_floats[2], u_floats[3]};
        int[] u_lengths = ((GriddedSet)u_ff.getDomainSet()).getLengths();
        u_ff = null;
        u_floats = null;
        FlatField v_ff = (FlatField)grid_file.getComponent(19);
        float[][] v_floats = v_ff.getFloats(false);
        float[][] v_latlon = new float[][]{v_floats[2], v_floats[3]};
        int[] v_lengths = ((GriddedSet)v_ff.getDomainSet()).getLengths();
        v_ff = null;
        v_floats = null;
        grid_file = null;
        FieldImpl t1 = (FieldImpl)history_file.getComponent(31);
        Set time_set = t1.getDomainSet();
        int ntimes = time_set.getLength();
        System.out.println("ntimes = " + ntimes);
        FunctionType t1type = (FunctionType)t1.getType();
        RealType time = (RealType)t1type.getDomain().getComponent(0);
        TupleType t1range = (TupleType)t1type.getRange();
        FunctionType grid_type = (FunctionType)t1range.getComponent(1);
        RealType zeta = (RealType)grid_type.getRange();
        RealTupleType grid_domain = grid_type.getDomain();
        RealType xi_rho = (RealType)grid_domain.getComponent(0);
        RealType eta_rho = (RealType)grid_domain.getComponent(1);
        RealTupleType latlon_type = RealTupleType.LatitudeLongitudeTuple;
        FunctionType grid_latlon_type = new FunctionType(latlon_type, zeta);
        FunctionType history_type = new FunctionType(time, grid_latlon_type);
        Real[] ocean_times = new Real[ntimes];
        double[][] times = new double[1][ntimes];
        for (int itime = 0; itime < ntimes; ++itime) {
            Tuple t1tuple = (Tuple)t1.getSample(itime);
            ocean_times[itime] = (Real)t1tuple.getComponent(0);
            times[0][itime] = ocean_times[itime].getValue();
        }
        Unit[] tunits = new Unit[]{ocean_times[0].getUnit()};
        Gridded1DDoubleSet dset = new Gridded1DDoubleSet((MathType)time, times, ntimes, null, tunits, null, false);
        FieldImpl history = new FieldImpl(history_type, dset);
        Gridded2DSet grid_set = new Gridded2DSet(latlon_type, rho_latlon, rho_lengths[0], rho_lengths[1], null, null, null, false, false);
        for (int itime = 0; itime < ntimes; ++itime) {
            Tuple t1tuple = (Tuple)t1.getSample(itime);
            Real ocean_time = (Real)t1tuple.getComponent(0);
            FlatField grid = (FlatField)t1tuple.getComponent(1);
            FlatField grid_latlon = new FlatField(grid_latlon_type, grid_set);
            grid_latlon.setSamples(grid.getFloats(false), false);
            history.setSample(itime, (Data)grid_latlon);
        }
        DisplayImplJ3D display = new DisplayImplJ3D("TestROMS");
        ScalarMap tmap = new ScalarMap(time, Display.Animation);
        display.addMap(tmap);
        ScalarMap xmap = new ScalarMap(RealType.Longitude, Display.XAxis);
        display.addMap(xmap);
        xmap.setRange(160.0, 245.0);
        ScalarMap ymap = new ScalarMap(RealType.Latitude, Display.YAxis);
        display.addMap(ymap);
        ymap.setRange(20.0, 80.0);
        ScalarMap zmap = new ScalarMap(zeta, Display.ZAxis);
        display.addMap(zmap);
        ScalarMap rgbmap = new ScalarMap(zeta, Display.RGB);
        display.addMap(rgbmap);
        GraphicsModeControl mode = ((DisplayImpl)display).getGraphicsModeControl();
        mode.setScaleEnable(true);
        mode.setTextureEnable(false);
        mode.setProjectionPolicy(0);
        BaseMapAdapter baseMapAdapter = new BaseMapAdapter("OUTLSUPW");
        UnionSet map = baseMapAdapter.getData();
        DataReferenceImpl maplinesRef = new DataReferenceImpl("MapLines");
        maplinesRef.setData(map);
        ConstantMap[] maplinesConstantMap = new ConstantMap[]{new ConstantMap(0.4, Display.ZAxis)};
        display.addReference(maplinesRef, maplinesConstantMap);
        DataReferenceImpl dr = new DataReferenceImpl("history");
        dr.setData(history);
        display.addReference(dr);
        JFrame frame = new JFrame("TestROMS");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        frame.getContentPane().add(panel);
        panel.add(display.getComponent());
        panel.add(new AnimationWidget(tmap, 1000));
        frame.setSize(600, 900);
        frame.setVisible(true);
    }

    public static void main(String[] args) throws RemoteException, VisADException, IOException {
        TestROMS roms = new TestROMS(args);
    }
}

