/*
 * Decompiled with CFR 0.152.
 */
package visad.ss;

import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.StubNotFoundException;
import java.rmi.UnmarshalException;
import java.rmi.registry.LocateRegistry;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import visad.CellImpl;
import visad.Data;
import visad.DataImpl;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayEvent;
import visad.DisplayImpl;
import visad.DisplayListener;
import visad.MathType;
import visad.ProjectionControl;
import visad.Real;
import visad.RealTuple;
import visad.RemoteCellImpl;
import visad.RemoteDataReference;
import visad.RemoteDataReferenceImpl;
import visad.RemoteServer;
import visad.RemoteServerImpl;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleIface;
import visad.TupleType;
import visad.VisADException;
import visad.data.Form;
import visad.data.netcdf.Plain;
import visad.data.tiff.TiffForm;
import visad.data.visad.VisADForm;
import visad.formula.FormulaManager;
import visad.formula.FormulaVar;
import visad.ss.BasicSSCell;
import visad.ss.FancySSCell;
import visad.ss.MappingDialog;
import visad.ss.SSCellChangeEvent;
import visad.ss.SSCellListener;
import visad.ss.SSLayout;
import visad.util.ExtensionFileFilter;
import visad.util.GUIFrame;
import visad.util.Util;

public class SpreadSheet
extends GUIFrame
implements AdjustmentListener,
DisplayListener,
KeyListener,
ItemListener,
MouseListener,
MouseMotionListener,
SSCellListener {
    protected static final int WIDTH_PERCENT = 60;
    protected static final int HEIGHT_PERCENT = 80;
    protected static final int MIN_VIS_WIDTH = 120;
    protected static final int MIN_VIS_HEIGHT = 120;
    protected static final int DEFAULT_VIS_WIDTH = 250;
    protected static final int DEFAULT_VIS_HEIGHT = 250;
    protected static final String Letters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    protected static final int LABEL_WIDTH = 30;
    protected static final int LABEL_HEIGHT = 20;
    protected static final boolean SHOW_CONNECT_MESSAGES = true;
    protected static final String SSFileHeader = "# VisAD Visualization SpreadSheet spreadsheet file";
    protected static final Class[] cellArgs = new Class[]{String.class, FormulaManager.class, RemoteServer.class, Boolean.TYPE, String.class, Frame.class};
    protected static Constructor cellConstructor;
    protected static boolean Possible3D;
    protected static boolean CanDo3D;
    protected static boolean CanDoHDF5;
    protected static boolean CanDoJPEG;
    protected static boolean CanDoPython;
    protected static boolean BugFix;
    protected JFileChooser SSFileDialog;
    protected String bTitle;
    protected int NumVisX;
    protected int NumVisY;
    protected FormulaManager fm;
    protected String serverName;
    protected String cloneAddress;
    protected RemoteServerImpl rsi = null;
    protected boolean IsRemote = false;
    protected boolean IsSlave = false;
    protected double CollabID = 0.0;
    protected RemoteDataReference RemoteColRow;
    protected RemoteDataReference RemoteCanDo3D;
    protected boolean AutoSwitch = true;
    protected boolean AutoDetect = true;
    protected boolean AutoShowControls = true;
    protected Panel DisplayPanel;
    protected JPanel ScrollPanel;
    protected ScrollPane SCPane;
    protected JViewport HorizLabels;
    protected JViewport VertLabels;
    protected JPanel[] HorizLabel;
    protected JPanel[] VertLabel;
    protected JComponent[] HorizDrag;
    protected JComponent[] VertDrag;
    protected JPanel HorizPanel;
    protected JPanel VertPanel;
    protected FancySSCell[][] DisplayCells = null;
    protected JComboBox FormulaBox;
    protected ComboBoxEditor FormulaEditor;
    protected JTextField FormulaText;
    protected ActionListener FormulaListener;
    protected JToolBar Toolbar;
    protected JMenu FileExport;
    protected JMenuItem FileSave1;
    protected JMenuItem FileSave2;
    protected JMenuItem FileSave3;
    protected JMenuItem FileSave4;
    protected JMenuItem FileSave5;
    protected JMenuItem FileSnap;
    protected JMenuItem EditPaste;
    protected JMenuItem EditClear;
    protected JMenuItem CellDel;
    protected JMenuItem CellPrint;
    protected JMenuItem CellEdit;
    protected JMenuItem CellReset;
    protected JMenuItem CellShow;
    protected JMenuItem LayAddCol;
    protected JMenuItem LayDelCol;
    protected JMenuItem LayDelRow;
    protected JCheckBoxMenuItem CellDim3D3D;
    protected JCheckBoxMenuItem CellDim2D2D;
    protected JCheckBoxMenuItem CellDim2D3D;
    protected JCheckBoxMenuItem AutoSwitchBox;
    protected JCheckBoxMenuItem AutoDetectBox;
    protected JCheckBoxMenuItem AutoShowBox;
    protected JButton ToolSave;
    protected JButton ToolPaste;
    protected JButton Tool3D;
    protected JButton Tool2D;
    protected JButton ToolJ2D;
    protected JButton ToolMap;
    protected JButton ToolShow;
    protected JButton ToolReset;
    protected JButton FormulaAdd;
    protected JButton FormulaDel;
    protected int CurX = 0;
    protected int CurY = 0;
    protected String Clipboard = null;
    protected File CurrentFile = null;
    protected Object Lock = new Object();
    private static double[] matrix3D;
    private static double[] matrix2D;
    private static double[] matrixJ2D;
    private boolean commandKey;
    private boolean shiftHeld;
    private int oldX;
    private int oldY;

    public static void snooze(long ms) {
        block2: {
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException exc) {
                if (!BasicSSCell.DEBUG) break block2;
                exc.printStackTrace();
            }
        }
    }

    public static void main(String[] argv) {
        String usage = "\nUsage: java [-mx###m] visad.ss.SpreadSheet [cols rows]\n       [-file filename] [-gui] [-no3d] [-debug] [-bugfix]\n       [-server name] [-client address] [-slave address]\n\n###\n     Maximum megabytes of memory to use.\ncols\n     Number of columns in this SpreadSheet.\nrows\n     Number of rows in this SpreadSheet.\n-file filename\n     Load the given filename at launch. If file is a\n     spreadsheet file, the layout is configured accordingly.\n     If file is data, it is loaded into cell A1.\n-gui\n     Pop up an options window so that the user can\n     select SpreadSheet settings graphically.\n-no3d\n     Disable Java3D.\n-debug\n     Print stack traces for all errors.\n-bugfix\n     Disable toolbar. For some systems, will prevent\n     lockups on spreadsheet start.\n-server name\n     Initialize this SpreadSheet as an RMI server\n     with the given name.\n-client address\n     Initialize this SpreadSheet as a clone of\n     the server at the given RMI address.\n-slave address\n     Initialize this SpreadSheet as a slaved clone\n     of the server at the given RMI address.";
        int cols = 2;
        int rows = 2;
        String dfile = null;
        String servname = null;
        String clonename = null;
        boolean guiOptions = false;
        int len = argv.length;
        if (len > 0) {
            for (int ix = 0; ix < len; ++ix) {
                if (argv[ix].charAt(0) == '-') {
                    if (argv[ix].equals("-file")) {
                        if (ix >= len - 1) continue;
                        dfile = argv[++ix];
                        continue;
                    }
                    if (argv[ix].equals("-server")) {
                        if (clonename != null) {
                            System.out.println("A spreadsheet cannot be both a server and a clone!");
                            System.out.println(usage);
                            System.exit(3);
                            continue;
                        }
                        if (ix < len - 1) {
                            servname = argv[++ix];
                            continue;
                        }
                        System.out.println("You must specify a server name after the '-server' flag!");
                        System.out.println(usage);
                        System.exit(4);
                        continue;
                    }
                    if (argv[ix].equals("-client") || argv[ix].equals("-slave")) {
                        if (servname != null) {
                            System.out.println("A spreadsheet cannot be both a server and a clone!");
                            System.out.println(usage);
                            System.exit(3);
                            continue;
                        }
                        if (ix < len - 1) {
                            clonename = argv[ix + 1];
                            if (argv[ix].equals("-slave")) {
                                clonename = "slave:" + clonename;
                            }
                            ++ix;
                            continue;
                        }
                        System.out.println("You must specify a server after the '" + argv[ix] + "' flag!");
                        System.out.println(usage);
                        System.exit(5);
                        continue;
                    }
                    if (argv[ix].equals("-gui")) {
                        guiOptions = true;
                        continue;
                    }
                    if (argv[ix].equals("-bugfix")) {
                        BugFix = true;
                        continue;
                    }
                    if (argv[ix].equals("-no3d")) {
                        BasicSSCell.disable3D();
                        continue;
                    }
                    if (argv[ix].equals("-debug")) {
                        BasicSSCell.DEBUG = true;
                        FormulaVar.DEBUG = true;
                        continue;
                    }
                    if (!argv[ix].equals("-help")) {
                        System.out.println("Unknown option: " + argv[ix]);
                    }
                    System.out.println(usage);
                    System.exit(1);
                    continue;
                }
                boolean success = true;
                if (ix < len - 1) {
                    try {
                        cols = Integer.parseInt(argv[ix]);
                        rows = Integer.parseInt(argv[ix + 1]);
                        ++ix;
                        if (rows < 1 || cols < 1 || cols > Letters.length()) {
                            success = false;
                        }
                    }
                    catch (NumberFormatException exc) {
                        success = false;
                    }
                    if (success) continue;
                    System.out.println("Invalid number of columns and rows: " + argv[ix] + " x " + argv[ix + 1]);
                    System.out.println(usage);
                    System.exit(2);
                    continue;
                }
                System.out.println("Unknown option: " + argv[ix]);
                System.out.println(usage);
                System.exit(1);
            }
        }
        final SpreadSheet ss = new SpreadSheet(60, 80, cols, rows, servname, clonename, "VisAD SpreadSheet", null, guiOptions);
        if (dfile != null) {
            File f = new File(dfile);
            String line = null;
            try {
                BufferedReader fin = new BufferedReader(new FileReader(f));
                line = fin.readLine();
                fin.close();
            }
            catch (IOException exc) {
                if (BasicSSCell.DEBUG) {
                    exc.printStackTrace();
                }
                System.out.println("Could not read file " + dfile);
            }
            if (line != null) {
                final boolean ssfile = line.equals(SSFileHeader);
                final String filename = dfile;
                Util.invoke(false, BasicSSCell.DEBUG, new Runnable(){

                    public void run() {
                        try {
                            if (ssfile) {
                                ss.openFile(filename);
                            } else {
                                ss.DisplayCells[0][0].addDataSource(filename);
                            }
                        }
                        catch (Exception exc) {
                            if (BasicSSCell.DEBUG) {
                                exc.printStackTrace();
                            }
                            System.out.println("Could not load file " + filename + " into the SpreadSheet");
                        }
                    }
                });
            }
        }
    }

    public SpreadSheet() {
        this(60, 80, 2, 2, null, null, "VisAD SpreadSheet", null, true);
    }

    public SpreadSheet(int sWidth, int sHeight, int cols, int rows, String server, String clone, String sTitle) {
        this(sWidth, sHeight, cols, rows, server, clone, sTitle, null, false);
    }

    public SpreadSheet(int sWidth, int sHeight, int cols, int rows, String server, String clone, String sTitle, FormulaManager fm) {
        this(sWidth, sHeight, cols, rows, server, clone, sTitle, fm, false);
    }

    public SpreadSheet(int sWidth, int sHeight, int cols, int rows, String server, String clone, String sTitle, FormulaManager fm, boolean chooseOptions) {
        super(true);
        JViewport vl;
        JViewport hl;
        boolean slave;
        this.bTitle = sTitle;
        this.NumVisX = cols;
        this.NumVisY = rows;
        this.fm = fm;
        Possible3D = BasicSSCell.possible3D();
        CanDo3D = BasicSSCell.canDo3D();
        MappingDialog.initDialog();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SpreadSheet.this.quitProgram();
            }
        });
        this.setBackground(Color.white);
        boolean bl = slave = clone != null && clone.startsWith("slave:");
        if (slave) {
            clone = clone.substring(6);
        }
        if (clone != null) {
            int slash = clone.lastIndexOf("/");
            if (slash < 0) {
                slash = clone.lastIndexOf(":");
            }
            server = clone.substring(slash + 1);
            clone = clone.substring(0, slash);
        }
        this.serverName = server;
        this.cloneAddress = clone;
        this.IsSlave = slave;
        CanDoHDF5 = Util.canDoHDF5();
        if (!CanDoHDF5 && BasicSSCell.DEBUG) {
            System.err.println("Warning: HDF-5 library not found");
        }
        if (!(CanDoJPEG = Util.canDoJPEG()) && BasicSSCell.DEBUG) {
            System.err.println("Warning: JPEG codec not found");
        }
        if (!(CanDoPython = Util.canDoPython()) && BasicSSCell.DEBUG) {
            System.err.println("Warning: JPython not found");
        }
        this.SSFileDialog = new JFileChooser(System.getProperty("user.dir"));
        this.SSFileDialog.addChoosableFileFilter(new ExtensionFileFilter("ss", "SpreadSheet files"));
        if (chooseOptions) {
            this.getOptions(this.NumVisX, this.NumVisY, this.serverName, this.cloneAddress, this.IsSlave);
        }
        clone = this.cloneAddress == null ? null : this.cloneAddress + "/" + this.serverName;
        server = this.cloneAddress == null ? this.serverName : null;
        RemoteServer rs = null;
        String[][] cellNames = null;
        if (clone != null) {
            boolean success = true;
            System.out.print("Connecting to " + clone + " ");
            while (cellNames == null && success) {
                SpreadSheet.snooze(1000L);
                System.out.print(".");
                try {
                    rs = (RemoteServer)Naming.lookup("//" + clone);
                    this.RemoteCanDo3D = rs.getDataReference("CanDo3D");
                    Real bit = (Real)this.RemoteCanDo3D.getData();
                    if (bit.getValue() == 0.0) {
                        CanDo3D = false;
                        BasicSSCell.disable3D();
                    }
                    this.RemoteColRow = rs.getDataReference("ColRow");
                    cellNames = this.getNewCellNames();
                }
                catch (UnmarshalException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                    this.displayErrorMessage("Unable to clone the spreadsheet at " + clone + ". The server is using an incompatible version of Java", null, "Failed to clone spreadsheet");
                    success = false;
                }
                catch (MalformedURLException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                    this.displayErrorMessage("Unable to clone the spreadsheet at " + clone + ". The server name is not valid", null, "Failed to clone spreadsheet");
                    success = false;
                }
                catch (VisADException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                    this.displayErrorMessage("Unable to clone the spreadsheet at " + clone + ". An error occurred while downloading the necessary data", exc, "Failed to clone spreadsheet");
                    success = false;
                }
                catch (NotBoundException exc) {
                    if (!BasicSSCell.DEBUG) continue;
                    exc.printStackTrace();
                }
                catch (NullPointerException exc) {
                    if (!BasicSSCell.DEBUG) continue;
                    exc.printStackTrace();
                }
                catch (RemoteException exc) {
                    if (!BasicSSCell.DEBUG) continue;
                    exc.printStackTrace();
                }
            }
            if (success) {
                System.out.println(" done");
                this.bTitle = this.bTitle + " [" + (this.IsSlave ? "slaved" : "collaborative") + " mode: " + clone + "]";
                this.IsRemote = true;
            } else {
                System.out.println(" failed");
                this.IsSlave = false;
                rs = null;
            }
        }
        JPanel pane = new JPanel();
        pane.setBackground(Color.white);
        pane.setLayout(new BoxLayout(pane, 1));
        this.setContentPane(pane);
        this.addMenuItem("File", "Import data...", "loadDataSet", 'i');
        this.FileExport = this.addSubMenu("File", "Export data", 'e', false);
        this.FileSave1 = this.addMenuItem("Export data", "netCDF...", "exportDataSetNetcdf", 'n', true);
        this.FileSave3 = this.addMenuItem("Export data", "HDF-5...", "exportDataSetHDF5", 'h', CanDoHDF5);
        this.FileSave4 = this.addMenuItem("Export data", "TIFF...", "exportDataSetTIFF", 't', true);
        this.FileSave2 = this.addMenuItem("Export data", "Serialized...", "exportDataSetSerial", 's', true);
        this.FileSave5 = this.addMenuItem("Export data", "Binary...", "exportDataSetBinary", 'b', true);
        this.addMenuSeparator("File");
        this.FileSnap = this.addMenuItem("File", "Take JPEG snapshot...", "captureImageJPEG", 'j', false);
        this.addMenuSeparator("File");
        this.addMenuItem("File", "Exit", "quitProgram", 'x');
        this.addMenuItem("Edit", "Cut", "cutCell", 't', !this.IsRemote);
        this.addMenuItem("Edit", "Copy", "copyCell", 'c', !this.IsRemote);
        this.EditPaste = this.addMenuItem("Edit", "Paste", "pasteCell", 'p', false);
        this.EditClear = this.addMenuItem("Edit", "Clear", "clearCell", 'l', false);
        this.addMenuItem("Setup", "New spreadsheet file", "newFile", 'n');
        this.addMenuItem("Setup", "Open spreadsheet file...", "openFile", 'o', !this.IsRemote);
        this.addMenuItem("Setup", "Save spreadsheet file", "saveFile", 's', !this.IsRemote);
        this.addMenuItem("Setup", "Save spreadsheet file as...", "saveAsFile", 'a', !this.IsRemote);
        this.CellDim3D3D = new JCheckBoxMenuItem("3-D (Java3D)", CanDo3D);
        this.addMenuItem("Cell", this.CellDim3D3D, "setDim3D", '3', CanDo3D);
        this.CellDim2D2D = new JCheckBoxMenuItem("2-D (Java2D)", !CanDo3D);
        this.addMenuItem("Cell", this.CellDim2D2D, "setDimJ2D", 'j', true);
        this.CellDim2D3D = new JCheckBoxMenuItem("2-D (Java3D)", false);
        this.addMenuItem("Cell", this.CellDim2D3D, "setDim2D", '2', CanDo3D);
        this.addMenuSeparator("Cell");
        this.addMenuItem("Cell", "Add data object", "formulaAdd", 'a');
        this.CellDel = this.addMenuItem("Cell", "Delete data object", "formulaDel", 'd', false);
        this.addMenuSeparator("Cell");
        this.CellPrint = this.addMenuItem("Cell", "Print cell...", "printCurrentCell", 'p', false);
        this.addMenuSeparator("Cell");
        this.CellEdit = this.addMenuItem("Cell", "Edit mappings...", "createMappings", 'e', false);
        this.CellReset = this.addMenuItem("Cell", "Reset orientation", "resetOrientation", 'r', false);
        this.CellShow = this.addMenuItem("Cell", "Show controls", "showControls", 's', false);
        this.LayAddCol = this.addMenuItem("Layout", "Add column", "addColumn", 'c');
        this.addMenuItem("Layout", "Add row", "addRow", 'r');
        this.LayDelCol = this.addMenuItem("Layout", "Delete column", "deleteColumn", 'l', this.NumVisX > 1);
        this.LayDelRow = this.addMenuItem("Layout", "Delete row", "deleteRow", 'w', this.NumVisY > 1);
        this.addMenuSeparator("Layout");
        this.addMenuItem("Layout", "Tile cells", "tileCells", 't');
        if (!CanDo3D) {
            this.AutoSwitch = false;
        }
        this.AutoSwitchBox = new JCheckBoxMenuItem("Auto-switch to 3-D", this.AutoSwitch && !this.IsRemote);
        this.addMenuItem("Options", this.AutoSwitchBox, "optionsSwitch", '3', CanDo3D && !this.IsRemote);
        this.AutoDetectBox = new JCheckBoxMenuItem("Auto-detect mappings", this.AutoDetect && !this.IsRemote);
        this.addMenuItem("Options", this.AutoDetectBox, "optionsDetect", 'm', !this.IsRemote);
        this.AutoShowBox = new JCheckBoxMenuItem("Auto-display controls", this.AutoShowControls && !this.IsSlave);
        this.addMenuItem("Options", this.AutoShowBox, "optionsDisplay", 'c', !this.IsSlave);
        if (!BugFix) {
            this.Toolbar = new JToolBar();
            this.Toolbar.setBackground(Color.lightGray);
            this.Toolbar.setBorder(new EtchedBorder());
            this.Toolbar.setFloatable(false);
            pane.add(this.Toolbar);
            this.addToolbarButton("open", "Import data", "loadDataSet", true, this.Toolbar);
            this.ToolSave = this.addToolbarButton("save", "Export data to netCDF", "exportDataSetNetcdf", false, this.Toolbar);
            this.Toolbar.addSeparator();
            this.addToolbarButton("cut", "Cut", "cutCell", !this.IsRemote, this.Toolbar);
            this.addToolbarButton("copy", "Copy", "copyCell", !this.IsRemote, this.Toolbar);
            this.ToolPaste = this.addToolbarButton("paste", "Paste", "pasteCell", false, this.Toolbar);
            this.Toolbar.addSeparator();
            this.Tool3D = this.addToolbarButton("3d", "3-D (Java3D)", "setDim3D", false, this.Toolbar);
            this.ToolJ2D = this.addToolbarButton("j2d", "2-D (Java2D)", "setDimJ2D", CanDo3D, this.Toolbar);
            this.Tool2D = this.addToolbarButton("2d", "2-D (Java3D)", "setDim2D", CanDo3D, this.Toolbar);
            this.Toolbar.addSeparator();
            this.ToolMap = this.addToolbarButton("mappings", "Edit mappings", "createMappings", false, this.Toolbar);
            this.ToolReset = this.addToolbarButton("reset", "Reset orientation", "resetOrientation", false, this.Toolbar);
            this.ToolShow = this.addToolbarButton("show", "Show controls", "showControls", false, this.Toolbar);
            this.Toolbar.addSeparator();
            this.addToolbarButton("tile", "Tile cells", "tileCells", true, this.Toolbar);
            this.Toolbar.add(Box.createHorizontalGlue());
            this.Toolbar.setMaximumSize(new Dimension(this.Toolbar.getMaximumSize().width, this.Toolbar.getPreferredSize().height));
        }
        JPanel formulaPanel = new JPanel();
        formulaPanel.setPreferredSize(new Dimension(Integer.MAX_VALUE, 25));
        formulaPanel.setBackground(Color.lightGray);
        formulaPanel.setLayout(new BoxLayout(formulaPanel, 0));
        formulaPanel.setBorder(new EtchedBorder());
        pane.add(formulaPanel);
        pane.add(Box.createRigidArea(new Dimension(0, 6)));
        if (!BugFix) {
            this.FormulaAdd = this.addToolbarButton("add", "Add data", "formulaAdd", true, formulaPanel);
            this.FormulaDel = this.addToolbarButton("del", "Remove data", "formulaDel", true, formulaPanel);
        }
        this.FormulaBox = new JComboBox();
        formulaPanel.add(this.FormulaBox);
        this.FormulaBox.setLightWeightPopupEnabled(false);
        this.FormulaBox.setEditable(true);
        this.FormulaEditor = this.FormulaBox.getEditor();
        this.FormulaListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String newItem = ((String)SpreadSheet.this.FormulaEditor.getItem()).trim();
                try {
                    int id = 0;
                    int type = -1;
                    boolean notify = true;
                    int index1 = newItem.indexOf("d", 2);
                    int index2 = newItem.indexOf(":");
                    if (index1 > 0 && index2 > 0 && index1 < index2) {
                        int dataId;
                        BasicSSCell ssCell;
                        block12: {
                            String cellName = newItem.substring(0, index1);
                            ssCell = BasicSSCell.getSSCellByName(cellName);
                            dataId = 0;
                            try {
                                dataId = Integer.parseInt(newItem.substring(index1 + 1, index2));
                            }
                            catch (NumberFormatException exc) {
                                if (!BasicSSCell.DEBUG || BasicSSCell.DEBUG_LEVEL < 3) break block12;
                                exc.printStackTrace();
                            }
                        }
                        if (ssCell == SpreadSheet.this.DisplayCells[SpreadSheet.this.CurX][SpreadSheet.this.CurY] && dataId > 0) {
                            String varName = newItem.substring(0, index2);
                            String source = ssCell.getDataSource(varName);
                            if (source != null) {
                                ssCell.removeData(varName);
                                String oldItem = null;
                                for (int i = 0; i < SpreadSheet.this.FormulaBox.getItemCount(); ++i) {
                                    String item = (String)SpreadSheet.this.FormulaBox.getItemAt(i);
                                    if (!item.startsWith(varName + ":")) continue;
                                    oldItem = item;
                                    break;
                                }
                                if (oldItem != null) {
                                    SpreadSheet.this.FormulaBox.removeItem(oldItem);
                                }
                            }
                            id = dataId;
                            newItem = newItem.substring(index2 + 1).trim();
                        }
                    }
                    String varName = SpreadSheet.this.DisplayCells[SpreadSheet.this.CurX][SpreadSheet.this.CurY].addDataSource(id, newItem, type, notify);
                    String itemString = varName + ": " + newItem;
                    SpreadSheet.this.FormulaBox.addItem(itemString);
                    SpreadSheet.this.FormulaBox.setSelectedItem(itemString);
                    SpreadSheet.this.FormulaText.getCaret().setVisible(true);
                }
                catch (VisADException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                    SpreadSheet.this.displayErrorMessage("Unable to compute data object from \"" + newItem + "\"", exc, "VisAD SpreadSheet error");
                }
                catch (RemoteException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                    SpreadSheet.this.displayErrorMessage("Unable to compute data object from \"" + newItem + "\"", exc, "VisAD SpreadSheet error");
                }
            }
        };
        this.FormulaEditor.addActionListener(this.FormulaListener);
        this.FormulaText = (JTextField)this.FormulaEditor.getEditorComponent();
        JPanel horizShell = new JPanel();
        horizShell.setBackground(Color.white);
        horizShell.setLayout(new BoxLayout(horizShell, 0));
        horizShell.add(Box.createRigidArea(new Dimension(36, 0)));
        pane.add(horizShell);
        this.HorizPanel = new JPanel(){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                return new Dimension(d.width, 20);
            }
        };
        this.HorizPanel.setBackground(Color.white);
        this.constructHorizontalLabels();
        this.HorizLabels = hl = new JViewport(){

            public Dimension getMinimumSize() {
                return new Dimension(0, 20);
            }

            public Dimension getPreferredSize() {
                return new Dimension(0, 20);
            }

            public Dimension getMaximumSize() {
                return new Dimension(Integer.MAX_VALUE, 20);
            }
        };
        this.HorizLabels.setView(this.HorizPanel);
        horizShell.add(this.HorizLabels);
        horizShell.add(new JComponent(){

            public Dimension getMinimumSize() {
                return new Dimension(6 + SpreadSheet.this.SCPane.getVScrollbarWidth(), 0);
            }

            public Dimension getPreferredSize() {
                return new Dimension(6 + SpreadSheet.this.SCPane.getVScrollbarWidth(), 0);
            }

            public Dimension getMaximumSize() {
                return new Dimension(6 + SpreadSheet.this.SCPane.getVScrollbarWidth(), 0);
            }
        });
        JPanel mainPanel = new JPanel();
        mainPanel.setBackground(Color.white);
        mainPanel.setLayout(new BoxLayout(mainPanel, 0));
        pane.add(mainPanel);
        pane.add(Box.createRigidArea(new Dimension(0, 6)));
        JPanel vertShell = new JPanel();
        vertShell.setBackground(Color.white);
        vertShell.setLayout(new BoxLayout(vertShell, 1));
        mainPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        mainPanel.add(vertShell);
        this.VertPanel = new JPanel(){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                return new Dimension(30, d.height);
            }
        };
        this.VertPanel.setBackground(Color.white);
        this.constructVerticalLabels();
        this.VertLabels = vl = new JViewport(){

            public Dimension getMinimumSize() {
                return new Dimension(30, 0);
            }

            public Dimension getPreferredSize() {
                return new Dimension(30, 0);
            }

            public Dimension getMaximumSize() {
                return new Dimension(30, Integer.MAX_VALUE);
            }
        };
        this.VertLabels.setView(this.VertPanel);
        vertShell.add(this.VertLabels);
        vertShell.add(new JComponent(){

            public Dimension getMinimumSize() {
                return new Dimension(0, SpreadSheet.this.SCPane.getHScrollbarHeight());
            }

            public Dimension getPreferredSize() {
                return new Dimension(0, SpreadSheet.this.SCPane.getHScrollbarHeight());
            }

            public Dimension getMaximumSize() {
                return new Dimension(0, SpreadSheet.this.SCPane.getHScrollbarHeight());
            }
        });
        this.ScrollPanel = new JPanel();
        this.ScrollPanel.setBackground(Color.white);
        this.ScrollPanel.setLayout(new BoxLayout(this.ScrollPanel, 0));
        mainPanel.add(this.ScrollPanel);
        mainPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        this.SCPane = new ScrollPane(1){

            public Dimension getPreferredSize() {
                return new Dimension(0, 0);
            }
        };
        Adjustable hadj = this.SCPane.getHAdjustable();
        Adjustable vadj = this.SCPane.getVAdjustable();
        hadj.setBlockIncrement(120);
        hadj.setUnitIncrement(30);
        hadj.addAdjustmentListener(this);
        vadj.setBlockIncrement(120);
        vadj.setUnitIncrement(30);
        vadj.addAdjustmentListener(this);
        this.ScrollPanel.add(this.SCPane);
        this.DisplayPanel = new Panel();
        this.DisplayPanel.setBackground(Color.darkGray);
        this.SCPane.add(this.DisplayPanel);
        String os = System.getProperty("os.name");
        if (!os.startsWith("Windows")) {
            this.addKeyListener(this);
            this.SCPane.addKeyListener(this);
            this.ScrollPanel.addKeyListener(this);
            this.DisplayPanel.addKeyListener(this);
            this.FormulaBox.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    SpreadSheet.this.SCPane.requestFocus();
                }
            });
        }
        DataReferenceImpl lColRow = null;
        if (server != null) {
            boolean success = true;
            boolean registryStarted = false;
            do {
                try {
                    this.rsi = new RemoteServerImpl();
                    Naming.rebind("///" + server, this.rsi);
                    break;
                }
                catch (ConnectException exc) {
                    if (!registryStarted) {
                        try {
                            LocateRegistry.createRegistry(1099);
                            registryStarted = true;
                        }
                        catch (RemoteException rexc) {
                            if (BasicSSCell.DEBUG) {
                                exc.printStackTrace();
                            }
                            this.displayErrorMessage("Unable to autostart rmiregistry. Please start rmiregistry before launching the SpreadSheet in server mode", null, "Failed to initialize RemoteServer");
                            success = false;
                        }
                        continue;
                    }
                    this.displayErrorMessage("Unable to export cells as RMI addresses. Make sure you are running rmiregistry before launching the SpreadSheet in server mode", null, "Failed to initialize RemoteServer");
                    success = false;
                }
                catch (MalformedURLException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                    this.displayErrorMessage("Unable to export cells as RMI addresses. The name \"" + server + "\" is not valid", null, "Failed to initialize RemoteServer");
                    success = false;
                }
                catch (RemoteException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                    this.displayErrorMessage("Unable to export cells as RMI addresses", exc, "Failed to initialize RemoteServer");
                    success = false;
                }
            } while (success);
            try {
                DataReferenceImpl lCanDo3D = new DataReferenceImpl("CanDo3D");
                this.RemoteCanDo3D = new RemoteDataReferenceImpl(lCanDo3D);
                this.RemoteCanDo3D.setData(new Real(CanDo3D ? 1.0 : 0.0));
                this.rsi.addDataReference((RemoteDataReferenceImpl)this.RemoteCanDo3D);
                lColRow = new DataReferenceImpl("ColRow");
                this.RemoteColRow = new RemoteDataReferenceImpl(lColRow);
                this.rsi.addDataReference((RemoteDataReferenceImpl)this.RemoteColRow);
            }
            catch (VisADException exc) {
                if (BasicSSCell.DEBUG) {
                    exc.printStackTrace();
                }
                this.displayErrorMessage("Unable to export cells as RMI addresses. An error occurred setting up the necessary data", exc, "Failed to initialize RemoteServer");
                success = false;
            }
            catch (RemoteException exc) {
                if (BasicSSCell.DEBUG) {
                    exc.printStackTrace();
                }
                this.displayErrorMessage("Unable to export cells as RMI addresses. A remote error occurred setting up the necessary data", exc, "Failed to initialize RemoteServer");
                success = false;
            }
            if (success) {
                this.bTitle = this.bTitle + " (" + server + ")";
            } else {
                this.rsi = null;
            }
        }
        if (rs == null) {
            this.constructSpreadsheetCells(null);
        } else {
            this.NumVisX = cellNames.length;
            this.NumVisY = cellNames[0].length;
            this.reconstructLabels(cellNames, null, null);
            this.constructSpreadsheetCells(cellNames, rs);
        }
        if (this.rsi != null) {
            this.synchColRow();
        }
        this.CollabID = this.DisplayCells[0][0].getRemoteId();
        if (this.rsi != null || this.IsRemote) {
            final RemoteServer frs = rs;
            CellImpl lColRowCell = new CellImpl(){

                public void doAction() {
                    if (SpreadSheet.this.getColRowID() != SpreadSheet.this.CollabID) {
                        Util.invoke(true, BasicSSCell.DEBUG, new Runnable(){

                            public void run() {
                                String[][] cellNamesx = SpreadSheet.this.getNewCellNames();
                                if (cellNamesx == null) {
                                    if (BasicSSCell.DEBUG) {
                                        System.out.println("Warning: could not obtain new spreadsheet dimensions!");
                                    }
                                    return;
                                }
                                int oldNVX = SpreadSheet.this.NumVisX;
                                int oldNVY = SpreadSheet.this.NumVisY;
                                SpreadSheet.this.NumVisX = cellNamesx.length;
                                SpreadSheet.this.NumVisY = cellNamesx[0].length;
                                if (SpreadSheet.this.NumVisX != oldNVX || SpreadSheet.this.NumVisY != oldNVY) {
                                    SpreadSheet.this.reconstructSpreadsheet(cellNamesx, null, null, frs);
                                    if (!SpreadSheet.this.IsRemote) {
                                        SpreadSheet.this.synchColRow();
                                    }
                                }
                            }
                        });
                    }
                }
            };
            try {
                RemoteCellImpl rColRowCell = new RemoteCellImpl(lColRowCell);
                rColRowCell.addReference(this.RemoteColRow);
            }
            catch (VisADException exc) {
                if (BasicSSCell.DEBUG) {
                    exc.printStackTrace();
                }
                this.displayErrorMessage("Remote cell error (1)", exc, "VisAD SpreadSheet error");
            }
            catch (RemoteException exc) {
                try {
                    lColRowCell.addReference(lColRow);
                }
                catch (VisADException exc2) {
                    if (BasicSSCell.DEBUG) {
                        exc2.printStackTrace();
                    }
                    this.displayErrorMessage("Remote cell error (2)", exc2, "VisAD SpreadSheet error");
                }
                catch (RemoteException exc2) {
                    if (BasicSSCell.DEBUG) {
                        exc2.printStackTrace();
                    }
                    this.displayErrorMessage("Remote cell error (3)", exc2, "VisAD SpreadSheet error");
                }
            }
        }
        this.setTitle(this.bTitle);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int appWidth = (int)(0.01 * (double)sWidth * (double)screenSize.width);
        int appHeight = (int)(0.01 * (double)sHeight * (double)screenSize.height);
        this.setSize(appWidth, appHeight);
        Util.centerWindow(this);
        this.setVisible(true);
        SpreadSheet.snooze(500L);
        this.FormulaText.getCaret().setVisible(true);
        this.tileCells();
    }

    public void loadDataSet() {
        this.DisplayCells[this.CurX][this.CurY].loadDataDialog();
    }

    public void exportDataSetNetcdf() {
        try {
            this.exportDataSet(new Plain());
        }
        catch (VisADException exc) {
            if (BasicSSCell.DEBUG) {
                exc.printStackTrace();
            }
            this.displayErrorMessage("Error initializing netCDF export", exc, "VisAD SpreadSheet error");
        }
    }

    public void exportDataSetSerial() {
        this.exportDataSet(new VisADForm());
    }

    public void exportDataSetHDF5() {
        Form hdf5form = null;
        try {
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            Class<?> hdf5form_class = cl.loadClass("visad.data.hdf5.HDF5Form");
            hdf5form = (Form)hdf5form_class.newInstance();
        }
        catch (Exception exc) {
            if (BasicSSCell.DEBUG) {
                exc.printStackTrace();
            }
            this.displayErrorMessage("Error initializing HDF-5 export", exc, "VisAD SpreadSheet error");
        }
        if (hdf5form != null) {
            this.exportDataSet(hdf5form);
        }
    }

    public void exportDataSetTIFF() {
        this.exportDataSet(new TiffForm());
    }

    public void exportDataSetBinary() {
        this.exportDataSet(new VisADForm(true));
    }

    public void exportDataSet(Form form) {
        String item = (String)this.FormulaBox.getSelectedItem();
        String varName = item.substring(0, item.indexOf(":"));
        this.DisplayCells[this.CurX][this.CurY].saveDataDialog(varName, form);
    }

    public void captureImageJPEG() {
        this.DisplayCells[this.CurX][this.CurY].captureDialog();
    }

    public void quitProgram() {
        try {
            this.DisplayCells[this.CurX][this.CurY].hideWidgetFrame();
        }
        catch (NullPointerException exc) {
            // empty catch block
        }
        this.setVisible(false);
        Thread t = new Thread(){

            public void run() {
                boolean b = BasicSSCell.isSaving();
                JFrame f = null;
                if (b) {
                    f = new JFrame("Please wait");
                    f.setCursor(Cursor.getPredefinedCursor(3));
                    JPanel p = new JPanel();
                    f.setContentPane(p);
                    p.setBorder(new EmptyBorder(10, 20, 10, 20));
                    p.setLayout(new BorderLayout());
                    p.add("Center", new JLabel("Please wait while the VisAD SpreadSheet finishes saving files..."));
                    f.setResizable(false);
                    f.pack();
                    Dimension sSize = Toolkit.getDefaultToolkit().getScreenSize();
                    Dimension fSize = f.getSize();
                    f.setLocation(sSize.width / 2 - fSize.width / 2, sSize.height / 2 - fSize.height / 2);
                    f.setVisible(true);
                }
                while (BasicSSCell.isSaving()) {
                    SpreadSheet.snooze(200L);
                }
                if (b) {
                    f.setCursor(Cursor.getDefaultCursor());
                    f.setVisible(false);
                }
                boolean[][] alive = new boolean[SpreadSheet.this.NumVisX][SpreadSheet.this.NumVisY];
                for (int j = 0; j < SpreadSheet.this.NumVisY; ++j) {
                    for (int i = 0; i < SpreadSheet.this.NumVisX; ++i) {
                        alive[i][j] = true;
                    }
                }
                int aliveCount = SpreadSheet.this.NumVisX * SpreadSheet.this.NumVisY;
                while (aliveCount > 0) {
                    for (int j = 0; j < SpreadSheet.this.NumVisY; ++j) {
                        for (int i = 0; i < SpreadSheet.this.NumVisX; ++i) {
                            if (!alive[i][j] || SpreadSheet.this.DisplayCells[i][j].othersDepend()) continue;
                            try {
                                SpreadSheet.this.DisplayCells[i][j].destroyCell();
                                alive[i][j] = false;
                                --aliveCount;
                                continue;
                            }
                            catch (VisADException exc) {
                                if (BasicSSCell.DEBUG) {
                                    exc.printStackTrace();
                                }
                                SpreadSheet.this.displayErrorMessage("Cannot destroy cell (1)", exc, "VisAD SpreadSheet error");
                                continue;
                            }
                            catch (RemoteException exc) {
                                if (BasicSSCell.DEBUG) {
                                    exc.printStackTrace();
                                }
                                SpreadSheet.this.displayErrorMessage("Cannot destroy cell (2)", exc, "VisAD SpreadSheet error");
                            }
                        }
                    }
                }
                System.exit(0);
            }
        };
        t.start();
    }

    public void cutCell() {
        if (this.DisplayCells[this.CurX][this.CurY].confirmClear()) {
            this.copyCell();
            this.clearCell(false);
        }
    }

    public void copyCell() {
        this.Clipboard = this.DisplayCells[this.CurX][this.CurY].getSaveString();
        this.EditPaste.setEnabled(true);
        if (!BugFix) {
            this.ToolPaste.setEnabled(true);
        }
    }

    public void pasteCell() {
        if (this.Clipboard != null) {
            try {
                boolean b = this.DisplayCells[this.CurX][this.CurY].getAutoDetect();
                this.DisplayCells[this.CurX][this.CurY].setAutoDetect(false);
                this.DisplayCells[this.CurX][this.CurY].setSaveString(this.Clipboard);
                this.DisplayCells[this.CurX][this.CurY].setAutoDetect(b);
            }
            catch (VisADException exc) {
                if (BasicSSCell.DEBUG) {
                    exc.printStackTrace();
                }
                this.displayErrorMessage("Cannot paste cell", exc, "VisAD SpreadSheet error");
            }
            catch (RemoteException exc) {
                if (BasicSSCell.DEBUG) {
                    exc.printStackTrace();
                }
                this.displayErrorMessage("Cannot paste cell", exc, "VisAD SpreadSheet error");
            }
        }
    }

    public void clearCell() {
        this.clearCell(true);
    }

    protected void clearCell(boolean checkSafe) {
        try {
            if (checkSafe) {
                this.DisplayCells[this.CurX][this.CurY].smartClear();
            } else {
                this.DisplayCells[this.CurX][this.CurY].clearCell();
            }
        }
        catch (VisADException exc) {
            if (BasicSSCell.DEBUG) {
                exc.printStackTrace();
            }
            this.displayErrorMessage("Cannot clear display mappings", exc, "VisAD SpreadSheet error");
        }
        catch (RemoteException exc) {
            if (BasicSSCell.DEBUG) {
                exc.printStackTrace();
            }
            this.displayErrorMessage("Cannot clear display mappings", exc, "VisAD SpreadSheet error");
        }
        this.refreshFormulaBar();
        this.refreshMenuCommands();
    }

    public boolean newFile() {
        return this.newFile(true);
    }

    protected boolean newFile(boolean safe) {
        int ans;
        if (safe && (ans = JOptionPane.showConfirmDialog(this, "Clear all spreadsheet cells?", "Are you sure?", 0)) != 0) {
            return false;
        }
        this.DisplayCells[this.CurX][this.CurY].hideWidgetFrame();
        boolean[][] dirty = new boolean[this.NumVisX][this.NumVisY];
        for (int j = 0; j < this.NumVisY; ++j) {
            for (int i = 0; i < this.NumVisX; ++i) {
                dirty[i][j] = true;
            }
        }
        int dirtyCount = this.NumVisX * this.NumVisY;
        while (dirtyCount > 0) {
            for (int j = 0; j < this.NumVisY; ++j) {
                for (int i = 0; i < this.NumVisX; ++i) {
                    if (!dirty[i][j] || this.DisplayCells[i][j].othersDepend()) continue;
                    try {
                        this.DisplayCells[i][j].clearCell();
                        dirty[i][j] = false;
                        --dirtyCount;
                        continue;
                    }
                    catch (VisADException exc) {
                        if (BasicSSCell.DEBUG) {
                            exc.printStackTrace();
                        }
                        this.displayErrorMessage("Cannot clear cell (1)", exc, "VisAD SpreadSheet error");
                        continue;
                    }
                    catch (RemoteException exc) {
                        if (BasicSSCell.DEBUG) {
                            exc.printStackTrace();
                        }
                        this.displayErrorMessage("Cannot clear cell (2)", exc, "VisAD SpreadSheet error");
                    }
                }
            }
        }
        this.CurrentFile = null;
        this.setTitle(this.bTitle);
        return true;
    }

    public void openFile() {
        this.SSFileDialog.setDialogType(0);
        if (this.SSFileDialog.showOpenDialog(this) != 0) {
            return;
        }
        File f = this.SSFileDialog.getSelectedFile();
        if (!f.exists()) {
            this.displayErrorMessage("The file " + f.getName() + " does not exist", null, "VisAD SpreadSheet error");
            return;
        }
        this.openFile(f.getPath());
    }

    public void openFile(String file) {
        int j;
        int len;
        String line;
        File f = new File(file);
        boolean origSwitch = this.AutoSwitch;
        boolean origDetect = this.AutoDetect;
        boolean origShow = this.AutoShowControls;
        this.setAutoSwitch(false);
        this.setAutoDetect(false);
        this.setAutoShowControls(false);
        this.newFile(false);
        int fLen = (int)f.length();
        char[] buff = new char[fLen];
        try {
            FileReader fr = new FileReader(f);
            fr.read(buff, 0, fLen);
            fr.close();
        }
        catch (IOException exc) {
            if (BasicSSCell.DEBUG) {
                exc.printStackTrace();
            }
            this.displayErrorMessage("Unable to read the file " + file + " from disk", null, "VisAD SpreadSheet error");
            this.setAutoSwitch(origSwitch);
            this.setAutoDetect(origDetect);
            this.setAutoShowControls(origShow);
            return;
        }
        StringTokenizer st = new StringTokenizer(new String(buff), "\n\r");
        int numTokens = st.countTokens();
        String[] tokens = new String[numTokens + 1];
        for (int i = 0; i < numTokens; ++i) {
            tokens[i] = st.nextToken();
        }
        tokens[numTokens] = null;
        st = null;
        int sizeX = -1;
        int sizeY = -1;
        int dimX = -1;
        int dimY = -1;
        Vector<Integer> colWidths = new Vector<Integer>();
        Vector<Integer> rowHeights = new Vector<Integer>();
        boolean autoSwitch = true;
        boolean autoDetect = true;
        boolean autoShow = true;
        int tokenNum = 0;
        boolean gotGlobal = false;
        while (!gotGlobal) {
            if ((line = tokens[tokenNum++]) == null) {
                this.displayErrorMessage("The file " + file + " does not contain " + "the required [Global] tag", null, "VisAD SpreadSheet error");
                this.setAutoSwitch(origSwitch);
                this.setAutoDetect(origDetect);
                this.setAutoShowControls(origShow);
                return;
            }
            len = line.length();
            String trimLine = line.trim();
            int trimLen = trimLine.length();
            if (trimLine.charAt(0) != '[' || trimLine.charAt(trimLen - 1) != ']') continue;
            String sub = trimLine.substring(1, trimLen - 1).trim();
            if (!sub.equalsIgnoreCase("global")) {
                this.displayErrorMessage("The file " + file + " does not contain the " + "[Global] tag as its first entry", null, "VisAD SpreadSheet error");
                this.setAutoSwitch(origSwitch);
                this.setAutoDetect(origDetect);
                this.setAutoShowControls(origShow);
                return;
            }
            int endToken = tokenNum;
            while (tokens[endToken] != null && tokens[endToken].trim().indexOf("[") != 0) {
                ++endToken;
            }
            for (int i = tokenNum; i < endToken; ++i) {
                String val;
                String keyword;
                int eq;
                block43: {
                    String sY;
                    String sX;
                    int x;
                    block42: {
                        line = tokens[i].trim();
                        if (line == null || line.charAt(0) == '#' || (eq = line.indexOf("=")) < 0) continue;
                        keyword = line.substring(0, eq).trim();
                        if ((keyword.equalsIgnoreCase("sheet size") || keyword.equalsIgnoreCase("sheet_size") || keyword.equalsIgnoreCase("sheetsize") || keyword.equalsIgnoreCase("size")) && (x = line.indexOf("x", eq)) >= 0) {
                            sX = line.substring(eq + 1, x).trim();
                            sY = line.substring(x + 1).trim();
                            try {
                                sizeX = Integer.parseInt(sX);
                                sizeY = Integer.parseInt(sY);
                            }
                            catch (NumberFormatException exc) {
                                if (!BasicSSCell.DEBUG) break block42;
                                exc.printStackTrace();
                            }
                        }
                    }
                    if ((keyword.equalsIgnoreCase("dimension") || keyword.equalsIgnoreCase("dimensions") || keyword.equalsIgnoreCase("dim")) && (x = line.indexOf("x", eq)) >= 0) {
                        sX = line.substring(eq + 1, x).trim();
                        sY = line.substring(x + 1).trim();
                        try {
                            dimX = Integer.parseInt(sX);
                            dimY = Integer.parseInt(sY);
                        }
                        catch (NumberFormatException exc) {
                            if (!BasicSSCell.DEBUG) break block43;
                            exc.printStackTrace();
                        }
                    }
                }
                if (keyword.equalsIgnoreCase("columns") || keyword.equalsIgnoreCase("column") || keyword.equalsIgnoreCase("column widths") || keyword.equalsIgnoreCase("column_widths") || keyword.equalsIgnoreCase("columnwidths") || keyword.equalsIgnoreCase("column width") || keyword.equalsIgnoreCase("column_width") || keyword.equalsIgnoreCase("columnwidth")) {
                    StringTokenizer ln = new StringTokenizer(line.substring(eq + 1));
                    int nt = ln.countTokens();
                    for (int z = 0; z < nt; ++z) {
                        int cw;
                        block44: {
                            cw = 0;
                            try {
                                cw = Integer.parseInt(ln.nextToken());
                            }
                            catch (NumberFormatException exc) {
                                if (!BasicSSCell.DEBUG) break block44;
                                exc.printStackTrace();
                            }
                        }
                        if (cw < 120) continue;
                        colWidths.add(new Integer(cw));
                    }
                }
                if (keyword.equalsIgnoreCase("rows") || keyword.equalsIgnoreCase("row") || keyword.equalsIgnoreCase("row heights") || keyword.equalsIgnoreCase("row_heights") || keyword.equalsIgnoreCase("rowheights") || keyword.equalsIgnoreCase("row height") || keyword.equalsIgnoreCase("row_height") || keyword.equalsIgnoreCase("rowheight")) {
                    StringTokenizer ln = new StringTokenizer(line.substring(eq + 1));
                    int nt = ln.countTokens();
                    for (int z = 0; z < nt; ++z) {
                        int rh;
                        block45: {
                            rh = 0;
                            try {
                                rh = Integer.parseInt(ln.nextToken());
                            }
                            catch (NumberFormatException exc) {
                                if (!BasicSSCell.DEBUG) break block45;
                                exc.printStackTrace();
                            }
                        }
                        if (rh < 120) continue;
                        rowHeights.add(new Integer(rh));
                    }
                }
                if ((keyword.equalsIgnoreCase("auto switch") || keyword.equalsIgnoreCase("auto_switch") || keyword.equalsIgnoreCase("auto-switch") || keyword.equalsIgnoreCase("autoswitch")) && ((val = line.substring(eq + 1).trim()).equalsIgnoreCase("false") || val.equalsIgnoreCase("F"))) {
                    autoSwitch = false;
                }
                if ((keyword.equalsIgnoreCase("auto detect") || keyword.equalsIgnoreCase("auto_detect") || keyword.equalsIgnoreCase("auto-detect") || keyword.equalsIgnoreCase("autodetect")) && ((val = line.substring(eq + 1).trim()).equalsIgnoreCase("false") || val.equalsIgnoreCase("F"))) {
                    autoDetect = false;
                }
                if (!keyword.equalsIgnoreCase("auto show") && !keyword.equalsIgnoreCase("auto_show") && !keyword.equalsIgnoreCase("auto-show") && !keyword.equalsIgnoreCase("autoshow") || !(val = line.substring(eq + 1).trim()).equalsIgnoreCase("false") && !val.equalsIgnoreCase("F")) continue;
                autoShow = false;
            }
            gotGlobal = true;
        }
        if (dimX < 1 || dimY < 1) {
            this.displayErrorMessage("The file " + file + " has an invalid " + "global dimension entry", null, "VisAD SpreadSheet error");
            this.setAutoSwitch(origSwitch);
            this.setAutoDetect(origDetect);
            this.setAutoShowControls(origShow);
            return;
        }
        len = colWidths.size();
        int[] cw = new int[dimX];
        for (int i = 0; i < dimX; ++i) {
            cw[i] = i < len ? (Integer)colWidths.elementAt(i) : 250;
        }
        len = rowHeights.size();
        int[] rh = new int[dimY];
        for (int i = 0; i < dimY; ++i) {
            rh[i] = i < len ? (Integer)rowHeights.elementAt(i) : 250;
        }
        String[][] cellNames = new String[dimX][dimY];
        String[][] fileStrings = new String[dimX][dimY];
        for (j = 0; j < dimY; ++j) {
            for (int i = 0; i < dimX; ++i) {
                cellNames[i][j] = null;
                do {
                    if ((line = tokens[tokenNum++]) == null) {
                        this.displayErrorMessage("The file " + file + " is incomplete", null, "VisAD SpreadSheet error");
                        this.setAutoSwitch(origSwitch);
                        this.setAutoDetect(origDetect);
                        this.setAutoShowControls(origShow);
                        return;
                    }
                    String trimLine = line.trim();
                    int trimLen = trimLine.length();
                    if (trimLine.charAt(0) != '[' || trimLine.charAt(trimLen - 1) != ']') continue;
                    cellNames[i][j] = trimLine.substring(1, trimLen - 1).trim();
                } while (cellNames[i][j] == null);
                int last = tokenNum + 1;
                while (tokens[last] != null && tokens[last].trim().indexOf("[") != 0) {
                    ++last;
                }
                String s = "";
                for (int l = tokenNum; l < last; ++l) {
                    s = s + tokens[l] + "\n";
                }
                fileStrings[i][j] = s;
            }
        }
        if (sizeX > 0 && sizeY > 0) {
            this.setSize(sizeX, sizeY);
        }
        this.NumVisX = dimX;
        this.NumVisY = dimY;
        this.reconstructSpreadsheet(cellNames, cw, rh, null);
        this.synchColRow();
        for (j = 0; j < this.NumVisY; ++j) {
            for (int i = 0; i < this.NumVisX; ++i) {
                try {
                    this.DisplayCells[i][j].setSaveString(fileStrings[i][j]);
                    continue;
                }
                catch (VisADException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                    this.displayErrorMessage("Invalid save string", exc, "VisAD SpreadSheet error");
                    continue;
                }
                catch (RemoteException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                    this.displayErrorMessage("Invalid save string", exc, "VisAD SpreadSheet error");
                }
            }
        }
        this.setAutoSwitch(autoSwitch);
        this.setAutoDetect(autoDetect);
        this.setAutoShowControls(autoShow);
        this.CurrentFile = f;
        this.setTitle(this.bTitle + " - " + f.getPath());
        this.refreshDisplayMenuItems();
        this.refreshFormulaBar();
        this.refreshMenuCommands();
        this.refreshOptions();
        this.validate();
        this.repaint();
    }

    public void saveFile() {
        if (this.CurrentFile == null) {
            this.saveAsFile();
        } else {
            int j;
            StringBuffer sb = new StringBuffer(1024 * this.NumVisX * this.NumVisY + 1024);
            sb.append(SSFileHeader);
            sb.append("\n");
            sb.append("# File ");
            sb.append(this.CurrentFile.getName());
            sb.append(" written at ");
            sb.append(Util.getTimestamp());
            sb.append("\n\n");
            sb.append("[Global]\n");
            sb.append("sheet size = ");
            sb.append(this.getWidth());
            sb.append(" x ");
            sb.append(this.getHeight());
            sb.append("\n");
            sb.append("dimension = ");
            sb.append(this.NumVisX);
            sb.append(" x ");
            sb.append(this.NumVisY);
            sb.append("\n");
            sb.append("columns =");
            for (j = 0; j < this.NumVisX; ++j) {
                sb.append(" ");
                sb.append(this.HorizLabel[j].getSize().width);
            }
            sb.append("\n");
            sb.append("rows =");
            for (int i = 0; i < this.NumVisY; ++i) {
                sb.append(" ");
                sb.append(this.VertLabel[i].getSize().height);
            }
            sb.append("\n");
            sb.append("auto switch = ");
            sb.append(this.AutoSwitch);
            sb.append("\n");
            sb.append("auto detect = ");
            sb.append(this.AutoDetect);
            sb.append("\n");
            sb.append("auto show = ");
            sb.append(this.AutoShowControls);
            sb.append("\n\n");
            for (j = 0; j < this.NumVisY; ++j) {
                for (int i = 0; i < this.NumVisX; ++i) {
                    sb.append("[");
                    sb.append(this.DisplayCells[i][j].getName());
                    sb.append("]\n");
                    sb.append(this.DisplayCells[i][j].getSaveString());
                    sb.append("\n");
                }
            }
            char[] sc = sb.toString().toCharArray();
            try {
                FileWriter fw = new FileWriter(this.CurrentFile);
                fw.write(sc, 0, sc.length);
                fw.close();
            }
            catch (IOException exc) {
                if (BasicSSCell.DEBUG) {
                    exc.printStackTrace();
                }
                this.displayErrorMessage("Could not save file " + this.CurrentFile.getName() + ". Make sure there is enough disk space", null, "VisAD SpreadSheet error");
            }
        }
    }

    public void saveAsFile() {
        File f;
        this.SSFileDialog.setDialogType(1);
        if (this.SSFileDialog.showSaveDialog(this) != 0) {
            return;
        }
        this.CurrentFile = f = this.SSFileDialog.getSelectedFile();
        this.setTitle(this.bTitle + " - " + f.getPath());
        this.saveFile();
    }

    public void setDim3D() {
        this.setDim(1);
    }

    public void setDimJ2D() {
        this.setDim(2);
    }

    public void setDim2D() {
        this.setDim(3);
    }

    protected void setDim(int dim) {
        try {
            this.DisplayCells[this.CurX][this.CurY].setDimension(dim);
        }
        catch (VisADException exc) {
            if (BasicSSCell.DEBUG) {
                exc.printStackTrace();
            }
            this.displayErrorMessage("Cannot alter display dimension", exc, "VisAD SpreadSheet error");
        }
        catch (RemoteException exc) {
            if (BasicSSCell.DEBUG) {
                exc.printStackTrace();
            }
            this.displayErrorMessage("Cannot alter display dimension", exc, "VisAD SpreadSheet error");
        }
        this.refreshDisplayMenuItems();
    }

    public void printCurrentCell() {
        if (!this.DisplayCells[this.CurX][this.CurY].hasData()) {
            this.displayErrorMessage("The current cell contains no data to be printed", null, "VisAD SpreadSheet error");
            return;
        }
        final PrinterJob printJob = PrinterJob.getPrinterJob();
        DisplayImpl display = this.DisplayCells[this.CurX][this.CurY].getDisplay();
        Printable p = display.getPrintable();
        printJob.setPrintable(p);
        if (printJob.printDialog()) {
            Runnable printImage = new Runnable(){

                public void run() {
                    try {
                        printJob.print();
                    }
                    catch (Exception exc) {
                        if (BasicSSCell.DEBUG) {
                            exc.printStackTrace();
                        }
                        SpreadSheet.this.displayErrorMessage("Cannot print the current cell", exc, "VisAD SpreadSheet error");
                    }
                }
            };
            Thread t = new Thread(printImage);
            t.start();
        }
    }

    public void createMappings() {
        this.DisplayCells[this.CurX][this.CurY].addMapDialog();
        this.refreshMenuCommands();
    }

    public void resetOrientation() {
        ProjectionControl pc;
        DisplayImpl display = this.DisplayCells[this.CurX][this.CurY].getDisplay();
        if (display != null && (pc = display.getProjectionControl()) != null) {
            int dim = this.DisplayCells[this.CurX][this.CurY].getDimension();
            double[] matrix = dim == 1 ? matrix3D : (dim == 2 ? matrixJ2D : matrix2D);
            try {
                pc.setMatrix(matrix);
            }
            catch (VisADException exc) {
                if (BasicSSCell.DEBUG) {
                    exc.printStackTrace();
                }
                this.displayErrorMessage("Cannot reset orientation", exc, "VisAD SpreadSheet error");
            }
            catch (RemoteException exc) {
                if (BasicSSCell.DEBUG) {
                    exc.printStackTrace();
                }
                this.displayErrorMessage("Cannot reset orientation", exc, "VisAD SpreadSheet error");
            }
        }
    }

    public void showControls() {
        this.DisplayCells[this.CurX][this.CurY].showWidgetFrame();
    }

    public synchronized void addColumn() {
        JLabel l = (JLabel)this.HorizLabel[this.NumVisX - 1].getComponent(0);
        int maxVisX = Letters.indexOf(l.getText()) + 1;
        int diffX = Letters.length() - maxVisX;
        if (diffX > 0) {
            JPanel[] newLabels = new JPanel[this.NumVisX + 1];
            for (int i = 0; i < this.NumVisX; ++i) {
                newLabels[i] = this.HorizLabel[i];
            }
            newLabels[this.NumVisX] = new JPanel();
            newLabels[this.NumVisX].setBorder(new LineBorder(Color.black, 1));
            newLabels[this.NumVisX].setLayout(new BorderLayout());
            newLabels[this.NumVisX].setPreferredSize(new Dimension(250, 20));
            String s = String.valueOf(Letters.charAt(maxVisX));
            newLabels[this.NumVisX].add("Center", new JLabel(s, 0));
            if (this.IsRemote) {
                this.HorizLabel = newLabels;
                this.synchColRow();
            } else {
                JComponent[] newDrag = new JComponent[this.NumVisX + 1];
                for (int i = 0; i < this.NumVisX; ++i) {
                    newDrag[i] = this.HorizDrag[i];
                }
                newDrag[this.NumVisX] = new JComponent(){

                    public void paint(Graphics g) {
                        Dimension d = this.getSize();
                        g.setColor(Color.black);
                        g.drawRect(0, 0, d.width - 1, d.height - 1);
                        g.setColor(Color.yellow);
                        g.fillRect(1, 1, d.width - 2, d.height - 2);
                    }
                };
                newDrag[this.NumVisX].setPreferredSize(new Dimension(5, 0));
                newDrag[this.NumVisX].addMouseListener(this);
                newDrag[this.NumVisX].addMouseMotionListener(this);
                this.HorizPanel.removeAll();
                FancySSCell[][] fcells = new FancySSCell[this.NumVisX + 1][this.NumVisY];
                this.DisplayPanel.removeAll();
                for (int j = 0; j < this.NumVisY; ++j) {
                    for (int i = 0; i < this.NumVisX; ++i) {
                        fcells[i][j] = this.DisplayCells[i][j];
                    }
                    try {
                        String name = String.valueOf(Letters.charAt(maxVisX)) + String.valueOf(j + 1);
                        FancySSCell f = this.createCell(name, null);
                        f.addSSCellListener(this);
                        f.addMouseListener(this);
                        f.setAutoSwitch(this.AutoSwitch);
                        f.setAutoDetect(this.AutoDetect);
                        f.setAutoShowControls(this.AutoShowControls);
                        f.setDimension(CanDo3D ? 1 : 2);
                        f.addDisplayListener(this);
                        f.setPreferredSize(new Dimension(250, 250));
                        fcells[this.NumVisX][j] = f;
                        if (this.rsi == null) continue;
                        fcells[this.NumVisX][j].addToRemoteServer(this.rsi);
                        continue;
                    }
                    catch (VisADException exc) {
                        if (BasicSSCell.DEBUG) {
                            exc.printStackTrace();
                        }
                        this.displayErrorMessage("Cannot add the column. Unable to create new displays", exc, "VisAD SpreadSheet error");
                        continue;
                    }
                    catch (RemoteException exc) {
                        if (BasicSSCell.DEBUG) {
                            exc.printStackTrace();
                        }
                        this.displayErrorMessage("Cannot add the column. A remote error occurred", exc, "VisAD SpreadSheet error");
                    }
                }
                ++this.NumVisX;
                this.reconstructHoriz(newLabels, newDrag, fcells);
                if (diffX == 1) {
                    this.LayAddCol.setEnabled(false);
                }
                this.LayDelCol.setEnabled(true);
            }
        }
    }

    public void addRow() {
        JLabel l = (JLabel)this.VertLabel[this.NumVisY - 1].getComponent(0);
        int maxVisY = Integer.parseInt(l.getText());
        JPanel[] newLabels = new JPanel[this.NumVisY + 1];
        JComponent[] newDrag = new JComponent[this.NumVisY + 1];
        for (int i = 0; i < this.NumVisY; ++i) {
            newLabels[i] = this.VertLabel[i];
        }
        newLabels[this.NumVisY] = new JPanel();
        newLabels[this.NumVisY].setBorder(new LineBorder(Color.black, 1));
        newLabels[this.NumVisY].setLayout(new BorderLayout());
        newLabels[this.NumVisY].setPreferredSize(new Dimension(30, 250));
        String s = String.valueOf(maxVisY + 1);
        newLabels[this.NumVisY].add("Center", new JLabel(s, 0));
        if (this.IsRemote) {
            this.VertLabel = newLabels;
            this.synchColRow();
        } else {
            for (int i = 0; i < this.NumVisY; ++i) {
                newDrag[i] = this.VertDrag[i];
            }
            newDrag[this.NumVisY] = new JComponent(){

                public void paint(Graphics g) {
                    Dimension d = this.getSize();
                    g.setColor(Color.black);
                    g.drawRect(0, 0, d.width - 1, d.height - 1);
                    g.setColor(Color.yellow);
                    g.fillRect(1, 1, d.width - 2, d.height - 2);
                }
            };
            newDrag[this.NumVisY].setPreferredSize(new Dimension(0, 5));
            newDrag[this.NumVisY].addMouseListener(this);
            newDrag[this.NumVisY].addMouseMotionListener(this);
            this.VertPanel.removeAll();
            FancySSCell[][] fcells = new FancySSCell[this.NumVisX][this.NumVisY + 1];
            this.DisplayPanel.removeAll();
            for (int i = 0; i < this.NumVisX; ++i) {
                for (int j = 0; j < this.NumVisY; ++j) {
                    fcells[i][j] = this.DisplayCells[i][j];
                }
                try {
                    String name = String.valueOf(Letters.charAt(i)) + String.valueOf(maxVisY + 1);
                    FancySSCell f = this.createCell(name, null);
                    f.addSSCellListener(this);
                    f.addMouseListener(this);
                    f.setAutoSwitch(this.AutoSwitch);
                    f.setAutoDetect(this.AutoDetect);
                    f.setAutoShowControls(this.AutoShowControls);
                    f.setDimension(CanDo3D ? 1 : 2);
                    f.addDisplayListener(this);
                    f.setPreferredSize(new Dimension(250, 250));
                    fcells[i][this.NumVisY] = f;
                    if (this.rsi == null) continue;
                    fcells[i][this.NumVisY].addToRemoteServer(this.rsi);
                    continue;
                }
                catch (VisADException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                    this.displayErrorMessage("Cannot add the row. Unable to create new displays", exc, "VisAD SpreadSheet error");
                    continue;
                }
                catch (RemoteException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                    this.displayErrorMessage("Cannot add the row. A remote error occurred", exc, "VisAD SpreadSheet error");
                }
            }
            ++this.NumVisY;
            this.reconstructVert(newLabels, newDrag, fcells);
            this.LayDelRow.setEnabled(true);
        }
    }

    public synchronized boolean deleteColumn() {
        int i;
        if (this.NumVisX == 1) {
            this.displayErrorMessage("This is the last column", null, "Cannot delete column");
            return false;
        }
        for (int j = 0; j < this.NumVisY; ++j) {
            if (!this.DisplayCells[this.CurX][j].othersDepend()) continue;
            this.displayErrorMessage("Other cells depend on cells from this column. Make sure that no cells depend on this column before attempting to delete it", null, "Cannot delete column");
            return false;
        }
        JLabel label = (JLabel)this.HorizLabel[this.CurX].getComponent(0);
        char letter = label.getText().charAt(0);
        char last = Letters.charAt(Letters.length() - 1);
        JPanel[] newLabels = new JPanel[this.NumVisX - 1];
        for (i = 0; i < this.CurX; ++i) {
            newLabels[i] = this.HorizLabel[i];
        }
        for (i = this.CurX + 1; i < this.NumVisX; ++i) {
            newLabels[i - 1] = this.HorizLabel[i];
        }
        if (this.IsRemote) {
            this.HorizLabel = newLabels;
            this.synchColRow();
        } else {
            JComponent[] newDrag = new JComponent[this.NumVisX - 1];
            for (int i2 = 0; i2 < this.NumVisX - 1; ++i2) {
                newDrag[i2] = this.HorizDrag[i2];
            }
            this.HorizPanel.removeAll();
            FancySSCell[][] fcells = new FancySSCell[this.NumVisX - 1][this.NumVisY];
            this.DisplayPanel.removeAll();
            for (int j = 0; j < this.NumVisY; ++j) {
                int i3;
                for (i3 = 0; i3 < this.CurX; ++i3) {
                    fcells[i3][j] = this.DisplayCells[i3][j];
                }
                for (i3 = this.CurX + 1; i3 < this.NumVisX; ++i3) {
                    fcells[i3 - 1][j] = this.DisplayCells[i3][j];
                }
                try {
                    this.DisplayCells[this.CurX][j].destroyCell();
                }
                catch (VisADException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                    this.displayErrorMessage("Cannot destroy cell (3)", exc, "VisAD SpreadSheet error");
                }
                catch (RemoteException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                    this.displayErrorMessage("Cannot destroy cell (4)", exc, "VisAD SpreadSheet error");
                }
                this.DisplayCells[this.CurX][j] = null;
            }
            --this.NumVisX;
            if (this.CurX > this.NumVisX - 1) {
                this.selectCell(this.NumVisX - 1, this.CurY);
            }
            this.reconstructHoriz(newLabels, newDrag, fcells);
            if (letter == last) {
                this.LayAddCol.setEnabled(true);
            }
            if (this.NumVisX == 1) {
                this.LayDelCol.setEnabled(false);
            }
        }
        return true;
    }

    public synchronized boolean deleteRow() {
        int i;
        if (this.NumVisY == 1) {
            this.displayErrorMessage("This is the last row", null, "Cannot delete row");
            return false;
        }
        for (int i2 = 0; i2 < this.NumVisX; ++i2) {
            if (!this.DisplayCells[i2][this.CurY].othersDepend()) continue;
            this.displayErrorMessage("Other cells depend on cells from this row. Make sure that no cells depend on this row before attempting to delete it", null, "Cannot delete row");
            return false;
        }
        JPanel[] newLabels = new JPanel[this.NumVisY - 1];
        for (i = 0; i < this.CurY; ++i) {
            newLabels[i] = this.VertLabel[i];
        }
        for (i = this.CurY + 1; i < this.NumVisY; ++i) {
            newLabels[i - 1] = this.VertLabel[i];
        }
        if (this.IsRemote) {
            this.VertLabel = newLabels;
            this.synchColRow();
        } else {
            JComponent[] newDrag = new JComponent[this.NumVisY];
            for (int i3 = 0; i3 < this.NumVisY; ++i3) {
                newDrag[i3] = this.VertDrag[i3];
            }
            this.VertPanel.removeAll();
            FancySSCell[][] fcells = new FancySSCell[this.NumVisX][this.NumVisY - 1];
            this.DisplayPanel.removeAll();
            for (int i4 = 0; i4 < this.NumVisX; ++i4) {
                int j;
                for (j = 0; j < this.CurY; ++j) {
                    fcells[i4][j] = this.DisplayCells[i4][j];
                }
                for (j = this.CurY + 1; j < this.NumVisY; ++j) {
                    fcells[i4][j - 1] = this.DisplayCells[i4][j];
                }
                try {
                    this.DisplayCells[i4][this.CurY].destroyCell();
                }
                catch (VisADException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                    this.displayErrorMessage("Cannot destroy cell (5)", exc, "VisAD SpreadSheet error");
                }
                catch (RemoteException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                    this.displayErrorMessage("Cannot destroy cell (6)", exc, "VisAD SpreadSheet error");
                }
                this.DisplayCells[i4][this.CurY] = null;
            }
            --this.NumVisY;
            if (this.CurY > this.NumVisY - 1) {
                this.selectCell(this.CurX, this.NumVisY - 1);
            }
            this.reconstructVert(newLabels, newDrag, fcells);
            if (this.NumVisY == 1) {
                this.LayDelRow.setEnabled(false);
            }
        }
        return true;
    }

    public void tileCells() {
        Dimension paneSize = this.SCPane.getSize();
        int w = paneSize.width - this.SCPane.getVScrollbarWidth() - 5 * this.NumVisX;
        int h = paneSize.height - this.SCPane.getHScrollbarHeight() - 5 * this.NumVisY;
        int wx = w / this.NumVisX;
        int hy = h / this.NumVisY;
        if (wx < 120) {
            wx = 120;
        }
        if (hy < 120) {
            hy = 120;
        }
        Dimension hSize = new Dimension(wx, 20);
        Dimension vSize = new Dimension(30, hy);
        for (int i = 0; i < this.NumVisX; ++i) {
            this.HorizLabel[i].setSize(hSize);
            this.HorizLabel[i].setPreferredSize(hSize);
        }
        for (int j = 0; j < this.NumVisY; ++j) {
            this.VertLabel[j].setSize(vSize);
            this.VertLabel[j].setPreferredSize(vSize);
        }
        this.synchLabelAndCellSizes();
    }

    public void optionsSwitch() {
        this.setAutoSwitch(this.AutoSwitchBox.getState());
    }

    public void optionsDetect() {
        this.setAutoDetect(this.AutoDetectBox.getState());
    }

    public void optionsDisplay() {
        this.setAutoShowControls(this.AutoShowBox.getState());
    }

    protected void setAutoSwitch(boolean b) {
        for (int j = 0; j < this.NumVisY; ++j) {
            for (int i = 0; i < this.NumVisX; ++i) {
                this.DisplayCells[i][j].setAutoSwitch(b);
            }
        }
        this.AutoSwitch = b;
    }

    protected void setAutoDetect(boolean b) {
        for (int j = 0; j < this.NumVisY; ++j) {
            for (int i = 0; i < this.NumVisX; ++i) {
                this.DisplayCells[i][j].setAutoDetect(b);
            }
        }
        this.AutoDetect = b;
    }

    protected void setAutoShowControls(boolean b) {
        for (int j = 0; j < this.NumVisY; ++j) {
            for (int i = 0; i < this.NumVisX; ++i) {
                this.DisplayCells[i][j].setAutoShowControls(b);
            }
        }
        this.AutoShowControls = b;
    }

    public void formulaAdd() {
        this.FormulaEditor.setItem("");
        this.FormulaEditor.selectAll();
    }

    public void formulaDel() {
        String item = (String)this.FormulaBox.getSelectedItem();
        if (item == null) {
            return;
        }
        int index = item.indexOf(":");
        if (index < 0) {
            return;
        }
        String varName = item.substring(0, index);
        try {
            this.DisplayCells[this.CurX][this.CurY].removeData(varName);
            this.FormulaBox.removeItem(item);
        }
        catch (VisADException exc) {
            if (BasicSSCell.DEBUG) {
                exc.printStackTrace();
            }
            this.displayErrorMessage("Cannot delete data " + varName, exc, "VisAD SpreadSheet error");
        }
        catch (RemoteException exc) {
            if (BasicSSCell.DEBUG) {
                exc.printStackTrace();
            }
            this.displayErrorMessage("Cannot delete data " + varName, exc, "VisAD SpreadSheet error");
        }
    }

    protected void refreshCells() {
        Util.invoke(false, BasicSSCell.DEBUG, new Runnable(){

            public void run() {
                for (int i = 0; i < SpreadSheet.this.NumVisX; ++i) {
                    for (int j = 0; j < SpreadSheet.this.NumVisY; ++j) {
                        SpreadSheet.this.DisplayCells[i][j].refresh();
                    }
                }
            }
        });
    }

    protected void refreshOptions() {
        Util.invoke(false, BasicSSCell.DEBUG, new Runnable(){

            public void run() {
                SpreadSheet.this.AutoSwitchBox.setState(SpreadSheet.this.AutoSwitch);
                SpreadSheet.this.AutoDetectBox.setState(SpreadSheet.this.AutoDetect);
                SpreadSheet.this.AutoShowBox.setState(SpreadSheet.this.AutoShowControls);
            }
        });
    }

    protected void refreshShowControls() {
        Util.invoke(false, BasicSSCell.DEBUG, new Runnable(){

            public void run() {
                boolean b = SpreadSheet.this.DisplayCells[SpreadSheet.this.CurX][SpreadSheet.this.CurY].hasControls();
                SpreadSheet.this.CellShow.setEnabled(b);
                if (!BugFix) {
                    SpreadSheet.this.ToolShow.setEnabled(b);
                }
            }
        });
    }

    protected void refreshMenuCommands() {
        Util.invoke(false, BasicSSCell.DEBUG, new Runnable(){

            public void run() {
                boolean b = SpreadSheet.this.DisplayCells[SpreadSheet.this.CurX][SpreadSheet.this.CurY].hasData();
                SpreadSheet.this.FileExport.setEnabled(b);
                SpreadSheet.this.FileSnap.setEnabled(b && CanDoJPEG);
                SpreadSheet.this.EditClear.setEnabled(b);
                SpreadSheet.this.CellPrint.setEnabled(b);
                SpreadSheet.this.CellEdit.setEnabled(b);
                SpreadSheet.this.CellReset.setEnabled(b && !SpreadSheet.this.IsSlave);
                if (!BugFix) {
                    SpreadSheet.this.ToolSave.setEnabled(b);
                    SpreadSheet.this.ToolMap.setEnabled(b);
                    SpreadSheet.this.ToolReset.setEnabled(b && !SpreadSheet.this.IsSlave);
                }
                SpreadSheet.this.refreshShowControls();
            }
        });
    }

    protected void refreshFormulaBar() {
        Util.invoke(false, BasicSSCell.DEBUG, new Runnable(){

            public void run() {
                if (SpreadSheet.this.FormulaBox.getItemCount() > 0) {
                    SpreadSheet.this.FormulaBox.removeAllItems();
                }
                String[] varNames = SpreadSheet.this.DisplayCells[SpreadSheet.this.CurX][SpreadSheet.this.CurY].getVariableNames();
                int len = varNames.length;
                for (int i = 0; i < len; ++i) {
                    String varName = varNames[i];
                    String source = SpreadSheet.this.DisplayCells[SpreadSheet.this.CurX][SpreadSheet.this.CurY].getDataSource(varName);
                    SpreadSheet.this.FormulaBox.addItem(varName + ": " + source);
                }
                boolean b = len > 0;
                SpreadSheet.this.CellDel.setEnabled(b);
                if (!BugFix) {
                    SpreadSheet.this.FormulaDel.setEnabled(b);
                }
            }
        });
    }

    protected void refreshDisplayMenuItems() {
        Util.invoke(false, BasicSSCell.DEBUG, new Runnable(){

            public void run() {
                int dim = SpreadSheet.this.DisplayCells[SpreadSheet.this.CurX][SpreadSheet.this.CurY].getDimension();
                boolean j3d3d = dim == 1;
                boolean j2d2d = dim == 2;
                boolean j3d2d = dim == 3;
                SpreadSheet.this.CellDim3D3D.setState(j3d3d);
                SpreadSheet.this.CellDim2D2D.setState(j2d2d);
                SpreadSheet.this.CellDim2D3D.setState(j3d2d);
                if (!BugFix) {
                    SpreadSheet.this.Tool3D.setEnabled(!j3d3d && CanDo3D);
                    SpreadSheet.this.Tool2D.setEnabled(!j3d2d && CanDo3D);
                    SpreadSheet.this.ToolJ2D.setEnabled(!j2d2d);
                }
            }
        });
    }

    private double getColRowID() {
        block6: {
            TupleIface t = null;
            Real id = null;
            try {
                t = (TupleIface)this.RemoteColRow.getData();
                id = (Real)t.getComponent(0);
                return id.getValue();
            }
            catch (NullPointerException exc) {
                if (BasicSSCell.DEBUG) {
                    exc.printStackTrace();
                }
            }
            catch (VisADException exc) {
                if (BasicSSCell.DEBUG) {
                    exc.printStackTrace();
                }
            }
            catch (RemoteException exc) {
                if (!BasicSSCell.DEBUG) break block6;
                exc.printStackTrace();
            }
        }
        return Double.NaN;
    }

    private String[][] getNewCellNames() {
        int i;
        int rowlen;
        int collen;
        RealTuple tr;
        TupleIface tc;
        block25: {
            block24: {
                TupleIface t = null;
                tc = null;
                tr = null;
                try {
                    t = (TupleIface)this.RemoteColRow.getData();
                    tc = (TupleIface)t.getComponent(1);
                    tr = (RealTuple)t.getComponent(2);
                }
                catch (NullPointerException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                }
                catch (VisADException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                }
                catch (RemoteException exc) {
                    if (!BasicSSCell.DEBUG) break block24;
                    exc.printStackTrace();
                }
            }
            if (tc == null || tr == null) {
                return null;
            }
            collen = -1;
            rowlen = -1;
            try {
                collen = tc.getDimension();
                rowlen = tr.getDimension();
            }
            catch (RemoteException exc) {
                if (!BasicSSCell.DEBUG) break block25;
                exc.printStackTrace();
            }
        }
        if (rowlen < 1 || collen < 1) {
            return null;
        }
        String[] colNames = new String[collen];
        int[] rowNames = new int[rowlen];
        String[][] cellNames = new String[collen][rowlen];
        for (i = 0; i < collen; ++i) {
            Text txt;
            block26: {
                txt = null;
                try {
                    txt = (Text)tc.getComponent(i);
                }
                catch (VisADException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                }
                catch (RemoteException exc) {
                    if (!BasicSSCell.DEBUG) break block26;
                    exc.printStackTrace();
                }
            }
            if (txt == null) {
                return null;
            }
            colNames[i] = txt.getValue();
        }
        for (int j = 0; j < rowlen; ++j) {
            Real r;
            block27: {
                r = null;
                try {
                    r = (Real)tr.getComponent(j);
                }
                catch (VisADException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                }
                catch (RemoteException exc) {
                    if (!BasicSSCell.DEBUG) break block27;
                    exc.printStackTrace();
                }
            }
            if (r == null) {
                return null;
            }
            rowNames[j] = (int)r.getValue();
        }
        for (i = 0; i < collen; ++i) {
            for (int j = 0; j < rowlen; ++j) {
                cellNames[i][j] = colNames[i] + rowNames[j];
            }
        }
        return cellNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchColRow() {
        if (this.RemoteColRow != null) {
            RemoteDataReference remoteDataReference = this.RemoteColRow;
            synchronized (remoteDataReference) {
                block10: {
                    int xlen = this.HorizLabel.length;
                    int ylen = this.VertLabel.length;
                    try {
                        MathType[] m = new MathType[3];
                        Real id = new Real(this.CollabID);
                        m[0] = id.getType();
                        Data[] txt = new Text[xlen];
                        MathType[] tt = new TextType[xlen];
                        for (int i = 0; i < xlen; ++i) {
                            String s = ((JLabel)this.HorizLabel[i].getComponent(0)).getText();
                            txt[i] = new Text(s);
                            tt[i] = (TextType)((DataImpl)txt[i]).getType();
                        }
                        m[1] = new TupleType(tt);
                        Tuple tc = new Tuple((TupleType)m[1], txt);
                        Real[] r = new Real[ylen];
                        for (int j = 0; j < ylen; ++j) {
                            String s = ((JLabel)this.VertLabel[j].getComponent(0)).getText();
                            r[j] = new Real(Integer.parseInt(s));
                        }
                        RealTuple tr = new RealTuple(r);
                        m[2] = tr.getType();
                        Tuple t = new Tuple(new TupleType(m), new Data[]{id, tc, tr});
                        this.RemoteColRow.setData(t);
                    }
                    catch (VisADException exc) {
                        if (BasicSSCell.DEBUG) {
                            exc.printStackTrace();
                        }
                    }
                    catch (RemoteException exc) {
                        if (!BasicSSCell.DEBUG) break block10;
                        exc.printStackTrace();
                    }
                }
            }
        }
    }

    private void synchLabelAndCellSizes() {
        for (int j = 0; j < this.NumVisY; ++j) {
            int h = this.VertLabel[j].getSize().height;
            for (int i = 0; i < this.NumVisX; ++i) {
                int w = this.HorizLabel[i].getSize().width;
                this.DisplayCells[i][j].setPreferredSize(new Dimension(w, h));
            }
        }
        this.HorizLabels.validate();
        this.VertLabels.validate();
        this.DisplayPanel.doLayout();
        this.SCPane.validate();
        this.refreshCells();
    }

    private void constructSpreadsheetCells(RemoteServer rs) {
        String[][] labels = new String[this.NumVisX][this.NumVisY];
        for (int i = 0; i < this.NumVisX; ++i) {
            for (int j = 0; j < this.NumVisY; ++j) {
                labels[i][j] = "" + Letters.charAt(i) + (j + 1);
            }
        }
        this.constructSpreadsheetCells(labels, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructSpreadsheetCells(String[][] l, RemoteServer rs) {
        Object object = this.Lock;
        synchronized (object) {
            this.DisplayPanel.setLayout(new SSLayout(this.NumVisX, this.NumVisY, 5, 5));
            this.DisplayCells = new FancySSCell[this.NumVisX][this.NumVisY];
            for (int j = 0; j < this.NumVisY; ++j) {
                int ph = this.VertLabel[j].getPreferredSize().height;
                for (int i = 0; i < this.NumVisX; ++i) {
                    int pw = this.HorizLabel[i].getPreferredSize().width;
                    try {
                        FancySSCell f = (FancySSCell)BasicSSCell.getSSCellByName(l[i][j]);
                        if (f == null) {
                            f = this.createCell(l[i][j], rs);
                            f.addSSCellListener(this);
                            f.addMouseListener(this);
                            f.setAutoSwitch(this.AutoSwitch);
                            f.setAutoDetect(this.AutoDetect);
                            f.setAutoShowControls(this.AutoShowControls);
                            if (rs == null) {
                                f.setDimension(CanDo3D ? 1 : 2);
                            }
                            f.addDisplayListener(this);
                            if (this.rsi != null) {
                                f.addToRemoteServer(this.rsi);
                            }
                        }
                        f.setPreferredSize(new Dimension(pw, ph));
                        this.DisplayCells[i][j] = f;
                        this.DisplayPanel.add(this.DisplayCells[i][j]);
                        continue;
                    }
                    catch (VisADException exc) {
                        if (BasicSSCell.DEBUG) {
                            exc.printStackTrace();
                        }
                        this.displayErrorMessage("Cannot construct spreadsheet cells. An error occurred", exc, "VisAD SpreadSheet error");
                        continue;
                    }
                    catch (RemoteException exc) {
                        if (BasicSSCell.DEBUG) {
                            exc.printStackTrace();
                        }
                        this.displayErrorMessage("Cannot construct spreadsheet cells. A remote error occurred", exc, "VisAD SpreadSheet error");
                    }
                }
            }
            this.selectCell(0, 0);
        }
    }

    private void constructHorizontalLabels() {
        this.constructHorizontalLabels(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructHorizontalLabels(String[] l, int[] widths) {
        int i;
        if (l == null) {
            l = new String[this.NumVisX];
            for (i = 0; i < this.NumVisX; ++i) {
                l[i] = "" + Letters.charAt(i);
            }
        }
        if (widths == null) {
            widths = new int[this.NumVisX];
            for (i = 0; i < this.NumVisX; ++i) {
                widths[i] = 250;
            }
        }
        Object object = this.Lock;
        synchronized (object) {
            this.HorizPanel.setLayout(new SSLayout(2 * this.NumVisX, 1, 0, 0));
            this.HorizLabel = new JPanel[this.NumVisX];
            this.HorizDrag = new JComponent[this.NumVisX];
            for (int i2 = 0; i2 < this.NumVisX; ++i2) {
                this.HorizLabel[i2] = new JPanel();
                this.HorizLabel[i2].setBorder(new LineBorder(Color.black, 1));
                this.HorizLabel[i2].setLayout(new BorderLayout());
                this.HorizLabel[i2].setPreferredSize(new Dimension(widths[i2], 20));
                this.HorizLabel[i2].add("Center", new JLabel(l[i2], 0));
                this.HorizPanel.add(this.HorizLabel[i2]);
                this.HorizDrag[i2] = new JComponent(){

                    public void paint(Graphics g) {
                        Dimension d = this.getSize();
                        g.setColor(Color.black);
                        g.drawRect(0, 0, d.width - 1, d.height - 1);
                        g.setColor(Color.yellow);
                        g.fillRect(1, 1, d.width - 2, d.height - 2);
                    }

                    public Dimension getPreferredSize() {
                        return new Dimension(5, 20);
                    }
                };
                this.HorizDrag[i2].setPreferredSize(new Dimension(5, 0));
                this.HorizDrag[i2].addMouseListener(this);
                this.HorizDrag[i2].addMouseMotionListener(this);
                this.HorizPanel.add(this.HorizDrag[i2]);
            }
        }
    }

    private void constructVerticalLabels() {
        this.constructVerticalLabels(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructVerticalLabels(String[] l, int[] heights) {
        int i;
        if (l == null) {
            l = new String[this.NumVisY];
            for (i = 0; i < this.NumVisY; ++i) {
                l[i] = "" + (i + 1);
            }
        }
        if (heights == null) {
            heights = new int[this.NumVisY];
            for (i = 0; i < this.NumVisY; ++i) {
                heights[i] = 250;
            }
        }
        Object object = this.Lock;
        synchronized (object) {
            this.VertPanel.setLayout(new SSLayout(1, 2 * this.NumVisY, 0, 0));
            this.VertLabel = new JPanel[this.NumVisY];
            this.VertDrag = new JComponent[this.NumVisY];
            for (int i2 = 0; i2 < this.NumVisY; ++i2) {
                this.VertLabel[i2] = new JPanel();
                this.VertLabel[i2].setBorder(new LineBorder(Color.black, 1));
                this.VertLabel[i2].setLayout(new BorderLayout());
                this.VertLabel[i2].setPreferredSize(new Dimension(30, heights[i2]));
                this.VertLabel[i2].add("Center", new JLabel(l[i2], 0));
                this.VertPanel.add(this.VertLabel[i2]);
                this.VertDrag[i2] = new JComponent(){

                    public void paint(Graphics g) {
                        Dimension d = this.getSize();
                        g.setColor(Color.black);
                        g.drawRect(0, 0, d.width - 1, d.height - 1);
                        g.setColor(Color.yellow);
                        g.fillRect(1, 1, d.width - 2, d.height - 2);
                    }

                    public Dimension getPreferredSize() {
                        return new Dimension(30, 5);
                    }
                };
                this.VertDrag[i2].setBackground(Color.white);
                this.VertDrag[i2].setPreferredSize(new Dimension(0, 5));
                this.VertDrag[i2].addMouseListener(this);
                this.VertDrag[i2].addMouseMotionListener(this);
                this.VertPanel.add(this.VertDrag[i2]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconstructLabels(String[][] cellNames, int[] w, int[] h) {
        String[] hLabels = new String[this.NumVisX];
        Object object = this.Lock;
        synchronized (object) {
            this.HorizPanel.removeAll();
            for (int i = 0; i < this.NumVisX; ++i) {
                hLabels[i] = "" + cellNames[i][0].charAt(0);
            }
        }
        this.constructHorizontalLabels(hLabels, w);
        String[] vLabels = new String[this.NumVisY];
        Object object2 = this.Lock;
        synchronized (object2) {
            this.VertPanel.removeAll();
            for (int j = 0; j < this.NumVisY; ++j) {
                vLabels[j] = cellNames[0][j].substring(1);
            }
        }
        this.constructVerticalLabels(vLabels, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reconstructSpreadsheet(String[][] cellNames, int[] w, int[] h, RemoteServer rs) {
        this.reconstructLabels(cellNames, w, h);
        Object object = this.Lock;
        synchronized (object) {
            int oy;
            int ox;
            this.DisplayPanel.removeAll();
            if (this.DisplayCells == null) {
                ox = 0;
                oy = 0;
            } else {
                ox = this.DisplayCells.length;
                oy = this.DisplayCells[0].length;
            }
            for (int i = 0; i < ox; ++i) {
                for (int j = 0; j < oy; ++j) {
                    try {
                        String s = this.DisplayCells[i][j].getName();
                        boolean kill = true;
                        for (int ii = 0; ii < cellNames.length; ++ii) {
                            for (int jj = 0; jj < cellNames[ii].length; ++jj) {
                                if (!s.equals(cellNames[ii][jj])) continue;
                                kill = false;
                            }
                        }
                        if (kill) {
                            this.DisplayCells[i][j].destroyCell();
                        }
                    }
                    catch (VisADException exc) {
                        if (BasicSSCell.DEBUG) {
                            exc.printStackTrace();
                        }
                        this.displayErrorMessage("Cannot destroy cell (7)", exc, "VisAD SpreadSheet error");
                    }
                    catch (RemoteException exc) {
                        if (BasicSSCell.DEBUG) {
                            exc.printStackTrace();
                        }
                        this.displayErrorMessage("Cannot destroy cell (8)", exc, "VisAD SpreadSheet error");
                    }
                    this.DisplayCells[i][j] = null;
                }
            }
        }
        this.constructSpreadsheetCells(cellNames, rs);
        object = this.Lock;
        synchronized (object) {
            this.HorizPanel.doLayout();
            for (int i = 0; i < this.NumVisX; ++i) {
                this.HorizLabel[i].doLayout();
            }
            this.VertPanel.doLayout();
            for (int j = 0; j < this.NumVisY; ++j) {
                this.VertLabel[j].doLayout();
            }
            this.SCPane.doLayout();
            this.DisplayPanel.doLayout();
            this.refreshCells();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconstructHoriz(JPanel[] newLabels, JComponent[] newDrag, FancySSCell[][] fcells) {
        Object object = this.Lock;
        synchronized (object) {
            int i;
            this.HorizLabel = newLabels;
            this.HorizDrag = newDrag;
            this.HorizPanel.setLayout(new SSLayout(2 * this.NumVisX, 1, 0, 0));
            for (i = 0; i < this.NumVisX; ++i) {
                this.HorizPanel.add(this.HorizLabel[i]);
                this.HorizPanel.add(this.HorizDrag[i]);
            }
            this.DisplayCells = fcells;
            this.DisplayPanel.setLayout(new SSLayout(this.NumVisX, this.NumVisY, 5, 5));
            for (int j = 0; j < this.NumVisY; ++j) {
                for (int i2 = 0; i2 < this.NumVisX; ++i2) {
                    this.DisplayPanel.add(this.DisplayCells[i2][j]);
                }
            }
            this.HorizPanel.validate();
            this.HorizLabels.validate();
            this.HorizLabels.repaint();
            for (i = 0; i < this.NumVisX; ++i) {
                this.HorizLabel[i].validate();
            }
            this.SCPane.validate();
            this.DisplayPanel.repaint();
            this.refreshCells();
        }
        this.synchColRow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconstructVert(JPanel[] newLabels, JComponent[] newDrag, FancySSCell[][] fcells) {
        Object object = this.Lock;
        synchronized (object) {
            int j;
            this.VertLabel = newLabels;
            this.VertDrag = newDrag;
            this.VertPanel.setLayout(new SSLayout(1, 2 * this.NumVisY, 0, 0));
            for (int i = 0; i < this.NumVisY; ++i) {
                this.VertPanel.add(this.VertLabel[i]);
                this.VertPanel.add(this.VertDrag[i]);
            }
            this.DisplayCells = fcells;
            this.DisplayPanel.setLayout(new SSLayout(this.NumVisX, this.NumVisY, 5, 5));
            for (j = 0; j < this.NumVisY; ++j) {
                for (int i = 0; i < this.NumVisX; ++i) {
                    this.DisplayPanel.add(this.DisplayCells[i][j]);
                }
            }
            this.VertPanel.validate();
            this.VertLabels.validate();
            this.VertLabels.repaint();
            for (j = 0; j < this.NumVisY; ++j) {
                this.VertLabel[j].validate();
            }
            this.SCPane.validate();
            this.DisplayPanel.repaint();
            this.refreshCells();
        }
        this.synchColRow();
    }

    public void itemStateChanged(ItemEvent e) {
        String item = (String)e.getItem();
        if (item.equals("3-D (Java3D)")) {
            this.setDim(1);
        } else if (item.equals("2-D (Java2D)")) {
            this.setDim(2);
        } else if (item.equals("2-D (Java3D)")) {
            this.setDim(3);
        } else if (item.equals("Auto-switch to 3-D")) {
            boolean b = e.getStateChange() == 1;
            this.setAutoSwitch(b);
        } else if (item.equals("Auto-detect mappings")) {
            boolean b = e.getStateChange() == 1;
            this.setAutoDetect(b);
        } else if (item.equals("Auto-display controls")) {
            boolean b = e.getStateChange() == 1;
            this.setAutoShowControls(b);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        Adjustable a = e.getAdjustable();
        int value = a.getValue();
        if (a.getOrientation() == 0) {
            this.HorizLabels.setViewPosition(new Point(value, 0));
        } else {
            this.VertLabels.setViewPosition(new Point(0, value));
        }
    }

    public void displayChanged(DisplayEvent e) {
        if (e.getId() == 1 && !e.isRemote()) {
            String name;
            block9: {
                name = null;
                try {
                    Display d = e.getDisplay();
                    name = d.getName();
                    if (name.endsWith(".remote")) {
                        name = name.substring(0, name.length() - 7);
                    }
                }
                catch (VisADException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                }
                catch (RemoteException exc) {
                    if (!BasicSSCell.DEBUG) break block9;
                    exc.printStackTrace();
                }
            }
            FancySSCell fcell = (FancySSCell)BasicSSCell.getSSCellByName(name);
            int ci = -1;
            int cj = -1;
            for (int j = 0; j < this.NumVisY; ++j) {
                for (int i = 0; i < this.NumVisX; ++i) {
                    if (fcell != this.DisplayCells[i][j]) continue;
                    ci = i;
                    cj = j;
                }
            }
            if (BasicSSCell.DEBUG && (ci < 0 || cj < 0)) {
                System.err.println("Warning: an unknown display change occurred: display (" + name + ") has changed, but there is no " + "corresponding SSCell with that name!");
            }
            this.selectCell(ci, cj);
        }
    }

    public void keyPressed(KeyEvent e) {
        this.commandKey = true;
        int keyCode = e.getKeyCode();
        if (keyCode == 10) {
            this.FormulaListener.actionPerformed(new ActionEvent(this.FormulaEditor, 0, ""));
        } else if (keyCode == 8) {
            int end;
            String text = this.FormulaText.getText();
            int start = this.FormulaText.getSelectionStart();
            if (start != (end = this.FormulaText.getSelectionEnd()) || start != 0) {
                int pos = start == end ? start - 1 : start;
                String pre = text.substring(0, pos);
                String post = text.substring(end);
                this.FormulaText.setText(pre + post);
                this.FormulaText.getCaret().setDot(pos);
            }
        } else if (keyCode == 16) {
            this.shiftHeld = true;
        } else if (keyCode == 37) {
            int pos = this.FormulaText.getCaretPosition();
            if (this.shiftHeld) {
                if (pos > 0) {
                    this.FormulaText.getCaret().moveDot(pos - 1);
                }
            } else if (pos > 0) {
                this.FormulaText.getCaret().setDot(pos - 1);
            }
        } else if (keyCode == 39) {
            int pos = this.FormulaText.getCaretPosition();
            if (this.shiftHeld) {
                if (pos < this.FormulaText.getText().length()) {
                    this.FormulaText.getCaret().moveDot(pos + 1);
                }
            } else if (pos < this.FormulaText.getText().length()) {
                this.FormulaText.getCaret().setDot(pos + 1);
            }
        } else if (keyCode == 36) {
            if (this.shiftHeld) {
                this.FormulaText.getCaret().moveDot(0);
            } else {
                this.FormulaText.getCaret().setDot(0);
            }
        } else if (keyCode == 35) {
            if (this.shiftHeld) {
                this.FormulaText.getCaret().moveDot(this.FormulaText.getText().length());
            } else {
                this.FormulaText.getCaret().setDot(this.FormulaText.getText().length());
            }
        } else {
            this.commandKey = false;
        }
    }

    public void keyReleased(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode == 16) {
            this.shiftHeld = false;
        }
    }

    public void keyTyped(KeyEvent e) {
        char key = e.getKeyChar();
        if (!this.commandKey && !e.isActionKey() && key >= ' ') {
            int start = this.FormulaText.getSelectionStart();
            int end = this.FormulaText.getSelectionEnd();
            String text = this.FormulaText.getText();
            this.FormulaText.setText(text.substring(0, start) + key + text.substring(end));
            this.FormulaText.getCaret().setDot(start + 1);
        }
        e.consume();
    }

    public void mousePressed(MouseEvent e) {
        Component c = e.getComponent();
        for (int j = 0; j < this.NumVisY; ++j) {
            for (int i = 0; i < this.NumVisX; ++i) {
                if (c != this.DisplayCells[i][j]) continue;
                this.selectCell(i, j);
                return;
            }
        }
        this.oldX = e.getX();
        this.oldY = e.getY();
    }

    public void mouseReleased(MouseEvent e) {
        int j;
        int x = e.getX();
        int y = e.getY();
        Component c = e.getComponent();
        boolean change = false;
        for (j = 0; j < this.NumVisX; ++j) {
            if (c != this.HorizDrag[j]) continue;
            change = true;
            break;
        }
        for (j = 0; j < this.NumVisY; ++j) {
            if (c != this.VertDrag[j]) continue;
            change = true;
            break;
        }
        if (change) {
            this.synchLabelAndCellSizes();
        }
    }

    public void mouseDragged(MouseEvent e) {
        int j;
        Component c = e.getComponent();
        int x = e.getX();
        int y = e.getY();
        for (j = 0; j < this.NumVisX; ++j) {
            if (c != this.HorizDrag[j]) continue;
            Dimension s = this.HorizLabel[j].getSize();
            int oldW = s.width;
            s.width += x - this.oldX;
            if (s.width < 120) {
                s.width = 120;
            }
            this.HorizLabel[j].setSize(s);
            this.HorizLabel[j].setPreferredSize(s);
            this.HorizLabels.validate();
            return;
        }
        for (j = 0; j < this.NumVisY; ++j) {
            if (c != this.VertDrag[j]) continue;
            Dimension s = this.VertLabel[j].getSize();
            int oldH = s.height;
            s.height += y - this.oldY;
            if (s.height < 120) {
                s.height = 120;
            }
            this.VertLabel[j].setSize(s);
            this.VertLabel[j].setPreferredSize(s);
            this.VertLabels.validate();
            return;
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void ssCellChanged(SSCellChangeEvent e) {
        FancySSCell f = (FancySSCell)e.getSSCell();
        if (this.CurX < this.NumVisX && this.CurY < this.NumVisY && this.DisplayCells[this.CurX][this.CurY] == f) {
            int ct = e.getChangeType();
            if (ct == SSCellChangeEvent.DATA_CHANGE) {
                this.refreshFormulaBar();
                this.refreshMenuCommands();
            } else if (ct == SSCellChangeEvent.DISPLAY_CHANGE) {
                this.refreshShowControls();
                if (this.IsSlave) {
                    this.refreshFormulaBar();
                    this.refreshMenuCommands();
                }
            } else if (ct == SSCellChangeEvent.DIMENSION_CHANGE) {
                this.refreshDisplayMenuItems();
            }
        }
    }

    public static void setSSCellClass(Class c) {
        block2: {
            try {
                cellConstructor = c.getConstructor(cellArgs);
            }
            catch (NoSuchMethodException exc) {
                if (!BasicSSCell.DEBUG) break block2;
                exc.printStackTrace();
            }
        }
    }

    public void selectCell(int x, int y) {
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x >= this.NumVisX) {
            x = this.NumVisX - 1;
        }
        if (y >= this.NumVisY) {
            y = this.NumVisY - 1;
        }
        for (int j = 0; j < this.NumVisY; ++j) {
            for (int i = 0; i < this.NumVisX; ++i) {
                boolean selected = x == i && y == j;
                this.DisplayCells[i][j].setSelected(selected);
                this.DisplayCells[i][j].setAutoShowControls(selected && this.AutoShowControls);
            }
        }
        this.CurX = x;
        this.CurY = y;
        this.FormulaText.getCaret().setVisible(true);
        this.refreshFormulaBar();
        this.refreshMenuCommands();
        this.refreshDisplayMenuItems();
    }

    protected boolean getOptions(int cols, int rows, String server, String clone, boolean slave) {
        final SSOptions options = new SSOptions(cols, rows, CanDo3D, BugFix, BasicSSCell.DEBUG, server, clone, slave);
        final boolean[] success = new boolean[]{false};
        final JDialog dialog = new JDialog((Frame)null, "VisAD SpreadSheet Options", true);
        JPanel pane = new JPanel();
        dialog.setContentPane(pane);
        pane.setLayout(new BoxLayout(pane, 1));
        JPanel row1 = new JPanel();
        row1.setLayout(new BoxLayout(row1, 0));
        JPanel row1Cols = new JPanel();
        row1Cols.setLayout(new BoxLayout(row1Cols, 1));
        row1Cols.add(new JLabel("Columns"));
        final JTextField colField = new JTextField("" + cols);
        Util.adjustTextField(colField);
        colField.setEnabled(clone == null);
        row1Cols.add(colField);
        row1.add(row1Cols);
        JPanel row1Xs = new JPanel();
        row1Xs.setLayout(new BoxLayout(row1Xs, 1));
        row1Xs.add(new JLabel(" x "));
        row1Xs.add(new JLabel(" x "));
        row1.add(row1Xs);
        JPanel row1Rows = new JPanel();
        row1Rows.setLayout(new BoxLayout(row1Rows, 1));
        row1Rows.add(new JLabel("Rows"));
        final JTextField rowField = new JTextField("" + rows);
        Util.adjustTextField(rowField);
        rowField.setEnabled(clone == null);
        row1Rows.add(rowField);
        row1.add(row1Rows);
        JPanel row1Boxes = new JPanel();
        row1Boxes.setLayout(new BoxLayout(row1Boxes, 1));
        final JCheckBox java3d = new JCheckBox("Enable Java3D", CanDo3D);
        java3d.setEnabled(Possible3D);
        row1Boxes.add(java3d);
        final JCheckBox toolBox = new JCheckBox("Enable toolbar", !BugFix);
        row1Boxes.add(toolBox);
        final JCheckBox debugBox = new JCheckBox("Debug mode", BasicSSCell.DEBUG);
        row1Boxes.add(debugBox);
        row1.add(row1Boxes);
        pane.add(row1);
        JPanel row2 = new JPanel();
        row2.setLayout(new BoxLayout(row2, 0));
        ButtonGroup collabGroup = new ButtonGroup();
        final JRadioButton serverChoice = new JRadioButton("Server");
        serverChoice.setSelected(server != null && clone == null);
        collabGroup.add(serverChoice);
        row2.add(serverChoice);
        final JRadioButton cloneChoice = new JRadioButton("Clone");
        cloneChoice.setSelected(clone != null && !slave);
        collabGroup.add(cloneChoice);
        row2.add(cloneChoice);
        final JRadioButton slaveChoice = new JRadioButton("Slave");
        slaveChoice.setSelected(slave);
        collabGroup.add(slaveChoice);
        row2.add(slaveChoice);
        final JRadioButton aloneChoice = new JRadioButton("Stand-alone");
        aloneChoice.setSelected(server == null && clone == null);
        collabGroup.add(aloneChoice);
        row2.add(aloneChoice);
        pane.add(row2);
        JPanel row3 = new JPanel();
        row3.setLayout(new BoxLayout(row3, 0));
        row3.add(new JLabel("Server name "));
        final JTextField name = new JTextField(server == null ? "" : server);
        Util.adjustTextField(name);
        name.setEnabled(server != null);
        row3.add(name);
        pane.add(row3);
        JPanel row4 = new JPanel();
        row4.setLayout(new BoxLayout(row4, 0));
        row4.add(new JLabel("Server address "));
        final JTextField host = new JTextField(clone == null ? "" : clone);
        Util.adjustTextField(host);
        host.setEnabled(clone != null);
        row4.add(host);
        pane.add(row4);
        JPanel row5 = new JPanel();
        row5.setLayout(new BoxLayout(row5, 0));
        boolean first = true;
        String extras = "Extras: ";
        if (Possible3D) {
            extras = extras + (first ? "" : ", ") + "Java3D";
            first = false;
        }
        if (CanDoHDF5) {
            extras = extras + (first ? "" : ", ") + "HDF-5";
            first = false;
        }
        if (CanDoJPEG) {
            extras = extras + (first ? "" : ", ") + "JPEG snapshot";
            first = false;
        }
        if (CanDoPython) {
            extras = extras + (first ? "" : ", ") + "JPython scripting";
            first = false;
        }
        if (first) {
            extras = extras + "None";
        }
        extras = extras + ".";
        row5.add(new JLabel(extras));
        pane.add(row5);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        final JButton ok = new JButton("Ok");
        dialog.getRootPane().setDefaultButton(ok);
        buttons.add(ok);
        final JButton cancel = new JButton("Cancel");
        buttons.add(cancel);
        final JButton quit = new JButton("Quit");
        buttons.add(quit);
        pane.add(buttons);
        ActionListener handler = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object o = e.getSource();
                if (o == serverChoice) {
                    colField.setEnabled(true);
                    rowField.setEnabled(true);
                    name.setEnabled(true);
                    host.setEnabled(false);
                } else if (o == cloneChoice || o == slaveChoice) {
                    colField.setEnabled(false);
                    rowField.setEnabled(false);
                    name.setEnabled(true);
                    host.setEnabled(true);
                } else if (o == aloneChoice) {
                    colField.setEnabled(true);
                    rowField.setEnabled(true);
                    name.setEnabled(false);
                    host.setEnabled(false);
                } else if (o == ok) {
                    boolean serv = serverChoice.isSelected();
                    boolean clon = cloneChoice.isSelected();
                    boolean slav = slaveChoice.isSelected();
                    boolean alon = aloneChoice.isSelected();
                    if (clon || slav) {
                        options.cols = 2;
                        options.rows = 2;
                    } else {
                        options.cols = 0;
                        try {
                            options.cols = Integer.parseInt(colField.getText());
                        }
                        catch (NumberFormatException exc) {
                            // empty catch block
                        }
                        if (options.cols <= 0) {
                            SpreadSheet.this.displayErrorMessage(dialog, "The columns field must contain a number greater than zero", null, "Invalid value");
                            return;
                        }
                        options.rows = 0;
                        try {
                            options.rows = Integer.parseInt(rowField.getText());
                        }
                        catch (NumberFormatException exc) {
                            // empty catch block
                        }
                        if (options.rows <= 0) {
                            SpreadSheet.this.displayErrorMessage(dialog, "The rows field must contain a number greater than zero", null, "Invalid value");
                            return;
                        }
                    }
                    options.enable3d = java3d.isSelected();
                    options.bugfix = !toolBox.isSelected();
                    options.debug = debugBox.isSelected();
                    options.name = alon ? null : name.getText();
                    options.address = clon || slav ? host.getText() : null;
                    options.slave = slav;
                    SpreadSheet.this.NumVisX = options.cols;
                    SpreadSheet.this.NumVisY = options.rows;
                    CanDo3D = options.enable3d;
                    BasicSSCell.DEBUG = options.debug;
                    BugFix = options.bugfix;
                    SpreadSheet.this.serverName = options.name;
                    SpreadSheet.this.cloneAddress = options.address;
                    SpreadSheet.this.IsSlave = options.slave;
                    success[0] = true;
                    dialog.setVisible(false);
                } else if (o == cancel) {
                    success[0] = false;
                    dialog.setVisible(false);
                } else if (o == quit) {
                    System.exit(0);
                }
            }
        };
        serverChoice.addActionListener(handler);
        cloneChoice.addActionListener(handler);
        slaveChoice.addActionListener(handler);
        aloneChoice.addActionListener(handler);
        ok.addActionListener(handler);
        cancel.addActionListener(handler);
        quit.addActionListener(handler);
        dialog.pack();
        Util.centerWindow(dialog);
        dialog.setVisible(true);
        return success[0];
    }

    public JToolBar getToolbar() {
        return this.Toolbar;
    }

    protected FancySSCell createCell(String name, RemoteServer rs) throws VisADException, RemoteException {
        Object[] args = new Object[]{name, this.fm, rs, new Boolean(this.IsSlave), null, this};
        if (cellConstructor == null) {
            SpreadSheet.setSSCellClass(FancySSCell.class);
        }
        Object cell = null;
        try {
            cell = cellConstructor.newInstance(args);
        }
        catch (IllegalAccessException exc) {
            exc.printStackTrace();
        }
        catch (InstantiationException exc) {
            exc.printStackTrace();
        }
        catch (InvocationTargetException exc) {
            if (exc.getTargetException() instanceof StubNotFoundException) {
                System.err.println("Your VisAD installation has not properly executed the RMIC\ncompiler on the appropriate source files. Please re-run\n\"make compile\" in the VisAD directory. If you are using\nMakefile.WinNT and running JDK 1.2, please double-check that\nyou have uncommented the RMIC-related environment variables,\nor else the RMIC-related classes will be placed in the wrong\ndirectories. A full stack dump follows:\n");
            }
            exc.getTargetException().printStackTrace();
        }
        if (!(cell instanceof FancySSCell)) {
            System.err.print("Cell constructor failed to produce a FancySSCell, but instead produced: ");
            if (cell == null) {
                System.err.println("null");
            } else {
                System.err.println(cell.getClass().getName());
            }
            System.exit(3);
        }
        return (FancySSCell)cell;
    }

    protected void displayErrorMessage(String msg, Exception exc, String title) {
        this.displayErrorMessage(this, msg, exc, title);
    }

    protected void displayErrorMessage(Component parent, String msg, Exception exc, String title) {
        String s = exc == null ? null : exc.getMessage();
        final Component c = parent;
        final String m = msg + (s == null ? "." : ": " + s);
        final String t = title;
        Util.invoke(false, BasicSSCell.DEBUG, new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(c, m, t, 0);
            }
        });
    }

    protected JButton addToolbarButton(String file, String tooltip, String command, boolean enabled, JComponent parent) {
        URL url = SpreadSheet.class.getResource(file + ".gif");
        ImageIcon icon = new ImageIcon(url);
        if (icon != null) {
            JButton b = new JButton(icon);
            b.setAlignmentY(0.5f);
            b.setToolTipText(tooltip);
            b.addActionListener(this);
            b.setActionCommand(command);
            b.setEnabled(enabled);
            if (parent instanceof JPanel) {
                int w = icon.getIconWidth() + 4;
                int h = icon.getIconHeight() + 4;
                b.setPreferredSize(new Dimension(w, h));
            }
            parent.add(b);
            return b;
        }
        return null;
    }

    public static void adjustTextField(JTextField field) {
        Util.adjustTextField(field);
    }

    public static void centerWindow(Window window) {
        Util.centerWindow(window);
    }

    static {
        matrix3D = new double[]{0.5, 0.0, 0.0, 0.0, 0.0, 0.5, 0.0, 0.0, 0.0, 0.0, 0.5, 0.0, 0.0, 0.0, 0.0, 1.0};
        matrix2D = new double[]{0.65, 0.0, 0.0, 0.0, 0.0, 0.65, 0.0, 0.0, 0.0, 0.0, 0.65, 0.0, 0.0, 0.0, 0.0, 1.0};
        matrixJ2D = new double[]{1.0, 0.0, 0.0, -1.0, 0.0, 0.0};
    }

    public class SSOptions {
        public int cols;
        public int rows;
        public boolean enable3d;
        public boolean bugfix;
        public boolean debug;
        public String name;
        public String address;
        public boolean slave;

        public SSOptions(int c, int r, boolean e, boolean b, boolean d, String n, String a, boolean s) {
            this.cols = c;
            this.rows = r;
            this.enable3d = e;
            this.bugfix = b;
            this.debug = d;
            this.name = n;
            this.address = a;
            this.slave = s;
        }
    }
}

