/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class GUIFrame
extends JFrame
implements ActionListener {
    public static final int MENU_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    protected JMenuBar menubar = new JMenuBar();
    protected Hashtable hash;
    protected boolean heavy;

    public GUIFrame() {
        this(false);
    }

    public GUIFrame(boolean heavyweight) {
        this.setJMenuBar(this.menubar);
        this.hash = new Hashtable();
        this.heavy = heavyweight;
    }

    public JMenu getMenu(String menu) {
        JMenu m = (JMenu)this.hash.get(menu);
        if (m == null) {
            m = new JMenu(menu);
            m.setMnemonic(menu.charAt(0));
            m.getPopupMenu().setLightWeightPopupEnabled(!this.heavy);
            this.menubar.add(m);
            this.hash.put(menu, m);
        }
        return m;
    }

    public JMenuItem getMenuItem(String menu, String item) {
        JMenuItem x = (JMenuItem)this.hash.get(menu + "\n" + item);
        return x;
    }

    public JMenuItem addMenuItem(String menu, String item, String command, char mnemonic) {
        JMenuItem x = new JMenuItem(item);
        this.addMenuItem(menu, x, command, mnemonic, true);
        return x;
    }

    public JMenuItem addMenuItem(String menu, String item, String command, char mnemonic, boolean enabled) {
        JMenuItem x = new JMenuItem(item);
        this.addMenuItem(menu, x, command, mnemonic, enabled);
        return x;
    }

    public void addMenuItem(String menu, JMenuItem item, String command, char mnemonic, boolean enabled) {
        JMenu m = this.getMenu(menu);
        item.setMnemonic(mnemonic);
        item.setActionCommand(command);
        item.addActionListener(this);
        item.setEnabled(enabled);
        m.add(item);
        this.hash.put(menu + "\n" + item.getText(), item);
    }

    public JMenu addSubMenu(String menu, String sub, char mnemonic) {
        JMenu x = new JMenu(sub);
        this.addSubMenu(menu, x, mnemonic, true);
        return x;
    }

    public JMenu addSubMenu(String menu, String sub, char mnemonic, boolean enabled) {
        JMenu x = new JMenu(sub);
        this.addSubMenu(menu, x, mnemonic, enabled);
        return x;
    }

    public void addSubMenu(String menu, JMenu sub, char mnemonic, boolean enabled) {
        JMenu m = this.getMenu(menu);
        sub.setMnemonic(mnemonic);
        sub.getPopupMenu().setLightWeightPopupEnabled(!this.heavy);
        sub.setEnabled(enabled);
        m.add(sub);
        this.hash.put(sub.getText(), sub);
    }

    public void addMenuSeparator(String menu) {
        JMenu m = this.getMenu(menu);
        m.addSeparator();
    }

    public void setMenuShortcut(String menu, String item, int keycode) {
        JMenuItem jmi = this.getMenuItem(menu, item);
        if (jmi == null) {
            return;
        }
        jmi.setAccelerator(KeyStroke.getKeyStroke(keycode, MENU_MASK));
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        Method method = null;
        try {
            method = this.getClass().getMethod(command, null);
        }
        catch (NoSuchMethodException exc) {
            exc.printStackTrace();
        }
        catch (SecurityException exc) {
            exc.printStackTrace();
        }
        if (method != null) {
            try {
                method.invoke((Object)this, (Object[])null);
            }
            catch (IllegalAccessException exc) {
                exc.printStackTrace();
            }
            catch (IllegalArgumentException exc) {
                exc.printStackTrace();
            }
            catch (InvocationTargetException exc) {
                exc.printStackTrace();
            }
        }
    }
}

