/*
 * Decompiled with CFR 0.152.
 */
package opendap.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import opendap.dap.BaseType;
import opendap.dap.BaseTypePrimitiveVector;
import opendap.dap.DArray;
import opendap.dap.DArrayDimension;
import opendap.dap.DByte;
import opendap.dap.DConstructor;
import opendap.dap.DDS;
import opendap.dap.DFloat32;
import opendap.dap.DFloat64;
import opendap.dap.DGrid;
import opendap.dap.DInt16;
import opendap.dap.DInt32;
import opendap.dap.DSequence;
import opendap.dap.DString;
import opendap.dap.DStructure;
import opendap.dap.DUInt16;
import opendap.dap.DUInt32;
import opendap.dap.NoSuchVariableException;
import opendap.dap.PrimitiveVector;
import opendap.servers.ServerMethods;

public class AsciiWriter {
    public void toASCII(PrintWriter pw, DDS dds, Object specialO) throws NoSuchVariableException, IOException {
        Enumeration e = dds.getVariables();
        while (e.hasMoreElements()) {
            BaseType bt = (BaseType)e.nextElement();
            this.writeAsc(bt, dds.getEncodedName(), pw, specialO);
        }
    }

    private void writeAsc(BaseType bt, String datasetName, PrintWriter pw, Object specialO) throws IOException, NoSuchVariableException {
        if (!((ServerMethods)((Object)bt)).isProject()) {
            return;
        }
        if (bt instanceof DSequence) {
            DSequence dseq = (DSequence)bt;
            boolean moreToRead = true;
            while (moreToRead) {
                moreToRead = ((ServerMethods)((Object)bt)).read(datasetName, specialO);
                Enumeration em = dseq.getVariables();
                while (em.hasMoreElements()) {
                    BaseType member = (BaseType)em.nextElement();
                    this.writeAsc(member, datasetName, pw, specialO);
                }
            }
        } else {
            if (!((ServerMethods)((Object)bt)).isRead()) {
                ((ServerMethods)((Object)bt)).read(datasetName, specialO);
            }
            this.toASCII(bt, pw);
        }
    }

    public void toASCII(BaseType dtype, PrintWriter pw) {
        this.toASCII(dtype, pw, true, null, true);
    }

    private void toASCII(BaseType dtype, PrintWriter pw, boolean addName, String rootName, boolean newLine) {
        if (dtype instanceof DArray) {
            this.showArray((DArray)dtype, pw, addName, rootName, newLine);
        } else if (dtype instanceof DGrid) {
            this.showGrid((DGrid)dtype, pw, addName, rootName, newLine);
        } else if (dtype instanceof DSequence) {
            this.showSequence((DSequence)dtype, pw, addName, rootName, newLine);
        } else if (dtype instanceof DStructure) {
            this.showStructure((DStructure)dtype, pw, addName, rootName, newLine);
        } else {
            this.showPrimitive(dtype, pw, addName, rootName, newLine);
        }
    }

    public void showPrimitive(BaseType data, PrintWriter pw, boolean addName, String rootName, boolean newLine) {
        if (addName) {
            pw.print(this.toASCIIFlatName(data, rootName));
            pw.print(", ");
        }
        if (data instanceof DString) {
            this.showString(pw, ((DString)data).getValue());
        } else if (data instanceof DFloat32) {
            pw.print(new Float(((DFloat32)data).getValue()).toString());
        } else if (data instanceof DFloat64) {
            pw.print(new Double(((DFloat64)data).getValue()).toString());
        } else if (data instanceof DUInt32) {
            pw.print(new Long((long)((DUInt32)data).getValue() & 0xFFFFFFFFFFFFFFFFL).toString());
        } else if (data instanceof DUInt16) {
            pw.print(new Integer(((DUInt16)data).getValue() & 0xFFFF).toString());
        } else if (data instanceof DInt32) {
            pw.print(new Integer(((DInt32)data).getValue()).toString());
        } else if (data instanceof DInt16) {
            pw.print(new Short(((DInt16)data).getValue()).toString());
        } else if (data instanceof DByte) {
            pw.print(new Integer(((DByte)data).getValue() & 0xFF).toString());
        } else {
            pw.print("Not implemented type = " + data.getTypeName() + " " + data.getEncodedName() + "\n");
        }
        if (newLine) {
            pw.print("\n");
        }
    }

    private void showString(PrintWriter pw, String s) {
        if (s.length() > 0 && s.charAt(s.length() - 1) == '\u0000') {
            char[] cArray = s.toCharArray();
            s = new String(cArray, 0, cArray.length - 1);
        }
        pw.print("\"" + s + "\"");
    }

    private void showArray(DArray data, PrintWriter pw, boolean addName, String rootName, boolean newLine) {
        if (addName) {
            pw.print(this.toASCIIFlatName(data, rootName));
            pw.print("\n");
        }
        int dims = data.numDimensions();
        int[] shape = new int[dims];
        int i = 0;
        Enumeration e = data.getDimensions();
        while (e.hasMoreElements()) {
            DArrayDimension d = (DArrayDimension)e.nextElement();
            shape[i++] = d.getSize();
        }
        this.asciiArray(data, pw, addName, "", 0, dims, shape, 0);
        if (newLine) {
            pw.print("\n");
        }
    }

    private int asciiArray(DArray data, PrintWriter os, boolean addName, String label, int index, int dims, int[] shape, int offset) {
        if (dims == 1) {
            if (addName) {
                os.print(label);
            }
            for (int i = 0; i < shape[offset]; ++i) {
                PrimitiveVector pv = data.getPrimitiveVector();
                if (pv instanceof BaseTypePrimitiveVector) {
                    BaseType bt = ((BaseTypePrimitiveVector)pv).getValue(index++);
                    if (i > 0 && bt instanceof DString) {
                        os.print(", ");
                    }
                    this.toASCII(bt, os, false, null, false);
                    continue;
                }
                if (i > 0) {
                    os.print(", ");
                }
                pv.printSingleVal(os, index++);
            }
            if (addName) {
                os.print("\n");
            }
            return index;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < shape[offset]; ++i) {
            buf.setLength(0);
            buf.append(label);
            buf.append("[");
            buf.append(i);
            buf.append("]");
            if (dims - 1 == 1) {
                buf.append(", ");
            }
            index = this.asciiArray(data, os, addName, buf.toString(), index, dims - 1, shape, offset + 1);
        }
        return index;
    }

    private void showStructure(DStructure dstruct, PrintWriter pw, boolean addName, String rootName, boolean newLine) {
        rootName = rootName != null ? rootName + "." + dstruct.getEncodedName() : dstruct.getEncodedName();
        boolean firstPass = true;
        Enumeration e = dstruct.getVariables();
        while (e.hasMoreElements()) {
            BaseType ta = (BaseType)e.nextElement();
            if (!ta.isProject()) continue;
            if (!newLine && !firstPass) {
                pw.print(", ");
            }
            firstPass = false;
            this.toASCII(ta, pw, addName, rootName, newLine);
        }
        if (newLine) {
            pw.print("\n");
        }
    }

    private void showGrid(DGrid dgrid, PrintWriter pw, boolean addName, String rootName, boolean newLine) {
        int subprojections = dgrid.projectedComponents(true);
        rootName = rootName != null ? rootName + "." + dgrid.getEncodedName() : (subprojections > 1 ? dgrid.getEncodedName() : null);
        boolean firstPass = true;
        Enumeration e = dgrid.getVariables();
        while (e.hasMoreElements()) {
            BaseType ta = (BaseType)e.nextElement();
            if (!ta.isProject()) continue;
            if (!newLine && !firstPass) {
                pw.print(", ");
            }
            firstPass = false;
            this.toASCII(ta, pw, addName, rootName, newLine);
        }
        if (newLine) {
            pw.print("\n");
        }
    }

    private void showSequence(DSequence dseq, PrintWriter pw, boolean addName, String rootName, boolean newLine) {
        rootName = rootName != null ? rootName + "." + dseq.getEncodedName() : dseq.getEncodedName();
        pw.println(this.toASCIIFlatName(dseq, rootName));
        for (int row = 0; row < dseq.getRowCount(); ++row) {
            Vector v = dseq.getRow(row);
            int j = 0;
            Enumeration e2 = v.elements();
            while (e2.hasMoreElements()) {
                BaseType ta = (BaseType)e2.nextElement();
                if (j > 0) {
                    pw.print(", ");
                }
                this.toASCII(ta, pw, false, rootName, false);
                ++j;
            }
            pw.println("");
        }
        if (newLine) {
            pw.print("\n");
        }
    }

    private String toASCIIFlatName(BaseType data, String rootName) {
        StringBuffer s;
        block14: {
            block13: {
                s = new StringBuffer();
                if (rootName != null) {
                    s.append(rootName).append(".");
                }
                s.append(data.getEncodedName());
                if (data instanceof DArray) {
                    String result;
                    DArray darray = (DArray)data;
                    PrimitiveVector pv = darray.getPrimitiveVector();
                    if (pv instanceof BaseTypePrimitiveVector) {
                        BaseType bt = ((BaseTypePrimitiveVector)pv).getValue(0);
                        if (bt instanceof DString) {
                            Enumeration e = darray.getDimensions();
                            while (e.hasMoreElements()) {
                                DArrayDimension d = (DArrayDimension)e.nextElement();
                                s.append("[").append(d.getSize()).append("]");
                            }
                            result = s.toString();
                        } else {
                            result = this.toASCIIFlatName(bt, s.toString());
                        }
                    } else {
                        Enumeration e = darray.getDimensions();
                        while (e.hasMoreElements()) {
                            DArrayDimension d = (DArrayDimension)e.nextElement();
                            s.append("[").append(d.getSize()).append("]");
                        }
                        result = s.toString();
                    }
                    return result;
                }
                if (!(data instanceof DSequence)) break block13;
                DSequence dseq = (DSequence)data;
                s.setLength(0);
                boolean firstPass = true;
                for (int row = 0; row < dseq.getRowCount(); ++row) {
                    Vector v = dseq.getRow(row);
                    Enumeration e2 = v.elements();
                    while (e2.hasMoreElements()) {
                        BaseType ta = (BaseType)e2.nextElement();
                        if (!firstPass) {
                            s.append(", ");
                        }
                        firstPass = false;
                        s.append(this.toASCIIFlatName(ta, rootName));
                    }
                }
                break block14;
            }
            if (!(data instanceof DConstructor)) break block14;
            DConstructor dcon = (DConstructor)data;
            s.setLength(0);
            boolean firstPass = true;
            Enumeration e = dcon.getVariables();
            while (e.hasMoreElements()) {
                BaseType ta = (BaseType)e.nextElement();
                if (!firstPass) {
                    s.append(", ");
                }
                firstPass = false;
                s.append(this.toASCIIFlatName(ta, rootName));
            }
        }
        return s.toString();
    }
}

