/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui.catalog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;
import thredds.client.catalog.Access;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.ServiceType;
import thredds.ui.catalog.CatalogChooser;
import thredds.ui.catalog.ThreddsDatasetChooser;
import ucar.nc2.constants.DataFormatType;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.FileManager;
import ucar.nc2.ui.widget.IndependentDialog;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.TextGetPutPane;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.util.IO;
import ucar.util.prefs.PreferencesExt;

public class ThreddsUI
extends JPanel {
    private static final String VIEWER_SIZE = "ViewerSize";
    private static final String SOURCE_WINDOW_SIZE = "SourceWindowSize";
    private static final String XML_WINDOW_SIZE = "XmlWindowSize";
    private PreferencesExt store;
    private Component parent;
    private ThreddsDatasetChooser datasetChooser = null;
    private TextGetPutPane sourcePane;
    private JTabbedPane tabbedPane;
    private TextHistoryPane xmlPane;
    private IndependentDialog xmlWindow = null;
    private IndependentWindow sourceWindow = null;
    FileManager fileChooser = null;
    private boolean debugSelection = false;
    private boolean debugTab = false;

    public ThreddsUI(JFrame parent, PreferencesExt store) {
        this.store = store;
        this.parent = parent;
        this.enableEvents(64L);
        Dimension d = (Dimension)store.getBean(VIEWER_SIZE, null);
        int defaultWidth = 700;
        int defaultHeight = 350;
        this.setPreferredSize(d != null ? d : new Dimension(defaultWidth, defaultHeight));
        try {
            this.makeActionsSystem();
            this.makeActionsDataset();
            this.makeUI();
        }
        catch (Exception e) {
            System.out.println("UI creation Exception");
            e.printStackTrace();
        }
        PreferencesExt fcPrefs = (PreferencesExt)store.node("FileManager");
        FileFilter[] filters = new FileFilter[]{new FileManager.NetcdfExtFilter()};
        this.fileChooser = new FileManager(parent, null, filters, fcPrefs);
    }

    private void makeUI() throws Exception {
        this.tabbedPane = new JTabbedPane(1);
        this.datasetChooser = this.makeDatasetChooser();
        this.sourcePane = new TextGetPutPane((PreferencesExt)this.store.node("getputPane"));
        this.sourceWindow = new IndependentWindow("Source", BAMutil.getImage("threddsIcon.png"), this.sourcePane);
        this.sourceWindow.setBounds((Rectangle)this.store.getBean(SOURCE_WINDOW_SIZE, new Rectangle(50, 50, 725, 450)));
        this.xmlPane = new TextHistoryPane(false);
        this.xmlWindow = new IndependentDialog(null, false, "XML data", this.xmlPane);
        this.xmlWindow.setBounds((Rectangle)this.store.getBean(XML_WINDOW_SIZE, new Rectangle(50, 50, 725, 450)));
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
    }

    private ThreddsDatasetChooser makeDatasetChooser() {
        this.datasetChooser = new ThreddsDatasetChooser((PreferencesExt)this.store.node("ThreddsDatasetChooser"), this.tabbedPane);
        this.datasetChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("InvAccess")) {
                    ThreddsUI.this.firePropertyChangeEvent(e);
                    return;
                }
                if (e.getPropertyName().equals("Dataset") || e.getPropertyName().equals("CoordSys") || e.getPropertyName().equals("File")) {
                    DataFormatType format;
                    Dataset ds = (Dataset)e.getNewValue();
                    Access access = ds.getAccess(ServiceType.HTTPServer);
                    if (access != null && ((format = access.getDataFormatType()) == DataFormatType.PLAIN || format == DataFormatType.XML)) {
                        String urlString = access.getWrappedUrlName();
                        IO.readURLcontents(urlString);
                        ThreddsUI.this.xmlPane.setText(IO.readURLcontents(urlString));
                        ThreddsUI.this.xmlPane.gotoTop();
                        ThreddsUI.this.xmlWindow.setVisible(true);
                        return;
                    }
                    ThreddsUI.this.firePropertyChangeEvent(e);
                }
            }
        });
        JButton catSource = new JButton("Source");
        catSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CatalogChooser cc = ThreddsUI.this.datasetChooser.getCatalogChooser();
                String catURL = cc.getCurrentURL();
                if (ThreddsUI.this.debugSelection) {
                    System.out.println("Catalog Source: url = " + catURL);
                }
                ThreddsUI.this.sourcePane.setURL(catURL);
                ThreddsUI.this.sourcePane.gotoTop();
                ThreddsUI.this.sourceWindow.show();
            }
        });
        this.datasetChooser.getCatalogChooser().addButton(catSource);
        return this.datasetChooser;
    }

    public void storePersistentData() {
        this.store.putBeanObject(VIEWER_SIZE, this.getSize());
        this.store.putBeanObject(SOURCE_WINDOW_SIZE, this.sourceWindow.getBounds());
        if (this.fileChooser != null) {
            this.fileChooser.save();
        }
        if (this.datasetChooser != null) {
            this.datasetChooser.save();
        }
        if (this.sourcePane != null) {
            this.sourcePane.save();
        }
    }

    private void firePropertyChangeEvent(PropertyChangeEvent event) {
        this.firePropertyChange(event.getPropertyName(), event.getOldValue(), event.getNewValue());
    }

    public void setDataset(String location) {
        this.datasetChooser.getCatalogChooser().setCatalog(location);
        this.tabbedPane.setSelectedComponent(this.datasetChooser.getCatalogChooser());
    }

    private void makeActionsSystem() {
        AbstractAction clearDebugFlagsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        BAMutil.setActionProperties(clearDebugFlagsAction, null, "Clear Debug Flags", false, 68, -1);
    }

    private void makeActionsDataset() {
    }
}

