/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.util.Indent;

public class AttributeContainerHelper
implements AttributeContainer {
    final String name;
    List<Attribute> atts;

    public AttributeContainerHelper(String name) {
        this.name = name;
        this.atts = new ArrayList<Attribute>();
    }

    public AttributeContainerHelper(String name, List<Attribute> from) {
        this(name);
        this.addAll(from);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setImmutable() {
        this.atts = Collections.unmodifiableList(this.atts);
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.atts;
    }

    @Override
    public Attribute addAttribute(Attribute att) {
        if (att == null) {
            return null;
        }
        for (int i = 0; i < this.atts.size(); ++i) {
            Attribute a = this.atts.get(i);
            if (!att.getShortName().equals(a.getShortName())) continue;
            this.atts.set(i, att);
            return att;
        }
        this.atts.add(att);
        return att;
    }

    @Override
    public void addAll(Iterable<Attribute> atts) {
        for (Attribute att : atts) {
            this.addAttribute(att);
        }
    }

    @Override
    public String findAttValueIgnoreCase(String attName, String defaultValue) {
        String attValue = null;
        Attribute att = this.findAttributeIgnoreCase(attName);
        if (att != null && att.isString()) {
            attValue = att.getStringValue();
        }
        if (null == attValue) {
            attValue = defaultValue;
        }
        return attValue;
    }

    @Override
    public Attribute findAttribute(String name) {
        for (Attribute a : this.atts) {
            if (!name.equals(a.getShortName())) continue;
            return a;
        }
        return null;
    }

    @Override
    public Attribute findAttributeIgnoreCase(String name) {
        for (Attribute a : this.atts) {
            if (!name.equalsIgnoreCase(a.getShortName())) continue;
            return a;
        }
        return null;
    }

    @Override
    public boolean remove(Attribute a) {
        return a != null && this.atts.remove(a);
    }

    @Override
    public boolean removeAttribute(String attName) {
        Attribute att = this.findAttribute(attName);
        return att != null && this.atts.remove(att);
    }

    @Override
    public boolean removeAttributeIgnoreCase(String attName) {
        Attribute att = this.findAttributeIgnoreCase(attName);
        return att != null && this.atts.remove(att);
    }

    public static AttributeContainer filter(AttributeContainer atts, String ... remove) {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        for (Attribute att : atts.getAttributes()) {
            boolean ok = true;
            for (String s2 : remove) {
                if (!att.getShortName().startsWith(s2)) continue;
                ok = false;
            }
            if (!ok) continue;
            result.add(att);
        }
        return new AttributeContainerHelper(atts.getName(), result);
    }

    public static void show(AttributeContainer atts, Indent indent, Formatter f) {
        for (Attribute att : atts.getAttributes()) {
            f.format("%s%s%n", indent, att);
        }
    }
}

