/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import thredds.inventory.MFile;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTable;

public class MFileTable
extends JPanel {
    private PreferencesExt prefs;
    private final boolean isPopup;
    private BeanTable fileTable;
    private IndependentWindow fileWindow;
    private List<String> gribCollectionFiles = new ArrayList<String>();

    public MFileTable(PreferencesExt prefs, boolean isPopup) {
        this.prefs = prefs;
        this.isPopup = isPopup;
        this.fileTable = new BeanTable(FileBean.class, (PreferencesExt)prefs.node("FileBean"), false, "Files", "Files", null);
        PopupMenu varPopup = new PopupMenu(this.fileTable.getJTable(), "Options");
        varPopup.addAction("Open this file in Grib2Collection", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileBean bean = (FileBean)MFileTable.this.fileTable.getSelectedBean();
                if (bean == null) {
                    return;
                }
                if (MFileTable.this.isPopup) {
                    MFileTable.this.fileWindow.setVisible(false);
                }
                Formatter f = new Formatter();
                f.format("list:", new Object[0]);
                f.format(bean.getPath(), new Object[0]);
                MFileTable.this.firePropertyChange("openGrib2Collection", null, f.toString());
            }
        });
        varPopup.addAction("Add Files to Collection", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List beans = MFileTable.this.fileTable.getSelectedBeans();
                if (beans == null || beans.size() == 0) {
                    return;
                }
                for (FileBean bean : beans) {
                    MFileTable.this.gribCollectionFiles.add(bean.getPath());
                }
            }
        });
        varPopup.addAction("Clear Collection", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MFileTable.this.gribCollectionFiles = new ArrayList();
            }
        });
        varPopup.addAction("Open Collection in Grib2Collection", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MFileTable.this.gribCollectionFiles.size() == 0) {
                    return;
                }
                if (MFileTable.this.isPopup) {
                    MFileTable.this.fileWindow.setVisible(false);
                }
                Formatter f = new Formatter();
                f.format("list:", new Object[0]);
                for (String s2 : MFileTable.this.gribCollectionFiles) {
                    f.format("%s;", s2);
                }
                MFileTable.this.firePropertyChange("openGrib2Collection", null, f.toString());
            }
        });
        if (isPopup) {
            this.fileWindow = new IndependentWindow("Files Used", BAMutil.getImage("netcdfUI"), this.fileTable);
            this.fileWindow.setBounds((Rectangle)prefs.getBean("FileWindowBounds", new Rectangle(300, 300, 500, 300)));
        } else {
            this.add((Component)this.fileTable, "Center");
        }
    }

    public void save() {
        this.fileTable.saveState(false);
        if (this.fileWindow != null) {
            this.prefs.putBeanObject("FileWindowBounds", this.fileWindow.getBounds());
        }
    }

    public void setFiles(File dir, Collection<MFile> files) {
        if (files == null) {
            return;
        }
        int count = 0;
        ArrayList<FileBean> beans = new ArrayList<FileBean>();
        for (MFile mfile : files) {
            beans.add(new FileBean(dir, mfile, count++));
        }
        this.fileTable.setBeans(beans);
        if (this.isPopup) {
            this.fileWindow.show();
        }
    }

    public class FileBean {
        MFile mfile;
        int count;

        public FileBean() {
        }

        public FileBean(File dir, MFile mfile, int count) {
            this.mfile = mfile;
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }

        public String getName() {
            return this.mfile.getName();
        }

        public String getPath() {
            return this.mfile.getPath();
        }

        public long getSize() {
            return this.mfile.getLength();
        }

        public String getLastModified() {
            return CalendarDateFormatter.toDateTimeString(new Date(this.mfile.getLastModified()));
        }
    }
}

