/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.grib;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import thredds.inventory.CollectionAbstract;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1RecordScanner;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib1.tables.Grib1ParamTableReader;
import ucar.nc2.grib.grib1.tables.Grib1ParamTables;
import ucar.nc2.grib.grib2.Grib2Index;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2SectionGridDefinition;
import ucar.nc2.grib.grib2.Grib2Show;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.util.Misc;
import ucar.nc2.wmo.CommonCodeTable;
import ucar.unidata.io.KMPMatch;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil2;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTable;

public class GribFilesPanel
extends JPanel {
    private PreferencesExt prefs;
    private BeanTable grib1Table;
    private BeanTable grib2Table;
    private BeanTable collectionTable;
    private JSplitPane split2;
    private TextHistoryPane infoPopup;
    private IndependentWindow infoWindow;
    private static final KMPMatch matcher = new KMPMatch(new byte[]{71, 82, 73, 66});
    private List<CollectionBean> collections = new ArrayList<CollectionBean>();

    public GribFilesPanel(PreferencesExt prefs) {
        this.prefs = prefs;
        this.collectionTable = new BeanTable(CollectionBean.class, (PreferencesExt)prefs.node("CollectionBean"), true);
        PopupMenu varPopup = new PopupMenu(this.collectionTable.getJTable(), "Options");
        varPopup.addAction("Show Files in Collection", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionBean pb = (CollectionBean)GribFilesPanel.this.collectionTable.getSelectedBean();
                Formatter f = new Formatter();
                GribFilesPanel.this.showFilesInCollection(pb, f);
                GribFilesPanel.this.infoPopup.setText(f.toString());
                GribFilesPanel.this.infoPopup.gotoTop();
                GribFilesPanel.this.infoWindow.show();
            }
        });
        varPopup.addAction("Read Files", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = GribFilesPanel.this.collectionTable.getSelectedBeans();
                GribFilesPanel.this.readFiles(list);
            }
        });
        this.grib1Table = new BeanTable(Grib1Bean.class, (PreferencesExt)prefs.node("Grib1Bean"), false);
        varPopup = new PopupMenu(this.grib1Table.getJTable(), "Options");
        varPopup.addAction("Open in Grib1-Collection", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib1Bean pb = (Grib1Bean)GribFilesPanel.this.grib1Table.getSelectedBean();
                if (pb == null) {
                    return;
                }
                GribFilesPanel.this.firePropertyChange("openGrib1Collection", null, pb.m.getPath());
            }
        });
        this.grib2Table = new BeanTable(Grib2Bean.class, (PreferencesExt)prefs.node("Grib2Bean"), false);
        varPopup = new PopupMenu(this.grib2Table.getJTable(), "Options");
        varPopup.addAction("Show complete GridRecord", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib2Bean bean = (Grib2Bean)GribFilesPanel.this.grib2Table.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    bean.showComplete(f);
                    GribFilesPanel.this.infoPopup.setText(f.toString());
                    GribFilesPanel.this.infoPopup.gotoTop();
                    GribFilesPanel.this.infoWindow.show();
                }
            }
        });
        varPopup.addAction("Open in Grib2collecion", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib2Bean pb = (Grib2Bean)GribFilesPanel.this.grib2Table.getSelectedBean();
                if (pb == null) {
                    return;
                }
                GribFilesPanel.this.firePropertyChange("openGrib2c", null, pb.m.getPath());
            }
        });
        this.infoPopup = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoPopup);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.setLayout(new BorderLayout());
        this.split2 = new JSplitPane(0, false, this.collectionTable, this.grib1Table);
        this.split2.setDividerLocation(prefs.getInt("splitPos2", 800));
        this.add((Component)this.split2, "Center");
    }

    public void save() {
        this.grib1Table.saveState(false);
        this.grib2Table.saveState(false);
        this.collectionTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        if (this.split2 != null) {
            this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
        }
    }

    public void showCollection(Formatter f) {
    }

    private void showFilesInCollection(CollectionBean bean, Formatter f) {
        f.format("Collection= %s %n", bean.spec);
        int count = 0;
        for (MFile mfile : bean.fileList) {
            f.format("  %s%n", mfile.getPath());
            ++count;
        }
        f.format(" count = %d %n", count);
    }

    public void setCollection(String spec) throws IOException {
        this.collections.add(new CollectionBean(spec));
        this.collectionTable.setBeans(this.collections);
    }

    private void readFiles(List<CollectionBean> beans) {
        ArrayList<Object> files = new ArrayList<Object>();
        for (CollectionBean bean : beans) {
            for (MFile mfile : bean.fileList) {
                Object gbean;
                String path = mfile.getPath();
                if (path.endsWith(".gbx8") || path.endsWith(".gbx9") || path.endsWith(".ncx") || (gbean = this.getGribBean(mfile)) == null) continue;
                files.add(gbean);
            }
        }
        this.grib1Table.setBeans(files);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object getGribBean(MFile ff) {
        String path = ff.getPath();
        try (RandomAccessFile raf = new RandomAccessFile(path, "r");){
            raf.order(0);
            raf.seek(0L);
            if (!raf.searchForward(matcher, 8000)) {
                Object var5_6 = null;
                return var5_6;
            }
            raf.skipBytes(7);
            int edition = raf.read();
            if (edition != 1) return null;
            Object object = this.getFirstGrib1Bean(ff, raf);
            return object;
        }
        catch (Throwable ioe) {
            System.out.printf("Failed on %s%n", path);
            ioe.printStackTrace();
        }
        return null;
    }

    Object getFirstGrib1Bean(MFile mf, RandomAccessFile raf) throws IOException {
        Grib1Record first = null;
        Grib1RecordScanner reader = new Grib1RecordScanner(raf);
        if (reader.hasNext()) {
            first = reader.next();
        }
        if (first == null) {
            return null;
        }
        return new Grib1Bean(mf, first);
    }

    public class Grib2Bean {
        MFile m;
        Grib2Index index;
        int nRecords;
        int localCount = 0;
        int gdsCount = 0;
        Grib2Record first;
        Grib2Customizer tables;
        boolean bad = false;

        public Grib2Bean() {
        }

        public Grib2Bean(MFile m3) {
            this.m = m3;
            try {
                this.index = new Grib2Index();
                if (!this.index.readIndex(m3.getPath(), m3.getLastModified())) {
                    this.index.makeIndex(m3.getPath(), null);
                }
                HashMap<Long, Grib2SectionGridDefinition> gdsSet = new HashMap<Long, Grib2SectionGridDefinition>();
                for (Grib2SectionGridDefinition gds : this.index.getGds()) {
                    if (gdsSet.get(gds.calcCRC()) != null) continue;
                    gdsSet.put(gds.calcCRC(), gds);
                }
                this.gdsCount = gdsSet.size();
                this.nRecords = this.index.getRecords().size();
                for (Grib2Record gr : this.index.getRecords()) {
                    Grib2Pds pds;
                    if (this.first == null) {
                        this.first = gr;
                    }
                    if (this.tables == null) {
                        this.tables = Grib2Customizer.factory(gr);
                    }
                    if ((pds = gr.getPDS()).getParameterCategory() <= 191 && pds.getParameterNumber() <= 191) continue;
                    ++this.localCount;
                }
            }
            catch (IOException e) {
                System.out.printf("%s%n", e.getMessage());
                this.bad = true;
            }
        }

        public final String getPath() {
            return this.bad ? "BAD " + this.m.getPath() : this.m.getPath();
        }

        public final String getRefDate() {
            return this.bad ? "" : this.first.getReferenceDate().toString();
        }

        public String getHeader() {
            return this.bad ? "" : StringUtil2.cleanup(this.first.getHeader());
        }

        public int getMasterTable() {
            return this.bad ? -1 : this.first.getId().getMaster_table_version();
        }

        public int getLocalTable() {
            return this.bad ? -1 : this.first.getId().getLocal_table_version();
        }

        public int getCenter() {
            return this.bad ? -1 : this.first.getId().getCenter_id();
        }

        public int getSubCenter() {
            return this.bad ? -1 : this.first.getId().getSubcenter_id();
        }

        public String getLocalCount() {
            return this.bad ? "" : this.localCount + "/" + this.nRecords;
        }

        public int getGdsCount() {
            return this.gdsCount;
        }

        void showComplete(Formatter f) {
            try {
                Grib2Show.showCompleteGribRecord(f, this.m.getPath(), this.first, this.tables);
            }
            catch (IOException e) {
                e.printStackTrace();
                StringWriter sw = new StringWriter(10000);
                e.printStackTrace(new PrintWriter(sw));
                f.format("%s", sw.toString());
            }
        }
    }

    public class Grib1Bean {
        MFile m;
        Grib1Record first;
        Grib1ParamTableReader table;
        Grib1SectionProductDefinition pds;

        public Grib1Bean() {
        }

        public Grib1Bean(MFile m3, Grib1Record first) {
            this.m = m3;
            this.first = first;
            this.pds = first.getPDSsection();
            Grib1ParamTables tables = new Grib1ParamTables();
            this.table = tables.getParameterTable(this.getCenter(), this.getSubCenter(), this.getTableVersion());
        }

        public final String getPath() {
            return this.m.getPath();
        }

        public int getTableVersion() {
            return this.pds.getTableVersion();
        }

        public int getCenter() {
            return this.pds.getCenter();
        }

        public String getCenterName() {
            return CommonCodeTable.getCenterName(this.getCenter(), 1);
        }

        public int getSubCenter() {
            return this.pds.getSubCenter();
        }

        public String getSubCenterName() {
            return Grib1Customizer.getSubCenterNameStatic(this.getCenter(), this.getSubCenter());
        }

        public int getTimeUnit() {
            return this.pds.getTimeUnit();
        }

        public String getTable() {
            return this.table == null ? " missing" : this.table.getName();
        }

        public int getTableKey() {
            return this.table == null ? -1 : this.table.getKey();
        }
    }

    public class CollectionBean {
        String spec;
        Iterable<MFile> fileList;

        public CollectionBean() {
        }

        public CollectionBean(String spec) throws IOException {
            this.spec = spec;
            Formatter f = new Formatter();
            try (MCollection dc = CollectionAbstract.open(spec, spec, null, f);){
                this.fileList = dc.getFilesSorted();
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter(10000);
                e.printStackTrace(new PrintWriter(sw));
                f.format("%s", sw.toString());
                JOptionPane.showMessageDialog(null, "Collection is null");
            }
        }

        public int getN() {
            return Misc.getSize(this.fileList);
        }

        public String getSpec() {
            return this.spec;
        }
    }
}

