/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.grid;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ucar.nc2.ui.gis.GisFeatureRenderer;
import ucar.nc2.ui.grid.ContourFeature;
import ucar.nc2.ui.grid.ContourGrid;
import ucar.nc2.ui.widget.FontUtil;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.util.Format;
import ucar.util.prefs.ui.Debug;

public class ContourFeatureRenderer
extends GisFeatureRenderer {
    private ProjectionImpl dataProjection;
    private ArrayList contourList = new ArrayList();
    private boolean ShowLabels;

    public ContourFeatureRenderer(ContourGrid conGrid, ProjectionImpl dataProjection) {
        this.dataProjection = dataProjection;
        this.ShowLabels = true;
        this.contourList = conGrid.getContourLines();
    }

    public void setShowLabels(boolean showlabels) {
        this.ShowLabels = showlabels;
    }

    @Override
    public LatLonRect getPreferredArea() {
        return null;
    }

    @Override
    protected List getFeatures() {
        return this.contourList;
    }

    @Override
    protected ProjectionImpl getDataProjection() {
        return this.dataProjection;
    }

    @Override
    public void draw(Graphics2D g2, AffineTransform deviceFromNormalAT) {
        g2.setColor(Color.black);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2.setStroke(new BasicStroke(0.0f));
        Rectangle2D clipRect = (Rectangle2D)g2.getClip();
        Iterator siter = this.getShapes(g2, deviceFromNormalAT);
        while (siter.hasNext()) {
            Shape s2 = (Shape)siter.next();
            Rectangle2D shapeBounds = s2.getBounds2D();
            if (!shapeBounds.intersects(clipRect)) continue;
            g2.draw(s2);
        }
        if (this.ShowLabels) {
            AffineTransform normalFromWorldAT;
            Font f = FontUtil.getStandardFont(10).getFont();
            Font saveFont = g2.getFont();
            AffineTransform deviceFromWorldAT = g2.getTransform();
            try {
                normalFromWorldAT = deviceFromNormalAT.createInverse();
                normalFromWorldAT.concatenate(deviceFromWorldAT);
            }
            catch (NoninvertibleTransformException e) {
                System.out.println(" ContourFeatureRenderer: NoninvertibleTransformException on " + deviceFromNormalAT);
                return;
            }
            g2.setTransform(deviceFromNormalAT);
            g2.setFont(f);
            siter = this.getShapes(g2, deviceFromNormalAT);
            Iterator CViter = this.contourList.iterator();
            Point2D.Double worldPt = new Point2D.Double();
            Point2D.Double normalPt = new Point2D.Double();
            float[] coords = new float[6];
            while (siter.hasNext()) {
                Shape s3 = (Shape)siter.next();
                double contValue = ((ContourFeature)CViter.next()).getContourValue();
                PathIterator piter = s3.getPathIterator(null);
                int count = 12;
                while (!piter.isDone()) {
                    int cs;
                    if (++count % 25 == 0 && ((cs = piter.currentSegment(coords)) == 0 || cs == 1)) {
                        ((Point2D)worldPt).setLocation(coords[0], coords[1]);
                        normalFromWorldAT.transform(worldPt, normalPt);
                        g2.drawString(Format.d(contValue, 4), (int)((Point2D)normalPt).getX(), (int)((Point2D)normalPt).getY());
                    }
                    piter.next();
                }
            }
            g2.setTransform(deviceFromWorldAT);
            g2.setFont(saveFont);
        }
        if (Debug.isSet("contour/doLabels")) {
            for (Object aContourList : this.contourList) {
                System.out.println(" ContourFeatureRenderer: contour value = " + ((ContourFeature)aContourList).getContourValue());
            }
        }
    }
}

