/*
 * Decompiled with CFR 0.152.
 */
package visad.data.fits;

import visad.data.fits.BooleanArrayConverter;
import visad.data.fits.ByteArrayConverter;
import visad.data.fits.DoubleArrayConverter;
import visad.data.fits.FloatArrayConverter;
import visad.data.fits.GenericArrayConverter;
import visad.data.fits.IntegerArrayConverter;
import visad.data.fits.LongArrayConverter;
import visad.data.fits.ShortArrayConverter;

public abstract class ConvertArray {
    private static final int UNSIGNED_ARRAY = 4096;
    private static final int NONINTEGRAL_ARRAY = 8192;
    private static final int BOOLEAN_ARRAY = 1;
    private static final int BYTE_ARRAY = 2;
    private static final int UBYTE_ARRAY = 4098;
    private static final int SHORT_ARRAY = 4;
    private static final int USHORT_ARRAY = 4100;
    private static final int INT_ARRAY = 8;
    private static final int UINT_ARRAY = 4104;
    private static final int LONG_ARRAY = 16;
    private static final int FLOAT_ARRAY = 8193;
    private static final int DOUBLE_ARRAY = 8194;
    private boolean analyzed = false;
    int[] lengths = null;
    private int arrayType;

    int getArrayType(double min2, double max, boolean integral) {
        if (!integral) {
            if (min2 >= -3.4028234663852886E38 && max <= 3.4028234663852886E38) {
                return 8193;
            }
            return 8194;
        }
        if (min2 >= 0.0) {
            if (max <= 1.0) {
                return 1;
            }
            if (max <= 255.0) {
                return 4098;
            }
            if (max <= 65535.0) {
                return 4100;
            }
            if (max <= 4.294967295E9) {
                return 4104;
            }
        }
        if (min2 >= -128.0 && max <= 127.0) {
            return 2;
        }
        if (min2 >= -32768.0 && max <= 32767.0) {
            return 4;
        }
        if (min2 >= -2.147483648E9 && max <= 2.147483647E9) {
            return 8;
        }
        return 16;
    }

    abstract int analyzeArray();

    private void analyze() {
        if (this.analyzed) {
            return;
        }
        this.arrayType = this.analyzeArray();
    }

    public GenericArrayConverter getConverter() {
        this.analyze();
        switch (this.arrayType) {
            case 1: {
                return new BooleanArrayConverter(this.lengths);
            }
            case 2: {
                return new ByteArrayConverter(this.lengths, false);
            }
            case 4098: {
                return new ByteArrayConverter(this.lengths, true);
            }
            case 4: {
                return new ShortArrayConverter(this.lengths, false);
            }
            case 4100: {
                return new ShortArrayConverter(this.lengths, true);
            }
            case 8: {
                return new IntegerArrayConverter(this.lengths, false);
            }
            case 4104: {
                return new IntegerArrayConverter(this.lengths, true);
            }
            case 16: {
                return new LongArrayConverter(this.lengths);
            }
            case 8193: {
                return new FloatArrayConverter(this.lengths);
            }
            case 8194: {
                return new DoubleArrayConverter(this.lengths);
            }
        }
        return null;
    }
}

