/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.View;
import org.bounce.QButton;
import org.bounce.plaf.BounceButtonListener;
import org.bounce.plaf.BounceGraphicsUtils;

public class BounceButtonUI
extends BasicButtonUI {
    private static final BounceButtonUI ui = new BounceButtonUI();

    public static ComponentUI createUI(JComponent c) {
        return ui;
    }

    public void paint(Graphics g2, JComponent c) {
        QButton b = (QButton)c;
        ButtonModel model = b.getModel();
        Color foreground = b.getForeground();
        Color tmpForeground = null;
        Color background = b.getBackground();
        Color tmpBackground = null;
        Font font = b.getFont();
        Font tmpFont = null;
        Icon icon = b.getIcon();
        Icon tmpIcon = null;
        FontMetrics fm = g2.getFontMetrics();
        Insets i = c.getInsets();
        Rectangle viewRect = new Rectangle();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        viewRect.x = i.left;
        viewRect.y = i.top;
        viewRect.width = b.getWidth() - (i.right + viewRect.x);
        viewRect.height = b.getHeight() - (i.bottom + viewRect.y);
        textRect.height = 0;
        textRect.width = 0;
        textRect.y = 0;
        textRect.x = 0;
        iconRect.height = 0;
        iconRect.width = 0;
        iconRect.y = 0;
        iconRect.x = 0;
        if (!model.isEnabled()) {
            if (model.isSelected()) {
                tmpForeground = b.getDisabledSelectedForeground();
                tmpBackground = b.getDisabledSelectedBackground();
                tmpFont = b.getDisabledSelectedFont();
                tmpIcon = b.getDisabledSelectedIcon();
            } else {
                tmpForeground = b.getDisabledForeground();
                tmpBackground = b.getDisabledBackground();
                tmpFont = b.getDisabledFont();
                tmpIcon = b.getDisabledIcon();
            }
        } else if (model.isPressed() && model.isArmed()) {
            tmpForeground = b.getPressedForeground();
            tmpBackground = b.getPressedBackground();
            tmpFont = b.getPressedFont();
            tmpIcon = b.getPressedIcon();
        } else if (b.hasFocus()) {
            if (model.isSelected()) {
                tmpForeground = b.getFocusedSelectedForeground();
                tmpBackground = b.getFocusedSelectedBackground();
                tmpFont = b.getFocusedSelectedFont();
                tmpIcon = b.getFocusedSelectedIcon();
            } else {
                tmpForeground = b.getFocusedForeground();
                tmpBackground = b.getFocusedBackground();
                tmpFont = b.getFocusedFont();
                tmpIcon = b.getFocusedIcon();
            }
        } else if (b.isRolloverEnabled() && model.isRollover()) {
            if (model.isSelected()) {
                tmpForeground = b.getRolloverSelectedForeground();
                tmpBackground = b.getRolloverSelectedBackground();
                tmpFont = b.getRolloverSelectedFont();
                tmpIcon = b.getRolloverSelectedIcon();
            } else {
                tmpForeground = b.getRolloverForeground();
                tmpBackground = b.getRolloverBackground();
                tmpFont = b.getRolloverFont();
                tmpIcon = b.getRolloverIcon();
            }
        } else if (model.isSelected()) {
            tmpForeground = b.getSelectedForeground();
            tmpBackground = b.getSelectedBackground();
            tmpFont = b.getSelectedFont();
            tmpIcon = b.getSelectedIcon();
        }
        if (tmpFont != null) {
            font = tmpFont;
        }
        g2.setFont(font);
        String[] text = BounceGraphicsUtils.layoutMultilineCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : this.defaultTextIconGap, b.getMinimumLines(), b.getMaximumLines());
        this.clearTextShiftOffset();
        if (tmpBackground != null) {
            background = tmpBackground;
        }
        g2.setColor(background);
        if (tmpIcon != null) {
            icon = tmpIcon;
        }
        if (icon != null) {
            this.paintIcon(g2, c, iconRect, icon);
        }
        if (tmpForeground != null) {
            foreground = tmpForeground;
        }
        g2.setColor(foreground);
        if (text != null && !text.equals("")) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g2, textRect);
            } else {
                this.paintText(g2, c, textRect, text);
            }
        }
        if (b.getFocusedRectangleMode() != 0 && b.isFocusPainted() && b.hasFocus() && b.getFocusedRectangleColor() != null) {
            this.paintFocus(g2, b, viewRect, textRect, iconRect);
        }
    }

    protected void paintIcon(Graphics g2, JComponent c, Rectangle iconRect, Icon icon) {
        QButton b = (QButton)c;
        ButtonModel model = b.getModel();
        if (icon == null) {
            return;
        }
        if (model.isPressed() && model.isArmed()) {
            icon.paintIcon(c, g2, iconRect.x + this.getTextShiftOffset(), iconRect.y + this.getTextShiftOffset());
        } else {
            icon.paintIcon(c, g2, iconRect.x, iconRect.y);
        }
    }

    protected void paintBackground(Graphics g2, JComponent c) {
        Dimension size = c.getSize();
        g2.fillRect(0, 0, size.width, size.height);
    }

    protected void paintFocus(Graphics g2, QButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        boolean isIcon;
        Rectangle focusRect = new Rectangle();
        String text = b.getText();
        boolean bl = isIcon = b.getIcon() != null;
        if (text != null && !text.equals("")) {
            if (!isIcon && b.getFocusedRectangleMode() != 2) {
                focusRect.setBounds(textRect);
            } else if (b.getFocusedRectangleMode() == 3) {
                focusRect.setBounds(iconRect.union(textRect));
            } else if (b.getFocusedRectangleMode() == 1) {
                focusRect.setBounds(textRect);
            } else if (b.getFocusedRectangleMode() == 2) {
                focusRect.setBounds(iconRect);
            }
        } else if (isIcon) {
            focusRect.setBounds(iconRect);
        }
        g2.setColor(b.getFocusedRectangleColor());
        g2.drawRect(focusRect.x - 1, focusRect.y - 1, focusRect.width + 1, focusRect.height + 1);
    }

    protected void paintText(Graphics g2, JComponent c, Rectangle textRect, String[] text) {
        QButton b = (QButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = g2.getFontMetrics();
        int y = textRect.y + fm.getAscent();
        for (int i = 0; i < text.length; ++i) {
            BounceGraphicsUtils.drawLine(g2, fm, textRect, text[i], b.getHorizontalAlignment(), y, model.getMnemonic());
            y += fm.getHeight();
        }
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new BounceButtonListener(b);
    }

    public Dimension getPreferredSize(JComponent c) {
        QButton b = (QButton)c;
        if (b.getComponentCount() > 0) {
            return null;
        }
        Insets i = c.getInsets();
        Rectangle viewRect = new Rectangle();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        if (b.getMaximumLines() == 1) {
            viewRect.x = i.left + i.right;
            viewRect.y = i.top + i.bottom;
            viewRect.height = Short.MAX_VALUE;
            viewRect.width = Short.MAX_VALUE;
        } else {
            viewRect.x = i.left;
            viewRect.y = i.top;
            viewRect.width = b.getWidth() - (i.right + viewRect.x);
            viewRect.height = b.getHeight() - (i.bottom + viewRect.y);
        }
        BounceGraphicsUtils.layoutMultilineCompoundLabel(c, b.getGraphics().getFontMetrics(), b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : this.defaultTextIconGap, b.getMinimumLines(), b.getMaximumLines());
        Rectangle r = iconRect.union(textRect);
        Insets insets = b.getInsets();
        r.width += insets.left + insets.right;
        r.height += insets.top + insets.bottom;
        if (r.width % 2 == 0) {
            ++r.width;
        }
        if (r.height % 2 == 0) {
            ++r.height;
        }
        return r.getSize();
    }
}

