/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ogc.erddap.util;

import ucar.nc2.ogc.erddap.util.ErddapMath2;

public class ErddapString2 {
    public static String ERROR = "ERROR";

    public static int indexOf(char[] cArray, char c, int fromIndex) {
        int cArrayLength = cArray.length;
        for (int index = Math.max(fromIndex, 0); index < cArrayLength; ++index) {
            if (cArray[index] != c) continue;
            return index;
        }
        return -1;
    }

    public static boolean isLetter(int c) {
        if (c < 65) {
            return false;
        }
        if (c <= 90) {
            return true;
        }
        if (c < 97) {
            return false;
        }
        if (c <= 122) {
            return true;
        }
        if (c < 192) {
            return false;
        }
        if (c == 215) {
            return false;
        }
        return c <= 255;
    }

    public static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    public static String replaceAll(String s2, char oldCh, char newCh) {
        int po = s2.indexOf(oldCh);
        if (po < 0) {
            return s2;
        }
        StringBuilder buffer = new StringBuilder(s2);
        while (po >= 0) {
            buffer.setCharAt(po, newCh);
            po = s2.indexOf(oldCh, po + 1);
        }
        return buffer.toString();
    }

    public static int parseInt(String s2) {
        if (s2 == null) {
            return Integer.MAX_VALUE;
        }
        if ((s2 = s2.trim()).length() == 0) {
            return Integer.MAX_VALUE;
        }
        char ch = s2.charAt(0);
        if ((ch < '0' || ch > '9') && ch != '-' && ch != '+' && ch != '.') {
            return Integer.MAX_VALUE;
        }
        try {
            if (s2.startsWith("0x")) {
                return Integer.parseInt(s2.substring(2), 16);
            }
            return Integer.parseInt(s2);
        }
        catch (Exception exception) {
            try {
                return ErddapMath2.roundToInt(Double.parseDouble(s2));
            }
            catch (Exception e) {
                return Integer.MAX_VALUE;
            }
        }
    }

    public static double parseDouble(String s2) {
        if (s2 == null) {
            return Double.NaN;
        }
        if ((s2 = s2.trim()).length() == 0) {
            return Double.NaN;
        }
        char ch = s2.charAt(0);
        if ((ch < '0' || ch > '9') && ch != '-' && ch != '+' && ch != '.') {
            return Double.NaN;
        }
        try {
            if (s2.startsWith("0x")) {
                return Integer.parseInt(s2.substring(2), 16);
            }
            return Double.parseDouble(s2);
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public static long parseLong(String s2) {
        if (s2 == null) {
            return Long.MAX_VALUE;
        }
        if ((s2 = s2.trim()).length() == 0) {
            return Long.MAX_VALUE;
        }
        char ch = s2.charAt(0);
        if ((ch < '0' || ch > '9') && ch != '-' && ch != '+') {
            return Long.MAX_VALUE;
        }
        try {
            if (s2.startsWith("0x")) {
                return Long.parseLong(s2.substring(2), 16);
            }
            return Long.parseLong(s2);
        }
        catch (Exception e) {
            return Long.MAX_VALUE;
        }
    }

    public static int[] toRational(double d) {
        int dpo;
        if (d == 0.0) {
            return new int[]{0, 0};
        }
        if (!ErddapMath2.isFinite(d)) {
            return new int[]{1, Integer.MAX_VALUE};
        }
        String s2 = "" + d;
        int ten = 0;
        int epo = s2.indexOf(69);
        if (epo > 0) {
            ten = ErddapString2.parseInt(s2.substring(epo + 1));
            s2 = s2.substring(0, epo);
        }
        if (s2.endsWith(".0")) {
            s2 = s2.substring(0, s2.length() - 2);
        }
        if ((dpo = s2.indexOf(46)) > 0) {
            ten -= s2.length() - dpo - 1;
            s2 = s2.substring(0, dpo) + s2.substring(dpo + 1);
        }
        long tl = ErddapString2.parseLong(s2);
        while (Math.abs(tl) > 1000000000L) {
            tl = Math.round((double)tl / 10.0);
            ++ten;
        }
        while (tl != 0L && (double)(tl / 10L) == (double)tl / 10.0) {
            tl /= 10L;
            ++ten;
        }
        if (tl < 100000L && ten >= 1 && ten <= 3) {
            while (ten > 0) {
                tl *= 10L;
                --ten;
            }
        }
        return new int[]{(int)tl, ten};
    }
}

