/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.widget;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;

public class FontUtil {
    private static final int MAX_FONTS = 15;
    private static int fontType = 0;
    private static Font[] stdFont = new Font[15];
    private static FontMetrics[] stdMetrics = new FontMetrics[15];
    private static Font[] monoFont = new Font[15];
    private static FontMetrics[] monoMetrics = new FontMetrics[15];
    private static boolean debug = false;
    private static boolean isInit = false;

    private static void init() {
        if (isInit) {
            return;
        }
        FontUtil.initFontFamily("SansSerif", stdFont, stdMetrics);
        FontUtil.initFontFamily("Monospaced", monoFont, monoMetrics);
        isInit = true;
    }

    private static void initFontFamily(String name, Font[] fonts, FontMetrics[] fontMetrics) {
        for (int i = 0; i < 15; ++i) {
            int fontSize = i < 6 ? 5 + i : (i < 11 ? 10 + 2 * (i - 5) : 20 + 4 * (i - 10));
            fonts[i] = new Font(name, fontType, fontSize);
            fontMetrics[i] = Toolkit.getDefaultToolkit().getFontMetrics(fonts[i]);
            if (!debug) continue;
            System.out.println("TextSymbol font " + fonts[i] + " " + fontSize + " " + fontMetrics[i].getAscent());
        }
    }

    public static StandardFont getStandardFont(int pixel_height) {
        FontUtil.init();
        return new StandardFont(stdFont, stdMetrics, pixel_height);
    }

    public static StandardFont getMonoFont(int pixel_height) {
        FontUtil.init();
        return new StandardFont(monoFont, monoMetrics, pixel_height);
    }

    public static class StandardFont {
        private int currFontNo;
        private int height;
        private Font[] fonts;
        private FontMetrics[] fontMetrics;

        StandardFont(Font[] fonts, FontMetrics[] fontMetrics, int pixel_height) {
            this.fonts = fonts;
            this.fontMetrics = fontMetrics;
            this.currFontNo = this.findClosest(pixel_height);
            this.height = fontMetrics[this.currFontNo].getAscent();
        }

        public Font getFont() {
            return this.fonts[this.currFontNo];
        }

        public int getFontHeight() {
            return this.height;
        }

        public Font incrFontSize() {
            if (this.currFontNo < 14) {
                ++this.currFontNo;
                this.height = this.fontMetrics[this.currFontNo].getAscent();
            }
            return this.getFont();
        }

        public Font decrFontSize() {
            if (this.currFontNo > 0) {
                --this.currFontNo;
                this.height = this.fontMetrics[this.currFontNo].getAscent();
            }
            return this.getFont();
        }

        public Dimension getBoundingBox(String s2) {
            return new Dimension(this.fontMetrics[this.currFontNo].stringWidth(s2), this.height);
        }

        private int findClosest(int pixel_height) {
            for (int i = 0; i < 14; ++i) {
                if (this.fontMetrics[i + 1].getAscent() <= pixel_height) continue;
                return i;
            }
            return 14;
        }
    }
}

