/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.JFrame;
import visad.ConstantMap;
import visad.DataReferenceImpl;
import visad.Display;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.bom.RadarAdapter;
import visad.data.mcidas.BaseMapAdapter;
import visad.java3d.DisplayImplJ3D;
import visad.util.LabeledColorWidget;

public class RadarDisplay {
    private static void setColorMap(ScalarMap colorMap, float min2, float max) throws VisADException, RemoteException {
        float[][] table = new float[3][256];
        for (int i = 0; i < 256; ++i) {
            if (i <= 15) {
                table[0][i] = 0.0f;
                table[1][i] = 0.0f;
                table[2][i] = 0.0f;
                continue;
            }
            if (i > 15 && i <= 31) {
                table[0][i] = 0.0f;
                table[1][i] = 0.9411765f;
                table[2][i] = 0.9411765f;
                continue;
            }
            if (i > 31 && i <= 47) {
                table[0][i] = 0.0f;
                table[1][i] = 0.5647059f;
                table[2][i] = 0.5647059f;
                continue;
            }
            if (i > 47 && i <= 63) {
                table[0][i] = 0.5019608f;
                table[1][i] = 0.8784314f;
                table[2][i] = 0.3137255f;
                continue;
            }
            if (i > 63 && i <= 79) {
                table[0][i] = 0.39215687f;
                table[1][i] = 0.72156864f;
                table[2][i] = 0.2509804f;
                continue;
            }
            if (i > 79 && i <= 95) {
                table[0][i] = 0.28235295f;
                table[1][i] = 0.5647059f;
                table[2][i] = 0.1882353f;
                continue;
            }
            if (i > 95 && i <= 111) {
                table[0][i] = 0.17254902f;
                table[1][i] = 0.40784314f;
                table[2][i] = 0.1254902f;
                continue;
            }
            if (i > 111 && i <= 127) {
                table[0][i] = 0.0627451f;
                table[1][i] = 0.2509804f;
                table[2][i] = 0.0627451f;
                continue;
            }
            if (i > 127 && i <= 143) {
                table[0][i] = 0.9411765f;
                table[1][i] = 0.7529412f;
                table[2][i] = 0.0627451f;
                continue;
            }
            if (i > 143 && i <= 159) {
                table[0][i] = 0.9411765f;
                table[1][i] = 0.5019608f;
                table[2][i] = 0.1254902f;
                continue;
            }
            if (i > 159 && i <= 175) {
                table[0][i] = 0.9411765f;
                table[1][i] = 0.0627451f;
                table[2][i] = 0.1254902f;
                continue;
            }
            if (i > 175 && i <= 191) {
                table[0][i] = 0.5647059f;
                table[1][i] = 0.0f;
                table[2][i] = 0.0f;
                continue;
            }
            if (i > 191 && i <= 207) {
                table[0][i] = 0.6901961f;
                table[1][i] = 0.1254902f;
                table[2][i] = 0.5019608f;
                continue;
            }
            if (i > 207 && i <= 223) {
                table[0][i] = 0.7921569f;
                table[1][i] = 0.2509804f;
                table[2][i] = 0.627451f;
                continue;
            }
            if (i > 223 && i <= 239) {
                table[0][i] = 1.0f;
                table[1][i] = 1.0f;
                table[2][i] = 1.0f;
                continue;
            }
            if (i <= 239 || i > 255) continue;
            table[0][i] = 1.0f;
            table[1][i] = 0.5019608f;
            table[2][i] = 0.8784314f;
        }
        LabeledColorWidget lw = new LabeledColorWidget(colorMap, table);
        Frame frame = new Frame("VisAD Color Widget");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.add(lw);
        frame.setSize(lw.getPreferredSize());
        frame.setVisible(true);
    }

    private static void mapDisplay(DisplayImplJ3D d, String mapFile) {
        try {
            BaseMapAdapter baseMap = new BaseMapAdapter(mapFile);
            DataReferenceImpl maplines_ref = new DataReferenceImpl("MapLines");
            maplines_ref.setData(baseMap.getData());
            ConstantMap[] colMap = new ConstantMap[]{new ConstantMap(1.0, Display.Green), new ConstantMap(1.0, Display.Red), new ConstantMap(0.0, Display.Blue), new ConstantMap(-0.99, Display.ZAxis)};
            d.addReference(maplines_ref, colMap);
        }
        catch (Exception ne) {
            ne.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        float centlat = -34.9581f;
        float centlon = 138.5342f;
        float radius = 6.0f;
        String radarSource = "radar.dat";
        Object rd = null;
        RadarAdapter ra = null;
        boolean d3d = args.length > 0;
        try {
            ra = new RadarAdapter(centlat, centlon, 0.0f, radarSource, d3d);
        }
        catch (Exception e) {
            System.err.println("Caught Exception for \"" + radarSource + "\": " + e);
            System.exit(1);
        }
        FlatField radar = ra.getData();
        FunctionType radar_image = (FunctionType)radar.getType();
        RealTupleType radaz = radar_image.getDomain();
        RealType reflection = (RealType)radar_image.getRange();
        RealType azimuth = (RealType)radaz.getComponent(1);
        RealType range = (RealType)radaz.getComponent(0);
        DisplayImplJ3D display = new DisplayImplJ3D("radar");
        ScalarMap lonmap = new ScalarMap(RealType.Longitude, Display.XAxis);
        lonmap.setRange(centlon - radius, centlon + radius);
        display.addMap(lonmap);
        ScalarMap latmap = new ScalarMap(RealType.Latitude, Display.YAxis);
        display.addMap(latmap);
        latmap.setRange(centlat - radius, centlat + radius);
        if (d3d) {
            ScalarMap altitudemap = new ScalarMap(RealType.Altitude, Display.ZAxis);
            altitudemap.setRange(0.0, 30000.0);
            display.addMap(altitudemap);
        } else {
            ScalarMap reflectionmap = new ScalarMap(reflection, Display.ZAxis);
            reflectionmap.setRange(0.0, 6.0);
            display.addMap(reflectionmap);
        }
        ScalarMap rgbMap = new ScalarMap(reflection, Display.RGB);
        display.addMap(rgbMap);
        RadarDisplay.setColorMap(rgbMap, 0.0f, 6.0f);
        RadarDisplay.mapDisplay(display, "OUTLAUST");
        GraphicsModeControl mode = display.getGraphicsModeControl();
        mode.setScaleEnable(true);
        DataReferenceImpl ref = new DataReferenceImpl("radar_ref");
        ref.setData(radar);
        display.addReference(ref);
        JFrame frame = new JFrame("VisAD BOM radar image");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.getContentPane().add(display.getComponent());
        int WIDTH = 500;
        int HEIGHT = 600;
        frame.setSize(WIDTH, HEIGHT);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(screenSize.width / 2 - WIDTH / 2, screenSize.height / 2 - HEIGHT / 2);
        frame.setVisible(true);
    }
}

