/*
 * Decompiled with CFR 0.152.
 */
package visad.cluster;

import java.io.Serializable;
import java.rmi.RemoteException;
import visad.cluster.RemoteAgentContactImpl;
import visad.cluster.RemoteClientAgent;

public abstract class NodeAgent
implements Serializable,
Runnable {
    private Object object = null;
    private RemoteClientAgent source = null;
    RemoteAgentContactImpl contact = null;
    private transient Thread agentThread;
    Serializable message = null;

    public NodeAgent(RemoteClientAgent s2) {
        this.source = s2;
    }

    public boolean onlyOne() {
        return true;
    }

    public Object getObject() {
        return this.object;
    }

    public Thread getAgentThread() {
        return this.agentThread;
    }

    public synchronized void sendToNode(Serializable me) {
        this.message = me;
        this.notify();
    }

    public synchronized Serializable getMessage() {
        while (this.message == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        Serializable me = this.message;
        this.message = null;
        return me;
    }

    public void sendToClient(Serializable message) {
        try {
            this.source.sendToClient(message);
        }
        catch (RemoteException e) {
            System.out.println("unable to send: " + message);
        }
    }

    public RemoteAgentContactImpl getRemoteAgentContact(Object obj) {
        this.object = obj;
        this.agentThread = new Thread(this);
        this.agentThread.start();
        try {
            this.contact = new RemoteAgentContactImpl(this);
            return this.contact;
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public void stop() {
        this.sendToNode((Serializable)((Object)"stop"));
        this.agentThread = null;
    }

    public abstract void run();
}

