/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdom2.Element;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.FileWriter2;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.ParsedSectionSpec;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLWriter;
import ucar.nc2.stream.NcStreamWriter;
import ucar.nc2.ui.DatasetTreeView;
import ucar.nc2.ui.NCdumpPane;
import ucar.nc2.ui.StructureTable;
import ucar.nc2.ui.VariablePlot;
import ucar.nc2.ui.VariableTable;
import ucar.nc2.ui.dialog.CompareDialog;
import ucar.nc2.ui.dialog.NetcdfOutputChooser;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.FileManager;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.util.CompareNetcdf2;
import ucar.nc2.write.Nc4ChunkingStrategy;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTable;
import ucar.util.prefs.ui.Debug;

public class DatasetViewer
extends JPanel {
    private FileManager fileChooser;
    private PreferencesExt prefs;
    private NetcdfFile ds;
    private List<NestedTable> nestedTableList = new ArrayList<NestedTable>();
    private BeanTable attTable;
    private JPanel tablePanel;
    private JSplitPane mainSplit;
    private JComponent currentComponent;
    private DatasetTreeView datasetTree;
    private NCdumpPane dumpPane;
    private VariablePlot dataPlot;
    private VariableTable variableTable;
    private TextHistoryPane infoTA;
    private StructureTable dataTable;
    private IndependentWindow infoWindow;
    private IndependentWindow dataWindow;
    private IndependentWindow plotWindow;
    private IndependentWindow dumpWindow;
    private IndependentWindow attWindow;
    private boolean eventsOK = true;
    NetcdfOutputChooser outChooser;
    private CompareDialog dialog = null;

    public DatasetViewer(PreferencesExt prefs, FileManager fileChooser) {
        this.prefs = prefs;
        this.fileChooser = fileChooser;
        this.tablePanel = new JPanel(new BorderLayout());
        this.setNestedTable(0, null);
        this.datasetTree = new DatasetTreeView();
        this.datasetTree.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("Selection")) {
                    DatasetViewer.this.setSelected((Variable)e.getNewValue());
                }
            }
        });
        this.mainSplit = new JSplitPane(1, false, this.datasetTree, this.tablePanel);
        this.mainSplit.setDividerLocation(prefs.getInt("mainSplit", 100));
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainSplit, "Center");
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Variable Information", BAMutil.getImage("netcdfUI"), this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.dataTable = new StructureTable((PreferencesExt)prefs.node("structTable"));
        this.variableTable = new VariableTable((PreferencesExt)prefs.node("variableTable"));
        this.dataWindow = new IndependentWindow("Data Table", BAMutil.getImage("netcdfUI"), this.dataTable);
        this.dataWindow.setBounds((Rectangle)prefs.getBean("dataWindowBounds", new Rectangle(50, 300, 1000, 1200)));
        this.dumpPane = new NCdumpPane((PreferencesExt)prefs.node("dumpPane"));
        this.dumpWindow = new IndependentWindow("NCDump Variable Data", BAMutil.getImage("netcdfUI"), this.dumpPane);
        this.dumpWindow.setBounds((Rectangle)prefs.getBean("DumpWindowBounds", new Rectangle(300, 300, 300, 200)));
        this.dataPlot = new VariablePlot((PreferencesExt)prefs.node("plotPane"));
        this.plotWindow = new IndependentWindow("Plot Variable Data", BAMutil.getImage("netcdfUI"), this.dataPlot);
        this.plotWindow.setBounds((Rectangle)prefs.getBean("PlotWindowBounds", new Rectangle(300, 300, 300, 200)));
        this.plotWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DatasetViewer.this.dataPlot.clear();
            }
        });
    }

    public void addActions(JPanel buttPanel) {
        AbstractAction netcdfAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DatasetViewer.this.ds == null) {
                    return;
                }
                if (DatasetViewer.this.outChooser == null) {
                    DatasetViewer.this.outChooser = new NetcdfOutputChooser((Frame)null);
                    DatasetViewer.this.outChooser.addPropertyChangeListener("OK", new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            DatasetViewer.this.writeNetcdf((NetcdfOutputChooser.Data)evt.getNewValue());
                        }
                    });
                }
                DatasetViewer.this.outChooser.setOutputFilename(DatasetViewer.this.ds.getLocation());
                DatasetViewer.this.outChooser.setVisible(true);
            }
        };
        BAMutil.setActionProperties(netcdfAction, "netcdf", "Write netCDF file", false, 83, -1);
        BAMutil.addActionToContainer(buttPanel, netcdfAction);
        AbstractButton compareButton = BAMutil.makeButtcon("Select", "Compare to another file", false);
        compareButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetViewer.this.compareDataset();
            }
        });
        buttPanel.add(compareButton);
        AbstractAction attAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetViewer.this.showAtts();
            }
        };
        BAMutil.setActionProperties(attAction, "FontDecr", "global attributes", false, 65, -1);
        BAMutil.addActionToContainer(buttPanel, attAction);
    }

    void writeNetcdf(NetcdfOutputChooser.Data data) {
        if (data.version == NetcdfFileWriter.Version.ncstream) {
            this.writeNcstream(data.outputFilename);
            return;
        }
        try {
            FileWriter2 writer = new FileWriter2(this.ds, data.outputFilename, data.version, Nc4ChunkingStrategy.factory(data.chunkerType, data.deflate, data.shuffle));
            NetcdfFile result = writer.write();
            result.close();
            JOptionPane.showMessageDialog(this, "File successfully written");
        }
        catch (Exception ioe) {
            JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
            ioe.printStackTrace();
        }
    }

    void writeNcstream(String filename) {
        try {
            NcStreamWriter writer = new NcStreamWriter(this.ds, null);
            try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(filename), 50000);){
                writer.streamAll(fos);
            }
            JOptionPane.showMessageDialog(this, "File successfully written");
        }
        catch (Exception ioe) {
            JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
            ioe.printStackTrace();
        }
    }

    void writeNcstreamHeader(String filename) {
        try {
            NcStreamWriter writer = new NcStreamWriter(this.ds, null);
            try (FileOutputStream fos = new FileOutputStream(filename);){
                writer.sendHeader(fos);
            }
            JOptionPane.showMessageDialog(this, "File successfully written");
        }
        catch (Exception ioe) {
            JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
            ioe.printStackTrace();
        }
    }

    public void compareDataset() {
        if (this.ds == null) {
            return;
        }
        if (this.dialog == null) {
            this.dialog = new CompareDialog(null, this.fileChooser);
            this.dialog.pack();
            this.dialog.addPropertyChangeListener("OK", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    CompareDialog.Data data = (CompareDialog.Data)evt.getNewValue();
                    DatasetViewer.this.compareDataset(data);
                }
            });
        }
        this.dialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compareDataset(CompareDialog.Data data) {
        if (data.name == null) {
            return;
        }
        NetcdfFile compareFile = null;
        try {
            compareFile = NetcdfDataset.openFile(data.name, null);
            Formatter f = new Formatter();
            CompareNetcdf2 cn = new CompareNetcdf2(f, data.showCompare, data.showDetails, data.readData);
            if (data.howMuch == CompareDialog.HowMuch.All) {
                cn.compare(this.ds, compareFile);
            } else if (data.howMuch == CompareDialog.HowMuch.varNameOnly) {
                f.format(" First file = %s%n", this.ds.getLocation());
                f.format(" Second file= %s%n", compareFile.getLocation());
                CompareNetcdf2.compareLists(this.getVariableNames(this.ds), this.getVariableNames(compareFile), f);
            } else {
                NestedTable nested = this.nestedTableList.get(0);
                Variable org = this.getCurrentVariable(nested.table);
                if (org == null) {
                    return;
                }
                Variable ov = compareFile.findVariable(org.getFullNameEscaped());
                if (ov != null) {
                    cn.compareVariable(org, ov);
                }
            }
            this.infoTA.setText(f.toString());
            this.infoTA.gotoTop();
            this.infoWindow.setTitle("Compare");
            this.infoWindow.show();
        }
        catch (Throwable ioe) {
            StringWriter sw = new StringWriter(10000);
            ioe.printStackTrace(new PrintWriter(sw));
            this.infoTA.setText(sw.toString());
            this.infoTA.gotoTop();
            this.infoWindow.show();
        }
        finally {
            if (compareFile != null) {
                try {
                    compareFile.close();
                }
                catch (Exception eek) {
                    eek.printStackTrace();
                }
            }
        }
    }

    private List<String> getVariableNames(NetcdfFile nc) {
        ArrayList<String> result = new ArrayList<String>();
        for (Variable v : nc.getVariables()) {
            result.add(v.getFullName());
        }
        return result;
    }

    public void showAtts() {
        if (this.ds == null) {
            return;
        }
        if (this.attTable == null) {
            this.attTable = new BeanTable(AttributeBean.class, (PreferencesExt)this.prefs.node("AttributeBeans"), false);
            PopupMenu varPopup = new PopupMenu(this.attTable.getJTable(), "Options");
            varPopup.addAction("Show Attribute", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributeBean bean = (AttributeBean)DatasetViewer.this.attTable.getSelectedBean();
                    if (bean != null) {
                        DatasetViewer.this.infoTA.setText(bean.att.toString());
                        DatasetViewer.this.infoTA.gotoTop();
                        DatasetViewer.this.infoWindow.show();
                    }
                }
            });
            this.attWindow = new IndependentWindow("Global Attributes", BAMutil.getImage("netcdfUI"), this.attTable);
            this.attWindow.setBounds((Rectangle)this.prefs.getBean("AttWindowBounds", new Rectangle(300, 100, 500, 800)));
        }
        ArrayList<AttributeBean> attlist = new ArrayList<AttributeBean>();
        for (Attribute att : this.ds.getGlobalAttributes()) {
            attlist.add(new AttributeBean(att));
        }
        this.attTable.setBeans(attlist);
        this.attWindow.show();
    }

    public NetcdfFile getDataset() {
        return this.ds;
    }

    public void clear() {
        this.ds = null;
        if (this.attTable != null) {
            this.attTable.clearBeans();
        }
        for (NestedTable nt : this.nestedTableList) {
            nt.table.clearBeans();
        }
        this.datasetTree.clear();
    }

    public void setDataset(NetcdfFile ds) {
        this.ds = ds;
        NestedTable nt = this.nestedTableList.get(0);
        nt.table.setBeans(this.getVariableBeans(ds));
        this.hideNestedTable(1);
        this.datasetTree.setFile(ds);
    }

    private void setSelected(Variable v) {
        this.eventsOK = false;
        ArrayList<Variable> vchain = new ArrayList<Variable>();
        vchain.add(v);
        Variable vp = v;
        while (vp.isMemberOfStructure()) {
            vp = vp.getParentStructure();
            vchain.add(0, vp);
        }
        for (int i = 0; i < vchain.size(); ++i) {
            vp = (Variable)vchain.get(i);
            NestedTable ntable = this.setNestedTable(i, vp.getParentStructure());
            ntable.setSelected(vp);
        }
        this.eventsOK = true;
    }

    private NestedTable setNestedTable(int level, Structure s2) {
        NestedTable ntable;
        if (this.nestedTableList.size() < level + 1) {
            ntable = new NestedTable(level);
            this.nestedTableList.add(ntable);
        } else {
            ntable = this.nestedTableList.get(level);
        }
        if (s2 != null) {
            ntable.table.setBeans(this.getStructureVariables(s2));
        }
        ntable.show();
        return ntable;
    }

    private void hideNestedTable(int level) {
        int n = this.nestedTableList.size();
        for (int i = n - 1; i >= level; --i) {
            NestedTable ntable = this.nestedTableList.get(i);
            ntable.hide();
        }
    }

    private void showDeclaration(BeanTable from, boolean isNcml) {
        Variable v = this.getCurrentVariable(from);
        if (v == null) {
            return;
        }
        this.infoTA.clear();
        if (isNcml) {
            NcMLWriter ncmlWriter = new NcMLWriter();
            ncmlWriter.setNamespace(null);
            ncmlWriter.getXmlFormat().setOmitDeclaration(true);
            Element varElement = ncmlWriter.makeVariableElement(v, false);
            this.infoTA.appendLine(ncmlWriter.writeToString(varElement));
        } else {
            this.infoTA.appendLine(v.toString());
        }
        if (Debug.isSet("Xdeveloper")) {
            this.infoTA.appendLine("\n");
            this.infoTA.appendLine("FULL NAME = " + v.getFullName());
            this.infoTA.appendLine("\n");
            this.infoTA.appendLine(v.toStringDebug());
        }
        this.infoTA.gotoTop();
        this.infoWindow.setTitle("Variable Info");
        this.infoWindow.show();
    }

    private void showData(BeanTable from) {
        Variable v = this.getCurrentVariable(from);
        if (v == null) {
            return;
        }
        this.infoTA.clear();
        try {
            Array data = v.read();
            this.infoTA.setText(NCdumpW.toString(data, v.getFullName(), null));
        }
        catch (Exception ex) {
            StringWriter s2 = new StringWriter();
            ex.printStackTrace(new PrintWriter(s2));
            this.infoTA.setText(s2.toString());
        }
        this.infoTA.gotoTop();
        this.infoWindow.setTitle("Variable Info");
        this.infoWindow.show();
    }

    private void dumpData(BeanTable from) {
        Variable v = this.getCurrentVariable(from);
        if (v == null) {
            return;
        }
        this.dumpPane.clear();
        try {
            String spec = ParsedSectionSpec.makeSectionSpecString(v, null);
            this.dumpPane.setContext(this.ds, spec);
        }
        catch (Exception ex) {
            StringWriter s2 = new StringWriter();
            ex.printStackTrace(new PrintWriter(s2));
            this.dumpPane.setText(s2.toString());
        }
        this.dumpWindow.show();
    }

    private void writeData(BeanTable from, File name) {
        Variable v = this.getCurrentVariable(from);
        if (v == null || name == null) {
            return;
        }
        try (FileOutputStream stream = new FileOutputStream(name);){
            FileChannel channel = stream.getChannel();
            v.readToByteChannel(v.getShapeAsSection(), channel);
            System.out.printf("Write ok to %s%n", name);
        }
        catch (IOException | InvalidRangeException e) {
            e.printStackTrace();
        }
    }

    private void dataTable(BeanTable from) {
        VariableBean vb = (VariableBean)from.getSelectedBean();
        if (vb == null) {
            return;
        }
        Variable v = vb.vs;
        if (v instanceof Structure) {
            try {
                this.dataTable.setStructure((Structure)v);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.dataWindow.setComponent(this.dataTable);
        } else {
            List l = from.getSelectedBeans();
            ArrayList<Variable> vl = new ArrayList<Variable>();
            for (VariableBean vb1 : l) {
                if (vb1 == null) {
                    return;
                }
                v = vb1.vs;
                if (v != null) {
                    vl.add(v);
                    continue;
                }
                return;
            }
            this.variableTable.setDataset(this.ds);
            this.variableTable.setVariableList(vl);
            this.variableTable.createTable();
            this.dataWindow.setComponent(this.variableTable);
        }
        Rectangle r = (Rectangle)this.prefs.getBean("dataWindowBounds", new Rectangle(50, 300, 1000, 1200));
        this.dataWindow.setBounds(r);
        this.dataWindow.show();
    }

    private void dataPlot(BeanTable from) {
        List l = from.getSelectedBeans();
        for (VariableBean vb : l) {
            if (vb == null) {
                return;
            }
            Variable v = vb.vs;
            if (v != null) {
                try {
                    this.dataPlot.setDataset(this.ds);
                    this.dataPlot.setVariable(v);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                continue;
            }
            return;
        }
        this.plotWindow.show();
    }

    private Variable getCurrentVariable(BeanTable from) {
        VariableBean vb = (VariableBean)from.getSelectedBean();
        if (vb == null) {
            return null;
        }
        return vb.vs;
    }

    public PreferencesExt getPrefs() {
        return this.prefs;
    }

    public void save() {
        this.dumpPane.save();
        this.fileChooser.save();
        for (NestedTable nt : this.nestedTableList) {
            nt.saveState();
        }
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putBeanObject("dataWindowBounds", this.dataWindow.getBounds());
        this.prefs.putBeanObject("DumpWindowBounds", this.dumpWindow.getBounds());
        this.prefs.putBeanObject("PlotWindowBounds", this.plotWindow.getBounds());
        if (this.attWindow != null) {
            this.prefs.putBeanObject("AttWindowBounds", this.attWindow.getBounds());
        }
        this.prefs.putInt("mainSplit", this.mainSplit.getDividerLocation());
    }

    public List<VariableBean> getVariableBeans(NetcdfFile ds) {
        ArrayList<VariableBean> vlist = new ArrayList<VariableBean>();
        for (Variable v : ds.getVariables()) {
            vlist.add(new VariableBean(v));
        }
        return vlist;
    }

    public List<VariableBean> getStructureVariables(Structure s2) {
        ArrayList<VariableBean> vlist = new ArrayList<VariableBean>();
        for (Variable v : s2.getVariables()) {
            vlist.add(new VariableBean(v));
        }
        return vlist;
    }

    public class AttributeBean {
        private Attribute att;

        public AttributeBean(Attribute att) {
            this.att = att;
        }

        public String getName() {
            return this.att.getShortName();
        }

        public String getValue() {
            Array value = this.att.getValues();
            return NCdumpW.toString(value, null, null);
        }
    }

    public class VariableBean {
        private Variable vs;
        private String name;
        private String dimensions;
        private String desc;
        private String units;
        private String dataType;
        private String shape;

        public VariableBean(Variable vs) {
            this.vs = vs;
            this.setName(vs.getShortName());
            this.setDescription(vs.getDescription());
            this.setUnits(vs.getUnitsString());
            this.setDataType(vs.getDataType().toString());
            StringBuilder lens = new StringBuilder();
            StringBuilder names = new StringBuilder();
            List<Dimension> dims = vs.getDimensions();
            for (int j = 0; j < dims.size(); ++j) {
                Dimension dim = dims.get(j);
                if (j > 0) {
                    lens.append(",");
                    names.append(",");
                }
                String name = dim.isShared() ? dim.getShortName() : "anon";
                names.append(name);
                lens.append(dim.getLength());
            }
            this.setDimensions(names.toString());
            this.setShape(lens.toString());
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getGroup() {
            return this.vs.getParentGroup().getFullName();
        }

        public String getDimensions() {
            return this.dimensions;
        }

        public void setDimensions(String dimensions) {
            this.dimensions = dimensions;
        }

        public String getDescription() {
            return this.desc;
        }

        public void setDescription(String desc) {
            this.desc = desc;
        }

        public String getUnits() {
            return this.units;
        }

        public void setUnits(String units) {
            this.units = units;
        }

        public String getDataType() {
            return this.dataType;
        }

        public void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public String getShape() {
            return this.shape;
        }

        public void setShape(String shape) {
            this.shape = shape;
        }
    }

    private class NestedTable {
        int level;
        PreferencesExt myPrefs;
        BeanTable table;
        JSplitPane split = null;
        int splitPos = 100;
        boolean isShowing = false;

        NestedTable(int level) {
            this.level = level;
            this.myPrefs = (PreferencesExt)DatasetViewer.this.prefs.node("NestedTable" + level);
            this.table = new BeanTable(VariableBean.class, this.myPrefs, false);
            JTable jtable = this.table.getJTable();
            PopupMenu csPopup = new PopupMenu(jtable, "Options");
            csPopup.addAction("Show Declaration", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatasetViewer.this.showDeclaration(NestedTable.this.table, false);
                }
            });
            csPopup.addAction("Show NcML", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatasetViewer.this.showDeclaration(NestedTable.this.table, true);
                }
            });
            csPopup.addAction("Show Data", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatasetViewer.this.showData(NestedTable.this.table);
                }
            });
            csPopup.addAction("NCdump Data", "Dump", (Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatasetViewer.this.dumpData(NestedTable.this.table);
                }
            });
            csPopup.addAction("Write binary Data to file", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String binaryFilePath = DatasetViewer.this.fileChooser.chooseFilenameToSave("data.bin");
                    if (binaryFilePath != null) {
                        DatasetViewer.this.writeData(NestedTable.this.table, new File(binaryFilePath));
                    }
                }
            });
            if (level == 0) {
                csPopup.addAction("Data Table", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DatasetViewer.this.dataTable(NestedTable.this.table);
                    }
                });
                csPopup.addAction("Data Plot", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DatasetViewer.this.dataPlot(NestedTable.this.table);
                    }
                });
            }
            this.table.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    Variable v = DatasetViewer.this.getCurrentVariable(NestedTable.this.table);
                    if (v != null && v instanceof Structure) {
                        DatasetViewer.this.hideNestedTable(NestedTable.this.level + 2);
                        DatasetViewer.this.setNestedTable(NestedTable.this.level + 1, (Structure)v);
                    } else {
                        DatasetViewer.this.hideNestedTable(NestedTable.this.level + 1);
                    }
                    if (DatasetViewer.this.eventsOK) {
                        DatasetViewer.this.datasetTree.setSelected(v);
                    }
                }
            });
            if (DatasetViewer.this.currentComponent == null) {
                DatasetViewer.this.currentComponent = this.table;
                DatasetViewer.this.tablePanel.add((Component)DatasetViewer.this.currentComponent, "Center");
                this.isShowing = true;
            } else {
                this.split = new JSplitPane(0, false, DatasetViewer.this.currentComponent, this.table);
                this.splitPos = this.myPrefs.getInt("splitPos" + level, 500);
                if (this.splitPos > 0) {
                    this.split.setDividerLocation(this.splitPos);
                }
                this.show();
            }
        }

        void show() {
            if (this.isShowing) {
                return;
            }
            DatasetViewer.this.tablePanel.remove(DatasetViewer.this.currentComponent);
            this.split.setLeftComponent(DatasetViewer.this.currentComponent);
            this.split.setDividerLocation(this.splitPos);
            DatasetViewer.this.currentComponent = this.split;
            DatasetViewer.this.tablePanel.add((Component)DatasetViewer.this.currentComponent, "Center");
            DatasetViewer.this.tablePanel.revalidate();
            this.isShowing = true;
        }

        void hide() {
            if (!this.isShowing) {
                return;
            }
            DatasetViewer.this.tablePanel.remove(DatasetViewer.this.currentComponent);
            if (this.split != null) {
                this.splitPos = this.split.getDividerLocation();
                DatasetViewer.this.currentComponent = (JComponent)this.split.getLeftComponent();
                DatasetViewer.this.tablePanel.add((Component)DatasetViewer.this.currentComponent, "Center");
            }
            DatasetViewer.this.tablePanel.revalidate();
            this.isShowing = false;
        }

        void setSelected(Variable vs) {
            List beans = this.table.getBeans();
            for (Object bean1 : beans) {
                VariableBean bean = (VariableBean)bean1;
                if (bean.vs != vs) continue;
                this.table.setSelectedBean(bean);
                return;
            }
        }

        void saveState() {
            this.table.saveState(false);
            if (this.split != null) {
                this.myPrefs.putInt("splitPos" + this.level, this.split.getDividerLocation());
            }
        }
    }
}

