/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.grib;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.unidata.util.StringUtil2;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTable;

public class GribRewritePanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(GribRewritePanel.class);
    private PreferencesExt prefs;
    private BeanTable ftTable;
    private JSplitPane split;
    private TextHistoryPane dumpTA;
    private IndependentWindow infoWindow;
    private static final boolean debug = true;

    public GribRewritePanel(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.ftTable = new BeanTable(FileBean.class, (PreferencesExt)prefs.node("FeatureDatasetBeans"), false);
        AbstractAction calcAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GribRewritePanel.this.calcAverage();
            }
        };
        BAMutil.setActionProperties(calcAction, "Dataset", "calc storage", false, 67, -1);
        BAMutil.addActionToContainer(buttPanel, calcAction);
        PopupMenu varPopup = new PopupMenu(this.ftTable.getJTable(), "Options");
        varPopup.addAction("Open as NetcdfFile", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileBean ftb = (FileBean)GribRewritePanel.this.ftTable.getSelectedBean();
                if (ftb == null) {
                    return;
                }
                GribRewritePanel.this.firePropertyChange("openNetcdfFile", null, ftb.getPath());
            }
        });
        varPopup.addAction("Open as GridDataset", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileBean ftb = (FileBean)GribRewritePanel.this.ftTable.getSelectedBean();
                if (ftb == null) {
                    return;
                }
                GribRewritePanel.this.firePropertyChange("openGridDataset", null, ftb.getPath());
            }
        });
        varPopup.addAction("Open in Grib2Data", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileBean ftb = (FileBean)GribRewritePanel.this.ftTable.getSelectedBean();
                if (ftb == null) {
                    return;
                }
                GribRewritePanel.this.firePropertyChange("openGrib2Data", null, ftb.getPath());
            }
        });
        varPopup.addAction("Open in Grib1Data", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileBean ftb = (FileBean)GribRewritePanel.this.ftTable.getSelectedBean();
                if (ftb == null) {
                    return;
                }
                GribRewritePanel.this.firePropertyChange("openGrib1Data", null, ftb.getPath());
            }
        });
        TextHistoryPane infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.dumpTA = new TextHistoryPane();
        this.split = new JSplitPane(0, false, this.ftTable, this.dumpTA);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    public PreferencesExt getPrefs() {
        return this.prefs;
    }

    public void save() {
        this.ftTable.saveState(false);
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
    }

    public void clear() {
        this.ftTable.setBeans(new ArrayList());
    }

    public boolean setScanDirectory(String dirName) {
        this.clear();
        Formatter errlog = new Formatter();
        List<FileBean> beans = this.scan(dirName, errlog);
        if (beans.size() == 0) {
            this.dumpTA.setText(errlog.toString());
            return false;
        }
        this.ftTable.setBeans(beans);
        return true;
    }

    private void setSelectedFeatureDataset(FileBean ftb) {
        this.dumpTA.setText(ftb.toString());
        this.dumpTA.gotoTop();
    }

    private void calcAverage() {
        Formatter f = new Formatter();
        this.calcAverage(null, f);
        this.calcAverage("grib1", f);
        this.calcAverage("grib2", f);
        this.dumpTA.setText(f.toString());
        this.dumpTA.gotoTop();
    }

    private void calcAverage(String what, Formatter f) {
        double totalRecords = 0.0;
        double ratio = 0.0;
        List beans = this.ftTable.getBeans();
        for (FileBean bean : beans) {
            if (bean.getNdups() > 0 || bean.getRatio() == 0.0 || what != null && !bean.getPath().contains(what)) continue;
            totalRecords += (double)bean.getNrecords();
            ratio += (double)bean.getNrecords() * bean.getRatio();
        }
        double weightedAvg = ratio / totalRecords;
        if (what != null) {
            f.format("%n%s%n", what);
        }
        f.format("Weighted average ratio = %f%n", weightedAvg);
        f.format("Total # grib records = %f%n", totalRecords);
    }

    public List<FileBean> scan(String top, Formatter errlog) {
        ArrayList<FileBean> result = new ArrayList<FileBean>();
        File topFile = new File(top);
        if (!topFile.exists()) {
            errlog.format("File %s does not exist", top);
            return result;
        }
        if (topFile.isDirectory()) {
            this.scanDirectory(topFile, false, result, errlog);
        } else {
            FileBean fdb = null;
            try {
                fdb = new FileBean(topFile);
            }
            catch (IOException e) {
                System.out.printf("FAIL, skip %s%n", topFile.getPath());
            }
            result.add(fdb);
        }
        return result;
    }

    private void scanDirectory(File dir, boolean subdirs, List<FileBean> result, Formatter errlog) {
        if (dir.getName().equals("exclude") || dir.getName().equals("problem")) {
            return;
        }
        File[] gribFilesInDir = dir.listFiles(new FileFilterFromSuffixes("grib1 grib2"));
        if (gribFilesInDir == null) {
            throw new RuntimeException(String.format("Either an I/O error occurred, or \"%s\" is not a directory.", dir));
        }
        ArrayList<File> files = new ArrayList<File>();
        for (File gribFile : gribFilesInDir) {
            if (gribFile.isDirectory()) continue;
            files.add(gribFile);
        }
        if (files.size() > 0) {
            Collections.sort(files);
            ArrayList files2 = new ArrayList(files);
            File prev = null;
            for (File f : files) {
                String name = f.getName();
                String stem = this.stem(name);
                if (prev != null && name.endsWith(".ncml") && (prev.getName().equals(stem) || prev.getName().equals(stem + ".grib2"))) {
                    files2.remove(prev);
                }
                prev = f;
            }
            for (File f : files2) {
                try {
                    result.add(new FileBean(f));
                }
                catch (IOException e) {
                    System.out.printf("FAIL, skip %s%n", f.getPath());
                }
            }
        }
        if (subdirs) {
            for (File f : dir.listFiles()) {
                if (!f.isDirectory() || f.getName().equals("exclude")) continue;
                this.scanDirectory(f, subdirs, result, errlog);
            }
        }
    }

    private String stem(String name) {
        int pos = name.lastIndexOf(46);
        return pos > 0 ? name.substring(0, pos) : name;
    }

    public class FileBean {
        private File f;
        String fileType;
        long cdmData2D;
        long nc4Data2D;
        long nc4Size;
        int nrecords;
        int nvars;
        int ndups;

        public FileBean() {
        }

        public FileBean(File f) throws IOException {
            this.f = f;
            System.out.printf(" fileScan=%s%n", this.getPath());
            try (NetcdfDataset ncd = NetcdfDataset.openDataset(this.getPath());){
                this.fileType = ncd.getFileTypeId();
                this.cdmData2D = this.countCdmData2D(ncd);
                this.countGribData2D(f);
                this.countNc4Data2D(f);
            }
        }

        public String getPath() {
            String p = this.f.getPath();
            return StringUtil2.replace(p, "\\", "/");
        }

        public String getFileType() {
            return this.fileType;
        }

        public double getGribSizeM() {
            return (double)this.f.length() / 1000.0 / 1000.0;
        }

        public long getCdmData2D() {
            return this.cdmData2D;
        }

        public int getNrecords() {
            return this.nrecords;
        }

        public boolean isMatch() {
            return (long)this.nrecords == this.cdmData2D;
        }

        public int getNvars() {
            return this.nvars;
        }

        public int getNdups() {
            return this.ndups;
        }

        public double getNc4SizeM() {
            return (double)this.nc4Size / 1000.0 / 1000.0;
        }

        public long getNc4Data2D() {
            return this.nc4Data2D;
        }

        public double getRatio() {
            long size = this.f.length();
            return size == 0L ? 0.0 : (double)this.nc4Size / (double)size;
        }

        public long countCdmData2D(NetcdfDataset ncd) throws IOException {
            long result = 0L;
            GridDataset ds = new GridDataset(ncd);
            for (GridDatatype grid : ds.getGrids()) {
                int[] shape = grid.getShape();
                int rank = grid.getRank();
                long data2D = 1L;
                for (int i = 0; i < rank - 2; ++i) {
                    data2D *= (long)shape[i];
                }
                result += data2D;
            }
            return result;
        }

        public void countGribData2D(File f) throws IOException {
            String indexFilename = f.getPath() + ".ncx4";
            FeatureCollectionConfig config = new FeatureCollectionConfig();
            try (GribCollectionImmutable gc = GribCdmIndex.openCdmIndex(indexFilename, config, false, logger);){
                if (gc == null) {
                    throw new IOException("Not a grib collection index file");
                }
                for (GribCollectionImmutable.Dataset ds : gc.getDatasets()) {
                    for (GribCollectionImmutable.GroupGC group : ds.getGroups()) {
                        for (GribCollectionImmutable.VariableIndex vi : group.getVariables()) {
                            ++this.nvars;
                        }
                    }
                }
            }
        }

        public void countNc4Data2D(File f) {
            String filename = f.getName();
            String nc4Filename = "G:/write/" + filename + ".3.grib.nc4";
            File nc4 = new File(nc4Filename);
            if (!nc4.exists()) {
                return;
            }
            this.nc4Size = nc4.length();
            try (NetcdfDataset ncd = NetcdfDataset.openDataset(nc4Filename);){
                this.nc4Data2D = this.countCdmData2D(ncd);
            }
            catch (IOException e) {
                System.out.printf("Error opening %s%n", nc4Filename);
            }
        }
    }

    public static class FileFilterFromSuffixes
    implements FileFilter {
        String[] suffixes;

        public FileFilterFromSuffixes(String suffixes) {
            this.suffixes = suffixes.split(" ");
        }

        @Override
        public boolean accept(File file) {
            for (String s2 : this.suffixes) {
                if (!file.getPath().endsWith(s2)) continue;
                return true;
            }
            return false;
        }
    }
}

