/*
 * Decompiled with CFR 0.152.
 */
package visad.browser;

import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import visad.browser.ContourWidget;
import visad.browser.Convert;
import visad.browser.Divider;
import visad.browser.Widget;
import visad.browser.WidgetEvent;
import visad.browser.WidgetListener;

public class VisADApplet
extends Applet
implements ActionListener,
MouseListener,
MouseMotionListener,
WidgetListener {
    private static final boolean DEBUG = false;
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 4567;
    public static final int REFRESH = 0;
    public static final int MOUSE_EVENT = 1;
    public static final int MESSAGE = 2;
    private boolean connected = false;
    private String address = "";
    private int port = 4567;
    private Socket socket = null;
    private DataOutputStream out = null;
    private int id;
    private Image image = null;
    private TextField addressField;
    private TextField portField;
    private Button connectButton;
    private Component canvas;
    private Frame frame;
    private GridBagLayout widgetLayout;
    private GridBagConstraints constraints;
    private Thread commThread = null;
    private Hashtable hashtable = new Hashtable();
    private Applet myself;

    private void addComponent(Component c, GridBagLayout layout, int x, int y, int w, int h2, double wx, double wy) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h2;
        gbc.fill = 1;
        gbc.weightx = wx;
        gbc.weighty = wy;
        layout.setConstraints(c, gbc);
        this.add(c);
    }

    private void addWidget(Widget widget, String hash) {
        this.hashtable.put(hash, widget);
        if (this.constraints.gridy > 0) {
            Divider divider = new Divider();
            this.widgetLayout.setConstraints(divider, this.constraints);
            ++this.constraints.gridy;
            this.frame.add(divider);
        }
        this.widgetLayout.setConstraints(widget, this.constraints);
        ++this.constraints.gridy;
        this.frame.add(widget);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private synchronized void removeAllWidgets() {
        this.hashtable = new Hashtable();
        this.constraints.gridy = 0;
        this.frame.setVisible(false);
        this.frame.removeAll();
    }

    public void init() {
        this.setBackground(Color.white);
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        this.myself = this;
        this.addressField = new TextField(DEFAULT_HOST);
        this.portField = new TextField("4567", 4);
        this.connectButton = new Button("Connect");
        this.canvas = new Component(){

            public void update(Graphics g2) {
                this.paint(g2);
            }

            public void paint(Graphics g2) {
                if (VisADApplet.this.connected) {
                    if (VisADApplet.this.image != null) {
                        g2.drawImage(VisADApplet.this.image, 0, 0, this);
                    }
                } else {
                    g2.setColor(Color.black);
                    g2.drawString("VisADApplet", 80, 20);
                    g2.drawString("To connect to a VisAD display available", 10, 50);
                    g2.drawString("through a SocketSlaveDisplay server, type", 10, 70);
                    g2.drawString("the IP address of the server into the IP", 10, 90);
                    g2.drawString("address field and type the port of the", 10, 110);
                    g2.drawString("server into the port field, then press", 10, 130);
                    g2.drawString("the Connect button.", 10, 150);
                }
            }
        };
        this.addressField.addActionListener(this);
        this.portField.addActionListener(this);
        this.connectButton.addActionListener(this);
        this.canvas.addMouseListener(this);
        this.canvas.addMouseMotionListener(this);
        this.addComponent(new Label("IP address"), gridbag, 0, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.addressField, gridbag, 1, 0, 1, 1, 1.0, 0.0);
        this.addComponent(new Label("Port"), gridbag, 2, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.portField, gridbag, 3, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.connectButton, gridbag, 4, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.canvas, gridbag, 0, 1, 5, 1, 1.0, 1.0);
        this.frame = new Frame("Controls");
        this.widgetLayout = new GridBagLayout();
        this.frame.setLayout(this.widgetLayout);
        this.constraints = new GridBagConstraints();
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.fill = 1;
        this.frame.setBackground(Widget.PALE_GRAY);
    }

    public void disconnect() {
        if (this.connected) {
            this.connected = false;
            for (int i = 0; i < this.frame.getComponentCount(); ++i) {
                Component c = this.frame.getComponent(i);
                if (!(c instanceof Widget)) continue;
                Widget w = (Widget)this.frame.getComponent(i);
                w.removeWidgetListener(this);
            }
            this.removeAllWidgets();
            this.repaint();
        }
    }

    private void requestRefresh() {
        if (this.out != null) {
            try {
                this.out.writeInt(this.id);
                this.out.writeInt(0);
            }
            catch (SocketException exc) {
                this.disconnect();
            }
            catch (IOException exc) {
                this.disconnect();
            }
        }
    }

    private void sendEvent(MouseEvent e) {
        int mid = e.getID();
        long when = e.getWhen();
        int mods = e.getModifiers();
        int x = e.getX();
        int y = e.getY();
        int clicks = e.getClickCount();
        boolean popup = e.isPopupTrigger();
        if (this.out != null) {
            try {
                this.out.writeInt(this.id);
                this.out.writeInt(1);
                this.out.writeInt(mid);
                this.out.writeLong(when);
                this.out.writeInt(mods);
                this.out.writeInt(x);
                this.out.writeInt(y);
                this.out.writeInt(clicks);
                this.out.writeBoolean(popup);
            }
            catch (SocketException exc) {
                this.disconnect();
            }
            catch (IOException exc) {
                this.disconnect();
            }
        }
    }

    private void sendMessage(String message) {
        if (this.out != null) {
            try {
                this.out.writeInt(this.id);
                this.out.writeInt(2);
                this.out.writeInt(message.length());
                this.out.writeChars(message);
            }
            catch (SocketException exc) {
                this.disconnect();
            }
            catch (IOException exc) {
                this.disconnect();
            }
        }
    }

    public synchronized void actionPerformed(ActionEvent e) {
        this.connectButton.requestFocus();
        String address = this.addressField.getText();
        int port = this.port;
        try {
            port = Integer.parseInt(this.portField.getText());
        }
        catch (NumberFormatException exc) {
            // empty catch block
        }
        this.portField.setText("" + port);
        Socket sock = null;
        try {
            sock = new Socket(address, port);
        }
        catch (UnknownHostException exc) {
            this.addressField.setText("" + this.address);
        }
        catch (IOException exc) {
            // empty catch block
        }
        if (sock == null) {
            return;
        }
        if (this.connected) {
            try {
                this.socket.close();
            }
            catch (IOException exc) {
                // empty catch block
            }
            this.disconnect();
            while (this.commThread.isAlive()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException exc) {}
            }
        }
        this.socket = sock;
        DataInputStream sin = null;
        try {
            sin = new DataInputStream(this.socket.getInputStream());
            this.out = new DataOutputStream(this.socket.getOutputStream());
            this.id = 0;
            while (true) {
                this.id = sin.readInt();
                if (this.id != 0) break;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException exc) {}
            }
            this.connected = true;
        }
        catch (IOException exc) {
            this.disconnect();
        }
        final DataInputStream in = sin;
        final VisADApplet applet = this;
        this.commThread = new Thread(new Runnable(){

            public void run() {
                try {
                    VisADApplet.this.requestRefresh();
                    while (VisADApplet.this.connected) {
                        int w = in.readInt();
                        if (w == 0) continue;
                        if (w == -1) {
                            int ctrlIndex;
                            Widget widget;
                            String widgetHash;
                            StringTokenizer st;
                            int len = in.readInt();
                            char[] c = new char[len];
                            for (int i = 0; i < len; ++i) {
                                c[i] = in.readChar();
                            }
                            String message = new String(c);
                            if (message.startsWith("visad.ScalarMap\n")) {
                                st = new StringTokenizer(message);
                                st.nextToken();
                                String scalar = st.nextToken();
                                String displayScalar = st.nextToken();
                                float min2 = Convert.getFloat(st.nextToken());
                                float max = Convert.getFloat(st.nextToken());
                                String mapHash = scalar + " " + displayScalar;
                                String dsHash = "." + displayScalar;
                                Integer index = (Integer)VisADApplet.this.hashtable.get(mapHash);
                                if (index == null) {
                                    Integer count = (Integer)VisADApplet.this.hashtable.get(dsHash);
                                    if (count == null) {
                                        count = new Integer(0);
                                    }
                                    index = count;
                                    VisADApplet.this.hashtable.put(mapHash, index);
                                    VisADApplet.this.hashtable.put(dsHash, new Integer(count + 1));
                                }
                                if (!displayScalar.equals("DisplayIsoContour")) continue;
                                widgetHash = "Contour" + index;
                                widget = (ContourWidget)VisADApplet.this.hashtable.get(widgetHash);
                                ((ContourWidget)widget).setName(scalar);
                                ((ContourWidget)widget).setRange(min2, max);
                                continue;
                            }
                            st = new StringTokenizer(message, "\n");
                            String controlClass = st.nextToken();
                            int index = Convert.getInt(st.nextToken());
                            String save = st.nextToken();
                            int dotIndex = controlClass.lastIndexOf(".");
                            String widgetName = controlClass.substring(dotIndex + 1, ctrlIndex = controlClass.lastIndexOf("Control"));
                            if (widgetName.equals("GraphicsMode")) {
                                widgetName = "GMC";
                            }
                            String widgetClass = "visad.browser." + widgetName + "Widget";
                            widgetHash = widgetName + index;
                            widget = (Widget)VisADApplet.this.hashtable.get(widgetHash);
                            if (widget == null) {
                                try {
                                    widget = (Widget)Class.forName(widgetClass).newInstance();
                                    widget.addWidgetListener(applet);
                                }
                                catch (ClassNotFoundException exc) {
                                }
                                catch (InstantiationException exc) {
                                }
                                catch (IllegalAccessException exc) {
                                    // empty catch block
                                }
                                if (widget != null) {
                                    VisADApplet.this.addWidget(widget, widgetHash);
                                }
                            }
                            if (widget == null) continue;
                            widget.setSaveString(save);
                            continue;
                        }
                        int h2 = in.readInt();
                        int len = in.readInt();
                        byte[] pixels = new byte[len];
                        for (int p = 0; p < len; p += in.read(pixels, p, len - p)) {
                        }
                        int[] pix = Convert.bytesToInt(pixels);
                        int[] decoded = Convert.decodeRLE(pix);
                        if (VisADApplet.this.image != null) {
                            VisADApplet.this.image.flush();
                        }
                        VisADApplet.this.image = VisADApplet.this.createImage(new MemoryImageSource(w, h2, decoded, 0, w));
                        MediaTracker tracker = new MediaTracker(VisADApplet.this.myself);
                        tracker.addImage(VisADApplet.this.image, 0);
                        try {
                            tracker.waitForAll();
                        }
                        catch (Exception tex) {
                            // empty catch block
                        }
                        VisADApplet.this.canvas.paint(VisADApplet.this.canvas.getGraphics());
                    }
                }
                catch (SocketException exc) {
                    applet.disconnect();
                }
                catch (IOException exc) {
                    applet.disconnect();
                }
            }
        });
        this.commThread.start();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.sendEvent(e);
    }

    public void mouseExited(MouseEvent e) {
        this.sendEvent(e);
    }

    public void mousePressed(MouseEvent e) {
        this.sendEvent(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.sendEvent(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.sendEvent(e);
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void widgetChanged(WidgetEvent e) {
        Widget w;
        int wdgtIndex;
        int dotIndex;
        Widget widget = e.getWidget();
        String widgetClass = widget.getClass().getName();
        String widgetName = widgetClass.substring((dotIndex = widgetClass.lastIndexOf(".")) + 1, wdgtIndex = widgetClass.lastIndexOf("Widget"));
        String controlName = widgetName;
        if (controlName.equals("GMC")) {
            controlName = "GraphicsMode";
        }
        String controlClass = "visad." + controlName + "Control";
        String save = widget.getSaveString();
        int i = 0;
        int index = -1;
        do {
            if ((w = (Widget)this.hashtable.get(widgetName + i)) == widget) {
                index = i;
                break;
            }
            ++i;
        } while (w != null);
        String message = controlClass + "\n" + index + "\n" + save;
        this.sendMessage(message);
    }
}

