/*
 * Decompiled with CFR 0.152.
 */
package visad.data.fits;

import visad.FlatField;
import visad.GriddedSet;
import visad.Set;
import visad.VisADException;
import visad.data.fits.ConvertArray;

public class ConvertDoubleArray
extends ConvertArray {
    private double[][] values;

    public ConvertDoubleArray(FlatField fld) throws VisADException {
        Set set = fld.getDomainSet();
        if (!(set instanceof GriddedSet)) {
            throw new VisADException("Cannot convert non-GriddedSet FlatField");
        }
        this.lengths = ((GriddedSet)set).getLengths();
        this.values = fld.getValues();
    }

    public ConvertDoubleArray(int[] lengths, double[][] values) throws VisADException {
        this.lengths = lengths;
        this.values = values;
    }

    int analyzeArray() {
        double max = this.values[0][0];
        double min2 = this.values[0][0];
        boolean integral = true;
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < this.values[i].length; ++j) {
                double v = this.values[i][j];
                if (v > max) {
                    max = v;
                }
                if (v < min2) {
                    min2 = v;
                }
                if (v >= -9.223372036854776E18 && v <= 9.223372036854776E18) {
                    if (!(v % 1.0 > 0.0)) continue;
                    integral = false;
                    continue;
                }
                integral = false;
            }
        }
        return this.getArrayType(min2, max, integral);
    }
}

