/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicArrowButton;

public class StepWidget
extends JPanel
implements ActionListener,
ChangeListener {
    protected static final boolean DEBUG = true;
    private static final int BUTTON_WIDTH = 25;
    private static final int BUTTON_HEIGHT = 25;
    private static final int GAP = 5;
    private static final Dimension buttonSize = new Dimension(25, 25);
    protected JSlider step;
    private boolean horiz;
    protected JButton forward;
    protected JButton back;
    protected int min = 1;
    protected int max = 1;
    protected int cur = 1;

    public StepWidget(boolean horizontal) {
        Component glue4;
        Component glue3;
        Component glue2;
        Component glue1;
        Dimension gap;
        int forwardDir;
        int stepDir;
        int backDir;
        int subLayout;
        int mainLayout;
        this.horiz = horizontal;
        if (horizontal) {
            mainLayout = 0;
            subLayout = 1;
            backDir = 7;
            stepDir = 0;
            forwardDir = 3;
            gap = new Dimension(5, 0);
            glue1 = Box.createVerticalGlue();
            glue2 = Box.createVerticalGlue();
            glue3 = Box.createVerticalGlue();
            glue4 = Box.createVerticalGlue();
        } else {
            mainLayout = 1;
            subLayout = 0;
            backDir = 1;
            stepDir = 1;
            forwardDir = 5;
            gap = new Dimension(0, 5);
            glue1 = Box.createHorizontalGlue();
            glue2 = Box.createHorizontalGlue();
            glue3 = Box.createHorizontalGlue();
            glue4 = Box.createHorizontalGlue();
        }
        JPanel before = new JPanel();
        JPanel after = new JPanel();
        this.setLayout(new BoxLayout(this, mainLayout));
        before.setLayout(new BoxLayout(before, subLayout));
        after.setLayout(new BoxLayout(after, subLayout));
        this.back = new BasicArrowButton(backDir){

            public Dimension getPreferredSize() {
                return buttonSize;
            }

            public Dimension getMaximumSize() {
                return buttonSize;
            }
        };
        this.step = new JSlider(stepDir, this.min, this.max, this.cur);
        this.forward = new BasicArrowButton(forwardDir){

            public Dimension getPreferredSize() {
                return buttonSize;
            }

            public Dimension getMaximumSize() {
                return buttonSize;
            }
        };
        this.step.setPaintTicks(true);
        this.step.setAlignmentX(0.0f);
        this.add(before);
        this.add(Box.createRigidArea(gap));
        this.add(this.step);
        this.add(Box.createRigidArea(gap));
        this.add(after);
        before.add(glue1);
        before.add(this.back);
        before.add(glue2);
        after.add(glue3);
        after.add(this.forward);
        after.add(glue4);
        this.back.addActionListener(this);
        this.forward.addActionListener(this);
        this.step.addChangeListener(this);
        this.setEnabled(false);
    }

    public Dimension getMinimumSize() {
        Dimension min2 = this.getPreferredSize();
        return this.horiz ? new Dimension(0, min2.height + 20) : new Dimension(min2.width, 0);
    }

    public Dimension getMaximumSize() {
        Dimension max = this.getPreferredSize();
        return this.horiz ? new Dimension(Integer.MAX_VALUE, max.height + 20) : new Dimension(max.width, Integer.MAX_VALUE);
    }

    public int getValue() {
        return this.step.getValue();
    }

    public int getMinimum() {
        return this.step.getMinimum();
    }

    public int getMaximum() {
        return this.step.getMaximum();
    }

    public void setValue(int cur) {
        this.cur = cur;
        this.step.setValue(cur);
    }

    public void setEnabled(boolean enabled) {
        this.step.setEnabled(enabled);
        this.back.setEnabled(enabled);
        this.forward.setEnabled(enabled);
    }

    public void setBounds(int min2, int max, int cur) {
        this.min = min2;
        this.max = max;
        this.cur = cur;
        this.step.setMinimum(min2);
        this.step.setMaximum(max);
        this.step.setValue(cur);
        int maj = max < 4 ? 1 : (max < 20 ? max / 4 : (max < 30 ? max / 6 : max / 8));
        this.step.setMajorTickSpacing(maj);
        this.step.setMinorTickSpacing(maj / 4);
        this.step.setPaintLabels(true);
    }

    public void addChangeListener(ChangeListener l) {
        this.step.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.step.removeChangeListener(l);
    }

    public void actionPerformed(ActionEvent e) {
        boolean direction;
        boolean bl = direction = e.getSource() == this.back;
        if (this.horiz == direction) {
            --this.cur;
            if (this.cur < this.min) {
                this.cur = this.max;
            }
        } else {
            ++this.cur;
            if (this.cur > this.max) {
                this.cur = this.min;
            }
        }
        this.step.setValue(this.cur);
        this.updateStep();
    }

    public void stateChanged(ChangeEvent e) {
        this.cur = this.step.getValue();
        this.updateStep();
    }

    protected void updateStep() {
    }
}

