/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.util.ListIterator;
import java.util.Vector;
import visad.ActionImpl;

public class ThreadPool {
    private static final String DEFAULT_PREFIX = "Minnow";
    private static final int DEFAULT_MIN_THREADS = 5;
    private static final int DEFAULT_MAX_THREADS = 10;
    private int maxQueuedTasks = 3;
    private int minThreads;
    private int maxThreads;
    private Object threadLock = new Object();
    private boolean terminateThread = false;
    private Vector threads = new Vector();
    private Vector tasks = new Vector();
    private Vector busy_tasks = new Vector();
    private String prefix;
    private int nextID = 0;

    public ThreadPool() throws Exception {
        this(DEFAULT_PREFIX, 5, 10);
    }

    public ThreadPool(String prefix) throws Exception {
        this(prefix, 5, 10);
    }

    public ThreadPool(int max) throws Exception {
        this(5, max);
    }

    public ThreadPool(int min2, int max) throws Exception {
        this(DEFAULT_PREFIX, min2, max);
    }

    public ThreadPool(String prefix, int min2, int max) throws Exception {
        this.minThreads = min2;
        this.maxThreads = max;
        if (this.minThreads > this.maxThreads) {
            throw new Exception("Maximum number of threads (" + this.maxThreads + ") is less than minimum number of threads (" + this.minThreads + ")");
        }
        this.prefix = prefix;
        for (int i = 0; i < this.minThreads; ++i) {
            ThreadMinnow minnow = new ThreadMinnow(this);
            minnow.setName(prefix + "-" + this.nextID++);
            this.threads.addElement(minnow);
        }
    }

    public int getTaskCount() {
        int count = 0;
        if (this.tasks != null) {
            count += this.tasks.size();
        }
        if (this.busy_tasks != null) {
            count += this.busy_tasks.size();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Runnable r) {
        Vector vector = this.tasks;
        synchronized (vector) {
            this.tasks.removeElement(r);
            this.busy_tasks.removeElement(r);
        }
    }

    public boolean isTerminated() {
        return this.terminateThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printPool() {
        Vector vector = this.tasks;
        synchronized (vector) {
            ActionImpl a;
            int i;
            int n = this.tasks.size();
            System.err.println("Tasks:");
            for (i = 0; i < n; ++i) {
                a = (ActionImpl)this.tasks.elementAt(i);
                System.out.println("\t" + i + " = " + a.getName());
            }
            System.err.println("Busy Tasks:");
            for (i = 0; i < this.busy_tasks.size(); ++i) {
                a = (ActionImpl)this.busy_tasks.elementAt(i);
                System.out.println("\t" + i + " = " + a.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(Runnable r) {
        if (this.terminateThread) {
            throw new Error("Task queued after threads stopped");
        }
        int numTasks = 0;
        Object object = this.tasks;
        synchronized (object) {
            if (!this.tasks.contains(r)) {
                this.tasks.addElement(r);
                numTasks = this.tasks.size();
            }
        }
        object = this.threadLock;
        synchronized (object) {
            if (numTasks > this.maxQueuedTasks) {
                if (this.threads != null && this.threads.size() < this.maxThreads) {
                    try {
                        ThreadMinnow t = new ThreadMinnow(this);
                        t.setName(this.prefix + "-" + this.nextID++);
                        this.threads.addElement(t);
                        this.threadLock.notify();
                    }
                    catch (SecurityException e) {}
                } else {
                    this.threadLock.notifyAll();
                }
            } else {
                this.threadLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Runnable getTask() {
        Runnable thisTask = null;
        Vector vector = this.tasks;
        synchronized (vector) {
            int n = this.tasks.size();
            for (int i = 0; i < n; ++i) {
                thisTask = (Runnable)this.tasks.elementAt(i);
                if (!this.busy_tasks.contains(thisTask)) {
                    this.tasks.removeElementAt(i);
                    this.busy_tasks.addElement(thisTask);
                    break;
                }
                thisTask = null;
            }
        }
        return thisTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseTask(Runnable r) {
        Vector vector = this.tasks;
        synchronized (vector) {
            this.busy_tasks.removeElement(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForTasks() {
        int timeout = this.tasks.size();
        if (Thread.currentThread() instanceof ThreadMinnow && this.threads.contains(Thread.currentThread())) {
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }
        do {
            try {
                Vector vector = this.tasks;
                synchronized (vector) {
                    if (this.tasks.size() == 0) {
                        break;
                    }
                    this.tasks.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (timeout-- != 0);
        return timeout > 0;
    }

    public void setThreadMaximum(int num) throws Exception {
        if (num < this.maxThreads) {
            throw new Exception("Cannot decrease maximum number of threads");
        }
        this.maxThreads = num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThreads() {
        ListIterator i;
        Vector oldthreads;
        if (this.terminateThread) {
            return;
        }
        this.terminateThread = true;
        Object object = this.threadLock;
        synchronized (object) {
            this.threadLock.notifyAll();
        }
        Vector vector = this.threads;
        synchronized (vector) {
            oldthreads = this.threads;
            this.threads = null;
            i = oldthreads.listIterator();
        }
        while (i.hasNext()) {
            Object object2;
            ThreadMinnow t = (ThreadMinnow)i.next();
            if (t.waitingOnThreadLock) {
                object2 = this.threadLock;
                synchronized (object2) {
                    this.threadLock.notifyAll();
                    continue;
                }
            }
            if (!t.active) continue;
            while (true) {
                object2 = oldthreads;
                synchronized (object2) {
                    oldthreads.notifyAll();
                }
                try {
                    t.join();
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
            i.remove();
        }
    }

    private class ThreadMinnow
    extends Thread {
        boolean waitingOnThreadLock = false;
        boolean active = false;
        private ThreadPool parent = null;

        public ThreadMinnow(ThreadPool p) {
            this.parent = p;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.active = true;
            while (true) {
                Object t2;
                Runnable r;
                if ((r = this.parent.getTask()) != null) {
                    try {
                        r.run();
                    }
                    catch (Throwable t2) {
                        t2.printStackTrace();
                    }
                    this.parent.releaseTask(r);
                    t2 = ThreadPool.this.threadLock;
                    synchronized (t2) {
                        ThreadPool.this.threadLock.notify();
                    }
                    t2 = ThreadPool.this.tasks;
                    synchronized (t2) {
                        ThreadPool.this.tasks.notifyAll();
                    }
                }
                if (ThreadPool.this.terminateThread) {
                    this.active = false;
                    return;
                }
                try {
                    t2 = ThreadPool.this.threadLock;
                    synchronized (t2) {
                        if (ThreadPool.this.terminateThread) {
                            this.active = false;
                            return;
                        }
                        this.waitingOnThreadLock = true;
                        if (ThreadPool.this.terminateThread) {
                            this.active = false;
                            return;
                        }
                        ThreadPool.this.threadLock.wait();
                        if (ThreadPool.this.terminateThread) {
                            this.active = false;
                            return;
                        }
                        this.waitingOnThreadLock = false;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (ThreadPool.this.terminateThread) break;
            }
            this.active = false;
        }
    }
}

