/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Arrays;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataStore;
import loci.formats.ReaderWrapper;

public class MinMaxCalculator
extends ReaderWrapper {
    protected double[][] chanMin;
    protected double[][] chanMax;
    protected double[][] planeMin;
    protected double[][] planeMax;
    protected int[] minMaxDone;

    public MinMaxCalculator() {
    }

    public MinMaxCalculator(IFormatReader r) {
        super(r);
    }

    public Double getChannelGlobalMinimum(int theC) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        if (theC < 0 || theC >= this.getSizeC()) {
            throw new FormatException("Invalid channel index: " + theC);
        }
        int series = this.getSeries();
        if (this.minMaxDone == null || this.minMaxDone[series] < this.getImageCount()) {
            return null;
        }
        return new Double(this.chanMin[series][theC]);
    }

    public Double getChannelGlobalMaximum(int theC) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        if (theC < 0 || theC >= this.getSizeC()) {
            throw new FormatException("Invalid channel index: " + theC);
        }
        int series = this.getSeries();
        if (this.minMaxDone == null || this.minMaxDone[series] < this.getImageCount()) {
            return null;
        }
        return new Double(this.chanMax[series][theC]);
    }

    public Double getChannelKnownMinimum(int theC) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.chanMin == null ? null : new Double(this.chanMin[this.getSeries()][theC]);
    }

    public Double getChannelKnownMaximum(int theC) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.chanMax == null ? null : new Double(this.chanMax[this.getSeries()][theC]);
    }

    public Double[] getPlaneMinimum(int no) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        if (this.planeMin == null) {
            return null;
        }
        int numRGB = this.getRGBChannelCount();
        int pBase = no * numRGB;
        int series = this.getSeries();
        if (this.planeMin[series][pBase] != this.planeMin[series][pBase]) {
            return null;
        }
        Double[] min2 = new Double[numRGB];
        for (int c = 0; c < numRGB; ++c) {
            min2[c] = new Double(this.planeMin[series][pBase + c]);
        }
        return min2;
    }

    public Double[] getPlaneMaximum(int no) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        if (this.planeMax == null) {
            return null;
        }
        int numRGB = this.getRGBChannelCount();
        int pBase = no * numRGB;
        int series = this.getSeries();
        if (this.planeMax[series][pBase] != this.planeMax[series][pBase]) {
            return null;
        }
        Double[] max = new Double[numRGB];
        for (int c = 0; c < numRGB; ++c) {
            max[c] = new Double(this.planeMax[series][pBase + c]);
        }
        return max;
    }

    public boolean isMinMaxPopulated() throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.minMaxDone != null && this.minMaxDone[this.getSeries()] == this.getImageCount();
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        BufferedImage b = super.openImage(no);
        this.updateMinMax(b, no);
        return b;
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        byte[] b = super.openBytes(no);
        this.updateMinMax(b, no);
        return b;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        super.openBytes(no, buf);
        this.updateMinMax(buf, no);
        return buf;
    }

    public void close() throws IOException {
        this.reader.close();
        this.chanMin = null;
        this.chanMax = null;
        this.planeMin = null;
        this.planeMax = null;
        this.minMaxDone = null;
    }

    protected void updateMinMax(BufferedImage b, int ndx) throws FormatException, IOException {
        if (b == null) {
            return;
        }
        this.initMinMax();
        int numRGB = this.getRGBChannelCount();
        int series = this.getSeries();
        if (this.planeMin[series][ndx * numRGB] == this.planeMin[series][ndx * numRGB]) {
            return;
        }
        int[] coords = this.getZCTCoords(ndx);
        int cBase = coords[1] * numRGB;
        int pBase = ndx * numRGB;
        for (int c = 0; c < numRGB; ++c) {
            this.planeMin[series][pBase + c] = Double.POSITIVE_INFINITY;
            this.planeMax[series][pBase + c] = Double.NEGATIVE_INFINITY;
        }
        WritableRaster pixels = b.getRaster();
        for (int x = 0; x < b.getWidth(); ++x) {
            for (int y = 0; y < b.getHeight(); ++y) {
                for (int c = 0; c < numRGB; ++c) {
                    double v = pixels.getSampleDouble(x, y, c);
                    if (v > this.chanMax[series][cBase + c]) {
                        this.chanMax[series][cBase + c] = v;
                    }
                    if (v < this.chanMin[series][cBase + c]) {
                        this.chanMin[series][cBase + c] = v;
                    }
                    if (v > this.planeMax[series][pBase + c]) {
                        this.planeMax[series][pBase + c] = v;
                    }
                    if (!(v < this.planeMin[series][pBase + c])) continue;
                    this.planeMin[series][pBase + c] = v;
                }
            }
        }
        int n = series;
        this.minMaxDone[n] = this.minMaxDone[n] + 1;
        if (this.minMaxDone[series] == this.getImageCount()) {
            MetadataStore store = this.getMetadataStore();
            for (int c = 0; c < this.getSizeC(); ++c) {
                store.setChannelGlobalMinMax(c, new Double(this.chanMin[series][c]), new Double(this.chanMax[series][c]), new Integer(this.getSeries()));
            }
        }
    }

    protected void updateMinMax(byte[] b, int ndx) throws FormatException, IOException {
        int c;
        if (b == null) {
            return;
        }
        this.initMinMax();
        int numRGB = this.getRGBChannelCount();
        int series = this.getSeries();
        if (this.planeMin[series][ndx * numRGB] == this.planeMin[series][ndx * numRGB]) {
            return;
        }
        boolean little = this.isLittleEndian();
        int bytes = FormatTools.getBytesPerPixel(this.getPixelType());
        int pixels = this.getSizeX() * this.getSizeY();
        boolean interleaved = this.isInterleaved();
        int[] coords = this.getZCTCoords(ndx);
        int cBase = coords[1] * numRGB;
        int pBase = ndx * numRGB;
        for (int c2 = 0; c2 < numRGB; ++c2) {
            this.planeMin[series][pBase + c2] = Double.POSITIVE_INFINITY;
            this.planeMax[series][pBase + c2] = Double.NEGATIVE_INFINITY;
        }
        boolean fp = this.getPixelType() == 6 || this.getPixelType() == 7;
        for (int i = 0; i < pixels; ++i) {
            for (c = 0; c < numRGB; ++c) {
                double v;
                int idx = bytes * (interleaved ? i * numRGB + c : c * pixels + i);
                long bits = DataTools.bytesToLong(b, idx, bytes, little);
                double d = v = fp ? Double.longBitsToDouble(bits) : (double)bits;
                if (v > this.chanMax[series][cBase + c]) {
                    this.chanMax[series][cBase + c] = v;
                }
                if (v < this.chanMin[series][cBase + c]) {
                    this.chanMin[series][cBase + c] = v;
                }
                if (v > this.planeMax[series][ndx]) {
                    this.planeMax[series][ndx] = v;
                }
                if (!(v < this.planeMin[series][pBase + c])) continue;
                this.planeMin[series][pBase + c] = v;
            }
        }
        int n = series;
        this.minMaxDone[n] = this.minMaxDone[n] + 1;
        if (this.minMaxDone[this.getSeries()] == this.getImageCount()) {
            MetadataStore store = this.getMetadataStore();
            for (c = 0; c < this.getSizeC(); ++c) {
                store.setChannelGlobalMinMax(c, new Double(this.chanMin[this.getSeries()][c]), new Double(this.chanMax[this.getSeries()][c]), new Integer(this.getSeries()));
            }
        }
    }

    protected void initMinMax() throws FormatException, IOException {
        int numRGB;
        int i;
        int seriesCount = this.getSeriesCount();
        int oldSeries = this.getSeries();
        if (this.chanMin == null) {
            this.chanMin = new double[seriesCount][];
            for (i = 0; i < seriesCount; ++i) {
                this.setSeries(i);
                this.chanMin[i] = new double[this.getSizeC()];
                Arrays.fill(this.chanMin[i], Double.POSITIVE_INFINITY);
            }
            this.setSeries(oldSeries);
        }
        if (this.chanMax == null) {
            this.chanMax = new double[seriesCount][];
            for (i = 0; i < seriesCount; ++i) {
                this.setSeries(i);
                this.chanMax[i] = new double[this.getSizeC()];
                Arrays.fill(this.chanMax[i], Double.NEGATIVE_INFINITY);
            }
            this.setSeries(oldSeries);
        }
        if (this.planeMin == null) {
            this.planeMin = new double[seriesCount][];
            for (i = 0; i < seriesCount; ++i) {
                this.setSeries(i);
                numRGB = this.getRGBChannelCount();
                this.planeMin[i] = new double[this.getImageCount() * numRGB];
                Arrays.fill(this.planeMin[i], Double.NaN);
            }
            this.setSeries(oldSeries);
        }
        if (this.planeMax == null) {
            this.planeMax = new double[seriesCount][];
            for (i = 0; i < seriesCount; ++i) {
                this.setSeries(i);
                numRGB = this.getRGBChannelCount();
                this.planeMax[i] = new double[this.getImageCount() * numRGB];
                Arrays.fill(this.planeMax[i], Double.NaN);
            }
            this.setSeries(oldSeries);
        }
        if (this.minMaxDone == null) {
            this.minMaxDone = new int[seriesCount];
        }
    }

    public BufferedImage openImage(String id, int no) throws FormatException, IOException {
        this.setId(id);
        BufferedImage b = super.openImage(no);
        this.updateMinMax(b, no);
        return b;
    }

    public byte[] openBytes(String id, int no) throws FormatException, IOException {
        this.setId(id);
        byte[] b = super.openBytes(no);
        this.updateMinMax(b, no);
        return b;
    }

    public byte[] openBytes(String id, int no, byte[] buf) throws FormatException, IOException {
        this.setId(id);
        super.openBytes(no, buf);
        this.updateMinMax(buf, no);
        return buf;
    }
}

