/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.StringTokenizer;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;

public class PGMReader
extends FormatReader {
    private boolean rawBits;
    private long offset;

    public PGMReader() {
        super("Portable Gray Map", "pgm");
    }

    public boolean isThisType(byte[] block) {
        return block[0] == 80;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length);
        this.in.seek(this.offset);
        if (this.rawBits) {
            this.in.read(buf);
        } else {
            int pt = 0;
            while (pt < buf.length) {
                String line = this.in.readLine().trim();
                line = line.replaceAll("[^0-9]", " ");
                StringTokenizer t = new StringTokenizer(line, " ");
                while (t.hasMoreTokens()) {
                    int q = Integer.parseInt(t.nextToken().trim());
                    if (this.core.pixelType[0] == 3) {
                        short s2 = (short)q;
                        buf[pt] = (byte)((s2 & 0xFF00) >> 8);
                        buf[pt + 1] = (byte)(s2 & 0xFF);
                        pt += 2;
                        continue;
                    }
                    buf[pt] = (byte)q;
                    ++pt;
                }
            }
        }
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        String magic = this.in.readLine().trim();
        boolean isBlackAndWhite = false;
        this.rawBits = magic.equals("P4") || magic.equals("P5") || magic.equals("P6");
        this.core.sizeC[0] = magic.equals("P3") || magic.equals("P6") ? 3 : 1;
        isBlackAndWhite = magic.equals("P1") || magic.equals("P4");
        String line = this.in.readLine().trim();
        while (line.startsWith("#") || line.length() == 0) {
            line = this.in.readLine();
        }
        line = line.replaceAll("[^0-9]", " ");
        this.core.sizeX[0] = Integer.parseInt(line.substring(0, line.indexOf(" ")).trim());
        this.core.sizeY[0] = Integer.parseInt(line.substring(line.indexOf(" ") + 1).trim());
        if (!isBlackAndWhite) {
            int max = Integer.parseInt(this.in.readLine().trim());
            this.core.pixelType[0] = max > 255 ? 3 : 1;
        }
        this.offset = this.in.getFilePointer();
        this.core.rgb[0] = this.core.sizeC[0] == 3;
        this.core.currentOrder[0] = "XYCZT";
        this.core.littleEndian[0] = true;
        this.core.interleaved[0] = false;
        this.core.sizeZ[0] = 1;
        this.core.sizeT[0] = 1;
        this.core.imageCount[0] = 1;
        this.core.indexed[0] = false;
        this.core.falseColor[0] = false;
        this.core.metadataComplete[0] = true;
        MetadataStore store = this.getMetadataStore();
        store.setImage(this.currentId, null, null, null);
        FormatTools.populatePixels(store, this);
        for (int i = 0; i < this.core.sizeC[0]; ++i) {
            store.setLogicalChannel(i, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }
    }
}

