/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.lang.reflect.Array;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.util.ArrayFuncs;

public class RandomGroupsData
extends Data {
    public RandomGroupsData(Header h2) throws FitsException {
        int gcount = h2.getIntValue("GCOUNT", -1);
        int pcount = h2.getIntValue("PCOUNT", -1);
        if (!h2.getBooleanValue("GROUPS") || h2.getIntValue("NAXIS1", -1) != 0 || gcount < 0 || pcount < 0 || h2.getIntValue("NAXIS") < 2) {
            throw new FitsException("Invalid Random Groups Parameters");
        }
        this.dataArray = gcount > 0 ? new Object[gcount][2] : new Object[0][];
        Object[] sampleRow = RandomGroupsData.generateSampleRow(h2);
        for (int i = 0; i < gcount; ++i) {
            ((Object[])this.dataArray)[i] = ArrayFuncs.deepClone(sampleRow);
        }
    }

    public static Object[] generateSampleRow(Header h2) throws FitsException {
        Class<Number> baseClass;
        int ndim = h2.getIntValue("NAXIS", 0) - 1;
        int[] dims = new int[ndim];
        int bitpix = h2.getIntValue("BITPIX", 0);
        if (bitpix == 8) {
            baseClass = Byte.TYPE;
        } else if (bitpix == 16) {
            baseClass = Short.TYPE;
        } else if (bitpix == 32) {
            baseClass = Integer.TYPE;
        } else if (bitpix == 64) {
            baseClass = Long.TYPE;
        } else if (bitpix == -32) {
            baseClass = Float.TYPE;
        } else if (bitpix == -64) {
            baseClass = Double.TYPE;
        } else {
            throw new FitsException("Invalid BITPIX:" + bitpix);
        }
        for (int i = 0; i < ndim; ++i) {
            long cdim = h2.getIntValue("NAXIS" + (i + 2), 0);
            if (cdim < 0L) {
                throw new FitsException("Invalid array dimension:" + cdim);
            }
            dims[ndim - i - 1] = (int)cdim;
        }
        Object[] sample = new Object[]{Array.newInstance(baseClass, h2.getIntValue("PCOUNT")), Array.newInstance(baseClass, dims)};
        return sample;
    }

    public RandomGroupsData() {
        this.dataArray = new Object[0][];
    }

    public RandomGroupsData(Object[][] x) {
        this.dataArray = x;
    }

    public int getPadding() {
        Object par = ((Object[][])this.dataArray)[0][0];
        Object dat = ((Object[][])this.dataArray)[0][1];
        int nbyte = ArrayFuncs.getBaseLength(par);
        int npar = Array.getLength(par);
        int[] ndims = ArrayFuncs.getDimensions(dat);
        int ngrp = ((Object[][])this.dataArray).length;
        int total = 1;
        for (int i = 0; i < ndims.length; ++i) {
            total *= ndims[i];
        }
        total += npar;
        if ((total = nbyte * ngrp * total) % 2880 == 0) {
            return 0;
        }
        return 2880 - total % 2880;
    }
}

