/*
 * Decompiled with CFR 0.152.
 */
package org.bounce;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import javax.swing.JViewport;

public class ResizingFlowLayout
extends FlowLayout {
    private static final long serialVersionUID = -7458075051466274410L;

    public ResizingFlowLayout() {
    }

    public ResizingFlowLayout(int arg0, int arg1, int arg2) {
        super(arg0, arg1, arg2);
    }

    public ResizingFlowLayout(int arg0) {
        super(arg0);
    }

    public Dimension preferredLayoutSize(Container target) {
        Insets insets = target.getInsets();
        int hgap = this.getHgap();
        int vgap = this.getVgap();
        Dimension targetSize = null;
        targetSize = target.getParent() instanceof JViewport ? target.getParent().getSize() : target.getSize();
        int maxwidth = targetSize.width - (insets.left + insets.right + hgap * 2);
        int nmembers = target.getComponentCount();
        int xPos = 0;
        int maxHeight = 0;
        Dimension dim = new Dimension(0, 0);
        for (int i = 0; i < nmembers; ++i) {
            Component m3 = target.getComponent(i);
            if (!m3.isVisible()) continue;
            Dimension d = m3.getPreferredSize();
            if (xPos + d.width > maxwidth && xPos != 0) {
                xPos = 0;
                dim.height += maxHeight + vgap;
                maxHeight = 0;
            }
            dim.width = Math.max(dim.width, xPos += d.width);
            xPos += hgap;
            maxHeight = Math.max(maxHeight, d.height);
        }
        dim.height += maxHeight + vgap;
        dim.width += insets.left + insets.right;
        dim.height += insets.top + insets.bottom + vgap;
        return dim;
    }
}

