/*
 * Decompiled with CFR 0.152.
 */
package org.bounce;

import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class ThreeStateCheckBox
extends JCheckBox {
    private static final long serialVersionUID = -6262164294612004192L;
    public static final String NOT_SELECTED = "NOT_SELECTED";
    public static final String SELECTED = "SELECTED";
    public static final String DONT_CARE = "DONT_CARE";
    private String state = "DONT_CARE";

    public ThreeStateCheckBox(String aString) {
        this(aString, DONT_CARE);
    }

    public ThreeStateCheckBox(String aString, String state) {
        super(aString, new ThreeStateCheckBoxIcon());
        this.setSelected(state);
    }

    public String getSelected() {
        return this.state;
    }

    public void setSelected(boolean selected) {
        this.state = selected ? SELECTED : NOT_SELECTED;
        super.setSelected(selected);
    }

    public void setSelected(String state) {
        this.state = state;
        super.setSelected(state == SELECTED);
        this.repaint();
    }

    private static class ThreeStateCheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = -1699947264495219246L;

        private ThreeStateCheckBoxIcon() {
        }

        protected int getControlSize() {
            return 13;
        }

        public void paintIcon(Component c, Graphics g2, int x, int y) {
            ThreeStateCheckBox cb = (ThreeStateCheckBox)c;
            int controlSize = this.getControlSize();
            if (cb.isEnabled()) {
                if (cb.getModel().isPressed() && cb.getModel().isArmed()) {
                    g2.setColor(MetalLookAndFeel.getControlShadow());
                    g2.fillRect(x, y, controlSize - 1, controlSize - 1);
                    this.drawPressed3DBorder(g2, x, y, controlSize, controlSize);
                } else {
                    this.drawFlush3DBorder(g2, x, y, controlSize, controlSize);
                }
                g2.setColor(MetalLookAndFeel.getControlInfo());
            } else {
                g2.setColor(MetalLookAndFeel.getControlShadow());
                g2.drawRect(x, y, controlSize - 1, controlSize - 1);
            }
            if (cb.getSelected() == ThreeStateCheckBox.DONT_CARE) {
                this.drawRect(c, g2, x, y);
            }
            if (cb.getSelected() == ThreeStateCheckBox.SELECTED) {
                if (cb.isBorderPaintedFlat()) {
                    ++x;
                }
                this.drawCheck(c, g2, x, y);
            }
        }

        protected void drawRect(Component c, Graphics g2, int x, int y) {
            int controlSize = this.getControlSize();
            g2.fillRect(x + 3, y + 3, controlSize - 7, controlSize - 7);
        }

        protected void drawCheck(Component c, Graphics g2, int x, int y) {
            int controlSize = this.getControlSize();
            g2.fillRect(x + 3, y + 5, 2, controlSize - 8);
            g2.drawLine(x + (controlSize - 4), y + 3, x + 5, y + (controlSize - 6));
            g2.drawLine(x + (controlSize - 4), y + 4, x + 5, y + (controlSize - 5));
        }

        private void drawFlush3DBorder(Graphics g2, int x, int y, int w, int h2) {
            g2.translate(x, y);
            g2.setColor(MetalLookAndFeel.getControlDarkShadow());
            g2.drawRect(0, 0, w - 2, h2 - 2);
            g2.setColor(MetalLookAndFeel.getControlHighlight());
            g2.drawRect(1, 1, w - 2, h2 - 2);
            g2.setColor(MetalLookAndFeel.getControl());
            g2.drawLine(0, h2 - 1, 1, h2 - 2);
            g2.drawLine(w - 1, 0, w - 2, 1);
            g2.translate(-x, -y);
        }

        private void drawPressed3DBorder(Graphics g2, int x, int y, int w, int h2) {
            g2.translate(x, y);
            this.drawFlush3DBorder(g2, 0, 0, w, h2);
            g2.setColor(MetalLookAndFeel.getControlShadow());
            g2.drawLine(1, 1, 1, h2 - 2);
            g2.drawLine(1, 1, w - 2, 1);
            g2.translate(-x, -y);
        }

        public int getIconWidth() {
            return this.getControlSize();
        }

        public int getIconHeight() {
            return this.getControlSize();
        }
    }
}

