/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.gantt;

import java.util.Date;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.gantt.TaskSeriesCollection;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.IntervalXYDataset;

public class XYTaskDataset
extends AbstractXYDataset
implements IntervalXYDataset,
DatasetChangeListener {
    private TaskSeriesCollection underlying;
    private double seriesWidth;
    private boolean transposed;

    public XYTaskDataset(TaskSeriesCollection tasks) {
        ParamChecks.nullNotPermitted(tasks, "tasks");
        this.underlying = tasks;
        this.seriesWidth = 0.8;
        this.underlying.addChangeListener(this);
    }

    public TaskSeriesCollection getTasks() {
        return this.underlying;
    }

    public double getSeriesWidth() {
        return this.seriesWidth;
    }

    public void setSeriesWidth(double w) {
        if (w <= 0.0) {
            throw new IllegalArgumentException("Requires 'w' > 0.0.");
        }
        this.seriesWidth = w;
        this.fireDatasetChanged();
    }

    public boolean isTransposed() {
        return this.transposed;
    }

    public void setTransposed(boolean transposed) {
        this.transposed = transposed;
        this.fireDatasetChanged();
    }

    @Override
    public int getSeriesCount() {
        return this.underlying.getSeriesCount();
    }

    @Override
    public Comparable getSeriesKey(int series) {
        return this.underlying.getSeriesKey(series);
    }

    @Override
    public int getItemCount(int series) {
        return this.underlying.getSeries(series).getItemCount();
    }

    @Override
    public double getXValue(int series, int item) {
        if (!this.transposed) {
            return this.getSeriesValue(series);
        }
        return this.getItemValue(series, item);
    }

    @Override
    public double getStartXValue(int series, int item) {
        if (!this.transposed) {
            return this.getSeriesStartValue(series);
        }
        return this.getItemStartValue(series, item);
    }

    @Override
    public double getEndXValue(int series, int item) {
        if (!this.transposed) {
            return this.getSeriesEndValue(series);
        }
        return this.getItemEndValue(series, item);
    }

    @Override
    public Number getX(int series, int item) {
        return new Double(this.getXValue(series, item));
    }

    @Override
    public Number getStartX(int series, int item) {
        return new Double(this.getStartXValue(series, item));
    }

    @Override
    public Number getEndX(int series, int item) {
        return new Double(this.getEndXValue(series, item));
    }

    @Override
    public double getYValue(int series, int item) {
        if (!this.transposed) {
            return this.getItemValue(series, item);
        }
        return this.getSeriesValue(series);
    }

    @Override
    public double getStartYValue(int series, int item) {
        if (!this.transposed) {
            return this.getItemStartValue(series, item);
        }
        return this.getSeriesStartValue(series);
    }

    @Override
    public double getEndYValue(int series, int item) {
        if (!this.transposed) {
            return this.getItemEndValue(series, item);
        }
        return this.getSeriesEndValue(series);
    }

    @Override
    public Number getY(int series, int item) {
        return new Double(this.getYValue(series, item));
    }

    @Override
    public Number getStartY(int series, int item) {
        return new Double(this.getStartYValue(series, item));
    }

    @Override
    public Number getEndY(int series, int item) {
        return new Double(this.getEndYValue(series, item));
    }

    private double getSeriesValue(int series) {
        return series;
    }

    private double getSeriesStartValue(int series) {
        return (double)series - this.seriesWidth / 2.0;
    }

    private double getSeriesEndValue(int series) {
        return (double)series + this.seriesWidth / 2.0;
    }

    private double getItemValue(int series, int item) {
        TaskSeries s2 = this.underlying.getSeries(series);
        Task t = s2.get(item);
        TimePeriod duration = t.getDuration();
        Date start = duration.getStart();
        Date end = duration.getEnd();
        return (double)(start.getTime() + end.getTime()) / 2.0;
    }

    private double getItemStartValue(int series, int item) {
        TaskSeries s2 = this.underlying.getSeries(series);
        Task t = s2.get(item);
        TimePeriod duration = t.getDuration();
        Date start = duration.getStart();
        return start.getTime();
    }

    private double getItemEndValue(int series, int item) {
        TaskSeries s2 = this.underlying.getSeries(series);
        Task t = s2.get(item);
        TimePeriod duration = t.getDuration();
        Date end = duration.getEnd();
        return end.getTime();
    }

    @Override
    public void datasetChanged(DatasetChangeEvent event) {
        this.fireDatasetChanged();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XYTaskDataset)) {
            return false;
        }
        XYTaskDataset that = (XYTaskDataset)obj;
        if (this.seriesWidth != that.seriesWidth) {
            return false;
        }
        if (this.transposed != that.transposed) {
            return false;
        }
        return this.underlying.equals(that.underlying);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        XYTaskDataset clone = (XYTaskDataset)super.clone();
        clone.underlying = (TaskSeriesCollection)this.underlying.clone();
        return clone;
    }
}

