/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui.monitor;

import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import ucar.nc2.ui.widget.StopButtonCancelTask;
import ucar.ui.prefs.ComboBox;
import ucar.util.prefs.PersistenceManager;

public class ManageForm
extends JPanel {
    private JLabel label1;
    private JRadioButton wantAccess;
    private JRadioButton wantServlet;
    private JButton acceptButton;
    private JLabel label2;
    private JScrollPane scrollPane1;
    private JTextArea textArea1;
    private JRadioButton wantRoots;
    private StopButtonCancelTask stopButton;
    private ComboBox<String> serverCB;
    private JToggleButton useHttps;
    private DownloadAction downloadAction;

    public ManageForm(PersistenceManager prefs) {
        this.initComponents();
        this.serverCB.setPreferences(prefs);
    }

    public JTextArea getTextArea() {
        return this.textArea1;
    }

    public StopButtonCancelTask getStopButton() {
        return this.stopButton;
    }

    public ComboBox<String> getServersCB() {
        return this.serverCB;
    }

    public ManageForm() {
        this.initComponents();
    }

    private void initComponents() {
        this.label1 = new JLabel();
        this.wantAccess = new JRadioButton();
        this.wantServlet = new JRadioButton();
        this.acceptButton = new JButton();
        this.label2 = new JLabel();
        this.scrollPane1 = new JScrollPane();
        this.textArea1 = new JTextArea();
        this.wantRoots = new JRadioButton();
        this.stopButton = new StopButtonCancelTask();
        this.serverCB = new ComboBox();
        this.useHttps = new JToggleButton();
        this.downloadAction = new DownloadAction();
        this.label1.setText("server:");
        this.label1.setFont(this.label1.getFont().deriveFont(3));
        this.wantAccess.setText("access logs");
        this.wantAccess.setFont(this.wantAccess.getFont().deriveFont(this.wantAccess.getFont().getStyle() | 1));
        this.wantServlet.setText("servlet logs");
        this.wantServlet.setFont(this.wantServlet.getFont().deriveFont(this.wantServlet.getFont().getStyle() | 1));
        this.acceptButton.setAction(this.downloadAction);
        this.label2.setText("Download log files:");
        this.label2.setFont(this.label2.getFont().deriveFont(this.label2.getFont().getStyle() | 1, (float)this.label2.getFont().getSize() + 2.0f));
        this.textArea1.setFont(new Font("Courier New", 0, 12));
        this.scrollPane1.setViewportView(this.textArea1);
        this.wantRoots.setText("data roots");
        this.wantRoots.setFont(this.wantRoots.getFont().deriveFont(this.wantRoots.getFont().getStyle() | 1));
        this.stopButton.setText("Stop");
        this.useHttps.setText("Use https:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGap(39, 39, 39).addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.acceptButton).addGap(64, 64, 64).addComponent(this.stopButton, -2, -1, -2)).addComponent(this.label2).addGroup(layout.createSequentialGroup().addComponent(this.label1, -2, 55, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.serverCB, -2, 283, -2).addGap(18, 18, 18).addComponent(this.useHttps)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.wantServlet).addComponent(this.wantAccess)).addGap(30, 30, 30).addComponent(this.wantRoots))))).addGap(223, 223, 223)).addGroup(layout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.scrollPane1, -1, 696, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.label2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label1).addComponent(this.serverCB, -2, -1, -2).addComponent(this.useHttps)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.wantRoots).addComponent(this.wantAccess)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.wantServlet).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.acceptButton).addComponent(this.stopButton, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.scrollPane1, -1, 428, Short.MAX_VALUE).addContainerGap()));
    }

    private class DownloadAction
    extends AbstractAction {
        private DownloadAction() {
            this.putValue("Name", "Download");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String server = (String)ManageForm.this.serverCB.getSelectedItem();
            ManageForm.this.serverCB.addItem(server);
            Data data = new Data(server, ManageForm.this.wantAccess.isSelected(), ManageForm.this.wantServlet.isSelected(), ManageForm.this.wantRoots.isSelected(), ManageForm.this.useHttps.isSelected());
            ManageForm.this.firePropertyChange("Download", null, data);
        }
    }

    public static class Data {
        public String server;
        public boolean wantAccess;
        public boolean wantServlet;
        public boolean wantRoots;
        public boolean useHttps;

        private Data(String server, boolean access, boolean servlet, boolean roots, boolean useHttps) {
            this.server = server == null ? "" : server.trim();
            this.wantAccess = access;
            this.wantServlet = servlet;
            this.wantRoots = roots;
            this.useHttps = useHttps;
        }

        public String getServerPrefix() {
            return this.useHttps ? "https://" : "http://" + this.server;
        }
    }
}

