/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ogc.erddap.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import ucar.nc2.ogc.erddap.util.ErddapCalendar2;
import ucar.nc2.ogc.erddap.util.ErddapString2;
import ucar.nc2.ogc.erddap.util.ErddapStringArray;
import ucar.nc2.util.Misc;

public class ErddapEDUnits {
    public static String[] metricName = new String[]{"yotta", "zetta", "exa", "peta", "tera", "giga", "mega", "kilo", "hecto", "deka", "deci", "centi", "milli", "micro", "nano", "pico", "femto", "atto", "zepto", "yocto", "\u00b5"};
    public static String[] metricAcronym = new String[]{"Y", "Z", "E", "P", "T", "G", "M", "k", "h", "da", "d", "c", "m", "u", "n", "p", "f", "a", "z", "y", "u"};
    public static int nMetric = metricName.length;
    public static String[] twoAcronym = new String[]{"Ki", "Mi", "Gi", "Ti"};
    public static String[] twoValue = new String[]{"1024", "1048576", "1073741824", "1.099511627776e12"};
    public static int nTwo = twoAcronym.length;
    private static final HashMap<String, String> udHashMap;
    private static final HashMap<String, String> ucHashMap;

    public static String udunitsToUcum(String udunits) {
        if (udunits == null) {
            return null;
        }
        int sincePo = udunits.indexOf(" since ");
        if (sincePo > 0) {
            try {
                double[] baf = ErddapCalendar2.getTimeBaseAndFactor(udunits);
                String u = Misc.nearlyEquals(baf[1], 0.001, 1.0E-6) ? "ms" : (baf[1] == 1.0 ? "s" : (baf[1] == 60.0 ? "min" : (baf[1] == 3600.0 ? "h" : (baf[1] == 86400.0 ? "d" : (baf[1] == 2592000.0 ? "mo" : (baf[1] == 3.1104E7 ? "a" : ErddapEDUnits.udunitsToUcum(udunits.substring(0, sincePo))))))));
                return u + "{" + udunits.substring(sincePo + 1) + "}";
            }
            catch (Exception baf) {
                // empty catch block
            }
        }
        StringBuilder ucum = new StringBuilder();
        int udLength = udunits.length();
        int po = 0;
        while (po < udLength) {
            int lastUcum;
            int po2;
            char ch = udunits.charAt(po);
            if (ErddapEDUnits.isUdunitsLetter(ch)) {
                int firstDigit;
                for (po2 = po + 1; po2 < udLength && (ErddapEDUnits.isUdunitsLetter(udunits.charAt(po2)) || udunits.charAt(po2) == '_' || ErddapString2.isDigit(udunits.charAt(po2))); ++po2) {
                }
                String tUdunits = udunits.substring(po, po2);
                po = po2;
                for (firstDigit = tUdunits.length(); firstDigit >= 1 && ErddapString2.isDigit(tUdunits.charAt(firstDigit - 1)); --firstDigit) {
                }
                String exponent = tUdunits.substring(firstDigit);
                String tUcum = ErddapEDUnits.oneUdunitsToUcum(tUdunits = tUdunits.substring(0, firstDigit));
                if (tUcum.equals("/")) {
                    int lastUcum2;
                    int n = lastUcum2 = ucum.length() == 0 ? 0 : (int)ucum.charAt(ucum.length() - 1);
                    if (lastUcum2 == 47) {
                        ucum.setCharAt(ucum.length() - 1, '.');
                    } else if (lastUcum2 == 46) {
                        ucum.setCharAt(ucum.length() - 1, '/');
                    } else {
                        ucum.append('/');
                    }
                } else {
                    ucum.append(tUcum);
                }
                ucum.append(exponent);
                continue;
            }
            if (ch == '-' || ErddapString2.isDigit(ch)) {
                for (po2 = po + 1; po2 < udLength && ErddapString2.isDigit(udunits.charAt(po2)); ++po2) {
                }
                boolean hasDot = false;
                if (po2 < udLength - 1 && udunits.charAt(po2) == '.' && ErddapString2.isDigit(udunits.charAt(po2 + 1))) {
                    hasDot = true;
                    po2 += 2;
                    while (po2 < udLength && ErddapString2.isDigit(udunits.charAt(po2))) {
                        ++po2;
                    }
                }
                boolean hasE = false;
                if (po2 < udLength - 1 && Character.toLowerCase(udunits.charAt(po2)) == 'e' && (udunits.charAt(po2 + 1) == '-' || ErddapString2.isDigit(udunits.charAt(po2 + 1)))) {
                    hasE = true;
                    po2 += 2;
                    while (po2 < udLength && ErddapString2.isDigit(udunits.charAt(po2))) {
                        ++po2;
                    }
                }
                String num = udunits.substring(po, po2);
                po = po2;
                if (hasDot || hasE) {
                    int[] rational = ErddapString2.toRational(ErddapString2.parseDouble(num));
                    if (rational[1] == Integer.MAX_VALUE) {
                        ucum.append(num);
                        continue;
                    }
                    if (rational[1] == 0) {
                        ucum.append(rational[0]);
                        continue;
                    }
                    ucum.append(rational[0]).append(".10^").append(rational[1]);
                    continue;
                }
                ucum.append(num);
                continue;
            }
            if (ch == ' ' || ch == '.' || ch == '\u00b7') {
                int n = lastUcum = ucum.length() == 0 ? 0 : (int)ucum.charAt(ucum.length() - 1);
                if (lastUcum != 47 && lastUcum != 46) {
                    ucum.append('.');
                }
                ++po;
                continue;
            }
            if (ch == '*') {
                if (++po < udLength && udunits.charAt(po) == '*') {
                    ucum.append('^');
                    ++po;
                    continue;
                }
                lastUcum = ucum.length() == 0 ? 0 : (int)ucum.charAt(ucum.length() - 1);
                if (lastUcum == 47 || lastUcum == 46) continue;
                ucum.append('.');
                continue;
            }
            if (ch == '/') {
                ++po;
                int n = lastUcum = ucum.length() == 0 ? 0 : (int)ucum.charAt(ucum.length() - 1);
                if (lastUcum == 47) {
                    ucum.setCharAt(ucum.length() - 1, '.');
                    continue;
                }
                if (lastUcum == 46) {
                    ucum.setCharAt(ucum.length() - 1, '/');
                    continue;
                }
                ucum.append('/');
                continue;
            }
            if (ch == '\"') {
                ++po;
                ucum.append("''");
                continue;
            }
            ucum.append(ch);
            ++po;
        }
        return ucum.toString();
    }

    private static boolean isUdunitsLetter(char ch) {
        return ErddapString2.isLetter(ch) || ch == '\u00b5' || ch == '\u00b0';
    }

    /*
     * Unable to fully structure code
     */
    private static String oneUdunitsToUcum(String udunits) {
        oldUdunits = udunits;
        ucum = new StringBuilder();
        block0: while (true) lbl-1000:
        // 3 sources

        {
            if ((tUcum = ErddapEDUnits.udHashMap.get(udunits)) != null) {
                ucum.append(tUcum);
                return ucum.toString();
            }
            for (p = 0; p < ErddapEDUnits.nMetric; ++p) {
                if (!udunits.startsWith(ErddapEDUnits.metricName[p])) continue;
                udunits = udunits.substring(ErddapEDUnits.metricName[p].length());
                ucum.append(ErddapEDUnits.metricAcronym[p]);
                if (udunits.length() != 0) ** GOTO lbl-1000
                ucum.append("{count}");
                return ucum.toString();
            }
            for (p = 0; p < ErddapEDUnits.nMetric; ++p) {
                if (!udunits.startsWith(ErddapEDUnits.metricAcronym[p])) continue;
                udunits = udunits.substring(ErddapEDUnits.metricAcronym[p].length());
                ucum.append(ErddapEDUnits.metricAcronym[p]);
                if (udunits.length() != 0) continue block0;
                ucum.append("{count}");
                return ucum.toString();
            }
            break;
        }
        return oldUdunits;
    }

    public static String ucumToUdunits(String ucum) {
        String tUdunits;
        int sincePo;
        if (ucum == null) {
            return null;
        }
        StringBuilder udunits = new StringBuilder();
        int ucLength = ucum.length();
        if (ucLength == 0) {
            return "";
        }
        if (ucum.charAt(ucLength - 1) == '}' && ucum.indexOf(125) == ucLength - 1 && (sincePo = ucum.indexOf("{since ")) > 0 && (tUdunits = ucHashMap.get(ucum.substring(0, sincePo))) != null) {
            return tUdunits + " " + ucum.substring(sincePo + 1, ucLength - 1);
        }
        int po = 0;
        while (po < ucLength) {
            int po2;
            char ch = ucum.charAt(po);
            if (ErddapEDUnits.isUcumLetter(ch)) {
                int firstDigit;
                for (po2 = po + 1; po2 < ucLength && (ErddapEDUnits.isUcumLetter(ucum.charAt(po2)) || ucum.charAt(po2) == '_' || ErddapString2.isDigit(ucum.charAt(po2))); ++po2) {
                }
                String tUcum = ucum.substring(po, po2);
                po = po2;
                for (firstDigit = tUcum.length(); firstDigit >= 1 && ErddapString2.isDigit(tUcum.charAt(firstDigit - 1)); --firstDigit) {
                }
                String exponent = tUcum.substring(firstDigit);
                String tUdunits2 = ErddapEDUnits.oneUcumToUdunits(tUcum = tUcum.substring(0, firstDigit));
                if (tUdunits2.equals("/")) {
                    int lastUdunits;
                    int n = lastUdunits = udunits.length() == 0 ? 0 : (int)udunits.charAt(udunits.length() - 1);
                    if (lastUdunits == 47) {
                        udunits.setCharAt(udunits.length() - 1, '.');
                    } else if (lastUdunits == 46) {
                        udunits.setCharAt(udunits.length() - 1, '/');
                    } else {
                        udunits.append('/');
                    }
                } else {
                    udunits.append(tUdunits2);
                }
                udunits.append(exponent);
                continue;
            }
            if (ch == '-' || ErddapString2.isDigit(ch)) {
                for (po2 = po + 1; po2 < ucLength && ErddapString2.isDigit(ucum.charAt(po2)); ++po2) {
                }
                if (po2 < ucLength - 1 && Character.toLowerCase(ucum.charAt(po2)) == '^' && (ucum.charAt(po2 + 1) == '-' || ErddapString2.isDigit(ucum.charAt(po2 + 1)))) {
                    po2 += 2;
                    while (po2 < ucLength && ErddapString2.isDigit(ucum.charAt(po2))) {
                        ++po2;
                    }
                }
                String num = ucum.substring(po, po2);
                po = po2;
                udunits.append(num);
                continue;
            }
            if (ch == '.') {
                ++po;
                udunits.append(' ');
                continue;
            }
            if (ch == '*') {
                ++po;
                udunits.append('^');
                continue;
            }
            if (ch == '\'') {
                if (++po < ucLength && ucum.charAt(po) == '\'') {
                    udunits.append("arc_second");
                    ++po;
                    continue;
                }
                udunits.append("arc_minute");
                continue;
            }
            udunits.append(ch);
            ++po;
        }
        return udunits.toString();
    }

    private static boolean isUcumLetter(char ch) {
        return ErddapString2.isLetter(ch) || ch == '[' || ch == ']' || ch == '{' || ch == '}' || ch == '\u00b5' || ch == '\'';
    }

    private static String oneUcumToUdunits(String ucum) {
        String oldUcum = ucum;
        StringBuilder udunits = new StringBuilder();
        block0: while (true) {
            int p;
            String tUdunits;
            if ((tUdunits = ucHashMap.get(ucum)) != null) {
                udunits.append(tUdunits);
                return udunits.toString();
            }
            for (p = 0; p < nMetric; ++p) {
                if (!ucum.startsWith(metricAcronym[p])) continue;
                ucum = ucum.substring(metricAcronym[p].length());
                udunits.append(metricAcronym[p]);
                if (ucum.length() != 0) continue block0;
                udunits.append("{count}");
                return udunits.toString();
            }
            for (p = 0; p < nTwo; ++p) {
                char udch;
                if (!ucum.startsWith(twoAcronym[p])) continue;
                ucum = ucum.substring(twoAcronym[p].length());
                char c = udch = udunits.length() > 0 ? udunits.charAt(udunits.length() - 1) : (char)'\u0000';
                if (udch != '\u0000' && udch != '.' && udch != '/') {
                    udunits.append('.');
                }
                if (ucum.length() == 0) {
                    udunits.append("{count}");
                    return udunits.toString();
                }
                udunits.append(twoValue[p]).append(".");
                continue block0;
            }
            break;
        }
        int po1 = oldUcum.lastIndexOf(123);
        if (po1 > 0 && oldUcum.endsWith("}")) {
            return ErddapEDUnits.oneUcumToUdunits(oldUcum.substring(0, po1)) + oldUcum.substring(po1);
        }
        return oldUcum;
    }

    public static HashMap<String, String> getHashMapStringString(InputStream inputStream, String charset) throws IOException {
        HashMap<String, String> ht = new HashMap<String, String>();
        ErddapStringArray sa = ErddapStringArray.fromInputStream(inputStream, charset);
        int n = sa.size();
        int i = 0;
        while (i < n) {
            String s2;
            if ((s2 = sa.get(i++)).startsWith("#")) continue;
            while (i < n && s2.endsWith("\\")) {
                s2 = s2.substring(0, s2.length() - 1) + sa.get(i++);
            }
            int po = s2.indexOf(61);
            if (po < 0) continue;
            ht.put(s2.substring(0, po).trim(), s2.substring(po + 1).trim());
        }
        return ht;
    }

    static {
        try (InputStream udunitsToUcumStream = ErddapEDUnits.class.getResourceAsStream("UdunitsToUcum.properties");
             InputStream ucumToUdunitsStream = ErddapEDUnits.class.getResourceAsStream("UcumToUdunits.properties");){
            udHashMap = ErddapEDUnits.getHashMapStringString(udunitsToUcumStream, "ISO-8859-1");
            ucHashMap = ErddapEDUnits.getHashMapStringString(ucumToUdunitsStream, "ISO-8859-1");
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

