/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ogc.erddap.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import ucar.nc2.ogc.erddap.util.ErddapMath2;
import ucar.nc2.ogc.erddap.util.ErddapString2;

public class ErddapStringArray {
    protected int size = 0;
    public String[] array = new String[8];

    public static ErddapStringArray fromInputStream(InputStream inputStream, String charset) throws IOException {
        String s2;
        if (charset == null || charset.isEmpty()) {
            charset = "UTF-8";
        }
        InputStreamReader isr = new InputStreamReader(inputStream, charset);
        BufferedReader bufferedReader = new BufferedReader(isr);
        ErddapStringArray sa = new ErddapStringArray();
        while ((s2 = bufferedReader.readLine()) != null) {
            sa.add(s2);
        }
        return sa;
    }

    public int size() {
        return this.size;
    }

    public void add(String value) {
        if (this.size == this.array.length) {
            this.ensureCapacity((long)this.size + 1L);
        }
        this.array[this.size++] = value;
    }

    public void ensureCapacity(long minCapacity) {
        if ((long)this.array.length < minCapacity) {
            ErddapMath2.ensureArraySizeOkay(minCapacity, "StringArray");
            int newCapacity = (int)Math.min(0x7FFFFFFEL, (long)this.array.length + (long)this.array.length);
            if ((long)newCapacity < minCapacity) {
                newCapacity = (int)minCapacity;
            }
            String[] newArray = new String[newCapacity];
            System.arraycopy(this.array, 0, newArray, 0, this.size);
            this.array = newArray;
        }
    }

    public String get(int index) {
        if (index >= this.size) {
            throw new IllegalArgumentException(ErddapString2.ERROR + " in StringArray.get: index (" + index + ") >= size (" + this.size + ").");
        }
        return this.array[index];
    }
}

