/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ogc.gml;

import java.io.IOException;
import net.opengis.gml.x32.TimePeriodType;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.point.CollectionInfo;
import ucar.nc2.ft.point.DsgCollectionHelper;
import ucar.nc2.ogc.MarshallingUtil;
import ucar.nc2.ogc.gml.NcTimePositionType;
import ucar.nc2.time.CalendarDateRange;

public abstract class NcTimePeriodType {
    public static TimePeriodType initTimePeriod(TimePeriodType timePeriod, StationTimeSeriesFeature stationFeat) throws IOException {
        CollectionInfo info;
        String id = MarshallingUtil.createIdForType(TimePeriodType.class);
        timePeriod.setId(id);
        try {
            info = new DsgCollectionHelper(stationFeat).calcBounds();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        CalendarDateRange cdr = info.getCalendarDateRange(stationFeat.getTimeUnit());
        if (cdr != null) {
            NcTimePositionType.initBeginPosition(timePeriod.addNewBeginPosition(), cdr.getStart());
            NcTimePositionType.initEndPosition(timePeriod.addNewEndPosition(), cdr.getEnd());
        }
        return timePeriod;
    }

    private NcTimePeriodType() {
    }
}

