/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.image;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;
import ucar.nc2.ui.image.ScalablePicture;
import ucar.nc2.ui.image.ScalablePictureListener;
import ucar.nc2.ui.image.SourcePicture;
import ucar.nc2.ui.image.Tools;

class PicturePane
extends JComponent
implements ScalablePictureListener {
    private boolean scaleToFit = true;
    public ScalablePicture sclPic = new ScalablePicture();
    private boolean Dragging = false;
    private boolean centerWhenScaled;
    private Point focusPoint = new Point();
    private int last_x;
    private int last_y;
    private String legend = null;
    private Point infoPoint = new Point(15, 15);
    private int lineSpacing = 12;
    private Font infoFont = new Font("Arial", 0, 10);
    private boolean showInfo = false;
    private DecimalFormat twoDecimalFormatter = new DecimalFormat("###0.00");
    private int maximumPictureSize = 5000;
    protected Vector picturePaneListeners = new Vector();

    public PicturePane() {
        Listener MouseListener2 = new Listener();
        this.addMouseListener(MouseListener2);
        this.addMouseMotionListener(MouseListener2);
        this.setDoubleBuffered(false);
        this.sclPic.addStatusListener(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                PicturePane.this.zoomToFit();
            }
        });
        this.setFont(this.infoFont);
    }

    public void setPicture(URL filenameURL, String legendParam, double rotation) {
        this.legend = legendParam;
        this.centerWhenScaled = true;
        this.sclPic.setScaleSize(this.getSize());
        this.sclPic.stopLoadingExcept(filenameURL);
        this.sclPic.loadAndScalePictureInThread(filenameURL, 10, rotation);
    }

    public void setBufferedImage(BufferedImage img, String statusMessage) {
        this.legend = statusMessage;
        this.centerWhenScaled = true;
        Dimension dim = this.getSize();
        this.sclPic.setScaleSize(dim);
        SourcePicture source = new SourcePicture();
        source.setSourceBufferedImage(img, statusMessage);
        this.sclPic.setSourcePicture(source);
        if (!this.scaleToFit) {
            this.sclPic.setScaleFactor(1.0);
        }
        this.sclPic.scalePicture();
        this.repaint();
    }

    public void setDragging(boolean parameter) {
        this.Dragging = parameter;
    }

    public void zoomIn() {
        double OldScaleFactor = this.sclPic.getScaleFactor();
        double NewScaleFactor = OldScaleFactor * 1.5;
        if (OldScaleFactor < 1.0 && NewScaleFactor > 1.0) {
            NewScaleFactor = 1.0;
        }
        if ((double)this.sclPic.getOriginalWidth() * this.sclPic.getScaleFactor() < (double)this.maximumPictureSize && (double)this.sclPic.getOriginalHeight() * this.sclPic.getScaleFactor() < (double)this.maximumPictureSize) {
            this.sclPic.setScaleFactor(NewScaleFactor);
            this.sclPic.createScaledPictureInThread(10);
        }
    }

    public void zoomOut() {
        this.sclPic.setScaleFactor(this.sclPic.getScaleFactor() / 1.5);
        this.sclPic.createScaledPictureInThread(10);
    }

    public void zoomToFit() {
        block3: {
            block2: {
                this.sclPic.setScaleSize(this.getSize());
                if (this.sclPic.getStatusCode() == 11) break block2;
                if (this.sclPic.getStatusCode() != 13) break block3;
            }
            this.sclPic.createScaledPictureInThread(10);
        }
    }

    public void centerImage() {
        if (this.sclPic.getOriginalImage() != null) {
            this.setCenterLocation(this.sclPic.getOriginalWidth() / 2, this.sclPic.getOriginalHeight() / 2);
            this.repaint();
        }
    }

    public void scrollUp() {
        if ((double)(this.sclPic.getOriginalHeight() - this.focusPoint.y) * this.sclPic.getScaleFactor() + (double)(this.getSize().height / 2) > (double)this.getSize().height) {
            this.focusPoint.y += (int)((double)this.getSize().height * 0.1 / this.sclPic.getScaleFactor());
            this.repaint();
        } else {
            Tools.log("Scrollup rejected because bottom of picture is already showing.");
        }
    }

    public void scrollDown() {
        if ((double)(this.getSize().height / 2) - (double)this.focusPoint.y * this.sclPic.getScaleFactor() < 0.0) {
            this.focusPoint.y -= (int)((double)this.getSize().height * 0.1 / this.sclPic.getScaleFactor());
            this.repaint();
        } else {
            Tools.log("Scroll down rejected because top edge is aready visible");
        }
    }

    public void scrollLeft() {
        if ((double)(this.sclPic.getOriginalWidth() - this.focusPoint.x) * this.sclPic.getScaleFactor() + (double)(this.getSize().width / 2) > (double)this.getSize().width) {
            this.focusPoint.x += (int)((double)this.getSize().width * 0.1 / this.sclPic.getScaleFactor());
            this.repaint();
        } else {
            Tools.log("Scrollup rejected because right edge of picture is already showing.");
        }
    }

    public void scrollRight() {
        if ((double)(this.getSize().width / 2) - (double)this.focusPoint.x * this.sclPic.getScaleFactor() < 0.0) {
            this.focusPoint.x -= (int)((double)this.getSize().width * 0.1 / this.sclPic.getScaleFactor());
            this.repaint();
        } else {
            Tools.log("Scroll left rejected because left edge is aready visible");
        }
    }

    public void setCenterLocation(int Xparameter, int Yparameter) {
        Tools.log("setCenterLocation invoked with " + Xparameter + " x " + Yparameter);
        this.focusPoint.setLocation(Xparameter, Yparameter);
    }

    public void setScaleToFit(boolean scaleToFit) {
        this.scaleToFit = scaleToFit;
    }

    @Override
    public void paintComponent(Graphics g2) {
        int WindowWidth = this.getSize().width;
        int WindowHeight = this.getSize().height;
        Tools.log("paintComponent called");
        if (!this.Dragging) {
            this.setCursor(new Cursor(3));
        }
        if (this.sclPic.getScaledPicture() != null) {
            Graphics2D g2d = (Graphics2D)g2;
            int X_Offset = (int)((double)(WindowWidth / 2) - (double)this.focusPoint.x * this.sclPic.getScaleFactor());
            int Y_Offset = (int)((double)(WindowHeight / 2) - (double)this.focusPoint.y * this.sclPic.getScaleFactor());
            Rectangle clipBounds = g2d.getClipBounds();
            g2d.setColor(Color.black);
            g2d.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
            g2d.drawRenderedImage(this.sclPic.getScaledPicture(), AffineTransform.getTranslateInstance(X_Offset, Y_Offset));
            if (this.showInfo) {
                g2d.setColor(Color.white);
                g2d.drawString(this.legend, this.infoPoint.x, this.infoPoint.y);
                g2d.drawString("Size: " + this.sclPic.getOriginalWidth() + " x " + this.sclPic.getOriginalHeight() + " Offset: " + X_Offset + " x " + Y_Offset + " Mid: " + this.focusPoint.x + " x " + this.focusPoint.y + " Scale: " + this.twoDecimalFormatter.format(this.sclPic.getScaleFactor()), this.infoPoint.x, this.infoPoint.y + this.lineSpacing);
            }
        } else {
            g2.setClip(0, 0, WindowWidth, WindowHeight);
            g2.setColor(Color.black);
            g2.fillRect(0, 0, WindowWidth, WindowHeight);
        }
        if (!this.Dragging) {
            this.setCursor(new Cursor(0));
        }
    }

    public void showInfoPanel() {
        this.showInfo = !this.showInfo;
        this.repaint();
    }

    @Override
    public void scalableStatusChange(int pictureStatusCode, String pictureStatusMessage) {
        Tools.log("PicturePane.scalableStatusChange: got a status change: " + pictureStatusMessage);
        if (pictureStatusCode == 13) {
            Tools.log("PicturePane.scalableStatusChange: a READY status");
            pictureStatusMessage = this.legend;
            if (this.centerWhenScaled) {
                Tools.log("PicturePane.scalableStatusChange: centering image");
                this.centerImage();
            }
            Tools.log("PicturePane.scalableStatusChange: forcing Panel repaint");
            this.repaint();
        }
        Enumeration e = this.picturePaneListeners.elements();
        while (e.hasMoreElements()) {
            ((ScalablePictureListener)e.nextElement()).scalableStatusChange(pictureStatusCode, pictureStatusMessage);
        }
    }

    @Override
    public void sourceLoadProgressNotification(int statusCode, int percentage) {
        Enumeration e = this.picturePaneListeners.elements();
        while (e.hasMoreElements()) {
            ((ScalablePictureListener)e.nextElement()).sourceLoadProgressNotification(statusCode, percentage);
        }
    }

    public void addStatusListener(ScalablePictureListener listener) {
        this.picturePaneListeners.add(listener);
    }

    public void removeStatusListener(ScalablePictureListener listener) {
        this.picturePaneListeners.remove(listener);
    }

    public ScalablePicture getScalablePicture() {
        return this.sclPic;
    }

    class Listener
    extends MouseInputAdapter {
        Listener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 3) {
                PicturePane.this.centerWhenScaled = false;
                PicturePane.this.zoomOut();
            }
            if (e.getButton() == 2) {
                PicturePane.this.zoomToFit();
                PicturePane.this.centerWhenScaled = true;
            }
            if (e.getButton() == 1) {
                int WindowWidth = PicturePane.this.getSize().width;
                int WindowHeight = PicturePane.this.getSize().height;
                int X_Offset = e.getX() - WindowWidth / 2;
                int Y_Offset = e.getY() - WindowHeight / 2;
                PicturePane.this.setCenterLocation(((PicturePane)PicturePane.this).focusPoint.x + (int)((double)X_Offset / PicturePane.this.sclPic.getScaleFactor()), ((PicturePane)PicturePane.this).focusPoint.y + (int)((double)Y_Offset / PicturePane.this.sclPic.getScaleFactor()));
                PicturePane.this.centerWhenScaled = false;
                PicturePane.this.zoomIn();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (PicturePane.this.Dragging) {
                PicturePane.this.Dragging = false;
                PicturePane.this.setCursor(new Cursor(0));
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!PicturePane.this.Dragging) {
                PicturePane.this.last_x = e.getX();
                PicturePane.this.last_y = e.getY();
                PicturePane.this.Dragging = true;
                PicturePane.this.setCursor(new Cursor(13));
            } else {
                int x = e.getX();
                int y = e.getY();
                PicturePane.this.focusPoint.setLocation((int)((double)((PicturePane)PicturePane.this).focusPoint.x + (double)(PicturePane.this.last_x - x) / PicturePane.this.sclPic.getScaleFactor()), (int)((double)((PicturePane)PicturePane.this).focusPoint.y + (double)(PicturePane.this.last_y - y) / PicturePane.this.sclPic.getScaleFactor()));
                PicturePane.this.last_x = x;
                PicturePane.this.last_y = y;
                PicturePane.this.Dragging = true;
                PicturePane.this.repaint();
            }
            PicturePane.this.centerWhenScaled = false;
        }
    }
}

