/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import ucar.nc2.iosp.bufr.DataDescriptor;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.MessageScanner;
import ucar.nc2.iosp.bufr.tables.BufrTables;
import ucar.nc2.iosp.bufr.tables.TableB;
import ucar.nc2.ui.dialog.BufrBCompare;
import ucar.nc2.units.SimpleUnit;
import ucar.ui.prefs.BeanTable;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.FileManager;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.TextHistoryPane;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil2;
import ucar.util.prefs.PreferencesExt;

public class BufrTableBViewer
extends JPanel {
    private PreferencesExt prefs;
    private BeanTable ddsTable;
    private BeanTable variantTable;
    private JSplitPane split;
    private TextHistoryPane compareTA;
    private IndependentWindow infoWindow;
    private TableB currTable;
    private TableB refTable;
    private FileManager fileChooser;
    private char[] remove = new char[]{'(', ')', ' ', '\"', ',', '*', '-'};
    private String[] replace = new String[]{"", "", "", "", "", "", ""};
    private BufrBCompare dialog = null;
    private HashMap<Short, List<Message>> usedDds = null;
    private HashMap<Short, List<DdsBean>> allVariants = null;
    private Set<String> varKeys = null;
    private boolean standardVariantsLoaded = false;

    public BufrTableBViewer(final PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.ddsTable = new BeanTable<DdsBean>(DdsBean.class, (PreferencesExt)prefs.node("DdsBean"), false);
        this.ddsTable.addListSelectionListener(e -> {
            DdsBean csb = (DdsBean)this.ddsTable.getSelectedBean();
            this.showVariants(csb);
        });
        this.variantTable = new BeanTable<DdsBean>(DdsBean.class, (PreferencesExt)prefs.node("VariantBean"), false);
        PopupMenu varPopup = new PopupMenu(this.ddsTable.getJTable(), "Options");
        varPopup.addAction("Show uses", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list;
                Formatter out = new Formatter();
                DdsBean csb = (DdsBean)BufrTableBViewer.this.ddsTable.getSelectedBean();
                if (BufrTableBViewer.this.usedDds != null && (list = (List)BufrTableBViewer.this.usedDds.get(csb.getId())) != null) {
                    for (Message use : list) {
                        use.dumpHeaderShort(out);
                    }
                }
                BufrTableBViewer.this.compareTA.setText(out.toString());
                BufrTableBViewer.this.compareTA.gotoTop();
                BufrTableBViewer.this.infoWindow.setVisible(true);
            }
        });
        AbstractButton standardButton = BAMutil.makeButtcon("FontIncr", "Show union of tables", false);
        standardButton.addActionListener(e -> this.showAll());
        buttPanel.add(standardButton);
        AbstractButton diffButton = BAMutil.makeButtcon("Select", "Diff all variants", false);
        diffButton.addActionListener(e -> this.diffVariants());
        buttPanel.add(diffButton);
        AbstractButton compareButton = BAMutil.makeButtcon("Select", "Compare to standard table", false);
        compareButton.addActionListener(e -> this.compareToStandard());
        buttPanel.add(compareButton);
        AbstractAction refAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BufrTableBViewer.this.refTable = BufrTableBViewer.this.currTable;
                BufrTableBViewer.this.loadVariant(BufrTableBViewer.this.refTable.getName(), BufrTableBViewer.this.refTable);
            }
        };
        BAMutil.setActionProperties(refAction, "nj22/Dataset", "useAsRef", false, 67, -1);
        BAMutil.addActionToContainer(buttPanel, refAction);
        AbstractAction usedAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String filename;
                    if (BufrTableBViewer.this.fileChooser == null) {
                        BufrTableBViewer.this.fileChooser = new FileManager(null, null, null, (PreferencesExt)prefs.node("FileManager"));
                    }
                    if ((filename = BufrTableBViewer.this.fileChooser.chooseFilename()) == null) {
                        return;
                    }
                    BufrTableBViewer.this.showUsed(filename);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        };
        BAMutil.setActionProperties(usedAction, "nj22/dd", "checkUsed", false, 67, -1);
        BAMutil.addActionToContainer(buttPanel, usedAction);
        AbstractAction diffAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String filename;
                    String defloc = "C:/dev/tds/thredds/bufrTables/src/main/resources/resources/bufrTables/local";
                    if (BufrTableBViewer.this.fileChooser == null) {
                        BufrTableBViewer.this.fileChooser = new FileManager(null, null, null, (PreferencesExt)prefs.node("FileManager"));
                    }
                    if ((filename = BufrTableBViewer.this.fileChooser.chooseFilenameToSave(defloc + ".csv")) == null) {
                        return;
                    }
                    try (FileOutputStream out = new FileOutputStream(filename);){
                        OutputStreamWriter fout = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
                        BufferedWriter bw = new BufferedWriter(fout);
                        Formatter f = new Formatter(bw);
                        BufrTableBViewer.this.writeDiff(BufrTables.getWmoTableB(14), BufrTableBViewer.this.currTable, f);
                    }
                    JOptionPane.showMessageDialog(BufrTableBViewer.this, filename + " successfully written");
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(BufrTableBViewer.this, "ERROR: " + ex.getMessage());
                    ex.printStackTrace();
                }
            }
        };
        BAMutil.setActionProperties(diffAction, "nj22/dd", "write diff", false, 67, -1);
        BAMutil.addActionToContainer(buttPanel, diffAction);
        AbstractAction localAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String filename;
                    String defloc = "C:/dev/tds/thredds/bufrTables/src/main/resources/resources/bufrTables/local";
                    if (BufrTableBViewer.this.fileChooser == null) {
                        BufrTableBViewer.this.fileChooser = new FileManager(null, null, null, (PreferencesExt)prefs.node("FileManager"));
                    }
                    if ((filename = BufrTableBViewer.this.fileChooser.chooseFilenameToSave(defloc + ".csv")) == null) {
                        return;
                    }
                    try (FileOutputStream out = new FileOutputStream(filename);){
                        OutputStreamWriter fout = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
                        BufferedWriter bw = new BufferedWriter(fout);
                        Formatter f = new Formatter(bw);
                        BufrTableBViewer.this.writeLocal(BufrTableBViewer.this.currTable, f);
                    }
                    JOptionPane.showMessageDialog(BufrTableBViewer.this, filename + " successfully written");
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(BufrTableBViewer.this, "ERROR: " + ex.getMessage());
                    ex.printStackTrace();
                }
            }
        };
        BAMutil.setActionProperties(localAction, "nj22/dd", "write local", false, 67, -1);
        BAMutil.addActionToContainer(buttPanel, localAction);
        this.compareTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("nj22/NetcdfUI"), this.compareTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 800, 600)));
        this.split = new JSplitPane(0, false, this.ddsTable, this.variantTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    public void save() {
        this.ddsTable.saveState(false);
        this.variantTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
        if (this.fileChooser != null) {
            this.fileChooser.save();
        }
    }

    public void setBufrTableB(String filename, BufrTables.Format format) throws IOException {
        TableB tableB = BufrTables.readTableB(filename, format, true);
        this.setBufrTableB(tableB);
    }

    private void setBufrTableB(TableB tb) throws IOException {
        String location = tb.getLocation();
        int pos = location.lastIndexOf("/");
        String src = pos > 0 ? location.substring(pos + 1) : location;
        ArrayList<TableB.Descriptor> listDesc = new ArrayList<TableB.Descriptor>(tb.getDescriptors());
        Collections.sort(listDesc);
        ArrayList<DdsBean> dds = new ArrayList<DdsBean>(listDesc.size());
        for (TableB.Descriptor d : listDesc) {
            dds.add(new DdsBean(src, d));
        }
        this.ddsTable.setBeans(dds);
        this.currTable = tb;
    }

    private String checkDiff(TableB.Descriptor want) {
        if (this.refTable == null) {
            return "n/a";
        }
        for (TableB.Descriptor d1 : this.refTable.getDescriptors()) {
            if (d1.getId() != want.getId()) continue;
            if (d1.getScale() != want.getScale()) {
                return "diff";
            }
            if (d1.getRefVal() != want.getRefVal()) {
                return "diff";
            }
            if (d1.getDataWidth() != want.getDataWidth()) {
                return "diff";
            }
            return "";
        }
        return want.isLocal() ? "local" : "new";
    }

    private void writeDiff(@Nullable TableB wmo, TableB t, Formatter out) {
        if (wmo == null) {
            return;
        }
        out.format("#%n# BUFR diff written from %s against %s %n#%n", t.getName(), wmo.getName());
        out.format("Class,FXY,enElementName,BUFR_Unit,BUFR_Scale,BUFR_ReferenceValue,BUFR_DataWidth_Bits%n", new Object[0]);
        ArrayList<TableB.Descriptor> listDesc = new ArrayList<TableB.Descriptor>(t.getDescriptors());
        Collections.sort(listDesc);
        for (TableB.Descriptor d1 : listDesc) {
            TableB.Descriptor d2 = wmo.getDescriptor(d1.getId());
            if (d2 != null && d1.getScale() == d2.getScale() && d1.getRefVal() == d2.getRefVal() && d1.getDataWidth() == d2.getDataWidth()) continue;
            short fxy = d1.getId();
            int x = (fxy & 0x3F00) >> 8;
            int y = fxy & 0xFF;
            out.format("%d,%2d%03d,\"%s\",%s,%d,%d,%d%n", x, x, y, d1.getName(), d1.getUnits(), d1.getScale(), d1.getRefVal(), d1.getDataWidth());
        }
        out.flush();
    }

    private void writeLocal(TableB t, Formatter out) {
        out.format("#%n# BUFR local only from %s %n#%n", t.getName());
        out.format("Class,FXY,enElementName,BUFR_Unit,BUFR_Scale,BUFR_ReferenceValue,BUFR_DataWidth_Bits%n", new Object[0]);
        ArrayList<TableB.Descriptor> listDesc = new ArrayList<TableB.Descriptor>(t.getDescriptors());
        Collections.sort(listDesc);
        for (TableB.Descriptor d1 : listDesc) {
            if (!d1.isLocal()) continue;
            short fxy = d1.getId();
            int x = (fxy & 0x3F00) >> 8;
            int y = fxy & 0xFF;
            out.format("%d,%d%03d,\"%s\",%s,%d,%d,%d%n", x, x, y, d1.getName(), d1.getUnits(), d1.getScale(), d1.getRefVal(), d1.getDataWidth());
        }
        out.flush();
    }

    private boolean equiv(String org1, String org2) {
        String s1 = StringUtil2.replace(org1, this.remove, this.replace).toLowerCase();
        String s2 = StringUtil2.replace(org2, this.remove, this.replace).toLowerCase();
        return s1.equals(s2);
    }

    private boolean equivUnits(String unitS1, String unitS2) {
        String lower2;
        String lower1 = unitS1.toLowerCase();
        if (lower1.equals(lower2 = unitS2.toLowerCase())) {
            return true;
        }
        if (lower1.startsWith("code") && lower2.startsWith("code")) {
            return true;
        }
        if (lower1.startsWith("flag") && lower2.startsWith("flag")) {
            return true;
        }
        if (unitS1.startsWith("CCITT") && unitS2.startsWith("CCITT")) {
            return true;
        }
        try {
            return SimpleUnit.isCompatibleWithExceptions(unitS1, unitS2);
        }
        catch (Exception e) {
            return this.equiv(unitS1, unitS2);
        }
    }

    public void compareToStandard() {
        if (this.dialog == null) {
            this.dialog = new BufrBCompare(null);
            this.dialog.pack();
            this.dialog.addPropertyChangeListener("OK", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    BufrTableBViewer.this.compareToStandard((BufrBCompare.Data)evt.getNewValue());
                }
            });
        }
        this.dialog.setVisible(true);
    }

    private void compareToStandard(BufrBCompare.Data data) {
        try {
            Formatter out = new Formatter();
            if (this.refTable == null) {
                this.refTable = BufrTables.getWmoTableBlatest();
            }
            this.compare(this.refTable, !data.compareNames, !data.compareUnits, out);
            this.compareTA.setText(out.toString());
            this.compareTA.gotoTop();
            this.infoWindow.setVisible(true);
        }
        catch (Throwable ioe) {
            StringWriter sw = new StringWriter(10000);
            ioe.printStackTrace(new PrintWriter(sw));
            this.compareTA.setText(sw.toString());
            this.compareTA.gotoTop();
            this.infoWindow.setVisible(true);
        }
    }

    private void compare(TableB t2, boolean skipNames, boolean skipUnits, Formatter out) {
        HashMap<Short, DdsBean> mapBeans = new HashMap<Short, DdsBean>(3000);
        out.format("Compare Current Table (%s) to %s %n", this.currTable.getName(), t2.getName());
        for (Object beano : this.ddsTable.getBeans()) {
            DdsBean bean = (DdsBean)beano;
            TableB.Descriptor d1 = bean.dds;
            TableB.Descriptor d2 = t2.getDescriptor(d1.getId());
            if (d2 == null) {
                out.format("**No key %s in second table; local=%s%n", d1.getFxy(), d1.isLocal());
            } else {
                if (!skipNames && !this.equiv(d1.getName(), d2.getName())) {
                    out.format(" %s name%n   %s%n   %s%n", d1.getFxy(), d1.getName(), d2.getName());
                }
                if (!skipUnits && !this.equivUnits(d1.getUnits(), d2.getUnits())) {
                    out.format(" %s units%n   %s%n   %s%n", d1.getFxy(), d1.getUnits(), d2.getUnits());
                }
                if (d1.getScale() != d2.getScale()) {
                    out.format(" %s scale %d != %d %n", d1.getFxy(), d1.getScale(), d2.getScale());
                }
                if (d1.getRefVal() != d2.getRefVal()) {
                    out.format(" %s refVal %d != %d %n", d1.getFxy(), d1.getRefVal(), d2.getRefVal());
                }
                if (d1.getDataWidth() != d2.getDataWidth()) {
                    out.format(" %s bitWidth %d != %d %n", d1.getFxy(), d1.getDataWidth(), d2.getDataWidth());
                }
            }
            mapBeans.put(d1.getId(), bean);
        }
        ArrayList<TableB.Descriptor> listDesc2 = new ArrayList<TableB.Descriptor>(t2.getDescriptors());
        out.format("%n Missing in first table %n", new Object[0]);
        Collections.sort(listDesc2);
        for (TableB.Descriptor d2 : listDesc2) {
            DdsBean bean = (DdsBean)mapBeans.get(d2.getId());
            if (bean != null) continue;
            out.format("   %s%n", d2.getFxy());
        }
    }

    private void showUsed(String filename) throws IOException {
        this.usedDds = new HashMap(3000);
        this.scanFileForDds(filename);
    }

    public void scanFileForDds(String filename) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        MessageScanner scan = new MessageScanner(raf);
        while (scan.hasNext()) {
            Message m3 = scan.next();
            if (m3 == null) continue;
            this.setDataDescriptors(m3, m3.getRootDataDescriptor());
        }
    }

    private void setDataDescriptors(Message src, DataDescriptor dds) {
        for (DataDescriptor key : dds.getSubKeys()) {
            List list = this.usedDds.computeIfAbsent(key.getFxy(), k -> new ArrayList());
            if (!list.contains(src)) {
                list.add(src);
            }
            if (key.getSubKeys() == null) continue;
            this.setDataDescriptors(src, key);
        }
    }

    private void loadStandardVariants() {
        for (BufrTables.TableConfig tc : BufrTables.getTables()) {
            try {
                if (tc.getName().startsWith("FNMOC")) continue;
                this.loadVariant(tc.getName(), BufrTables.readTableB(tc.getTableBname(), tc.getTableBformat(), false));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.standardVariantsLoaded = true;
    }

    private void loadVariant(String key, TableB tableB) {
        if (this.allVariants == null) {
            this.allVariants = new HashMap();
        }
        if (this.varKeys == null) {
            this.varKeys = new HashSet<String>();
        }
        if (this.varKeys.contains(key)) {
            return;
        }
        ArrayList<TableB.Descriptor> listDesc = new ArrayList<TableB.Descriptor>(tableB.getDescriptors());
        for (TableB.Descriptor d : listDesc) {
            List list = this.allVariants.computeIfAbsent(d.getId(), k -> new ArrayList(10));
            list.add(new DdsBean(key, d));
        }
    }

    private void showVariants(DdsBean bean) {
        if (!this.standardVariantsLoaded) {
            this.loadStandardVariants();
        }
        List<DdsBean> all = this.allVariants.get(bean.getId());
        ArrayList<DdsBean> ddsBean = new ArrayList<DdsBean>(10);
        ddsBean.add(bean);
        if (all != null) {
            ddsBean.addAll(all);
        }
        this.variantTable.setBeans(ddsBean);
    }

    private void showAll() {
        if (!this.standardVariantsLoaded) {
            this.loadStandardVariants();
        }
        HashMap<Short, DdsBean> allDesc = new HashMap<Short, DdsBean>(3000);
        HashSet<String> keys = new HashSet<String>();
        for (BufrTables.TableConfig tc : BufrTables.getTables()) {
            String filename = tc.getTableBname();
            if (keys.contains(filename)) continue;
            keys.add(filename);
            try {
                TableB tb = BufrTables.readTableB(filename, tc.getTableBformat(), false);
                this.addVariant(tc.getName(), tb, allDesc);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ArrayList beans = new ArrayList(allDesc.values());
        Collections.sort(beans);
        this.ddsTable.setBeans(beans);
        this.currTable = null;
    }

    private void addVariant(String key, TableB tableB, Map<Short, DdsBean> allDesc) {
        ArrayList<TableB.Descriptor> listDesc = new ArrayList<TableB.Descriptor>(tableB.getDescriptors());
        for (TableB.Descriptor d : listDesc) {
            if (allDesc.containsKey(d.getId())) continue;
            allDesc.put(d.getId(), new DdsBean(key, d));
        }
    }

    private void diffVariants() {
        if (!this.standardVariantsLoaded) {
            this.loadStandardVariants();
        }
        HashSet<String> keys = new HashSet<String>();
        for (Object beano : this.ddsTable.getBeans()) {
            DdsBean bean = (DdsBean)beano;
            bean.setDiff(null);
        }
        for (BufrTables.TableConfig tc : BufrTables.getTables()) {
            String filename;
            if (tc.getName().startsWith("FNMOC") || keys.contains(filename = tc.getTableBname())) continue;
            keys.add(filename);
            try {
                TableB tb = BufrTables.readTableB(filename, tc.getTableBformat(), false);
                this.diffVariant(tb, true, true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        int count = 0;
        int total = 0;
        for (Object beano : this.ddsTable.getBeans()) {
            DdsBean bean = (DdsBean)beano;
            if (bean.getDiff() != null) {
                ++count;
            }
            if (bean.dds.isLocal()) continue;
            ++total;
        }
        System.out.printf("Diff non-local = %d out of %d%n", count, total);
    }

    private void diffVariant(TableB t2, boolean skipNames, boolean skipUnits) {
        for (Object beano : this.ddsTable.getBeans()) {
            TableB.Descriptor d2;
            TableB.Descriptor d1;
            DdsBean bean = (DdsBean)beano;
            if (bean.getDiff() != null || (d1 = bean.dds).isLocal() || (d2 = t2.getDescriptor(d1.getId())) == null) continue;
            if (!skipNames && !this.equiv(d1.getName(), d2.getName())) {
                bean.setDiff("diff");
            }
            if (!skipUnits && !this.equivUnits(d1.getUnits(), d2.getUnits())) {
                bean.setDiff("diff");
            }
            if (d1.getScale() != d2.getScale()) {
                bean.setDiff("diff");
            }
            if (d1.getRefVal() != d2.getRefVal()) {
                bean.setDiff("diff");
            }
            if (d1.getDataWidth() == d2.getDataWidth()) continue;
            bean.setDiff("diff");
        }
    }

    public class DdsBean
    implements Comparable<DdsBean> {
        TableB.Descriptor dds;
        String source;
        String udunits;
        boolean checkDiff;
        String isDiff;

        public DdsBean(String source, TableB.Descriptor dds) {
            this.source = source;
            this.dds = dds;
        }

        public String getFxy() {
            return this.dds.getFxy();
        }

        public short getId() {
            return this.dds.getId();
        }

        public String getSource() {
            return this.source;
        }

        public String getName() {
            return this.dds.getName();
        }

        public String getUnits() {
            return this.dds.getUnits();
        }

        public String getDesc() {
            return this.dds.getDesc();
        }

        public String getUdunits() {
            if (this.udunits == null) {
                try {
                    SimpleUnit su = SimpleUnit.factoryWithExceptions(this.dds.getUnits());
                    this.udunits = su.isUnknownUnit() ? "" : su.toString();
                }
                catch (Exception ioe) {
                    this.udunits = " unit convert failed ";
                }
            }
            return this.udunits;
        }

        public int getWidth() {
            return this.dds.getDataWidth();
        }

        public int getScale() {
            return this.dds.getScale();
        }

        public int getReference() {
            return this.dds.getRefVal();
        }

        public boolean isNumeric() {
            return this.dds.isNumeric();
        }

        public boolean isLocal() {
            return this.dds.isLocal();
        }

        public String getDiff() {
            if (!this.checkDiff && BufrTableBViewer.this.refTable != null) {
                this.isDiff = BufrTableBViewer.this.checkDiff(this.dds);
                this.checkDiff = true;
            }
            return this.isDiff;
        }

        public void setDiff(String diff) {
            this.checkDiff = diff != null;
            this.isDiff = diff;
        }

        public int getUsed() {
            if (BufrTableBViewer.this.usedDds == null) {
                return 0;
            }
            List list = (List)BufrTableBViewer.this.usedDds.get(this.dds.getId());
            if (list == null) {
                return 0;
            }
            return list.size();
        }

        @Override
        public int compareTo(DdsBean o1) {
            return this.dds.compareTo(o1.dds);
        }
    }
}

