/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.FileWriter2;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.jni.netcdf.Nc4Iosp;
import ucar.nc2.ncml.NcMLWriter;
import ucar.nc2.stream.NcStreamWriter;
import ucar.nc2.ui.StructureTable;
import ucar.nc2.ui.dialog.CompareDialog;
import ucar.nc2.ui.dialog.NetcdfOutputChooser;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.CompareNetcdf2;
import ucar.nc2.write.Nc4Chunking;
import ucar.nc2.write.Nc4ChunkingStrategy;
import ucar.ui.prefs.BeanTable;
import ucar.ui.prefs.Debug;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.FileManager;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.ProgressMonitor;
import ucar.ui.widget.ProgressMonitorTask;
import ucar.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;

public class DatasetWriter
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private FileManager fileChooser;
    private PreferencesExt prefs;
    private NetcdfFile ds;
    private List<NestedTable> nestedTableList = new ArrayList<NestedTable>();
    private BeanTable attTable;
    private BeanTable dimTable;
    private JPanel tablePanel;
    private JSplitPane mainSplit;
    private JComponent currentComponent;
    private NetcdfOutputChooser outputChooser;
    private TextHistoryPane infoTA;
    private StructureTable dataTable;
    private IndependentWindow infoWindow;
    private IndependentWindow dataWindow;
    private IndependentWindow attWindow;
    private Nc4Chunking chunker = Nc4ChunkingStrategy.factory(Nc4Chunking.Strategy.standard, 0, false);
    private CompareDialog dialog = null;

    public DatasetWriter(PreferencesExt prefs, FileManager fileChooser) {
        this.prefs = prefs;
        this.fileChooser = fileChooser;
        this.dimTable = new BeanTable<DimensionBean>(DimensionBean.class, (PreferencesExt)prefs.node("DimensionBeanTable"), false, "Dimensions", null, new DimensionBean());
        this.tablePanel = new JPanel(new BorderLayout());
        this.setNestedTable(0, null);
        this.outputChooser = new NetcdfOutputChooser((Frame)null);
        this.outputChooser.addPropertyChangeListener("OK", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DatasetWriter.this.writeFile((NetcdfOutputChooser.Data)evt.getNewValue());
            }
        });
        this.outputChooser.addEventListener(e -> {
            Nc4Chunking.Strategy strategy = (Nc4Chunking.Strategy)((Object)((Object)e.getItem()));
            this.chunker = Nc4ChunkingStrategy.factory(strategy, 0, false);
            this.showChunking();
        });
        this.mainSplit = new JSplitPane(0, false, this.dimTable, this.tablePanel);
        this.mainSplit.setDividerLocation(prefs.getInt("mainSplit", 300));
        this.setLayout(new BorderLayout());
        this.add((Component)this.outputChooser.getContentPane(), "North");
        this.add((Component)this.mainSplit, "Center");
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Variable Information", BAMutil.getImage("nj22/NetcdfUI"), this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.dataTable = new StructureTable((PreferencesExt)prefs.node("structTable"));
        this.dataWindow = new IndependentWindow("Data Table", BAMutil.getImage("nj22/NetcdfUI"), this.dataTable);
        this.dataWindow.setBounds((Rectangle)prefs.getBean("dataWindow", new Rectangle(50, 300, 1000, 600)));
    }

    public void addActions(JPanel buttPanel) {
        AbstractAction attAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetWriter.this.showAtts();
            }
        };
        BAMutil.setActionProperties(attAction, "FontDecr", "global attributes", false, 65, -1);
        BAMutil.addActionToContainer(buttPanel, attAction);
    }

    public void save() {
        this.dimTable.saveState(false);
        for (NestedTable nt : this.nestedTableList) {
            nt.saveState();
        }
        this.prefs.putInt("mainSplit", this.mainSplit.getDividerLocation());
    }

    private void showChunking() {
        if (this.nestedTableList.size() == 0) {
            return;
        }
        NestedTable t = this.nestedTableList.get(0);
        List beans = t.table.getBeans();
        for (Object bean1 : beans) {
            VariableBean bean = (VariableBean)bean1;
            boolean isChunked = this.chunker.isChunked(bean.vs);
            bean.setChunked(isChunked);
            if (isChunked) {
                bean.setChunkArray(this.chunker.computeChunking(bean.vs));
                continue;
            }
            bean.setChunkArray(null);
        }
        t.table.refresh();
    }

    void writeFile(NetcdfOutputChooser.Data data) {
        if (this.ds == null) {
            return;
        }
        String filename = data.outputFilename.trim();
        if (filename.length() == 0) {
            JOptionPane.showMessageDialog(this, "Filename has not been set");
            return;
        }
        if (data.version == NetcdfFileWriter.Version.ncstream) {
            this.writeNcstream(data.outputFilename);
            return;
        }
        if (data.version.isNetdf4format() && !Nc4Iosp.isClibraryPresent()) {
            JOptionPane.showMessageDialog(this, "NetCDF-4 C library is not loaded");
            return;
        }
        WriterTask task = new WriterTask(data);
        ProgressMonitor pm = new ProgressMonitor(task, e -> logger.debug("success}"));
        pm.start(null, "Writing " + filename, this.ds.getVariables().size());
    }

    void writeNcstream(String filename) {
        try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(filename), 50000);){
            NcStreamWriter writer = new NcStreamWriter(this.ds, null);
            writer.streamAll(fos);
            JOptionPane.showMessageDialog(this, "File successfully written");
        }
        catch (Exception ioe) {
            JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
            ioe.printStackTrace();
        }
    }

    void writeNcstreamHeader(String filename) {
        try (FileOutputStream fos = new FileOutputStream(filename);){
            NcStreamWriter writer = new NcStreamWriter(this.ds, null);
            writer.sendHeader(fos);
            JOptionPane.showMessageDialog(this, "File successfully written");
        }
        catch (Exception ioe) {
            JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
            ioe.printStackTrace();
        }
    }

    public void compareDataset() {
        if (this.ds == null) {
            return;
        }
        if (this.dialog == null) {
            this.dialog = new CompareDialog(null, this.fileChooser);
            this.dialog.pack();
            this.dialog.addPropertyChangeListener("OK", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    CompareDialog.Data data = (CompareDialog.Data)evt.getNewValue();
                    DatasetWriter.this.compareDataset(data);
                }
            });
        }
        this.dialog.setVisible(true);
    }

    private void compareDataset(CompareDialog.Data data) {
        if (data.name == null) {
            return;
        }
        try (NetcdfFile compareFile = NetcdfDataset.openFile(data.name, null);){
            Formatter f = new Formatter();
            CompareNetcdf2 cn = new CompareNetcdf2(f, data.showCompare, data.showDetails, data.readData);
            if (data.howMuch == CompareDialog.HowMuch.All) {
                cn.compare(this.ds, compareFile);
            } else {
                NestedTable nested = this.nestedTableList.get(0);
                Variable org = this.getCurrentVariable(nested.table);
                if (org == null) {
                    return;
                }
                Variable ov = compareFile.findVariable(org.getFullNameEscaped());
                if (ov != null) {
                    cn.compareVariable(org, ov);
                }
            }
            this.infoTA.setText(f.toString());
            this.infoTA.gotoTop();
            this.infoWindow.setTitle("Compare");
            this.infoWindow.show();
        }
        catch (Throwable ioe) {
            StringWriter sw = new StringWriter(10000);
            ioe.printStackTrace(new PrintWriter(sw));
            this.infoTA.setText(sw.toString());
            this.infoTA.gotoTop();
            this.infoWindow.show();
        }
    }

    public void showAtts() {
        if (this.ds == null) {
            return;
        }
        if (this.attTable == null) {
            this.attTable = new BeanTable<AttributeBean>(AttributeBean.class, (PreferencesExt)this.prefs.node("AttributeBeans"), false);
            PopupMenu varPopup = new PopupMenu(this.attTable.getJTable(), "Options");
            varPopup.addAction("Show Attribute", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributeBean bean = (AttributeBean)DatasetWriter.this.attTable.getSelectedBean();
                    if (bean != null) {
                        DatasetWriter.this.infoTA.setText(bean.att.toString());
                        DatasetWriter.this.infoTA.gotoTop();
                        DatasetWriter.this.infoWindow.show();
                    }
                }
            });
            this.attWindow = new IndependentWindow("Global Attributes", BAMutil.getImage("nj22/NetcdfUI"), this.attTable);
            this.attWindow.setBounds((Rectangle)this.prefs.getBean("AttWindowBounds", new Rectangle(300, 100, 500, 800)));
        }
        ArrayList<AttributeBean> attlist = new ArrayList<AttributeBean>();
        for (Attribute att : this.ds.getGlobalAttributes()) {
            attlist.add(new AttributeBean(att));
        }
        this.attTable.setBeans(attlist);
        this.attWindow.show();
    }

    public NetcdfFile getDataset() {
        return this.ds;
    }

    public void setDataset(NetcdfFile ds) {
        this.ds = ds;
        this.dimTable.setBeans(this.makeDimensionBeans(ds));
        NestedTable nt = this.nestedTableList.get(0);
        nt.table.setBeans(this.makeVariableBeans(ds));
        this.hideNestedTable(1);
        this.showChunking();
    }

    private void setSelected(Variable v) {
        ArrayList<Variable> vchain = new ArrayList<Variable>();
        vchain.add(v);
        Variable vp = v;
        while (vp.isMemberOfStructure()) {
            vp = vp.getParentStructure();
            vchain.add(0, vp);
        }
        for (int i = 0; i < vchain.size(); ++i) {
            vp = (Variable)vchain.get(i);
            NestedTable ntable = this.setNestedTable(i, vp.getParentStructure());
            ntable.setSelected(vp);
        }
    }

    private void showDeclaration(BeanTable from, boolean isNcml) {
        Variable v = this.getCurrentVariable(from);
        if (v == null) {
            return;
        }
        this.infoTA.clear();
        if (isNcml) {
            NcMLWriter ncmlWriter = new NcMLWriter();
            ncmlWriter.setNamespace(null);
            ncmlWriter.getXmlFormat().setOmitDeclaration(true);
            Element varElement = ncmlWriter.makeVariableElement(v, false);
            this.infoTA.appendLine(ncmlWriter.writeToString(varElement));
        } else {
            this.infoTA.appendLine(v.toString());
        }
        if (Debug.isSet("Xdeveloper")) {
            this.infoTA.appendLine("\n");
            this.infoTA.appendLine("FULL NAME = " + v.getFullName());
            this.infoTA.appendLine("\n");
            this.infoTA.appendLine(v.toStringDebug());
        }
        this.infoTA.gotoTop();
        this.infoWindow.setTitle("Variable Info");
        this.infoWindow.show();
    }

    private void dataTable(BeanTable from) {
        VariableBean vb = (VariableBean)from.getSelectedBean();
        if (vb == null) {
            return;
        }
        Variable v = vb.vs;
        if (v instanceof Structure) {
            try {
                this.dataTable.setStructure((Structure)v);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            return;
        }
        this.dataWindow.show();
    }

    private Variable getCurrentVariable(BeanTable from) {
        VariableBean vb = (VariableBean)from.getSelectedBean();
        if (vb == null) {
            return null;
        }
        return vb.vs;
    }

    private List<VariableBean> makeVariableBeans(NetcdfFile ds) {
        ArrayList<VariableBean> vlist = new ArrayList<VariableBean>();
        for (Variable v : ds.getVariables()) {
            vlist.add(new VariableBean(v));
        }
        return vlist;
    }

    private List<DimensionBean> makeDimensionBeans(NetcdfFile ds) {
        ArrayList<DimensionBean> dlist = new ArrayList<DimensionBean>();
        for (Dimension d : ds.getDimensions()) {
            dlist.add(new DimensionBean(d));
        }
        return dlist;
    }

    private List<VariableBean> getStructureVariables(Structure s2) {
        ArrayList<VariableBean> vlist = new ArrayList<VariableBean>();
        for (Variable v : s2.getVariables()) {
            vlist.add(new VariableBean(v));
        }
        return vlist;
    }

    private NestedTable setNestedTable(int level, Structure s2) {
        NestedTable ntable;
        if (this.nestedTableList.size() < level + 1) {
            ntable = new NestedTable(level);
            this.nestedTableList.add(ntable);
        } else {
            ntable = this.nestedTableList.get(level);
        }
        if (s2 != null) {
            ntable.table.setBeans(this.getStructureVariables(s2));
        }
        ntable.show();
        return ntable;
    }

    private void hideNestedTable(int level) {
        int n = this.nestedTableList.size();
        for (int i = n - 1; i >= level; --i) {
            NestedTable ntable = this.nestedTableList.get(i);
            ntable.hide();
        }
    }

    public class AttributeBean {
        private Attribute att;

        public AttributeBean() {
        }

        public AttributeBean(Attribute att) {
            this.att = att;
        }

        public String getName() {
            return this.att.getShortName();
        }

        public String getValue() {
            Array value = this.att.getValues();
            return NCdumpW.toString(value, null, null);
        }
    }

    public class VariableBean {
        private Variable vs;
        private String name;
        private String dimensions;
        private String desc;
        private String units;
        private String dataType;
        private String shape;
        private boolean isChunked;
        private long[] chunked;

        public VariableBean() {
        }

        public VariableBean(Variable vs) {
            this.vs = vs;
            this.setName(vs.getShortName());
            this.setDescription(vs.getDescription());
            this.setUnits(vs.getUnitsString());
            this.setDataType(vs.getDataType().toString());
            Formatter lens = new Formatter();
            Formatter names = new Formatter();
            lens.format("(", new Object[0]);
            List<Dimension> dims = vs.getDimensions();
            for (int j = 0; j < dims.size(); ++j) {
                Dimension dim = dims.get(j);
                if (j > 0) {
                    lens.format(",", new Object[0]);
                    names.format(",", new Object[0]);
                }
                String name = dim.isShared() ? dim.getShortName() : "anon";
                names.format("%s", name);
                lens.format("%d", dim.getLength());
            }
            lens.format(")", new Object[0]);
            this.setDimensions(names.toString());
            this.setShape(lens.toString());
        }

        public String editableProperties() {
            return "chunked chunkSize";
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getGroup() {
            return this.vs.getParentGroup().getFullName();
        }

        public String getDimensions() {
            return this.dimensions;
        }

        public void setDimensions(String dimensions) {
            this.dimensions = dimensions;
        }

        public String getDescription() {
            return this.desc;
        }

        public void setDescription(String desc) {
            this.desc = desc;
        }

        public String getUnits() {
            return this.units;
        }

        public void setUnits(String units) {
            this.units = units;
        }

        public String getDataType() {
            return this.dataType;
        }

        public void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public String getShape() {
            return this.shape;
        }

        public void setShape(String shape) {
            this.shape = shape;
        }

        public boolean isUnlimited() {
            return this.vs.isUnlimited();
        }

        public String getSize() {
            Formatter f = new Formatter();
            f.format("%,d", this.vs.getSize());
            return f.toString();
        }

        public boolean isChunked() {
            return this.isChunked;
        }

        public void setChunked(boolean chunked) {
            this.isChunked = chunked;
            if (chunked) {
                this.setChunkArray(DatasetWriter.this.chunker.computeChunking(this.vs));
            } else {
                this.setChunkArray(null);
            }
        }

        public long getNChunks() {
            if (!this.isChunked) {
                return 1L;
            }
            if (this.chunked == null) {
                return 1L;
            }
            long elementsPerChunk = 1L;
            for (long c : this.chunked) {
                elementsPerChunk *= c;
            }
            return this.vs.getSize() / elementsPerChunk;
        }

        public long getOverHang() {
            if (!this.isChunked) {
                return 0L;
            }
            if (this.chunked == null) {
                return 0L;
            }
            int[] shape = this.vs.getShape();
            long total = 1L;
            for (int i = 0; i < this.chunked.length; ++i) {
                int overhang = (int)((long)shape[i] % this.chunked[i]);
                total *= (long)overhang;
            }
            return total;
        }

        public String getOHPercent() {
            if (!this.isChunked) {
                return "";
            }
            if (this.chunked == null) {
                return "";
            }
            long total = this.getOverHang();
            float p = 100.0f * (float)total / (float)this.vs.getSize();
            Formatter f = new Formatter();
            f.format("%6.3f", Float.valueOf(p));
            return f.toString();
        }

        public String getChunkSize() {
            if (this.chunked == null) {
                return "";
            }
            Formatter f = new Formatter();
            f.format("(", new Object[0]);
            for (int i = 0; i < this.chunked.length; ++i) {
                f.format("%d", this.chunked[i]);
                if (i >= this.chunked.length - 1) continue;
                f.format(",", new Object[0]);
            }
            f.format(")", new Object[0]);
            return f.toString();
        }

        public void setChunkSize(String chunkSize) {
            StringTokenizer stoke = new StringTokenizer(chunkSize, "(), ");
            this.chunked = new long[stoke.countTokens()];
            int count = 0;
            while (stoke.hasMoreTokens()) {
                this.chunked[count++] = Long.parseLong(stoke.nextToken());
            }
        }

        public void setChunkArray(long[] chunked) {
            this.chunked = chunked;
            this.isChunked = chunked != null;
        }
    }

    public class DimensionBean {
        Dimension ds;

        public DimensionBean() {
        }

        public DimensionBean(Dimension ds) {
            this.ds = ds;
        }

        public String editableProperties() {
            return "unlimited";
        }

        public String getName() {
            return this.ds.getShortName();
        }

        public int getLength() {
            return this.ds.getLength();
        }

        public boolean isUnlimited() {
            return this.ds.isUnlimited();
        }

        public void setUnlimited(boolean unlimited) {
            this.ds.setUnlimited(unlimited);
        }
    }

    public static class BeanChunker
    implements Nc4Chunking {
        Map<String, VariableBean> map;
        int deflate;
        boolean shuffle;

        BeanChunker(List<VariableBean> beans, int deflate, boolean shuffle) {
            this.map = new HashMap<String, VariableBean>(2 * beans.size());
            for (VariableBean bean : beans) {
                this.map.put(bean.vs.getFullName(), bean);
            }
            this.deflate = deflate;
            this.shuffle = shuffle;
        }

        @Override
        public boolean isChunked(Variable v) {
            VariableBean bean = this.map.get(v.getFullName());
            return bean != null && bean.isChunked();
        }

        @Override
        public long[] computeChunking(Variable v) {
            VariableBean bean = this.map.get(v.getFullName());
            return bean == null ? new long[]{} : bean.chunked;
        }

        @Override
        public int getDeflateLevel(Variable v) {
            return this.deflate;
        }

        @Override
        public boolean isShuffle(Variable v) {
            return this.shuffle;
        }
    }

    private class NestedTable {
        int level;
        PreferencesExt myPrefs;
        BeanTable table;
        JSplitPane split = null;
        int splitPos = 100;
        boolean isShowing = false;

        NestedTable(int level) {
            this.level = level;
            this.myPrefs = (PreferencesExt)DatasetWriter.this.prefs.node("NestedTable" + level);
            this.table = new BeanTable<VariableBean>(VariableBean.class, this.myPrefs, false, "Variables", null, new VariableBean());
            JTable jtable = this.table.getJTable();
            PopupMenu csPopup = new PopupMenu(jtable, "Options");
            csPopup.addAction("Show Declaration", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatasetWriter.this.showDeclaration(NestedTable.this.table, false);
                }
            });
            csPopup.addAction("Show NcML", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatasetWriter.this.showDeclaration(NestedTable.this.table, true);
                }
            });
            if (level == 0) {
                csPopup.addAction("Data Table", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DatasetWriter.this.dataTable(NestedTable.this.table);
                    }
                });
            }
            this.table.addListSelectionListener(e -> {
                Variable v = DatasetWriter.this.getCurrentVariable(this.table);
                if (v instanceof Structure) {
                    DatasetWriter.this.hideNestedTable(this.level + 2);
                    DatasetWriter.this.setNestedTable(this.level + 1, (Structure)v);
                } else {
                    DatasetWriter.this.hideNestedTable(this.level + 1);
                }
            });
            if (DatasetWriter.this.currentComponent == null) {
                DatasetWriter.this.currentComponent = this.table;
                DatasetWriter.this.tablePanel.add((Component)DatasetWriter.this.currentComponent, "Center");
                this.isShowing = true;
            } else {
                this.split = new JSplitPane(0, false, DatasetWriter.this.currentComponent, this.table);
                this.splitPos = this.myPrefs.getInt("splitPos" + level, 500);
                if (this.splitPos > 0) {
                    this.split.setDividerLocation(this.splitPos);
                }
                this.show();
            }
        }

        void show() {
            if (this.isShowing) {
                return;
            }
            DatasetWriter.this.tablePanel.remove(DatasetWriter.this.currentComponent);
            this.split.setLeftComponent(DatasetWriter.this.currentComponent);
            this.split.setDividerLocation(this.splitPos);
            DatasetWriter.this.currentComponent = this.split;
            DatasetWriter.this.tablePanel.add((Component)DatasetWriter.this.currentComponent, "Center");
            DatasetWriter.this.tablePanel.revalidate();
            this.isShowing = true;
        }

        void hide() {
            if (!this.isShowing) {
                return;
            }
            DatasetWriter.this.tablePanel.remove(DatasetWriter.this.currentComponent);
            if (this.split != null) {
                this.splitPos = this.split.getDividerLocation();
                DatasetWriter.this.currentComponent = (JComponent)this.split.getLeftComponent();
                DatasetWriter.this.tablePanel.add((Component)DatasetWriter.this.currentComponent, "Center");
            }
            DatasetWriter.this.tablePanel.revalidate();
            this.isShowing = false;
        }

        void setSelected(Variable vs) {
            List beans = this.table.getBeans();
            for (Object bean1 : beans) {
                VariableBean bean = (VariableBean)bean1;
                if (bean.vs != vs) continue;
                this.table.setSelectedBean(bean);
                return;
            }
        }

        void saveState() {
            this.table.saveState(false);
            if (this.split != null) {
                this.myPrefs.putInt("splitPos" + this.level, this.split.getDividerLocation());
            }
        }
    }

    class WriterTask
    extends ProgressMonitorTask
    implements CancelTask {
        NetcdfOutputChooser.Data data;

        WriterTask(NetcdfOutputChooser.Data data) {
            this.data = data;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                List<VariableBean> beans = ((NestedTable)((DatasetWriter)DatasetWriter.this).nestedTableList.get((int)0)).table.getBeans();
                BeanChunker bc = new BeanChunker(beans, this.data.deflate, this.data.shuffle);
                FileWriter2 writer = new FileWriter2(DatasetWriter.this.ds, this.data.outputFilename, this.data.version, bc);
                double start = System.nanoTime();
                try (NetcdfFile result = writer.write(this);){
                    result.close();
                }
                double took = ((double)System.nanoTime() - start) / 1000.0 / 1000.0 / 1000.0;
                File oldFile = new File(DatasetWriter.this.ds.getLocation());
                File newFile = new File(this.data.outputFilename);
                double r = (double)newFile.length() / (double)oldFile.length();
                logger.debug("Rewrite from {} {} to {} {} version = {} ratio = {} took= {} secs", new Object[]{DatasetWriter.this.ds.getLocation(), oldFile.length(), this.data.outputFilename, newFile.length(), this.data.version, r, took});
                JOptionPane.showMessageDialog(DatasetWriter.this, "File successfully written took=" + took + " secs ratio=" + r);
            }
            catch (Exception ioe) {
                try {
                    JOptionPane.showMessageDialog(DatasetWriter.this, "ERROR: " + ioe.getMessage());
                    ioe.printStackTrace();
                }
                catch (Throwable throwable) {
                    this.success = !this.cancel && !this.isError();
                    this.done = true;
                    throw throwable;
                }
                this.success = !this.cancel && !this.isError();
                this.done = true;
            }
            this.success = !this.cancel && !this.isError();
            this.done = true;
        }
    }
}

