/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.nio.channels.FileChannel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.IsMissingEvaluator;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ParsedSectionSpec;
import ucar.nc2.Variable;
import ucar.nc2.dt.image.image.ImageArrayAdapter;
import ucar.nc2.ui.image.ImageViewPanel;
import ucar.nc2.util.CancelTask;
import ucar.ui.prefs.ComboBox;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.FileManager;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.ProgressMonitorTask;
import ucar.ui.widget.StopButton;
import ucar.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;

public class NCdumpPane
extends TextHistoryPane {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String ImageViewer_WindowSize = "ImageViewer_WindowSize";
    private PreferencesExt prefs;
    private ComboBox<String> cb;
    private CommonTask task;
    private StopButton stopButton;
    private FileManager fileChooser;
    private NetcdfFile ds;
    private IndependentWindow imageWindow;
    private ImageViewPanel imageView;

    public NCdumpPane(PreferencesExt prefs) {
        super(true);
        this.prefs = prefs;
        this.fileChooser = new FileManager(null, null, null, (PreferencesExt)prefs.node("FileManager"));
        this.cb = new ComboBox(prefs);
        JButton getButton = new JButton("NCdump");
        getButton.setToolTipText("show selected data values");
        getButton.addActionListener(e -> this.ncdump((String)this.cb.getSelectedItem()));
        JButton imageButton = new JButton("Image");
        imageButton.setToolTipText("view selected data as Image");
        imageButton.addActionListener(e -> this.showImage((String)this.cb.getSelectedItem()));
        JButton binButton = new JButton("Write");
        binButton.setToolTipText("write binary data to file");
        binButton.addActionListener(e -> {
            String binaryFilePath = this.fileChooser.chooseFilenameToSave("data.bin");
            if (binaryFilePath != null) {
                this.writeBinaryData((String)this.cb.getSelectedItem(), new File(binaryFilePath));
            }
        });
        this.stopButton = new StopButton("stop NCdump");
        this.stopButton.addActionListener(e -> {
            this.ta.setText(this.task.v.toString());
            this.ta.append("\n data:\n");
            this.ta.append(this.task.contents);
            if (e.getActionCommand().equals("success")) {
                this.cb.setSelectedItem(this.task.command);
            }
        });
        JPanel buttPanel = new JPanel(new FlowLayout(0, 5, 0));
        buttPanel.add(getButton);
        buttPanel.add(imageButton);
        buttPanel.add(binButton);
        buttPanel.add(this.stopButton);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)new JLabel("Variable:"), "West");
        topPanel.add(this.cb, "Center");
        topPanel.add((Component)buttPanel, "East");
        this.add((Component)topPanel, "North");
    }

    public void setContext(NetcdfFile ds, String command) {
        this.ds = ds;
        this.cb.addItem(command);
    }

    private void ncdump(String command) {
        if (this.ds == null) {
            return;
        }
        if (command == null) {
            return;
        }
        this.task = new NCdumpTask(command);
        if (this.task.v != null) {
            this.stopButton.startProgressMonitorTask(this.task);
        }
    }

    private void showImage(String command) {
        if (this.ds == null) {
            return;
        }
        if (command == null) {
            return;
        }
        if (this.imageWindow == null) {
            this.makeImageViewer();
        }
        this.task = new GetContentsTask(command);
        if (this.task.v != null) {
            this.stopButton.startProgressMonitorTask(this.task);
        }
    }

    private void writeBinaryData(String variableSection, File name) {
        ParsedSectionSpec cer;
        try {
            cer = ParsedSectionSpec.parseVariableSection(this.ds, variableSection);
            if (cer.child != null) {
                return;
            }
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            return;
        }
        if (name == null) {
            return;
        }
        try (FileOutputStream stream = new FileOutputStream(name);){
            FileChannel channel = stream.getChannel();
            cer.v.readToByteChannel(cer.section, channel);
            System.out.printf("Write ok to %s%n", name);
        }
        catch (IOException | InvalidRangeException e) {
            e.printStackTrace();
        }
    }

    private void makeImageViewer() {
        this.imageWindow = new IndependentWindow("Image Viewer", BAMutil.getImage("nj22/ImageData"));
        this.imageView = new ImageViewPanel(null);
        this.imageWindow.setComponent(new JScrollPane(this.imageView));
        Rectangle b = (Rectangle)this.prefs.getBean(ImageViewer_WindowSize, new Rectangle(99, 33, 700, 900));
        this.imageWindow.setBounds(b);
    }

    public void save() {
        this.cb.save();
        this.fileChooser.save();
        if (this.imageWindow != null) {
            this.prefs.putBeanObject(ImageViewer_WindowSize, this.imageWindow.getBounds());
        }
    }

    @Override
    public void clear() {
        this.ta.setText(null);
    }

    @Override
    public String getText() {
        return this.ta.getText();
    }

    @Override
    public void gotoTop() {
        this.ta.setCaretPosition(0);
    }

    @Override
    public void setText(String text) {
        this.ta.setText(text);
    }

    private class NCdumpTask
    extends CommonTask {
        NCdumpTask(String command) {
            super(command);
        }

        @Override
        public void run() {
            try {
                this.data = NCdumpPane.this.ds.readSection(this.command);
                this.contents = NCdumpW.toString(this.data, null, this);
            }
            catch (Exception e) {
                e.printStackTrace();
                StringWriter sw = new StringWriter(100000);
                e.printStackTrace(new PrintWriter(sw));
                this.contents = sw.toString();
                this.setError(e.getMessage());
                this.done = true;
                return;
            }
            if (this.cancel) {
                this.contents = "\n***Cancelled by User";
            }
            this.success = !this.cancel;
            this.done = true;
        }
    }

    private class GetContentsTask
    extends CommonTask {
        GetContentsTask(String command) {
            super(command);
        }

        @Override
        public void run() {
            StringWriter sw = new StringWriter(100000);
            PrintWriter ps = new PrintWriter(sw);
            try {
                this.data = NCdumpPane.this.ds.readSection(this.command);
                if (this.data != null) {
                    NCdumpPane.this.imageView.setImage(ImageArrayAdapter.makeGrayscaleImage(((NCdumpPane)NCdumpPane.this).task.data, this.eval));
                    NCdumpPane.this.imageWindow.show();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                e.printStackTrace(new PrintWriter(sw));
                this.contents = sw.toString();
                this.setError(e.getMessage());
                this.done = true;
                return;
            }
            if (this.cancel) {
                ps.println("\n***Cancelled by User");
            }
            this.contents = sw.toString();
            this.success = !this.cancel;
            this.done = true;
        }
    }

    private abstract class CommonTask
    extends ProgressMonitorTask
    implements CancelTask {
        String contents;
        String command;
        Variable v;
        Array data;
        IsMissingEvaluator eval;

        CommonTask(String command) {
            this.command = command;
            try {
                ParsedSectionSpec cer = ParsedSectionSpec.parseVariableSection(NCdumpPane.this.ds, command);
                while (cer != null) {
                    this.v = cer.v;
                    cer = cer.child;
                }
                if (this.v instanceof IsMissingEvaluator) {
                    this.eval = (IsMissingEvaluator)((Object)this.v);
                }
            }
            catch (Exception e) {
                NCdumpPane.this.ta.setText(e.getMessage());
            }
        }
    }
}

