/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.apache.xmlbeans.XmlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.StructureData;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.DsgFeatureCollection;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.ProfileFeatureCollection;
import ucar.nc2.ft.StationProfileFeature;
import ucar.nc2.ft.StationProfileFeatureCollection;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.TrajectoryFeature;
import ucar.nc2.ft.TrajectoryFeatureCollection;
import ucar.nc2.ft.TrajectoryProfileFeature;
import ucar.nc2.ft.TrajectoryProfileFeatureCollection;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.writer.CFPointWriter;
import ucar.nc2.ogc.MarshallingUtil;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.ui.StructureTable;
import ucar.nc2.ui.dialog.NetcdfOutputChooser;
import ucar.nc2.ui.point.PointController;
import ucar.nc2.ui.point.StationRegionDateChooser;
import ucar.nc2.units.DateRange;
import ucar.ui.prefs.BeanTable;
import ucar.ui.util.Resource;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.IndependentDialog;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.TextHistoryPane;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;
import ucar.util.prefs.PreferencesExt;

public class PointFeatureDatasetViewer
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PreferencesExt prefs;
    private DsgFeatureCollection selectedCollection;
    private FeatureType selectedType;
    private BeanTable fcTable;
    private BeanTable profileTable;
    private BeanTable stnTable;
    private BeanTable stnProfileTable;
    private JPanel changingPane = new JPanel(new BorderLayout());
    private StationRegionDateChooser stationMap;
    private StructureTable obsTable;
    private JSplitPane splitFeatures;
    private JSplitPane splitMap;
    private JSplitPane splitObs;
    private IndependentDialog infoWindow;
    private TextHistoryPane infoTA;
    private PointController pointController;
    private NetcdfOutputChooser outChooser;
    private FeatureDatasetPoint pfDataset;
    private boolean eventsOK = true;
    private int maxCount = Integer.MAX_VALUE;

    public PointFeatureDatasetViewer(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentDialog(null, true, "Station Information", this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.stationMap = new StationRegionDateChooser();
        this.stationMap.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("Station")) {
                    StationBean selectedStation = (StationBean)e.getNewValue();
                    log.debug("selectedStation= {}", (Object)selectedStation.getName());
                    PointFeatureDatasetViewer.this.eventsOK = false;
                    PointFeatureDatasetViewer.this.stnTable.setSelectedBean(selectedStation);
                    PointFeatureDatasetViewer.this.eventsOK = true;
                }
            }
        });
        AbstractAction queryAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PointFeatureDatasetViewer.this.selectedCollection == null) {
                    return;
                }
                DateRange dateRange = PointFeatureDatasetViewer.this.stationMap.getDateRange();
                log.debug("date range={}", (Object)dateRange);
                LatLonRect geoRegion = null;
                StationBean selectedStation = null;
                boolean useRegion = PointFeatureDatasetViewer.this.stationMap.getGeoSelectionMode();
                if (useRegion) {
                    geoRegion = PointFeatureDatasetViewer.this.stationMap.getGeoSelectionLL();
                    log.debug("geoRegion={}", (Object)geoRegion);
                } else {
                    selectedStation = (StationBean)PointFeatureDatasetViewer.this.stationMap.getSelectedStation();
                }
                try {
                    if (selectedStation != null) {
                        PointFeatureDatasetViewer.this.setStation(selectedStation, dateRange);
                    } else if (useRegion || dateRange != null) {
                        PointFeatureDatasetViewer.this.subset(geoRegion, dateRange);
                    } else {
                        JOptionPane.showMessageDialog(null, "You must subset in space and/or time ");
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        };
        BAMutil.setActionProperties(queryAction, "nj22/Query", "query for data", false, 81, -1);
        this.stationMap.addToolbarAction(queryAction);
        AbstractAction getallAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PointFeatureDatasetViewer.this.selectedCollection == null) {
                    return;
                }
                try {
                    PointFeatureDatasetViewer.this.setObservationsAll();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        };
        BAMutil.setActionProperties(getallAction, "GetAll", "get ALL data", false, 65, -1);
        this.stationMap.addToolbarAction(getallAction);
        this.stationMap.addToolbarAction(new WaterMLConverterAction());
        AbstractAction netcdfAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PointFeatureDatasetViewer.this.pfDataset == null) {
                    return;
                }
                if (PointFeatureDatasetViewer.this.outChooser == null) {
                    PointFeatureDatasetViewer.this.outChooser = new NetcdfOutputChooser((Frame)null);
                    PointFeatureDatasetViewer.this.outChooser.addPropertyChangeListener("OK", new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            PointFeatureDatasetViewer.this.writeNetcdf((NetcdfOutputChooser.Data)evt.getNewValue());
                        }
                    });
                }
                PointFeatureDatasetViewer.this.outChooser.setOutputFilename(PointFeatureDatasetViewer.this.pfDataset.getLocation());
                PointFeatureDatasetViewer.this.outChooser.setVisible(true);
            }
        };
        BAMutil.setActionProperties(netcdfAction, "nj22/Netcdf", "Write netCDF-CF file", false, 83, -1);
        BAMutil.addActionToContainer(buttPanel, netcdfAction);
        this.fcTable = new BeanTable<FeatureCollectionBean>(FeatureCollectionBean.class, (PreferencesExt)prefs.node("FeatureCollectionBean"), false);
        this.fcTable.addListSelectionListener(e -> {
            FeatureCollectionBean fcb = (FeatureCollectionBean)this.fcTable.getSelectedBean();
            try {
                this.setFeatureCollection(fcb);
            }
            catch (Exception exc) {
                JOptionPane.showMessageDialog(null, "Error reading FeatureCollection " + fcb.fc.getName() + " error=" + exc.getMessage());
                exc.printStackTrace();
            }
        });
        new BeanContextMenu(this.fcTable);
        this.profileTable = new BeanTable<ProfileFeatureBean>(ProfileFeatureBean.class, (PreferencesExt)prefs.node("ProfileFeatureBean"), false);
        this.profileTable.addListSelectionListener(e -> {
            ProfileFeatureBean sb = (ProfileFeatureBean)this.profileTable.getSelectedBean();
            try {
                this.setProfile(sb);
                this.profileTable.fireBeanDataChanged(sb);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        });
        new BeanContextMenu(this.profileTable);
        this.stnTable = new BeanTable<StationBean>(StationBean.class, (PreferencesExt)prefs.node("StationBeans"), false);
        this.stnTable.addListSelectionListener(e -> {
            StationBean sb = (StationBean)this.stnTable.getSelectedBean();
            try {
                this.setStation(sb, null);
                this.stnTable.fireBeanDataChanged(sb);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            if (this.eventsOK) {
                this.stationMap.setSelectedStation(sb.getName());
            }
        });
        new BeanContextMenu(this.stnTable);
        this.stnProfileTable = new BeanTable<StnProfileFeatureBean>(StnProfileFeatureBean.class, (PreferencesExt)prefs.node("StnProfileFeatureBean"), false);
        this.stnProfileTable.addListSelectionListener(e -> {
            StnProfileFeatureBean sb = (StnProfileFeatureBean)this.stnProfileTable.getSelectedBean();
            try {
                this.setStnProfile(sb);
                this.stnProfileTable.fireBeanDataChanged(sb);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        });
        new BeanContextMenu(this.stnProfileTable);
        this.pointController = new PointController();
        this.obsTable = new StructureTable((PreferencesExt)prefs.node("ObsBean"));
        this.splitFeatures = new JSplitPane(0, false, this.fcTable, this.changingPane);
        this.splitFeatures.setDividerLocation(prefs.getInt("splitPosF", 50));
        this.splitMap = new JSplitPane(1, false, this.splitFeatures, this.stationMap);
        this.splitMap.setDividerLocation(prefs.getInt("splitPosM", 400));
        this.splitObs = new JSplitPane(0, false, this.splitMap, this.obsTable);
        this.splitObs.setDividerLocation(prefs.getInt("splitPosO", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitObs, "Center");
    }

    public void clear() {
        this.fcTable.clearBeans();
        this.stnTable.clearBeans();
        this.profileTable.clearBeans();
        this.stnProfileTable.clearBeans();
        this.infoTA.clear();
        this.stationMap.setStations(new ArrayList());
        this.obsTable.clear();
        this.selectedCollection = null;
    }

    public void save() {
        this.fcTable.saveState(false);
        this.stnTable.saveState(false);
        this.profileTable.saveState(false);
        this.stnProfileTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putInt("splitPosO", this.splitObs.getDividerLocation());
        this.prefs.putInt("splitPosF", this.splitFeatures.getDividerLocation());
        this.prefs.putInt("splitPosM", this.splitMap.getDividerLocation());
        this.obsTable.saveState();
    }

    private void writeNetcdf(NetcdfOutputChooser.Data data) {
        if (data.version == NetcdfFileWriter.Version.ncstream) {
            return;
        }
        try {
            int count = CFPointWriter.writeFeatureCollection(this.pfDataset, data.outputFilename, data.version);
            JOptionPane.showMessageDialog(this, count + " records written");
        }
        catch (Exception ioe) {
            JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
            ioe.printStackTrace();
        }
    }

    public void setDataset(FeatureDatasetPoint dataset) {
        LatLonRect bb;
        this.pfDataset = dataset;
        this.clear();
        ArrayList<FeatureCollectionBean> fcBeans = new ArrayList<FeatureCollectionBean>();
        for (DsgFeatureCollection fc : dataset.getPointFeatureCollectionList()) {
            fcBeans.add(new FeatureCollectionBean(fc));
        }
        if (fcBeans.size() == 0) {
            JOptionPane.showMessageDialog(null, "No PointFeatureCollections found that could be displayed");
        }
        this.fcTable.setBeans(fcBeans);
        this.infoTA.clear();
        CalendarDateRange dr = dataset.getCalendarDateRange();
        if (dr != null) {
            this.stationMap.setDateRange(dr.toDateRange());
        }
        if ((bb = dataset.getBoundingBox()) != null) {
            this.stationMap.setGeoBounds(bb);
        }
    }

    private void setFeatureCollection(FeatureCollectionBean fcb) throws IOException {
        this.changingPane.removeAll();
        FeatureType ftype = fcb.fc.getCollectionFeatureType();
        switch (ftype) {
            case POINT: {
                this.changingPane.add((Component)this.pointController, "Center");
                break;
            }
            case PROFILE: {
                ProfileFeatureCollection pfc = (ProfileFeatureCollection)fcb.fc;
                this.setProfileCollection(pfc);
                this.changingPane.add((Component)this.stnTable, "Center");
                break;
            }
            case STATION: {
                this.setStations(((StationTimeSeriesFeatureCollection)fcb.fc).getStationFeatures());
                this.changingPane.add((Component)this.stnTable, "Center");
                break;
            }
            case STATION_PROFILE: {
                this.setStations(((StationProfileFeatureCollection)fcb.fc).getStationFeatures());
                JSplitPane splitExtra = new JSplitPane(0, false, this.stnTable, this.stnProfileTable);
                splitExtra.setDividerLocation(this.changingPane.getHeight() / 2);
                this.changingPane.add((Component)splitExtra, "Center");
                break;
            }
            case TRAJECTORY: {
                TrajectoryFeatureCollection pfc = (TrajectoryFeatureCollection)fcb.fc;
                this.setTrajectoryCollection(pfc);
                this.changingPane.add((Component)this.stnTable, "Center");
                break;
            }
            case TRAJECTORY_PROFILE: {
                TrajectoryProfileFeatureCollection pfc = (TrajectoryProfileFeatureCollection)fcb.fc;
                this.setSectionCollection(pfc);
                JSplitPane splitExtra = new JSplitPane(0, false, this.stnTable, this.profileTable);
                splitExtra.setDividerLocation(this.changingPane.getHeight() / 2);
                this.changingPane.add((Component)splitExtra, "Center");
                break;
            }
        }
        this.selectedCollection = fcb.fc;
        this.selectedType = ftype;
        this.revalidate();
        this.repaint();
    }

    private void setStations(List<StationFeature> stations) {
        ArrayList<StationBean> stationBeans = new ArrayList<StationBean>();
        try {
            for (Station station : stations) {
                stationBeans.add(new StationBean(station));
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
        this.stnTable.setBeans(stationBeans);
        this.stationMap.setStations(stationBeans);
        this.obsTable.clear();
    }

    private void setPointCollection(PointFeatureCollection pointCollection) throws IOException {
        ArrayList<PointObsBean> pointBeans = new ArrayList<PointObsBean>();
        int count = 0;
        try (PointFeatureIterator iter = pointCollection.getPointFeatureIterator();){
            while (iter.hasNext() && count++ < this.maxCount) {
                PointFeature pob = iter.next();
                pointBeans.add(new PointObsBean(count++, pob));
            }
        }
        this.stnTable.setBeans(pointBeans);
        this.stationMap.setStations(pointBeans);
        this.stnTable.clearSelectedCells();
    }

    private void setProfileCollection(ProfileFeatureCollection profileCollection) throws IOException {
        ArrayList<ProfileFeatureBean> beans = new ArrayList<ProfileFeatureBean>();
        for (ProfileFeature profile : profileCollection) {
            ProfileFeatureBean bean = new ProfileFeatureBean(profile);
            if (bean.pf == null) continue;
            beans.add(bean);
        }
        this.stnTable.setBeans(beans);
        this.stationMap.setStations(beans);
        this.stnTable.clearSelectedCells();
    }

    private void setTrajectoryCollection(TrajectoryFeatureCollection trajCollection) throws IOException {
        ArrayList<TrajectoryFeatureBean> beans = new ArrayList<TrajectoryFeatureBean>();
        for (TrajectoryFeature traj : trajCollection) {
            TrajectoryFeatureBean trajBean = new TrajectoryFeatureBean(traj);
            if (trajBean.pf == null) continue;
            beans.add(trajBean);
        }
        this.stnTable.setBeans(beans);
        this.stationMap.setStations(beans);
        this.stnTable.clearSelectedCells();
    }

    private void setSectionCollection(TrajectoryProfileFeatureCollection sectionCollection) throws IOException {
        ArrayList<SectionFeatureBean> beans = new ArrayList<SectionFeatureBean>();
        for (TrajectoryProfileFeature sectionFeature : sectionCollection) {
            SectionFeatureBean bean = new SectionFeatureBean(sectionFeature);
            if (bean.pf == null) continue;
            beans.add(bean);
        }
        this.stnTable.setBeans(beans);
        this.stationMap.setStations(beans);
        this.stnTable.clearSelectedCells();
    }

    private void subset(LatLonRect geoRegion, DateRange dateRange) throws IOException {
        PointFeatureCollection pc = null;
        CalendarDateRange cdr = CalendarDateRange.of(dateRange);
        if (this.selectedType == FeatureType.POINT) {
            PointFeatureCollection ptCollection = (PointFeatureCollection)this.selectedCollection;
            pc = ptCollection.subset(geoRegion, cdr);
        } else if (this.selectedType == FeatureType.STATION) {
            StationTimeSeriesFeatureCollection stationCollection = (StationTimeSeriesFeatureCollection)this.selectedCollection;
            pc = stationCollection.flatten(geoRegion, cdr);
        }
        if (null != pc) {
            this.setObservations(pc);
        }
    }

    private void setStation(StationBean sb, DateRange dr) throws IOException {
        if (this.selectedType == FeatureType.POINT) {
            PointObsBean pobsBean = (PointObsBean)sb;
            ArrayList<PointFeature> obsList = new ArrayList<PointFeature>();
            obsList.add(pobsBean.pobs);
            this.setObservations(obsList);
        } else if (this.selectedType == FeatureType.PROFILE) {
            ProfileFeatureBean profBean = (ProfileFeatureBean)sb;
            ProfileFeature feature = profBean.pfc;
            this.setObservations(feature);
            int npts = feature.size();
            if (npts >= 0) {
                sb.setNobs(npts);
            }
        } else if (this.selectedType == FeatureType.STATION) {
            StationTimeSeriesFeatureCollection stationCollection = (StationTimeSeriesFeatureCollection)this.selectedCollection;
            StationTimeSeriesFeature feature = stationCollection.getStationTimeSeriesFeature(sb.stnFeat);
            if (dr != null) {
                feature = feature.subset(CalendarDateRange.of(dr));
            }
            this.setObservations(feature);
            int npts = feature.size();
            if (npts >= 0) {
                sb.setNobs(npts);
            }
        } else if (this.selectedType == FeatureType.STATION_PROFILE) {
            StationProfileFeatureCollection stationCollection = (StationProfileFeatureCollection)this.selectedCollection;
            StationProfileFeature feature = stationCollection.getStationProfileFeature(sb.stnFeat);
            this.setStnProfileObservations(feature);
            int npts = feature.size();
            if (npts >= 0) {
                sb.setNobs(npts);
            }
        } else if (this.selectedType == FeatureType.TRAJECTORY) {
            TrajectoryFeatureBean trajBean = (TrajectoryFeatureBean)sb;
            TrajectoryFeature feature = trajBean.pfc;
            this.setObservations(feature);
            int npts = feature.size();
            if (npts >= 0) {
                sb.setNobs(npts);
            }
        } else if (this.selectedType == FeatureType.TRAJECTORY_PROFILE) {
            SectionFeatureBean sectionBean = (SectionFeatureBean)sb;
            this.setSection(sectionBean);
            TrajectoryProfileFeature feature = sectionBean.pfc;
            int npts = feature.size();
            if (npts >= 0) {
                sb.setNobs(npts);
            }
        }
    }

    private void setStnProfile(StnProfileFeatureBean sb) throws IOException {
        ProfileFeature feature = sb.pfc;
        this.setObservations(feature);
        int npts = feature.size();
        if (npts >= 0) {
            sb.setNobs(npts);
        }
    }

    private void setProfile(ProfileFeatureBean sb) throws IOException {
        ProfileFeature feature = sb.pfc;
        this.setObservations(feature);
        int npts = feature.size();
        if (npts >= 0) {
            sb.setNobs(npts);
            this.stnTable.refresh();
        }
    }

    private void setTrajectory(TrajectoryFeatureBean sb) throws IOException {
        TrajectoryFeature feature = sb.pfc;
        this.setObservations(feature);
        int npts = feature.size();
        if (npts >= 0) {
            sb.setNobs(npts);
            this.stnTable.refresh();
        }
    }

    private void setSection(SectionFeatureBean sb) throws IOException {
        TrajectoryProfileFeature feature = sb.pfc;
        this.setSectionObservations(feature);
        int npts = feature.size();
        if (npts >= 0) {
            sb.setNobs(npts);
            this.stnTable.refresh();
        }
    }

    private void setStnProfiles(List<PointFeatureCollection> pfcList) throws IOException {
        ArrayList<StnProfileFeatureBean> beans = new ArrayList<StnProfileFeatureBean>();
        for (PointFeatureCollection pfc : pfcList) {
            beans.add(new StnProfileFeatureBean((ProfileFeature)pfc));
        }
        this.stnProfileTable.setBeans(beans);
        this.obsTable.clear();
    }

    private void setSectionProfiles(List<PointFeatureCollection> pfcList) throws IOException {
        ArrayList<ProfileFeatureBean> beans = new ArrayList<ProfileFeatureBean>();
        for (PointFeatureCollection pfc : pfcList) {
            beans.add(new ProfileFeatureBean((ProfileFeature)pfc));
        }
        this.profileTable.setBeans(beans);
        this.obsTable.clear();
    }

    private void setObservationsAll() throws IOException {
        if (this.selectedType == FeatureType.POINT) {
            PointFeatureCollection pointCollection = (PointFeatureCollection)this.selectedCollection;
            this.setObservations(pointCollection);
        } else if (this.selectedType == FeatureType.STATION) {
            StationTimeSeriesFeatureCollection stationCollection = (StationTimeSeriesFeatureCollection)this.selectedCollection;
            PointFeatureCollection pfc = stationCollection.flatten(null, null);
            ArrayList<PointFeature> obsList = new ArrayList<PointFeature>();
            int count = 0;
            for (PointFeature pf : pfc) {
                if (count++ > this.maxCount) break;
                obsList.add(pf);
            }
            this.setObservations(obsList);
        } else if (this.selectedType == FeatureType.STATION_PROFILE) {
            StationProfileFeatureCollection stationCollection = (StationProfileFeatureCollection)this.selectedCollection;
            ArrayList<PointFeature> obsList = new ArrayList<PointFeature>();
            int count = 0;
            for (StationProfileFeature spf : stationCollection) {
                block2: for (ProfileFeature pf : spf) {
                    for (PointFeature f : pf) {
                        if (count++ > this.maxCount) continue block2;
                        obsList.add(f);
                    }
                }
            }
            this.setObservations(obsList);
        }
    }

    private int setObservations(PointFeatureCollection pointCollection) throws IOException {
        int count = 0;
        ArrayList<PointFeature> obsList = new ArrayList<PointFeature>();
        for (PointFeature pf : pointCollection) {
            if (count++ > this.maxCount) break;
            obsList.add(pf);
        }
        this.setObservations(obsList);
        return obsList.size();
    }

    private void setStnProfileObservations(StationProfileFeature stationProfileFeature) throws IOException {
        ArrayList<PointFeatureCollection> pfcList = new ArrayList<PointFeatureCollection>();
        for (PointFeatureCollection pfc : stationProfileFeature) {
            pfcList.add(pfc);
        }
        this.setStnProfiles(pfcList);
    }

    private void setSectionObservations(TrajectoryProfileFeature sectionFeature) throws IOException {
        ArrayList<PointFeatureCollection> pfcList = new ArrayList<PointFeatureCollection>();
        for (PointFeatureCollection pfc : sectionFeature) {
            pfcList.add(pfc);
        }
        this.setSectionProfiles(pfcList);
    }

    private void setObservations(List<PointFeature> obsList) throws IOException {
        if (obsList.size() == 0) {
            this.obsTable.clear();
            JOptionPane.showMessageDialog(null, "There are no observations for this selection");
            return;
        }
        this.obsTable.setPointFeatureData(obsList);
        this.pointController.setPointFeatures(obsList);
    }

    public PreferencesExt getPrefs() {
        return this.prefs;
    }

    public static class SectionFeatureBean
    extends StationBean {
        int npts;
        TrajectoryProfileFeature pfc;
        ProfileFeature pf;

        public SectionFeatureBean(TrajectoryProfileFeature pfc) throws IOException {
            super(pfc.getFeatureData());
            this.pfc = pfc;
            try {
                if (pfc.hasNext()) {
                    this.pf = pfc.next();
                }
            }
            catch (IOException ioe) {
                log.warn("Section empty ", ioe);
            }
            this.npts = pfc.size();
        }

        public static String hiddenProperties() {
            return "latLon description wmoId";
        }

        @Override
        public void setNobs(int npts) {
            this.npts = npts;
        }

        @Override
        public int getNobs() {
            return this.npts;
        }

        @Override
        public String getName() {
            return this.pfc.getName();
        }

        @Override
        @Nullable
        public String getDescription() {
            return null;
        }

        @Override
        @Nullable
        public String getWmoId() {
            return null;
        }

        @Override
        public double getLatitude() {
            return this.pf.getLatLon().getLatitude();
        }

        @Override
        public double getLongitude() {
            return this.pf.getLatLon().getLongitude();
        }

        @Override
        public double getAltitude() {
            return Double.NaN;
        }

        @Override
        public LatLonPoint getLatLon() {
            return this.pf.getLatLon();
        }

        @Override
        public int compareTo(Station so) {
            return this.getName().compareTo(so.getName());
        }

        @Override
        public boolean isMissing() {
            return Double.isNaN(this.getLatitude());
        }
    }

    public static class StnProfileFeatureBean
    extends FeatureBean {
        ProfileFeature pfc;
        int npts;

        public StnProfileFeatureBean(ProfileFeature pfc) throws IOException {
            super(pfc.getFeatureData());
            this.pfc = pfc;
            this.npts = pfc.size();
        }

        public String getProfileName() {
            return this.pfc.getName();
        }

        public void setNobs(int npts) {
            this.npts = npts;
        }

        public int getNobs() {
            return this.npts;
        }

        public double getLatitude() {
            return this.pfc.getLatLon().getLatitude();
        }

        public double getLongitude() {
            return this.pfc.getLatLon().getLongitude();
        }

        public CalendarDate getDate() {
            return this.pfc.getTime();
        }
    }

    public static class ProfileFeatureBean
    extends StationBean {
        int npts;
        ProfileFeature pfc;
        PointFeature pf;

        public ProfileFeatureBean(ProfileFeature pfc) throws IOException {
            super(pfc.getFeatureData());
            this.pfc = pfc;
            Iterator iterator = pfc.iterator();
            while (iterator.hasNext()) {
                PointFeature pf2;
                this.pf = pf2 = (PointFeature)iterator.next();
            }
            this.npts = pfc.size();
        }

        public static String hiddenProperties() {
            return "latLon description wmoId";
        }

        @Override
        public void setNobs(int npts) {
            this.npts = npts;
        }

        @Override
        public int getNobs() {
            return this.npts;
        }

        @Override
        public String getName() {
            return this.pfc.getName();
        }

        @Override
        @Nullable
        public String getDescription() {
            return null;
        }

        @Override
        @Nullable
        public String getWmoId() {
            return null;
        }

        @Override
        public double getLatitude() {
            return this.pf == null ? Double.NaN : this.pf.getLocation().getLatitude();
        }

        @Override
        public double getLongitude() {
            return this.pf == null ? Double.NaN : this.pf.getLocation().getLongitude();
        }

        @Override
        public double getAltitude() {
            return this.pf == null ? Double.NaN : this.pf.getLocation().getAltitude();
        }

        @Override
        @Nullable
        public LatLonPoint getLatLon() {
            return this.pf == null ? null : this.pf.getLocation().getLatLon();
        }

        @Override
        public boolean isMissing() {
            return Double.isNaN(this.getLatitude());
        }

        @Override
        public int compareTo(Station so) {
            return this.getName().compareTo(so.getName());
        }
    }

    public static class TrajectoryFeatureBean
    extends StationBean {
        int npts;
        TrajectoryFeature pfc;
        PointFeature pf;

        public TrajectoryFeatureBean(TrajectoryFeature pfc) throws IOException {
            super(pfc.getFeatureData());
            this.pfc = pfc;
            try {
                pfc.resetIteration();
                if (pfc.hasNext()) {
                    this.pf = pfc.next();
                }
            }
            catch (IOException ioe) {
                log.warn("Trajectory empty ", ioe);
            }
            this.npts = pfc.size();
        }

        public static String hiddenProperties() {
            return "latLon description wmoId";
        }

        @Override
        public void setNobs(int npts) {
            this.npts = npts;
        }

        @Override
        public int getNobs() {
            return this.npts;
        }

        @Override
        public String getName() {
            return this.pfc.getName();
        }

        @Override
        @Nullable
        public String getDescription() {
            return null;
        }

        @Override
        @Nullable
        public String getWmoId() {
            return null;
        }

        @Override
        public double getLatitude() {
            return this.pf.getLocation().getLatitude();
        }

        @Override
        public double getLongitude() {
            return this.pf.getLocation().getLongitude();
        }

        @Override
        public double getAltitude() {
            return this.pf.getLocation().getAltitude();
        }

        @Override
        public LatLonPoint getLatLon() {
            return this.pf.getLocation().getLatLon();
        }

        @Override
        public int compareTo(Station so) {
            return this.getName().compareTo(so.getName());
        }

        @Override
        public boolean isMissing() {
            return Double.isNaN(this.getLatitude());
        }
    }

    public static class PointObsBean
    extends StationBean {
        private PointFeature pobs;
        private String timeObs;
        private int id;

        public PointObsBean(int id, PointFeature obs) {
            this.id = id;
            this.pobs = obs;
            this.timeObs = obs.getObservationTimeAsCalendarDate().toString();
        }

        public static String hiddenProperties() {
            return "latLon description wmoId";
        }

        public String getTime() {
            return this.timeObs;
        }

        @Override
        public String getName() {
            return Integer.toString(this.id);
        }

        @Override
        @Nullable
        public String getDescription() {
            return null;
        }

        @Override
        @Nullable
        public String getWmoId() {
            return null;
        }

        @Override
        public double getLatitude() {
            return this.pobs.getLocation().getLatitude();
        }

        @Override
        public double getLongitude() {
            return this.pobs.getLocation().getLongitude();
        }

        @Override
        public double getAltitude() {
            return this.pobs.getLocation().getAltitude();
        }

        @Override
        public LatLonPoint getLatLon() {
            return new LatLonPointImpl(this.getLatitude(), this.getLongitude());
        }

        @Override
        public boolean isMissing() {
            return Double.isNaN(this.getLatitude()) || Double.isNaN(this.getLongitude());
        }

        @Override
        public int compareTo(Station so) {
            return this.getName().compareTo(so.getName());
        }
    }

    public static class StationBean
    extends FeatureBean
    implements Station {
        private StationFeature stnFeat;
        private int npts = -1;

        public StationBean() {
        }

        public StationBean(StructureData sdata) throws IOException {
            super(sdata);
        }

        public StationBean(Station s2) throws IOException {
            super(((StationFeature)s2).getFeatureData());
            this.stnFeat = (StationFeature)s2;
            this.npts = s2.getNobs();
        }

        public static String hiddenProperties() {
            return "latLon";
        }

        @Override
        public int getNobs() {
            return this.npts;
        }

        public void setNobs(int npts) {
            this.npts = npts;
        }

        @Override
        public String getWmoId() {
            return this.stnFeat.getWmoId();
        }

        @Override
        public String getName() {
            return this.stnFeat.getName();
        }

        @Override
        public String getDescription() {
            return this.stnFeat.getDescription();
        }

        @Override
        public double getLatitude() {
            return this.stnFeat.getLatitude();
        }

        @Override
        public double getLongitude() {
            return this.stnFeat.getLongitude();
        }

        @Override
        public double getAltitude() {
            return this.stnFeat.getAltitude();
        }

        @Override
        public LatLonPoint getLatLon() {
            return this.stnFeat.getLatLon();
        }

        @Override
        public boolean isMissing() {
            return this.stnFeat.isMissing();
        }

        @Override
        public int compareTo(Station so) {
            return this.getName().compareTo(so.getName());
        }
    }

    public static class FeatureBean {
        StructureData sdata;
        String fields;

        public FeatureBean() {
        }

        FeatureBean(StructureData sdata) throws IOException {
            this.sdata = sdata;
            this.fields = NCdumpW.toString(sdata);
        }

        public String getFields() {
            return this.fields;
        }

        public String showFields() {
            StringWriter sw = new StringWriter(10000);
            try {
                NCdumpW.printStructureData(new PrintWriter(sw), this.sdata);
            }
            catch (IOException e) {
                e.printStackTrace(new PrintWriter(sw));
            }
            return sw.toString();
        }
    }

    public static class FeatureCollectionBean {
        DsgFeatureCollection fc;

        public FeatureCollectionBean(DsgFeatureCollection fc) {
            this.fc = fc;
        }

        public String getName() {
            return this.fc.getName();
        }

        public String getFeatureType() {
            return this.fc.getCollectionFeatureType().toString();
        }
    }

    private class WaterMLConverterAction
    extends AbstractAction {
        private WaterMLConverterAction() {
            this.putValue("Name", "WaterML 2.0 Writer");
            this.putValue("SmallIcon", Resource.getIcon(BAMutil.getResourcePath() + "nj22/drop_24.png", true));
            this.putValue("ShortDescription", "Write timeseries as an OGC WaterML v2.0 document.");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PointFeatureDatasetViewer.this.pfDataset == null) {
                return;
            }
            if (!PointFeatureDatasetViewer.this.pfDataset.getFeatureType().equals((Object)FeatureType.STATION)) {
                PointFeatureDatasetViewer parentComponent = PointFeatureDatasetViewer.this;
                String message = "Currently, only the STATION feature type is supported, not " + (Object)((Object)PointFeatureDatasetViewer.this.pfDataset.getFeatureType());
                String title = "Invalid feature type";
                boolean messageType = false;
                JOptionPane.showMessageDialog(parentComponent, message, "Invalid feature type", 0);
                return;
            }
            try {
                ByteArrayOutputStream outStream = new ByteArrayOutputStream(5000);
                MarshallingUtil.marshalPointDataset(PointFeatureDatasetViewer.this.pfDataset, PointFeatureDatasetViewer.this.pfDataset.getDataVariables(), outStream);
                PointFeatureDatasetViewer.this.infoTA.setText(outStream.toString(StandardCharsets.UTF_8.name()));
                PointFeatureDatasetViewer.this.infoTA.gotoTop();
                PointFeatureDatasetViewer.this.infoWindow.setVisible(true);
            }
            catch (IOException | XmlException ex) {
                StringWriter sw = new StringWriter(5000);
                ex.printStackTrace(new PrintWriter(sw));
                PointFeatureDatasetViewer.this.infoTA.setText(sw.toString());
                PointFeatureDatasetViewer.this.infoTA.gotoTop();
                PointFeatureDatasetViewer.this.infoWindow.setVisible(true);
            }
        }
    }

    private class BeanContextMenu
    extends PopupMenu {
        final BeanTable beanTable2;

        BeanContextMenu(BeanTable beanTable) {
            super(beanTable.getJTable(), "Options");
            this.beanTable2 = beanTable;
            this.addAction("Show Fields", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FeatureBean bean = (FeatureBean)BeanContextMenu.this.beanTable2.getSelectedBean();
                    if (bean == null) {
                        return;
                    }
                    PointFeatureDatasetViewer.this.infoTA.clear();
                    PointFeatureDatasetViewer.this.infoTA.appendLine(bean.showFields());
                    PointFeatureDatasetViewer.this.infoTA.gotoTop();
                    PointFeatureDatasetViewer.this.infoWindow.setVisible(true);
                }
            });
        }
    }
}

