/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.prefs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.annotation.Nullable;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.ToolTipManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ui.table.HidableTableColumnModel;
import ucar.ui.table.TableAligner;
import ucar.ui.table.TableAppearanceAction;
import ucar.ui.table.UndoableRowSorter;
import ucar.ui.widget.MultilineTooltip;
import ucar.util.prefs.PreferencesExt;

public class BeanTable<T>
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(BeanTable.class);
    protected Class<T> beanClass;
    protected T innerbean;
    protected PreferencesExt store;
    protected JTable jtable;
    protected JScrollPane scrollPane;
    protected ArrayList<T> beans;
    protected TableBeanModel model;
    protected boolean debug = false;
    protected boolean debugStore = false;
    protected boolean debugBean = false;
    protected boolean debugSelected = false;
    private JLabel headerLabel = null;

    public BeanTable(Class<T> bc, PreferencesExt pstore, boolean canAddDelete) {
        this(bc, pstore, canAddDelete, null, null, null);
    }

    public BeanTable(Class<T> bc, PreferencesExt pstore, String header, String tooltip, BeanInfo info) {
        this.beanClass = bc;
        this.store = pstore;
        this.beans = this.store != null ? (ArrayList)this.store.getBean("beanList", new ArrayList()) : new ArrayList();
        this.model = new TableBeanModelInfo(info);
        this.init(header, tooltip);
    }

    public BeanTable(Class<T> bc, PreferencesExt pstore, boolean canAddDelete, String header, String tooltip, T bean) {
        this.beanClass = bc;
        this.store = pstore;
        this.innerbean = bean;
        this.beans = this.store != null ? (ArrayList)this.store.getBean("beanList", new ArrayList()) : new ArrayList();
        this.model = new TableBeanModel(this.beanClass);
        this.init(header, tooltip);
        if (canAddDelete) {
            JPanel buttPanel = new JPanel();
            JButton newButton = new JButton("New");
            buttPanel.add((Component)newButton, null);
            JButton deleteButton = new JButton("Delete");
            buttPanel.add((Component)deleteButton, null);
            this.add((Component)buttPanel, "South");
            newButton.addActionListener(e -> {
                try {
                    T newbean = this.beanClass.newInstance();
                    this.addBean(newbean);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            });
            deleteButton.addActionListener(e -> {
                if (JOptionPane.showConfirmDialog(null, "Do you want to delete all selected records", "Delete Records", 0) != 0) {
                    return;
                }
                for (T o : this.getSelectedBeans()) {
                    this.beans.remove(o);
                }
                this.model.fireTableDataChanged();
            });
        }
    }

    public void setHeader(String header) {
        this.headerLabel.setText(header);
    }

    private void init(String header, String tooltip) {
        HidableTableColumnModel tcm = new HidableTableColumnModel(this.model);
        this.jtable = new JTable(this.model, tcm);
        this.jtable.setRowSorter(new UndoableRowSorter<TableBeanModel>(this.model));
        this.jtable.setDefaultRenderer(Date.class, new DateRenderer());
        ToolTipManager.sharedInstance().registerComponent(this.jtable);
        this.restoreState();
        this.jtable.setDefaultEditor(String.class, new DefaultCellEditor(new JTextField()));
        this.jtable.setDefaultEditor(Boolean.class, new DefaultCellEditor(new JCheckBox()));
        ((JComponent)((Object)this.jtable.getDefaultRenderer(Boolean.class))).setOpaque(true);
        TableAligner aligner = new TableAligner(this.jtable, 10);
        this.jtable.getColumnModel().addColumnModelListener(aligner);
        JButton cornerButton = new JButton(new TableAppearanceAction(this.jtable));
        cornerButton.setHideActionText(true);
        cornerButton.setContentAreaFilled(false);
        this.scrollPane = new JScrollPane(this.jtable);
        this.scrollPane.setCorner("UPPER_RIGHT_CORNER", cornerButton);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setColumnHeaderView(new JViewport());
        this.scrollPane.getColumnHeader().setPreferredSize(this.jtable.getTableHeader().getPreferredSize());
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        if (header != null) {
            if (tooltip != null) {
                this.headerLabel = new JLabel(header, 0){

                    @Override
                    public JToolTip createToolTip() {
                        return new MultilineTooltip();
                    }
                };
                this.headerLabel.setToolTipText(tooltip);
            } else {
                this.headerLabel = new JLabel(header, 0);
            }
            this.add((Component)this.headerLabel, "North");
        }
        this.listenerList = new EventListenerList();
        ListSelectionModel rowSM = this.jtable.getSelectionModel();
        rowSM.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                this.fireEvent(e);
            }
        });
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        String text = super.getToolTipText(event);
        System.out.println("BeanTable tooltip " + text);
        return text;
    }

    public void setProperty(String propertyName, String displayName, String toolTipText) {
        this.model.setProperty(propertyName, displayName, toolTipText);
    }

    public void setPropertyEditable(String propertyName, boolean isHidden) {
    }

    public void setPropertyHidden(String propertyName, boolean isHidden) {
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.listenerList.add(ListSelectionListener.class, l);
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.listenerList.remove(ListSelectionListener.class, l);
    }

    private void fireEvent(ListSelectionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((ListSelectionListener)listeners[i + 1]).valueChanged(event);
        }
    }

    @Nullable
    public T getSelectedBean() {
        int viewRowIndex = this.jtable.getSelectedRow();
        if (viewRowIndex < 0) {
            return null;
        }
        int modelRowIndex = this.jtable.convertRowIndexToModel(viewRowIndex);
        return modelRowIndex < 0 || modelRowIndex >= this.beans.size() ? null : (T)this.beans.get(modelRowIndex);
    }

    public List<T> getSelectedBeans() {
        int[] viewRowIndices;
        ArrayList<T> list = new ArrayList<T>();
        for (int viewRowIndex : viewRowIndices = this.jtable.getSelectedRows()) {
            int modelRowIndex = this.jtable.convertRowIndexToModel(viewRowIndex);
            list.add(this.beans.get(modelRowIndex));
            if (!this.debugSelected) continue;
            System.out.println(" bean selected= " + modelRowIndex + " " + this.beans.get(modelRowIndex));
        }
        return list;
    }

    public ArrayList<Object> getSelectedCells() {
        ArrayList<Object> list = new ArrayList<Object>();
        int[] viewRowIndices = this.jtable.getSelectedRows();
        int[] viewColumnIndices = this.jtable.getSelectedColumns();
        for (int viewRowIndex : viewRowIndices) {
            for (int viewColumnIndex : viewColumnIndices) {
                int modelRowIndex = this.jtable.convertRowIndexToModel(viewRowIndex);
                int modelColumnIndex = this.jtable.convertColumnIndexToModel(viewColumnIndex);
                list.add(this.model.getValueAt(modelRowIndex, modelColumnIndex));
            }
        }
        return list;
    }

    public void clearSelectedCells() {
        int[] viewRowIndices = this.jtable.getSelectedRows();
        int[] viewColumnIndices = this.jtable.getSelectedColumns();
        TableColumnModel tcm = this.jtable.getColumnModel();
        for (int viewColumnIndex : viewColumnIndices) {
            TableColumn tc = tcm.getColumn(viewColumnIndex);
            int modelColumnIndex = tc.getModelIndex();
            Class<?> colClass = this.jtable.getColumnClass(viewColumnIndex);
            Object zeroValue = this.model.zeroValue(colClass);
            for (int viewRowIndex : viewRowIndices) {
                int modelRowIndex = this.jtable.convertRowIndexToModel(viewRowIndex);
                this.model.setValueAt(zeroValue, modelRowIndex, modelColumnIndex);
            }
        }
    }

    public void addBean(T bean) {
        this.beans.add(bean);
        int row = this.beans.size() - 1;
        this.model.fireTableRowsInserted(row, row);
    }

    public void addBeans(List<T> newBeans) {
        this.beans.addAll(newBeans);
        int row = this.beans.size() - 1;
        this.model.fireTableRowsInserted(row - newBeans.size(), row);
    }

    public void setBeans(List<T> beans) {
        this.beans = beans == null ? new ArrayList() : new ArrayList<T>(beans);
        this.model.fireTableDataChanged();
        this.revalidate();
    }

    public void clearBeans() {
        this.setBeans(null);
    }

    public List<T> getBeans() {
        return this.beans;
    }

    public JTable getJTable() {
        return this.jtable;
    }

    public void setFontSize(int size) {
        this.jtable.setFont(this.jtable.getFont().deriveFont((float)size));
    }

    public void setSelectionMode(int mode) {
        this.jtable.setSelectionMode(mode);
    }

    public void setSelectedBean(T bean) {
        if (bean == null) {
            return;
        }
        int modelRowIndex = this.beans.indexOf(bean);
        int viewRowIndex = this.jtable.convertRowIndexToView(modelRowIndex);
        if (viewRowIndex >= 0) {
            this.jtable.getSelectionModel().setSelectionInterval(viewRowIndex, viewRowIndex);
        }
        this.makeRowVisible(viewRowIndex);
    }

    public void clearSelection() {
        this.jtable.getSelectionModel().clearSelection();
    }

    public void setSelectedBeans(List<T> want) {
        this.jtable.getSelectionModel().clearSelection();
        for (T bean : want) {
            int modelRowIndex = this.beans.indexOf(bean);
            int viewRowIndex = this.jtable.convertRowIndexToView(modelRowIndex);
            if (viewRowIndex < 0) continue;
            this.jtable.getSelectionModel().addSelectionInterval(viewRowIndex, viewRowIndex);
        }
    }

    private void makeRowVisible(int viewRowIndex) {
        Rectangle visibleRect = this.jtable.getCellRect(viewRowIndex, 0, true);
        if (this.debugSelected) {
            System.out.println("----ensureRowIsVisible = " + visibleRect);
        }
        visibleRect.x = this.scrollPane.getViewport().getViewPosition().x;
        this.jtable.scrollRectToVisible(visibleRect);
        this.jtable.repaint();
    }

    public void refresh() {
        this.jtable.repaint();
    }

    public void setColumnSelectionAllowed(boolean b) {
        this.jtable.setColumnSelectionAllowed(b);
    }

    public void saveState(boolean saveData) {
        if (this.store == null) {
            return;
        }
        try {
            if (saveData) {
                this.store.putBeanCollection("beanList", this.beans);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<PropertyCol> propCols = new ArrayList<PropertyCol>();
        HidableTableColumnModel tableColumnModel = (HidableTableColumnModel)this.jtable.getColumnModel();
        Enumeration<TableColumn> columns = tableColumnModel.getColumns(false);
        while (columns.hasMoreElements()) {
            PropertyCol propCol = new PropertyCol();
            TableColumn column = columns.nextElement();
            propCol.setName(column.getIdentifier().toString());
            propCol.setWidth(column.getWidth());
            propCol.setVisible(tableColumnModel.isColumnVisible(column));
            propCols.add(propCol);
        }
        this.store.putBeanCollection("propertyCol", propCols);
    }

    public void fireBeanDataChanged(T bean) {
        int row = this.beans.indexOf(bean);
        if (row >= 0) {
            this.model.fireTableRowsUpdated(row, row);
        }
    }

    protected void restoreState() {
        if (this.store == null) {
            return;
        }
        ArrayList propColObjs = (ArrayList)this.store.getBean("propertyCol", new ArrayList());
        HidableTableColumnModel tableColumnModel = (HidableTableColumnModel)this.jtable.getColumnModel();
        int newViewIndex = 0;
        for (Object propColObj : propColObjs) {
            PropertyCol propCol = (PropertyCol)propColObj;
            try {
                int currentViewIndex = tableColumnModel.getColumnIndex(propCol.getName());
                TableColumn column = tableColumnModel.getColumn(currentViewIndex);
                column.setPreferredWidth(propCol.getWidth());
                tableColumnModel.moveColumn(currentViewIndex, newViewIndex);
                assert (tableColumnModel.getColumn(newViewIndex) == column) : "tableColumn wasn't successfully moved.";
                tableColumnModel.setColumnVisible(column, propCol.isVisible());
                if (!propCol.isVisible()) continue;
                ++newViewIndex;
            }
            catch (IllegalArgumentException e) {
                logger.debug(String.format("Column named \"%s\" was present in the preferences file but not the dataset.", propCol.getName()), e);
            }
        }
    }

    protected class TableBeanModelInfo
    extends TableBeanModel {
        protected TableBeanModelInfo(BeanInfo info) {
            PropertyDescriptor[] pds;
            for (PropertyDescriptor pd : pds = info.getPropertyDescriptors()) {
                if (pd.getReadMethod() == null) continue;
                this.properties.add(pd);
            }
        }
    }

    protected class TableBeanModel
    extends AbstractTableModel {
        protected List<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        private ArrayList<String> editP = null;
        private ArrayList<String> hiddenP = null;

        protected TableBeanModel() {
        }

        protected TableBeanModel(Class beanClass) {
            PropertyDescriptor[] pds;
            BeanInfo info;
            try {
                info = !beanClass.isInterface() ? Introspector.getBeanInfo(beanClass, Object.class) : Introspector.getBeanInfo(beanClass);
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
                return;
            }
            if (BeanTable.this.debugBean) {
                System.out.println("Bean " + beanClass.getName());
            }
            String editableProperties = "";
            MethodDescriptor[] mds = info.getMethodDescriptors();
            if (mds == null) {
                throw new IllegalStateException("no public methods");
            }
            for (MethodDescriptor md : mds) {
                Method m3 = md.getMethod();
                if (m3 == null || !m3.getName().equals("editableProperties")) continue;
                try {
                    editableProperties = (String)m3.invoke(null, (Object[])null);
                    if (!BeanTable.this.debugBean) continue;
                    System.out.println(" static editableProperties: " + editableProperties);
                }
                catch (Exception ee) {
                    if (BeanTable.this.innerbean != null) {
                        try {
                            editableProperties = (String)m3.invoke(BeanTable.this.innerbean, (Object[])null);
                            if (!BeanTable.this.debugBean) continue;
                            System.out.println(" editableProperties: " + editableProperties);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        continue;
                    }
                    ee.printStackTrace();
                }
            }
            String hiddenProperties = "";
            for (MethodDescriptor md : mds) {
                Method m4 = md.getMethod();
                assert (m4 != null);
                if (!m4.getName().equals("hiddenProperties")) continue;
                try {
                    hiddenProperties = (String)m4.invoke(null, (Object[])null);
                    if (!BeanTable.this.debugBean) continue;
                    System.out.println(" hiddenProperties: " + hiddenProperties);
                }
                catch (Exception ee) {
                    if (BeanTable.this.innerbean != null) {
                        try {
                            hiddenProperties = (String)m4.invoke(BeanTable.this.innerbean, (Object[])null);
                            if (!BeanTable.this.debugBean) continue;
                            System.out.println(" hiddenProperties: " + hiddenProperties);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        continue;
                    }
                    System.out.println("BeanTable: Bad hiddenProperties ");
                    ee.printStackTrace();
                }
            }
            for (PropertyDescriptor pd : pds = info.getPropertyDescriptors()) {
                if (pd.getReadMethod() == null || this.isHidden(pd, hiddenProperties)) continue;
                this.properties.add(pd);
                this.setEditable(pd, editableProperties);
            }
            if (BeanTable.this.debugBean) {
                System.out.println("Properties:");
                System.out.println("  display name  type   read()       write()         editable");
                for (PropertyDescriptor pd : pds) {
                    String displayName = pd.getDisplayName();
                    String name = pd.getName();
                    Class<?> type = pd.getPropertyType();
                    Method rm = pd.getReadMethod();
                    Method wm = pd.getWriteMethod();
                    System.out.println("  " + displayName + " " + name + " " + type.getName() + " " + rm + " " + wm + " " + pd.isPreferred());
                }
            }
        }

        public void setProperty(String propertyName, String displayName, String toolTipText) {
            PropertyDescriptor pd = this.getProperty(propertyName);
            if (pd != null) {
                if (displayName != null) {
                    pd.setDisplayName(displayName);
                    JLabel hl = (JLabel)pd.getValue("Header");
                    if (hl != null) {
                        hl.setText(displayName);
                    }
                }
                if (toolTipText != null) {
                    pd.setShortDescription(toolTipText);
                    JComponent jc = (JComponent)pd.getValue("ToolTipComp");
                    if (jc != null) {
                        jc.setToolTipText(toolTipText);
                    }
                }
            } else {
                System.out.println("BeanTable.setProperty " + BeanTable.this.beanClass.getName() + " no property named " + propertyName);
            }
        }

        @Override
        public int getRowCount() {
            return BeanTable.this.beans.size();
        }

        @Override
        public int getColumnCount() {
            return this.properties.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.properties.get(col).getDisplayName();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Object bean = BeanTable.this.beans.get(row);
            Object value = "N/A";
            PropertyDescriptor pd = this.properties.get(col);
            try {
                Method m3 = pd.getReadMethod();
                value = m3.invoke(bean, (Object[])null);
            }
            catch (Exception ee) {
                System.out.println("BeanTable: Bad getReadMethod " + row + " " + col + " " + BeanTable.this.beanClass.getName() + " " + pd.getDisplayName());
                ee.printStackTrace();
            }
            return value;
        }

        public Object getValueAt(Object bean, int col) {
            Object value = "N/A";
            try {
                Method m3 = this.properties.get(col).getReadMethod();
                value = m3.invoke(bean, (Object[])null);
            }
            catch (Exception ee) {
                System.out.println("BeanTable: Bad Bean " + bean + " " + col + " " + BeanTable.this.beanClass.getName());
                ee.printStackTrace();
            }
            return value;
        }

        public Class getColumnClass(int col) {
            return this.wrapPrimitives(this.properties.get(col).getPropertyType());
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            PropertyDescriptor pd = this.properties.get(col);
            if (!pd.isPreferred()) {
                return false;
            }
            Class<?> type = pd.getPropertyType();
            return type.isPrimitive() || type == String.class;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            Object bean = BeanTable.this.beans.get(row);
            try {
                Object[] params = new Object[]{value};
                Method m3 = this.properties.get(col).getWriteMethod();
                if (m3 != null) {
                    m3.invoke(bean, params);
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            this.fireTableCellUpdated(row, col);
        }

        protected Class wrapPrimitives(Class c) {
            if (c == Boolean.TYPE) {
                return Boolean.class;
            }
            if (c == Integer.TYPE) {
                return Integer.class;
            }
            if (c == Float.TYPE) {
                return Float.class;
            }
            if (c == Double.TYPE) {
                return Double.class;
            }
            if (c == Short.TYPE) {
                return Short.class;
            }
            if (c == Long.TYPE) {
                return Long.class;
            }
            if (c == Byte.TYPE) {
                return Byte.class;
            }
            return c;
        }

        @Nullable
        protected Object zeroValue(Class c) {
            if (c == Boolean.class) {
                return Boolean.FALSE;
            }
            if (c == Integer.class) {
                return 0;
            }
            if (c == Float.class) {
                return Float.valueOf(0.0f);
            }
            if (c == Double.class) {
                return 0.0;
            }
            if (c == Short.class) {
                return (short)0;
            }
            if (c == Long.class) {
                return 0L;
            }
            if (c == Byte.class) {
                return (byte)0;
            }
            return null;
        }

        @Nullable
        protected PropertyDescriptor getProperty(String wantName) {
            for (PropertyDescriptor property : this.properties) {
                if (!property.getName().equals(wantName)) continue;
                return property;
            }
            return null;
        }

        protected PropertyDescriptor getProperty(int idx) {
            return this.properties.get(idx);
        }

        private void setEditable(PropertyDescriptor pd, String editableProperties) {
            if (this.editP == null) {
                this.editP = new ArrayList();
                StringTokenizer toke = new StringTokenizer(editableProperties);
                while (toke.hasMoreTokens()) {
                    this.editP.add(toke.nextToken());
                }
            }
            pd.setPreferred(this.editP.contains(pd.getName()));
        }

        private boolean isHidden(PropertyDescriptor pd, String hiddenProperties) {
            if (this.hiddenP == null) {
                this.hiddenP = new ArrayList();
                StringTokenizer toke = new StringTokenizer(hiddenProperties);
                while (toke.hasMoreTokens()) {
                    this.hiddenP.add(toke.nextToken());
                }
            }
            return this.hiddenP.contains(pd.getName());
        }
    }

    static class DateRenderer
    extends DefaultTableCellRenderer {
        private SimpleDateFormat newForm;
        private SimpleDateFormat oldForm = new SimpleDateFormat("yyyy MMM dd HH:mm z");
        private Date cutoff;

        DateRenderer() {
            this.oldForm.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.newForm = new SimpleDateFormat("MMM dd, HH:mm z");
            this.newForm.setTimeZone(TimeZone.getTimeZone("GMT"));
            Calendar cal = Calendar.getInstance();
            cal.setTimeZone(TimeZone.getTimeZone("GMT"));
            cal.add(1, -1);
            this.cutoff = cal.getTime();
        }

        @Override
        public void setValue(Object value) {
            if (value == null) {
                this.setText("");
            } else {
                Date date = (Date)value;
                if (date.before(this.cutoff)) {
                    this.setText(this.oldForm.format(date));
                } else {
                    this.setText(this.newForm.format(date));
                }
            }
        }
    }

    public static class PropertyCol {
        private String name;
        private int width;
        private boolean visible = true;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }
    }
}

