/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.prefs;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import ucar.ui.widget.ActionListenerAdapter;
import ucar.ui.widget.IndependentDialog;
import ucar.util.prefs.PersistenceManager;
import ucar.util.prefs.PreferencesExt;

public class ComboBox<E>
extends JComboBox<E> {
    private static final String LIST = "ComboBoxList";
    private boolean deleting = false;
    private PersistenceManager prefs;
    private int nkeep;
    private JPopupMenu popupMenu;

    public ComboBox() {
        this(null, 20);
    }

    public ComboBox(PersistenceManager prefs) {
        this(prefs, 20);
    }

    public ComboBox(PersistenceManager prefs, int nkeep) {
        this.prefs = prefs;
        this.nkeep = nkeep;
        this.setEditable(true);
        this.setPreferences(prefs);
        this.addContextMenu();
    }

    public void addChangeListener(ActionListener successListener) {
        this.addActionListener(new ActionListenerAdapter("comboBoxChanged", successListener));
    }

    public void setPreferences(PersistenceManager prefs) {
        this.prefs = prefs;
        if (prefs != null) {
            List list = prefs.getList(LIST, null);
            this.setItemList(list);
            this.setSelectedIndex(-1);
        }
    }

    public JComponent getDeepEditComponent() {
        return (JComponent)this.getEditor().getEditorComponent();
    }

    private void addContextMenu() {
        Component editComp = this.getEditor().getEditorComponent();
        this.popupMenu = new JPopupMenu();
        editComp.addMouseListener(new PopupTriggerListener(){

            @Override
            public void showPopup(MouseEvent e) {
                ComboBox.this.popupMenu.show(ComboBox.this, e.getX(), e.getY());
            }
        });
        AbstractAction deleteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JList delComp = new JList();
                delComp.setModel(ComboBox.this.getModel());
                delComp.addListSelectionListener(e2 -> {
                    int index = delComp.getSelectedIndex();
                    ComboBox.this.deleting = true;
                    if (index >= 0) {
                        ComboBox.this.removeItemAt(index);
                    }
                    ComboBox.this.deleting = false;
                });
                IndependentDialog iw = new IndependentDialog(null, true, "delete items", delComp);
                iw.setVisible(true);
            }
        };
        deleteAction.putValue("Name", "Delete");
        this.popupMenu.add(deleteAction);
        AbstractAction deleteAllAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComboBox.this.setItemList(new ArrayList());
            }
        };
        deleteAllAction.putValue("Name", "Delete All");
        this.popupMenu.add(deleteAllAction);
    }

    @Override
    protected void fireActionEvent() {
        if (this.deleting) {
            return;
        }
        super.fireActionEvent();
    }

    @Override
    public void addItem(E item) {
        if (item == null) {
            return;
        }
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!item.equals(this.getItemAt(i))) continue;
            if (i == 0) {
                this.setSelectedIndex(0);
                return;
            }
            this.removeItemAt(i);
        }
        this.insertItemAt(item, 0);
        this.setSelectedIndex(0);
    }

    public void save() {
        if (this.prefs != null) {
            this.prefs.putList(LIST, this.getItemList());
        }
    }

    public List<E> getItemList() {
        ArrayList list = new ArrayList();
        for (int i = 0; i < this.getItemCount() && i < this.nkeep; ++i) {
            list.add(this.getItemAt(i));
        }
        return list;
    }

    public void setItemList(Collection<E> list) {
        if (list == null) {
            return;
        }
        this.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
    }

    public void setNkeep(int nkeep) {
        this.nkeep = nkeep;
    }

    public int getNkeep() {
        return this.nkeep;
    }

    protected Object getStoreValue(Object defValue) {
        if (this.prefs == null) {
            return defValue;
        }
        return ((PreferencesExt)this.prefs).getBean(LIST, defValue);
    }

    protected void setStoreValue(List<E> newValue) {
        if (this.prefs != null) {
            this.prefs.putList(LIST, newValue);
        }
    }

    private static abstract class PopupTriggerListener
    extends MouseAdapter {
        private PopupTriggerListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        public abstract void showPopup(MouseEvent var1);
    }
}

