/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.widget;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class SpinIcon
implements Icon {
    public static final Type TypeUp = new Type();
    public static final Type TypeDown = new Type();
    public static final Type TypeRight = new Type();
    public static final Type TypeLeft = new Type();
    private Type type;
    private boolean orientH;

    public SpinIcon(Type type) {
        this.type = type;
        this.orientH = type == TypeUp || type == TypeDown;
    }

    @Override
    public void paintIcon(Component c, Graphics g2, int x, int y) {
        JComponent component = (JComponent)c;
        int iconWidth = 10;
        g2.translate(x, y);
        g2.setColor(component.isEnabled() ? MetalLookAndFeel.getControlInfo() : MetalLookAndFeel.getControlShadow());
        int line = 0;
        if (this.type == TypeUp) {
            g2.drawLine(4, line, 4 + (iconWidth - 9), line);
            g2.drawLine(3, ++line, 3 + (iconWidth - 7), line);
            g2.drawLine(2, ++line, 2 + (iconWidth - 5), line);
            g2.drawLine(1, ++line, 1 + (iconWidth - 3), line);
            g2.drawLine(0, ++line, iconWidth - 1, line);
            ++line;
        } else if (this.type == TypeDown) {
            g2.drawLine(0, line, iconWidth - 1, line);
            g2.drawLine(1, ++line, 1 + (iconWidth - 3), line);
            g2.drawLine(2, ++line, 2 + (iconWidth - 5), line);
            g2.drawLine(3, ++line, 3 + (iconWidth - 7), line);
            g2.drawLine(4, ++line, 4 + (iconWidth - 9), line);
            ++line;
        } else if (this.type == TypeRight) {
            g2.drawLine(line, 0, line, iconWidth - 1);
            g2.drawLine(++line, 1, line, 1 + (iconWidth - 3));
            g2.drawLine(++line, 2, line, 2 + (iconWidth - 5));
            g2.drawLine(++line, 3, line, 3 + (iconWidth - 7));
            g2.drawLine(++line, 4, line, 4 + (iconWidth - 9));
            ++line;
        } else {
            g2.drawLine(line, 4, line, 4 + (iconWidth - 9));
            g2.drawLine(++line, 3, line, 3 + (iconWidth - 7));
            g2.drawLine(++line, 2, line, 2 + (iconWidth - 5));
            g2.drawLine(++line, 1, line, 1 + (iconWidth - 3));
            g2.drawLine(++line, 0, line, iconWidth - 1);
            ++line;
        }
        g2.translate(-x, -y);
    }

    @Override
    public int getIconWidth() {
        return this.orientH ? 10 : 5;
    }

    @Override
    public int getIconHeight() {
        return this.orientH ? 5 : 10;
    }

    public static class Type {
    }
}

