/*
 * Decompiled with CFR 0.152.
 */
package opendap.servlet.ascii;

import java.io.PrintWriter;
import java.util.Enumeration;
import opendap.dap.BaseType;
import opendap.dap.BaseTypePrimitiveVector;
import opendap.dap.DArray;
import opendap.dap.DArrayDimension;
import opendap.dap.DString;
import opendap.dap.PrimitiveVector;
import opendap.servlet.ascii.toASCII;

public class asciiArray
extends DArray
implements toASCII {
    private static boolean _Debug = false;

    public asciiArray() {
        this(null);
    }

    public asciiArray(String n) {
        super(n);
    }

    @Override
    public void toASCII(PrintWriter pw, boolean addName, String rootName, boolean newLine) {
        if (_Debug) {
            System.out.println("asciiArray.toASCII(" + addName + ",'" + rootName + "')  getName(): " + this.getEncodedName());
            System.out.println("  PrimitiveVector size = " + this.getPrimitiveVector().getLength());
        }
        if (addName) {
            pw.print("\n");
        }
        int dims = this.numDimensions();
        int[] shape = new int[dims];
        int i = 0;
        Enumeration e = this.getDimensions();
        while (e.hasMoreElements()) {
            DArrayDimension d = (DArrayDimension)e.nextElement();
            shape[i++] = d.getSize();
        }
        if (newLine) {
            pw.print("\n");
        }
    }

    @Override
    public String toASCIIFlatName(String rootName) {
        StringBuilder s2 = new StringBuilder();
        if (rootName != null) {
            s2.append(rootName);
            s2.append(".");
            s2.append(this.getEncodedName());
        } else {
            s2.append(this.getEncodedName());
        }
        String s22 = "";
        PrimitiveVector pv = this.getPrimitiveVector();
        if (pv instanceof BaseTypePrimitiveVector) {
            BaseType bt = ((BaseTypePrimitiveVector)pv).getValue(0);
            if (bt instanceof DString) {
                int dims = this.numDimensions();
                boolean i = false;
                Enumeration e = this.getDimensions();
                while (e.hasMoreElements()) {
                    DArrayDimension d = (DArrayDimension)e.nextElement();
                    s2.append("[");
                    s2.append(d.getSize());
                    s2.append("]");
                }
                s22 = s2.toString();
            } else {
                s22 = ((toASCII)((Object)bt)).toASCIIFlatName(s2.toString());
            }
        } else {
            int dims = this.numDimensions();
            boolean i = false;
            Enumeration e = this.getDimensions();
            while (e.hasMoreElements()) {
                DArrayDimension d = (DArrayDimension)e.nextElement();
                s2.append("[");
                s2.append(d.getSize());
                s2.append("]");
            }
            s22 = s2.toString();
        }
        return s22;
    }

    @Override
    public String toASCIIAddRootName(PrintWriter pw, boolean addName, String rootName) {
        if (addName) {
            rootName = this.toASCIIFlatName(rootName);
            pw.print(rootName);
        }
        return rootName;
    }

    private int asciiArray(PrintWriter os, boolean addName, String label, int index, int dims, int[] shape, int offset) {
        if (dims == 1) {
            if (addName) {
                os.print(label);
            }
            for (int i = 0; i < shape[offset]; ++i) {
                PrimitiveVector pv = this.getPrimitiveVector();
                if (pv instanceof BaseTypePrimitiveVector) {
                    BaseType bt = ((BaseTypePrimitiveVector)pv).getValue(index++);
                    if (i > 0) {
                        if (bt instanceof DString) {
                            os.print(", ");
                        } else {
                            os.println("");
                        }
                    }
                    ((toASCII)((Object)bt)).toASCII(os, false, null, false);
                    continue;
                }
                if (i > 0) {
                    os.print(", ");
                }
                pv.printSingleVal(os, index++);
            }
            if (addName) {
                os.print("\n");
            }
            return index;
        }
        for (int i = 0; i < shape[offset]; ++i) {
            StringBuilder s2 = new StringBuilder();
            s2.append(label);
            s2.append("[");
            s2.append(i);
            s2.append("]");
            if (dims - 1 == 1) {
                s2.append(", ");
            }
            index = this.asciiArray(os, addName, s2.toString(), index, dims - 1, shape, offset + 1);
        }
        return index;
    }
}

