/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.text;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import org.bounce.text.Fold;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FoldingMargin
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static final int ICON_WIDTH = 9;
    private int lineHeight = 16;
    private int start = -1;
    private int end = -1;
    private FontMetrics fontMetrics = null;
    protected JTextComponent editor = null;

    public FoldingMargin(JTextComponent editor) throws IOException {
        this.editor = editor;
        this.setBorder(new CompoundBorder(new MatteBorder(0, 0, 0, 1, UIManager.getColor("controlShadow")), new EmptyBorder(0, 1, 0, 1)));
        editor.addPropertyChangeListener("document", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Object prop = event.getNewValue();
                if (prop instanceof Document) {
                    FoldingMargin.this.init((Document)prop);
                }
            }
        });
        this.init(editor.getDocument());
        this.setBackground(UIManager.getColor("control"));
        this.setForeground(UIManager.getColor("textText"));
        this.setFont(editor.getFont());
        editor.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent evt) {
                Element e = FoldingMargin.this.editor.getDocument().getDefaultRootElement();
                FoldingMargin.this.unfold(e.getElementIndex(evt.getDot()));
                FoldingMargin.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent e) {
                FoldingMargin.this.start = -1;
                FoldingMargin.this.end = -1;
                FoldingMargin.this.repaint();
            }

            public void mouseClicked(MouseEvent e) {
                FoldingMargin.this.editor.requestFocusInWindow();
                FoldingMargin.this.toggleFold(FoldingMargin.this.getLineNumber(e.getY()));
            }
        });
        this.addMouseMotionListener(new MouseAdapter(){

            public void mouseMoved(MouseEvent e) {
                boolean update;
                int start = FoldingMargin.this.getLineNumber(e.getY());
                boolean bl = update = FoldingMargin.this.start == -1;
                if (start != FoldingMargin.this.start) {
                    Rectangle visible = FoldingMargin.this.getVisibleRect();
                    int end = FoldingMargin.this.getLastFoldLine(start, Math.min(FoldingMargin.this.getLineNumber(visible.y + visible.height) + 2, FoldingMargin.this.getLines() - 1));
                    if (end != -1) {
                        FoldingMargin.this.start = start;
                        FoldingMargin.this.end = end;
                    } else {
                        FoldingMargin.this.start = -1;
                        FoldingMargin.this.end = -1;
                    }
                    if (update) {
                        FoldingMargin.this.repaint();
                    }
                }
            }
        });
    }

    private void init(Document document) {
        document.putProperty("org.bounce.text.FoldList", new ArrayList());
        document.addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentevent) {
                FoldingMargin.this.updateFolds();
            }

            public void insertUpdate(DocumentEvent documentevent) {
                FoldingMargin.this.updateFolds();
            }

            public void removeUpdate(DocumentEvent documentevent) {
                FoldingMargin.this.updateFolds();
            }
        });
    }

    private List<Fold> getFolds() {
        List folds = (List)this.editor.getDocument().getProperty("org.bounce.text.FoldList");
        if (folds == null) {
            folds = Collections.EMPTY_LIST;
        }
        return folds;
    }

    private void toggleFold(int line) {
        if (this.isFolded(line + 1)) {
            this.unfold(line + 1);
        } else {
            int end = this.getLastFoldLine(line, this.getLines() - 1);
            if (end != -1) {
                this.fold(this.editor.getDocument().getDefaultRootElement().getElement(line), this.editor.getDocument().getDefaultRootElement().getElement(end));
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible != this.isVisible()) {
            super.setVisible(visible);
            this.cleanupFolds();
        }
    }

    private void cleanupFolds() {
        List<Fold> folds = this.getFolds();
        for (int i = 0; i < folds.size(); ++i) {
            Fold f = folds.get(i);
            f.cleanup();
        }
        folds.clear();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isVisible()) {
            return new Dimension(this.getInsets().left + 9 + this.getInsets().right, this.editor.getPreferredSize().height);
        }
        return null;
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.isVisible()) {
            return new Dimension(this.getInsets().left + 9 + this.getInsets().right, this.editor.getPreferredSize().height);
        }
        return null;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isVisible()) {
            return new Dimension(this.getInsets().left + 9 + this.getInsets().right, this.editor.getPreferredSize().height);
        }
        return null;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (font != null) {
            this.fontMetrics = this.getFontMetrics(font);
            this.lineHeight = this.fontMetrics.getHeight();
        }
    }

    private int getLineHeight() {
        return this.lineHeight;
    }

    @Override
    public void paintComponent(Graphics g2) {
        if (this.fontMetrics != null) {
            int endLine;
            int lineHeight = this.getLineHeight();
            Rectangle bounds = g2.getClipBounds();
            g2.setColor(this.getBackground());
            g2.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            g2.setColor(this.getForeground());
            int startLine = this.getLineNumber(bounds.y);
            if (startLine > 0) {
                --startLine;
            }
            if ((endLine = this.getLineNumber(bounds.y + bounds.height)) < this.getLines()) {
                ++endLine;
            }
            int line = startLine;
            while (line < endLine) {
                try {
                    int start = this.getLineStart(line);
                    if (start != -1) {
                        if (this.isFolded(line + 1)) {
                            this.drawClosedFold(g2, this.getInsets().left, start + (lineHeight - 9) / 2);
                        } else if (this.getLastFoldLine(line, Math.min(this.getLineNumber(bounds.y + this.getVisibleRect().height) + 2, this.getLines() - 1)) != -1) {
                            this.drawOpenFold(g2, this.getInsets().left, start + (lineHeight - 9) / 2);
                        } else if (line > this.start && line < this.end) {
                            this.drawLine(g2, this.getInsets().left, start);
                        } else if (line == this.end) {
                            this.drawEnd(g2, this.getInsets().left, start);
                        }
                    }
                    line = this.getNextLineNumber(line);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
        }
    }

    private void fold(Element start, Element end) {
        if (this.isVisible()) {
            List<Fold> folds = this.getFolds();
            Fold fold = new Fold(start, end);
            int startIndex = this.getNextFoldIndex(fold.getStart());
            if (startIndex != -1) {
                ArrayList<Fold> oldFolds = new ArrayList<Fold>(folds);
                for (int i = startIndex; i < oldFolds.size(); ++i) {
                    Fold f = (Fold)oldFolds.get(i);
                    if (fold.contains(f.getStart())) {
                        fold.add(f);
                        folds.remove(f);
                        continue;
                    }
                    if (f.getStart() > fold.getEnd()) break;
                }
            }
            this.addFold(fold);
            Element e = this.editor.getDocument().getDefaultRootElement();
            int index = e.getElementIndex(this.editor.getCaretPosition());
            if (this.isFolded(index)) {
                this.editor.setCaretPosition(start.getEndOffset() - 1);
            }
            this.fireFoldsUpdated();
        }
    }

    private void fireFoldsUpdated() {
        this.editor.getDocument().putProperty("org.bounce.text.FoldsUpdated", true);
        this.editor.revalidate();
        this.editor.repaint();
        this.getParent().invalidate();
        this.getParent().repaint();
    }

    private void unfold(int line) {
        Fold f;
        if (this.isVisible() && (f = this.getFold(line)) != null) {
            List<Fold> folds = this.getFolds();
            folds.remove(f);
            f.remove(line, line);
            List<Fold> children = f.getChildren();
            for (int j = 0; j < children.size(); ++j) {
                this.addFold(children.get(j));
            }
            f.shallowCleanup();
            this.fireFoldsUpdated();
        }
    }

    private Fold getFold(int line) {
        List<Fold> folds = this.getFolds();
        if (this.isVisible() && folds != null) {
            int start = 0;
            int end = folds.size() - 1;
            while (end >= start) {
                int index = (end - start) / 2 + start;
                Fold fold = folds.get(index);
                if (line >= fold.getEnd()) {
                    start = index + 1;
                    continue;
                }
                if (line <= fold.getStart()) {
                    end = index - 1;
                    continue;
                }
                return fold;
            }
        }
        return null;
    }

    private int getNextFoldIndex(int line) {
        List<Fold> folds = this.getFolds();
        if (this.isVisible() && folds != null) {
            int start = 0;
            int end = folds.size() - 1;
            Fold lastFold = null;
            int lastIndex = -1;
            while (end >= start) {
                Fold fold;
                int index = (end - start) / 2 + start;
                lastFold = fold = folds.get(index);
                lastIndex = index;
                if (line >= fold.getEnd()) {
                    start = index + 1;
                    continue;
                }
                if (line <= fold.getStart()) {
                    end = index - 1;
                    continue;
                }
                return index;
            }
            if (lastFold == null || lastFold.getStart() > line) {
                return lastIndex;
            }
            return lastIndex + 1;
        }
        return -1;
    }

    private boolean isFolded(int line) {
        return this.getFold(line) != null;
    }

    private void addFold(Fold fold) {
        List<Fold> folds = this.getFolds();
        int index = this.getNextFoldIndex(fold.getStart());
        if (index != -1 && index < folds.size()) {
            folds.add(index, fold);
            return;
        }
        folds.add(fold);
    }

    private void updateFolds() {
        if (this.isVisible()) {
            List<Fold> folds = this.getFolds();
            ArrayList<Fold> oldFolds = new ArrayList<Fold>(folds);
            for (Fold fold : oldFolds) {
                if (fold.isValid()) continue;
                fold.update();
                folds.remove(fold);
                List<Fold> children = fold.getChildren();
                for (Fold child : children) {
                    this.addFold(child);
                }
            }
        }
    }

    private int getLines() {
        return this.editor.getDocument().getDefaultRootElement().getElementCount();
    }

    private int getLineStart(int i) throws BadLocationException {
        Element line = this.editor.getDocument().getDefaultRootElement().getElement(i);
        Rectangle result = this.editor.modelToView(line.getStartOffset());
        if (result != null) {
            return result.y;
        }
        return -1;
    }

    private int getLineNumber(int y) {
        int pos = this.editor.viewToModel(new Point(0, y));
        return this.editor.getDocument().getDefaultRootElement().getElementIndex(pos);
    }

    private int getNextLineNumber(int line) throws BadLocationException {
        Fold fold;
        if ((fold = this.getFold(++line)) != null) {
            line = fold.getEnd();
        }
        return line;
    }

    private int getLastFoldLine(int start, int limit) {
        int closing = this.getFoldClosingLine(start, limit);
        if (closing > start + 1) {
            return closing;
        }
        return -1;
    }

    protected abstract int getFoldClosingLine(int var1, int var2);

    protected void drawLine(Graphics g2, int x, int y) {
        g2.drawLine(x + 4, y, x + 4, y + this.getLineHeight());
    }

    protected void drawEnd(Graphics g2, int x, int y) {
        g2.drawLine(x + 4, y, x + 4, y + this.getLineHeight() / 2);
        g2.drawLine(x + 4, y + this.getLineHeight() / 2, x + 8, y + this.getLineHeight() / 2);
    }

    protected void drawOpenFold(Graphics g2, int x, int y) {
        Polygon polygon = new Polygon();
        polygon.addPoint(0, 1);
        polygon.addPoint(8, 1);
        polygon.addPoint(8, 9);
        polygon.addPoint(0, 9);
        polygon.translate(x, y);
        g2.drawPolygon(polygon);
        g2.drawLine(x + 2, y + 5, x + 6, y + 5);
    }

    protected void drawClosedFold(Graphics g2, int x, int y) {
        Polygon polygon = new Polygon();
        polygon.addPoint(0, 1);
        polygon.addPoint(8, 1);
        polygon.addPoint(8, 9);
        polygon.addPoint(0, 9);
        polygon.translate(x, y);
        g2.drawPolygon(polygon);
        g2.drawLine(x + 2, y + 5, x + 6, y + 5);
        g2.drawLine(x + 4, y + 3, x + 4, y + 7);
    }
}

