/*
 * Decompiled with CFR 0.152.
 */
package ucar.httpservices;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import javax.annotation.concurrent.ThreadSafe;
import javax.net.ssl.HostnameVerifier;
import javax.print.attribute.UnmodifiableSetException;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.DeflateDecompressingEntity;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.entity.InputStreamFactory;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.httpservices.HTTPAuthUtil;
import ucar.httpservices.HTTPConnectionPool;
import ucar.httpservices.HTTPConnections;
import ucar.httpservices.HTTPException;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPMethod;
import ucar.httpservices.HTTPProviderFactory;
import ucar.httpservices.HTTPUtil;
import ucar.httpservices.SingleProviderFactory;

@ThreadSafe
public class HTTPSession
implements Closeable {
    public static boolean TESTING = false;
    protected static final boolean USEPOOL = true;
    public static final String HEADER_USERAGENT = "User-Agent";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    static final int DFALTREDIRECTS = 25;
    static final int DFALTCONNTIMEOUT = 60000;
    static final int DFALTCONNREQTIMEOUT = 60000;
    static final int DFALTSOTIMEOUT = 300000;
    static final int DFALTMAXCONNS = 20;
    static final int DFALTRETRIES = 1;
    static final int DFALTUNAVAILRETRIES = 1;
    static final int DFALTUNAVAILINTERVAL = 3000;
    static final String DFALTUSERAGENT = "/NetcdfJava/HttpClient4.4";
    static final String[] KNOWNCOMPRESSORS = new String[]{"gzip", "deflate"};
    static final String DCONNTIMEOUT = "tds.http.conntimeout";
    static final String DSOTIMEOUT = "tds.http.sotimeout";
    static final String DMAXCONNS = "tds.http.maxconns";
    public static final Logger log = LoggerFactory.getLogger(HTTPSession.class);
    static Map<Prop, Object> globalsettings;
    static HttpRequestRetryHandler globalretryhandler;
    static List<HttpRequestInterceptor> reqintercepts;
    static List<HttpResponseInterceptor> rspintercepts;
    protected static HttpResponseInterceptor CEKILL;
    protected static List<HttpRequestInterceptor> dbgreq;
    protected static List<HttpResponseInterceptor> dbgrsp;
    protected static HTTPConnections connmgr;
    protected static Map<String, InputStreamFactory> contentDecoderMap;
    protected static Map<AuthScope, HTTPProviderFactory> globalcredfactories;
    protected static AuthControls authcontrols;
    protected String sessionURI = null;
    protected URI scopeURI = null;
    protected AuthScope scope = null;
    protected boolean closed = false;
    protected Map<AuthScope, CredentialsProvider> localcreds = new HashMap<AuthScope, CredentialsProvider>();
    protected ConcurrentSkipListSet<HTTPMethod> methods = new ConcurrentSkipListSet();
    protected String identifier = "Session";
    protected Map<Prop, Object> localsettings = new ConcurrentHashMap<Prop, Object>();
    protected HttpClientContext sessioncontext = HttpClientContext.create();
    protected BasicAuthCache sessioncache = new BasicAuthCache();
    protected URI requestURI = null;
    protected boolean cachevalid = false;
    protected RequestConfig cachedconfig = null;
    static Set<HTTPSession> sessionList;

    protected static int getDPropInt(String key) {
        String p = System.getProperty(key);
        if (p == null) {
            return -1;
        }
        try {
            int i = Integer.parseInt(p);
            return i;
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    protected static synchronized void setDefaults(Map<Prop, Object> props) {
        props.put(Prop.HANDLE_REDIRECTS, Boolean.TRUE);
        props.put(Prop.ALLOW_CIRCULAR_REDIRECTS, Boolean.TRUE);
        props.put(Prop.MAX_REDIRECTS, 25);
        props.put(Prop.SO_TIMEOUT, 300000);
        props.put(Prop.CONN_TIMEOUT, 60000);
        props.put(Prop.CONN_REQ_TIMEOUT, 60000);
        props.put(Prop.USER_AGENT, DFALTUSERAGENT);
    }

    static void buildsslfactory(AuthControls authcontrols) {
        KeyStore keystore = (KeyStore)authcontrols.get((Object)AuthProp.KEYSTORE);
        String keypass = (String)authcontrols.get((Object)AuthProp.KEYPASSWORD);
        KeyStore truststore = (KeyStore)authcontrols.get((Object)AuthProp.TRUSTSTORE);
        HTTPSession.buildsslfactory(authcontrols, truststore, keystore, keypass);
    }

    static void buildkeystores(AuthControls authcontrols) {
        String keypath = HTTPSession.cleanproperty("keystore");
        String keypassword = HTTPSession.cleanproperty("keystorepassword");
        String trustpath = HTTPSession.cleanproperty("truststore");
        String trustpassword = HTTPSession.cleanproperty("truststorepassword");
        KeyStore truststore = HTTPSession.buildkeystore(trustpath, trustpassword);
        KeyStore keystore = HTTPSession.buildkeystore(keypath, keypassword);
        authcontrols.put(AuthProp.KEYSTORE, (Object)keystore);
        authcontrols.put(AuthProp.KEYPASSWORD, (Object)keypassword);
        authcontrols.put(AuthProp.TRUSTSTORE, (Object)truststore);
        authcontrols.put(AuthProp.TRUSTPASSWORD, (Object)trustpassword);
    }

    protected static KeyStore buildkeystore(String keypath, String keypassword) {
        KeyStore keystore;
        block15: {
            try {
                if (keypath != null && keypassword != null) {
                    keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                    try (FileInputStream instream = new FileInputStream(new File(keypath));){
                        keystore.load(instream, keypassword.toCharArray());
                        break block15;
                    }
                }
                keystore = null;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                keystore = null;
            }
        }
        return keystore;
    }

    static void buildproxy(AuthControls ac) {
        URI uri;
        String proxyurl = HTTPSession.getproxyurl();
        if (proxyurl == null) {
            return;
        }
        try {
            uri = HTTPUtil.parseToURI(proxyurl);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Bad proxy URL: " + proxyurl);
        }
        HttpHost httpproxy = null;
        HttpHost httpsproxy = null;
        String user = null;
        String pwd = null;
        if (uri.getScheme().equals("http")) {
            httpproxy = new HttpHost(uri.getHost(), uri.getPort(), "http");
        } else if (uri.getScheme().equals("https")) {
            httpsproxy = new HttpHost(uri.getHost(), uri.getPort(), "https");
        }
        String upw = uri.getUserInfo();
        if (upw != null) {
            String[] pieces = upw.split("[:]");
            if (pieces.length == 2 && HTTPUtil.nullify(pieces[0]) != null && HTTPUtil.nullify(pieces[1]) != null) {
                user = pieces[0];
                pwd = pieces[1];
            } else {
                throw new IllegalArgumentException("Bad userinfo: " + proxyurl);
            }
        }
        ac.put(AuthProp.HTTPPROXY, (Object)httpproxy);
        ac.put(AuthProp.HTTPSPROXY, (Object)httpsproxy);
        ac.put(AuthProp.PROXYUSER, user);
        ac.put(AuthProp.PROXYPWD, pwd);
    }

    static String getproxyurl() {
        String proxyhost;
        String proxyurl = HTTPSession.cleanproperty("proxyurl");
        if (proxyurl == null && (proxyhost = HTTPSession.cleanproperty("https.proxyHost")) != null) {
            StringBuilder buf = new StringBuilder();
            buf.append("https://");
            buf.append(proxyhost);
            String proxyport = HTTPSession.cleanproperty("https.proxyPort");
            if (proxyport != null) {
                buf.append(":");
                buf.append(proxyport);
            }
            proxyurl = buf.toString();
        }
        return proxyurl;
    }

    static void buildsslfactory(AuthControls authcontrols, KeyStore truststore, KeyStore keystore, String keypassword) {
        SSLConnectionSocketFactory globalsslfactory;
        try {
            SSLContextBuilder sslbuilder = SSLContexts.custom();
            LooseTrustStrategy strat = new LooseTrustStrategy();
            if (truststore != null) {
                sslbuilder.loadTrustMaterial(truststore, strat);
            } else {
                sslbuilder.loadTrustMaterial(strat);
            }
            sslbuilder.loadTrustMaterial(truststore, new LooseTrustStrategy());
            if (keystore != null) {
                sslbuilder.loadKeyMaterial(keystore, keypassword.toCharArray());
            }
            globalsslfactory = new SSLConnectionSocketFactory(sslbuilder.build(), (HostnameVerifier)new NoopHostnameVerifier());
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException e) {
            log.error("Failed to set key/trust store(s): " + e.getMessage());
            globalsslfactory = null;
        }
        if (globalsslfactory != null) {
            authcontrols.put(AuthProp.SSLFACTORY, globalsslfactory);
        }
    }

    static synchronized void processDFlags() {
        int conns;
        int seconds = HTTPSession.getDPropInt(DCONNTIMEOUT);
        if (seconds > 0) {
            HTTPSession.setGlobalConnectionTimeout(seconds * 1000);
        }
        if ((seconds = HTTPSession.getDPropInt(DSOTIMEOUT)) > 0) {
            HTTPSession.setGlobalSoTimeout(seconds * 1000);
        }
        if ((conns = HTTPSession.getDPropInt(DMAXCONNS)) > 0) {
            HTTPSession.setGlobalMaxConnections(conns);
        }
    }

    public static synchronized void setGlobalUserAgent(String userAgent) {
        globalsettings.put(Prop.USER_AGENT, userAgent);
    }

    public static synchronized String getGlobalUserAgent() {
        return (String)globalsettings.get((Object)Prop.USER_AGENT);
    }

    public static synchronized void setGlobalMaxConnections(int n) {
        globalsettings.put(Prop.MAX_CONNECTIONS, n);
        HTTPConnections.setDefaultMaxConections(n);
        if (connmgr != null) {
            connmgr.setMaxConnections(n);
        }
    }

    public static synchronized int getGlobalMaxConnection() {
        return (Integer)globalsettings.get((Object)Prop.MAX_CONNECTIONS);
    }

    public static synchronized void setGlobalConnectionTimeout(int timeout) {
        if (timeout >= 0) {
            globalsettings.put(Prop.CONN_TIMEOUT, timeout);
            globalsettings.put(Prop.CONN_REQ_TIMEOUT, timeout);
        }
    }

    public static synchronized void setGlobalSoTimeout(int timeout) {
        if (timeout >= 0) {
            globalsettings.put(Prop.SO_TIMEOUT, timeout);
        }
    }

    public static synchronized void setGlobalFollowRedirects(boolean tf) {
        globalsettings.put(Prop.HANDLE_REDIRECTS, tf);
    }

    public static synchronized void setGlobalMaxRedirects(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("setMaxRedirects");
        }
        globalsettings.put(Prop.MAX_REDIRECTS, n);
    }

    public static synchronized Object getGlobalSetting(String key) {
        return globalsettings.get(key);
    }

    public static synchronized void setGlobalCompression(String compressors) {
        HttpResponseInterceptor hrsi;
        String compresslist;
        if (globalsettings.get((Object)Prop.COMPRESSION) != null) {
            HTTPSession.removeGlobalCompression();
        }
        if (HTTPUtil.nullify(compresslist = HTTPSession.checkCompressors(compressors)) == null) {
            throw new IllegalArgumentException("Bad compressors: " + compressors);
        }
        globalsettings.put(Prop.COMPRESSION, compresslist);
        if (compresslist.contains("gzip")) {
            hrsi = new GZIPResponseInterceptor();
            rspintercepts.add(hrsi);
        }
        if (compresslist.contains("deflate")) {
            hrsi = new DeflateResponseInterceptor();
            rspintercepts.add(hrsi);
        }
    }

    public static synchronized void removeGlobalCompression() {
        if (globalsettings.remove((Object)Prop.COMPRESSION) != null) {
            for (int i = rspintercepts.size() - 1; i >= 0; --i) {
                HttpResponseInterceptor hrsi = rspintercepts.get(i);
                if (!(hrsi instanceof GZIPResponseInterceptor) && !(hrsi instanceof DeflateResponseInterceptor)) continue;
                rspintercepts.remove(i);
            }
        }
    }

    protected static synchronized String checkCompressors(String compressors) {
        String[] pieces;
        HashSet<String> cset = new HashSet<String>();
        compressors = compressors.replace(',', ' ');
        compressors = compressors.replace('\t', ' ');
        block0: for (String p : pieces = compressors.split("[ ]+")) {
            for (String c : KNOWNCOMPRESSORS) {
                if (!p.equalsIgnoreCase(c)) continue;
                cset.add(c);
                continue block0;
            }
        }
        StringBuilder buf = new StringBuilder();
        for (String s2 : cset) {
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(s2);
        }
        return buf.toString();
    }

    public static void setCredentialsProviderFactory(HTTPProviderFactory factory, AuthScope scope) throws HTTPException {
        if (factory == null) {
            throw new NullPointerException(HTTPSession.class.getName());
        }
        if (scope == null) {
            scope = AuthScope.ANY;
        }
        globalcredfactories.put(scope, factory);
    }

    public static void setGlobalCredentials(Credentials creds) throws HTTPException {
        HTTPSession.setGlobalCredentials(creds, null);
    }

    public static void setGlobalCredentials(Credentials creds, AuthScope scope) throws HTTPException {
        assert (creds != null);
        if (scope == null) {
            scope = AuthScope.ANY;
        }
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(scope, creds);
        HTTPSession.setGlobalCredentialsProvider((CredentialsProvider)provider, scope);
    }

    public static void clearGlobalCredentials() {
        globalcredfactories.clear();
    }

    public static synchronized void setGlobalRetryCount(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("setGlobalRetryCount");
        }
        globalsettings.put(Prop.RETRIES, n);
        globalretryhandler = new DefaultHttpRequestRetryHandler(n, false);
    }

    protected HTTPSession() throws HTTPException {
    }

    HTTPSession(String host, int port) throws HTTPException {
        this.init(new AuthScope(host, port, null, null), null);
    }

    HTTPSession(String uri) throws HTTPException {
        this.init(HTTPAuthUtil.uriToAuthScope(uri), uri);
    }

    HTTPSession(HttpHost httphost) throws HTTPException {
        this.init(HTTPAuthUtil.hostToAuthScope(httphost), null);
    }

    protected void init(AuthScope scope, String actualurl) throws HTTPException {
        assert (scope != null);
        this.sessionURI = actualurl != null ? actualurl : HTTPAuthUtil.authscopeToURI(scope).toString();
        this.scope = scope;
        this.scopeURI = HTTPAuthUtil.authscopeToURI(scope);
        this.cachevalid = false;
        this.sessioncontext.setCookieStore(new BasicCookieStore());
        this.sessioncache = new BasicAuthCache();
        this.sessioncontext.setAuthCache(this.sessioncache);
    }

    protected static void setInterceptors(HttpClientBuilder cb) {
        for (HttpRequestInterceptor hrq : reqintercepts) {
            cb.addInterceptorLast(hrq);
        }
        for (HttpResponseInterceptor hrs : rspintercepts) {
            cb.addInterceptorLast(hrs);
        }
        for (HttpRequestInterceptor hrq : dbgreq) {
            cb.addInterceptorFirst(hrq);
        }
        for (HttpResponseInterceptor hrs : dbgrsp) {
            cb.addInterceptorFirst(hrs);
        }
        cb.addInterceptorFirst(CEKILL);
    }

    public AuthScope getAuthScope() {
        return this.scope;
    }

    public String getSessionURI() {
        return this.sessionURI;
    }

    public String getSessionID() {
        String sid = null;
        String jsid = null;
        List<Cookie> cookies = this.sessioncontext.getCookieStore().getCookies();
        for (Cookie cookie : cookies) {
            if (cookie.getName().equalsIgnoreCase("sessionid")) {
                sid = cookie.getValue();
            }
            if (!cookie.getName().equalsIgnoreCase("jsessionid")) continue;
            jsid = cookie.getValue();
        }
        return sid == null ? jsid : sid;
    }

    public HTTPSession setUserAgent(String agent) {
        if (agent == null || agent.length() == 0) {
            throw new IllegalArgumentException("null argument");
        }
        this.localsettings.put(Prop.USER_AGENT, agent);
        this.cachevalid = false;
        return this;
    }

    public HTTPSession setSoTimeout(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException("setSoTimeout");
        }
        this.localsettings.put(Prop.SO_TIMEOUT, timeout);
        this.cachevalid = false;
        return this;
    }

    public HTTPSession setConnectionTimeout(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException("setConnectionTImeout");
        }
        this.localsettings.put(Prop.CONN_TIMEOUT, timeout);
        this.localsettings.put(Prop.CONN_REQ_TIMEOUT, timeout);
        this.cachevalid = false;
        return this;
    }

    public HTTPSession setMaxRedirects(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("setMaxRedirects");
        }
        this.localsettings.put(Prop.MAX_REDIRECTS, n);
        this.cachevalid = false;
        return this;
    }

    public HTTPSession setFollowRedirects(boolean tf) {
        this.localsettings.put(Prop.HANDLE_REDIRECTS, tf);
        this.cachevalid = false;
        return this;
    }

    public HTTPSession setUseSessions(boolean tf) {
        this.localsettings.put(Prop.USESESSIONS, tf);
        this.cachevalid = false;
        return this;
    }

    public List<Cookie> getCookies() {
        if (this.sessioncontext == null) {
            return null;
        }
        List<Cookie> cookies = this.sessioncontext.getCookieStore().getCookies();
        return cookies;
    }

    public HTTPSession clearCookies() {
        BasicCookieStore cookies = (BasicCookieStore)this.sessioncontext.getCookieStore();
        if (cookies != null) {
            cookies.clear();
        }
        return this;
    }

    public HTTPSession clearCredentialsCache() {
        if (this.sessioncache != null) {
            this.sessioncache.clear();
        }
        return this;
    }

    public HTTPSession clearCredentialsCache(AuthScope template) {
        if (this.sessioncache != null) {
            HttpHost h2 = HTTPAuthUtil.authscopeToHost(template);
            this.sessioncache.remove(h2);
        }
        return this;
    }

    public BasicAuthCache getCredentialsCache() {
        return this.sessioncache;
    }

    HttpClientContext getExecutionContext() {
        return this.sessioncontext;
    }

    public Object getSetting(String key) {
        return this.localsettings.get(key);
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (HTTPMethod m3 : this.methods) {
            m3.close();
        }
        this.methods.clear();
    }

    synchronized HTTPSession addMethod(HTTPMethod m3) {
        if (!this.methods.contains(m3)) {
            this.methods.add(m3);
        }
        return this;
    }

    synchronized HTTPSession removeMethod(HTTPMethod m3) {
        this.methods.remove(m3);
        connmgr.freeManager(m3);
        return this;
    }

    public HTTPSession setCredentialsProvider(CredentialsProvider provider) throws HTTPException {
        this.setCredentialsProvider(provider, null);
        return this;
    }

    public HTTPSession setCredentialsProvider(CredentialsProvider provider, AuthScope scope) throws HTTPException {
        if (provider == null) {
            throw new NullPointerException(this.getClass().getName());
        }
        if (scope == null) {
            scope = AuthScope.ANY;
        }
        this.localcreds.put(scope, provider);
        return this;
    }

    public HTTPSession setCredentials(Credentials creds) throws HTTPException {
        this.setCredentials(creds, null);
        return this;
    }

    public HTTPSession setCredentials(Credentials creds, AuthScope scope) throws HTTPException {
        assert (creds != null);
        if (scope == null) {
            scope = AuthScope.ANY;
        }
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(scope, creds);
        this.setCredentialsProvider(provider, scope);
        return this;
    }

    protected synchronized void setAuthenticationAndProxy(HttpClientBuilder cb) throws HTTPException {
        cb.setSSLSocketFactory((SSLConnectionSocketFactory)authcontrols.get((Object)AuthProp.SSLFACTORY));
        AuthScope bestMatch = HTTPAuthUtil.bestmatch(this.scope, this.localcreds.keySet());
        CredentialsProvider cp = null;
        if (bestMatch != null) {
            cp = this.localcreds.get(bestMatch);
        } else {
            bestMatch = HTTPAuthUtil.bestmatch(this.scope, globalcredfactories.keySet());
            if (bestMatch != null) {
                HTTPProviderFactory factory = globalcredfactories.get(bestMatch);
                cp = factory.getProvider(bestMatch);
            }
        }
        UsernamePasswordCredentials proxycreds = null;
        AuthScope proxyscope = null;
        String user = (String)authcontrols.get((Object)AuthProp.PROXYUSER);
        String pwd = (String)authcontrols.get((Object)AuthProp.PROXYPWD);
        HttpHost httpproxy = (HttpHost)authcontrols.get((Object)AuthProp.HTTPPROXY);
        HttpHost httpsproxy = (HttpHost)authcontrols.get((Object)AuthProp.HTTPSPROXY);
        if (user != null && (httpproxy != null || httpsproxy != null)) {
            proxyscope = httpproxy != null ? HTTPAuthUtil.hostToAuthScope(httpproxy) : HTTPAuthUtil.hostToAuthScope(httpsproxy);
            proxycreds = new UsernamePasswordCredentials(user, pwd);
        }
        if (cp == null && proxycreds != null && proxyscope != null) {
            cp = new BasicCredentialsProvider();
            cp.setCredentials(proxyscope, proxycreds);
        } else if (cp != null && proxycreds != null && proxyscope != null) {
            cp.setCredentials(proxyscope, proxycreds);
        }
        if (cp != null) {
            this.sessioncontext.setCredentialsProvider(cp);
        }
    }

    void setRetryHandler(HttpClientBuilder cb) throws HTTPException {
        if (globalretryhandler != null) {
            cb.setRetryHandler(globalretryhandler);
        }
    }

    void setContentDecoderRegistry(HttpClientBuilder cb) {
        cb.setContentDecoderRegistry(contentDecoderMap);
    }

    void setClientManager(HttpClientBuilder cb, HTTPMethod m3) {
        connmgr.setClientManager(cb, m3);
    }

    HttpClientContext getContext() {
        return this.sessioncontext;
    }

    AuthScope getSessionScope() {
        return this.scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Prop, Object> mergedSettings() {
        Map<Prop, Object> merged;
        HTTPSession hTTPSession = this;
        synchronized (hTTPSession) {
            merged = HTTPUtil.merge(globalsettings, this.localsettings);
        }
        return Collections.unmodifiableMap(merged);
    }

    static String getCanonicalURL(String legalurl) {
        if (legalurl == null) {
            return null;
        }
        int index = legalurl.indexOf(63);
        if (index >= 0) {
            legalurl = legalurl.substring(0, index);
        }
        return HTTPUtil.canonicalpath(legalurl);
    }

    static String getUrlAsString(String url) throws HTTPException {
        try (HTTPMethod m3 = HTTPFactory.Get(url);){
            int status = m3.execute();
            String content = null;
            if (status == 200) {
                content = m3.getResponseAsString();
            }
            String string = content;
            return string;
        }
    }

    static int putUrlAsString(String content, String url) throws HTTPException {
        int status = 0;
        try (HTTPMethod m3 = HTTPFactory.Put(url);){
            m3.setRequestContent(new StringEntity(content, ContentType.create("application/text", "UTF-8")));
            status = m3.execute();
        }
        catch (UnsupportedCharsetException uce) {
            throw new HTTPException(uce);
        }
        return status;
    }

    static String getstorepath(String prefix) {
        String path = System.getProperty(prefix + "store");
        if (path != null && (path = path.trim()).length() == 0) {
            path = null;
        }
        return path;
    }

    static String getpassword(String prefix) {
        String password = System.getProperty(prefix + "storepassword");
        if (password != null && (password = password.trim()).length() == 0) {
            password = null;
        }
        return password;
    }

    static String cleanproperty(String property) {
        String value = System.getProperty(property);
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized int getMethodcount() {
        return this.methods.size();
    }

    protected static synchronized void track(HTTPSession session) {
        if (!TESTING) {
            throw new UnsupportedOperationException();
        }
        if (sessionList == null) {
            sessionList = new ConcurrentSkipListSet<HTTPSession>();
        }
        sessionList.add(session);
    }

    public static synchronized void setInterceptors(boolean print) {
        Object hr;
        int i;
        if (!TESTING) {
            throw new UnsupportedOperationException();
        }
        HTTPUtil.InterceptRequest rq = new HTTPUtil.InterceptRequest();
        HTTPUtil.InterceptResponse rs = new HTTPUtil.InterceptResponse();
        rq.setPrint(print);
        rs.setPrint(print);
        for (i = reqintercepts.size() - 1; i >= 0; --i) {
            hr = reqintercepts.get(i);
            if (!(hr instanceof HTTPUtil.InterceptCommon)) continue;
            reqintercepts.remove(i);
        }
        for (i = rspintercepts.size() - 1; i >= 0; --i) {
            hr = rspintercepts.get(i);
            if (!(hr instanceof HTTPUtil.InterceptCommon)) continue;
            rspintercepts.remove(i);
        }
        reqintercepts.add(rq);
        rspintercepts.add(rs);
    }

    public static void resetInterceptors() {
        if (!TESTING) {
            throw new UnsupportedOperationException();
        }
        for (HttpRequestInterceptor hri : reqintercepts) {
            if (!(hri instanceof HTTPUtil.InterceptCommon)) continue;
            ((HTTPUtil.InterceptCommon)((Object)hri)).clear();
        }
    }

    public static HTTPUtil.InterceptRequest debugRequestInterceptor() {
        if (!TESTING) {
            throw new UnsupportedOperationException();
        }
        for (HttpRequestInterceptor hri : reqintercepts) {
            if (!(hri instanceof HTTPUtil.InterceptRequest)) continue;
            return (HTTPUtil.InterceptRequest)hri;
        }
        return null;
    }

    public static HTTPUtil.InterceptResponse debugResponseInterceptor() {
        if (!TESTING) {
            throw new UnsupportedOperationException();
        }
        for (HttpResponseInterceptor hri : rspintercepts) {
            if (!(hri instanceof HTTPUtil.InterceptResponse)) continue;
            return (HTTPUtil.InterceptResponse)hri;
        }
        return null;
    }

    public static void clearkeystore() {
        if (!TESTING) {
            throw new UnsupportedOperationException();
        }
        authcontrols.setReadOnly(false);
        authcontrols.remove((Object)AuthProp.KEYSTORE);
        authcontrols.remove((Object)AuthProp.KEYPASSWORD);
        authcontrols.remove((Object)AuthProp.TRUSTSTORE);
        authcontrols.remove((Object)AuthProp.TRUSTPASSWORD);
        authcontrols.setReadOnly(true);
    }

    public static void rebuildkeystore(String path, String pwd) {
        if (!TESTING) {
            throw new UnsupportedOperationException();
        }
        KeyStore newks = HTTPSession.buildkeystore(path, pwd);
        authcontrols.setReadOnly(false);
        authcontrols.put(AuthProp.KEYSTORE, (Object)newks);
        authcontrols.setReadOnly(true);
    }

    @Deprecated
    public static void setGlobalCredentialsProvider(AuthScope scope, CredentialsProvider provider) throws HTTPException {
        HTTPSession.setGlobalCredentialsProvider(provider, scope);
    }

    @Deprecated
    public static void setGlobalCredentialsProvider(String url, CredentialsProvider provider) throws HTTPException {
        assert (url != null && provider != null);
        AuthScope scope = HTTPAuthUtil.uriToAuthScope(url);
        HTTPSession.setGlobalCredentialsProvider(provider, scope);
    }

    @Deprecated
    public static void setGlobalCredentials(String url, Credentials creds) throws HTTPException {
        assert (url != null && creds != null);
        AuthScope scope = HTTPAuthUtil.uriToAuthScope(url);
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(scope, creds);
        HTTPSession.setGlobalCredentialsProvider((CredentialsProvider)provider, scope);
    }

    @Deprecated
    public HTTPSession setCredentials(String url, Credentials creds) throws HTTPException {
        assert (creds != null);
        AuthScope scope = HTTPAuthUtil.uriToAuthScope(url);
        this.setCredentials(creds, scope);
        return this;
    }

    @Deprecated
    public HTTPSession setCredentialsProvider(String url, CredentialsProvider provider) throws HTTPException {
        assert (url != null && provider != null);
        AuthScope scope = HTTPAuthUtil.uriToAuthScope(url);
        this.setCredentialsProvider(provider, scope);
        return this;
    }

    @Deprecated
    public HTTPSession setCredentialsProvider(AuthScope scope, CredentialsProvider provider) throws HTTPException {
        return this.setCredentialsProvider(provider, scope);
    }

    @Deprecated
    public static int getRetryCount() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static void setGlobalCompression() {
        HTTPSession.setGlobalCompression("gzip,deflate");
    }

    @Deprecated
    public static void setGlobalProxy(String host, int port) {
        throw new UnsupportedOperationException("setGlobalProxy: use -D flags");
    }

    @Deprecated
    public void setProxy(String host, int port) {
        HTTPSession.setGlobalProxy(host, port);
    }

    @Deprecated
    public static void setGlobalCredentialsProvider(CredentialsProvider provider, String scheme) throws HTTPException {
        HTTPSession.setGlobalCredentialsProvider(provider);
    }

    @Deprecated
    public void clearState() {
    }

    @Deprecated
    public String getSessionURL() {
        return this.getSessionURI();
    }

    protected static synchronized void kill() {
        if (sessionList != null) {
            for (HTTPSession session : sessionList) {
                session.close();
            }
            sessionList.clear();
            connmgr.close();
        }
    }

    public static void validatestate() {
        connmgr.validate();
    }

    @Deprecated
    public static void setGlobalCredentialsProvider(CredentialsProvider provider) throws HTTPException {
        HTTPSession.setGlobalCredentialsProvider(provider, (AuthScope)null);
    }

    @Deprecated
    public static void setGlobalCredentialsProvider(CredentialsProvider provider, AuthScope scope) throws HTTPException {
        SingleProviderFactory factory = new SingleProviderFactory(provider);
        HTTPSession.setCredentialsProviderFactory(factory, scope);
    }

    static {
        globalretryhandler = null;
        reqintercepts = new CopyOnWriteArrayList<HttpRequestInterceptor>();
        rspintercepts = new CopyOnWriteArrayList<HttpResponseInterceptor>();
        dbgreq = new CopyOnWriteArrayList<HttpRequestInterceptor>();
        dbgrsp = new CopyOnWriteArrayList<HttpResponseInterceptor>();
        globalcredfactories = new HashMap<AuthScope, HTTPProviderFactory>();
        connmgr = new HTTPConnectionPool();
        CEKILL = new HTTPUtil.ContentEncodingInterceptor();
        contentDecoderMap = new HashMap<String, InputStreamFactory>();
        contentDecoderMap.put("zip", new ZipStreamFactory());
        contentDecoderMap.put("gzip", new GZIPStreamFactory());
        globalsettings = new ConcurrentHashMap<Prop, Object>();
        HTTPSession.setDefaults(globalsettings);
        authcontrols = new AuthControls();
        authcontrols.setReadOnly(false);
        HTTPSession.buildproxy(authcontrols);
        HTTPSession.buildkeystores(authcontrols);
        HTTPSession.buildsslfactory(authcontrols);
        authcontrols.setReadOnly(true);
        HTTPSession.processDFlags();
        connmgr.addProtocol("https", (ConnectionSocketFactory)authcontrols.get((Object)AuthProp.SSLFACTORY));
        sessionList = null;
    }

    static class GZIPStreamFactory
    implements InputStreamFactory {
        GZIPStreamFactory() {
        }

        @Override
        public InputStream create(InputStream instream) throws IOException {
            return new GZIPInputStream(instream);
        }
    }

    static class ZipStreamFactory
    implements InputStreamFactory {
        ZipStreamFactory() {
        }

        @Override
        public InputStream create(InputStream instream) throws IOException {
            return new ZipInputStream(instream, HTTPUtil.UTF8);
        }
    }

    static class DeflateResponseInterceptor
    implements HttpResponseInterceptor {
        DeflateResponseInterceptor() {
        }

        @Override
        public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            Header ceheader;
            HttpEntity entity = response.getEntity();
            if (entity != null && (ceheader = entity.getContentEncoding()) != null) {
                HeaderElement[] codecs;
                for (HeaderElement h2 : codecs = ceheader.getElements()) {
                    if (!h2.getName().equalsIgnoreCase("deflate")) continue;
                    response.setEntity(new DeflateDecompressingEntity(response.getEntity()));
                    return;
                }
            }
        }
    }

    static class GZIPResponseInterceptor
    implements HttpResponseInterceptor {
        GZIPResponseInterceptor() {
        }

        @Override
        public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            Header ceheader;
            HttpEntity entity = response.getEntity();
            if (entity != null && (ceheader = entity.getContentEncoding()) != null) {
                HeaderElement[] codecs;
                for (HeaderElement h2 : codecs = ceheader.getElements()) {
                    if (!h2.getName().equalsIgnoreCase("gzip")) continue;
                    response.setEntity(new GzipDecompressingEntity(response.getEntity()));
                    return;
                }
            }
        }
    }

    public static enum Methods {
        Get("get"),
        Head("head"),
        Put("put"),
        Post("post"),
        Options("options");

        private final String name;

        private Methods(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    static class LooseTrustStrategy
    extends TrustSelfSignedStrategy {
        LooseTrustStrategy() {
        }

        @Override
        public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            try {
                if (super.isTrusted(chain, authType)) {
                    return true;
                }
                for (X509Certificate x5 : chain) {
                    try {
                        x5.checkValidity();
                    }
                    catch (CertificateExpiredException | CertificateNotYetValidException ce) {
                        return true;
                    }
                }
            }
            catch (CertificateException e) {
                return true;
            }
            return false;
        }
    }

    static class AuthControls
    extends ConcurrentHashMap<AuthProp, Object> {
        protected boolean readonly = false;

        public AuthControls setReadOnly(boolean tf) {
            this.readonly = tf;
            return this;
        }

        @Override
        public Set<Map.Entry<AuthProp, Object>> entrySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object put(AuthProp key, Object val) {
            if (this.readonly) {
                throw new UnmodifiableSetException();
            }
            if (val != null) {
                super.put(key, val);
            }
            return val;
        }

        @Override
        public Object replace(AuthProp key, Object val) {
            if (this.readonly) {
                throw new UnmodifiableSetException();
            }
            return super.replace(key, val);
        }

        @Override
        public void clear() {
            if (this.readonly) {
                throw new UnmodifiableSetException();
            }
            super.clear();
        }
    }

    static enum AuthProp {
        KEYSTORE,
        KEYPASSWORD,
        TRUSTSTORE,
        TRUSTPASSWORD,
        SSLFACTORY,
        HTTPPROXY,
        HTTPSPROXY,
        PROXYUSER,
        PROXYPWD;

    }

    static enum Prop {
        ALLOW_CIRCULAR_REDIRECTS,
        HANDLE_REDIRECTS,
        HANDLE_AUTHENTICATION,
        MAX_REDIRECTS,
        MAX_CONNECTIONS,
        SO_TIMEOUT,
        CONN_TIMEOUT,
        CONN_REQ_TIMEOUT,
        USER_AGENT,
        COOKIE_STORE,
        RETRIES,
        UNAVAILRETRIES,
        COMPRESSION,
        CREDENTIALS,
        USESESSIONS;

    }
}

