/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.gis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ucar.nc2.ui.gis.AbstractGisFeature;
import ucar.nc2.ui.util.Renderer;
import ucar.ui.prefs.Debug;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;

public abstract class GisFeatureRenderer
implements Renderer {
    private Color color = Color.blue;
    protected ProjectionImpl displayProject;
    protected ArrayList shapeList;

    @Override
    public abstract LatLonRect getPreferredArea();

    protected abstract List getFeatures();

    protected abstract ProjectionImpl getDataProjection();

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public void setProjection(ProjectionImpl project) {
        this.displayProject = project;
        this.shapeList = null;
    }

    @Override
    public void draw(Graphics2D g2, AffineTransform pixelAT) {
        g2.setColor(this.color);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2.setStroke(new BasicStroke(0.0f));
        Rectangle2D clipRect = (Rectangle2D)g2.getClip();
        Iterator siter = this.getShapes(g2, pixelAT);
        while (siter.hasNext()) {
            Shape s2 = (Shape)siter.next();
            Rectangle2D shapeBounds = s2.getBounds2D();
            if (!shapeBounds.intersects(clipRect)) continue;
            g2.draw(s2);
        }
    }

    protected Iterator getShapes(Graphics2D g2, AffineTransform normal2device) {
        if (this.shapeList != null) {
            return this.shapeList.iterator();
        }
        if (Debug.isSet("projection/LatLonShift")) {
            System.out.println("projection/LatLonShift GisFeatureRenderer.getShapes called");
        }
        ProjectionImpl dataProject = this.getDataProjection();
        List featList = this.getFeatures();
        this.shapeList = new ArrayList(featList.size());
        for (Object o : featList) {
            AbstractGisFeature feature = (AbstractGisFeature)o;
            Shape shape = dataProject == null ? feature.getShape() : (dataProject.isLatLon() ? feature.getProjectedShape(this.displayProject) : (dataProject == this.displayProject ? feature.getShape() : feature.getProjectedShape(dataProject, this.displayProject)));
            this.shapeList.add(shape);
        }
        return this.shapeList.iterator();
    }
}

