/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.grid;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.ma2.MAMath;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.ui.grid.ContourFeature;
import ucar.nc2.ui.grid.ContourLine;
import ucar.ui.prefs.Debug;

public class ContourGrid {
    private GridDatatype geogrid;
    private Array dataArray;
    private Index dgIndex;
    private List<Double> contourValues = new ArrayList<Double>();
    private List<ContourLine> contourLines = new ArrayList<ContourLine>();
    private int[][] contourOnVertlEdge;
    private int[][] contourOnHorizEdge;
    private double[] xpositions;
    private double[] ypositions;
    private double conLevel;
    private int xMaxInd;
    private int yMaxInd;
    private int dimX;
    private int numLevel;
    private double gridmax;
    private double gridmin;

    public ContourGrid(Array dataGrid, List<Double> allContourValues, double[] xPosition, double[] yPosition, GridDatatype geogrid) {
        this.geogrid = geogrid;
        this.dgIndex = dataGrid.getIndex();
        this.dataArray = dataGrid;
        this.dimX = dataGrid.getShape()[1];
        this.xpositions = xPosition;
        this.ypositions = yPosition;
        this.xMaxInd = dataGrid.getShape()[0] - 1;
        this.yMaxInd = dataGrid.getShape()[1] - 1;
        this.conLevel = 0.0;
        MAMath.MinMax minmax = geogrid.getMinMaxSkipMissingData(dataGrid);
        this.gridmax = minmax.max;
        this.gridmin = minmax.min;
        if (Debug.isSet("contour/debugContours")) {
            System.out.println("  cstr: grid x dim = " + this.xMaxInd + "  y dim = " + this.yMaxInd);
            System.out.println("  cstr: input grid has x coord limits " + this.xpositions[0] + " to " + this.xpositions[this.yMaxInd]);
            System.out.println("  cstr: input grid has y coord limits " + this.ypositions[0] + " to " + this.ypositions[this.yMaxInd]);
            System.out.println("  cstr: grid max value = " + this.gridmax + "  grid min = " + this.gridmin);
        }
        if (!allContourValues.isEmpty()) {
            if (Debug.isSet("contour/debugContours")) {
                System.out.println("  Supplied contour levels are" + allContourValues);
            }
            for (Double cv : allContourValues) {
                if (!(cv >= this.gridmin) || !(cv <= this.gridmax)) continue;
                this.contourValues.add(cv);
            }
        } else {
            double interval = (this.gridmax - this.gridmin) / 10.0;
            if (interval == 0.0) {
                Double dob = -999.0;
                this.contourValues.add(dob);
            } else {
                int lowestmult;
                int highestmult = (int)(this.gridmax / interval);
                for (int i = lowestmult = (int)(this.gridmin / interval) + 1; i <= highestmult; ++i) {
                    Double dob = (double)i * interval;
                    this.contourValues.add(dob);
                }
            }
        }
        this.contourOnVertlEdge = new int[this.contourValues.size()][(this.xMaxInd + 1) * (this.yMaxInd + 1)];
        this.contourOnHorizEdge = new int[this.contourValues.size()][(this.xMaxInd + 1) * (this.yMaxInd + 1)];
    }

    public List<ContourFeature> getContourLines() {
        long t1 = 0L;
        ArrayList<ContourFeature> contourFeatureList = new ArrayList<ContourFeature>();
        if (Debug.isSet("contour/contourTiming")) {
            t1 = System.currentTimeMillis();
        }
        this.setupContourCrossings();
        int i = 0;
        while (i < this.contourValues.size()) {
            this.conLevel = this.contourValues.get(i);
            this.numLevel = i++;
            if (this.conLevel == -999.0) {
                System.err.println("  No contours possible: all same grid values");
                return new ArrayList<ContourFeature>();
            }
            this.searchWestEdge();
            this.searchSouthEdge();
            this.searchEastEdge();
            this.searchNorthEdge();
            this.sweepfromWest();
            this.sweepfromTop();
            ContourFeature oneLevelLines = new ContourFeature(this.contourLines);
            contourFeatureList.add(oneLevelLines);
            this.contourLines.clear();
        }
        if (Debug.isSet("contour/contourTiming")) {
            long t2 = System.currentTimeMillis();
            long dt = t2 - t1;
            System.out.println("  getContourLines used " + dt + " ms elapsed");
        }
        return contourFeatureList;
    }

    private void setupContourCrossings() {
        double clevel;
        boolean v2IsMissingData;
        boolean v1IsMissingData;
        double v2;
        int i;
        double v1;
        int j;
        int m3;
        double[] clevels = new double[this.contourValues.size()];
        for (m3 = 0; m3 < this.contourValues.size(); ++m3) {
            clevels[m3] = this.contourValues.get(m3);
        }
        for (j = 0; j <= this.yMaxInd; ++j) {
            v1 = this.value(0, j);
            for (i = 0; i < this.xMaxInd; ++i) {
                v2 = this.value(i + 1, j);
                v1IsMissingData = this.geogrid.isMissingData(v1);
                v2IsMissingData = this.geogrid.isMissingData(v2);
                for (m3 = 0; m3 < this.contourValues.size(); ++m3) {
                    clevel = clevels[m3];
                    this.contourOnHorizEdge[m3][j + i * this.dimX] = 0;
                    if (v1IsMissingData || v2IsMissingData || !(clevel >= v1 && clevel < v2) && (!(clevel >= v2) || !(clevel < v1))) continue;
                    this.contourOnHorizEdge[m3][j + i * this.dimX] = 1;
                }
                v1 = v2;
            }
        }
        for (i = 0; i <= this.xMaxInd; ++i) {
            v1 = this.value(i, 0);
            for (j = 0; j < this.yMaxInd; ++j) {
                v2 = this.value(i, j + 1);
                v1IsMissingData = this.geogrid.isMissingData(v1);
                v2IsMissingData = this.geogrid.isMissingData(v2);
                for (m3 = 0; m3 < this.contourValues.size(); ++m3) {
                    clevel = clevels[m3];
                    this.contourOnVertlEdge[m3][j + i * this.dimX] = 0;
                    if (v1IsMissingData || v2IsMissingData || !(clevel >= v1 && clevel < v2) && (!(clevel >= v2) || !(clevel < v1))) continue;
                    this.contourOnVertlEdge[m3][j + i * this.dimX] = 1;
                }
                v1 = v2;
            }
        }
    }

    private double value(int i, int j) {
        double truevalue = this.dataArray.getDouble(this.dgIndex.set(i, j));
        if (truevalue != this.conLevel) {
            return truevalue;
        }
        return truevalue + (this.gridmax - this.gridmin) / 100000.0;
    }

    private void searchWestEdge() {
        int i = 0;
        for (int j = this.yMaxInd - 1; j >= 0; --j) {
            if (this.contourOnVertlEdge[this.numLevel][j + i * this.dimX] != 1) continue;
            ContourLine cline = new ContourLine(this.followContour('W', i, j), this.conLevel);
            this.contourLines.add(cline);
            this.contourOnVertlEdge[this.numLevel][j + i * this.dimX] = 0;
        }
    }

    private void searchEastEdge() {
        int i = this.xMaxInd;
        for (int j = 0; j < this.yMaxInd; ++j) {
            if (this.contourOnVertlEdge[this.numLevel][j + i * this.dimX] != 1) continue;
            ContourLine cline = new ContourLine(this.followContour('E', i - 1, j), this.conLevel);
            this.contourLines.add(cline);
            this.contourOnVertlEdge[this.numLevel][j + i * this.dimX] = 0;
        }
    }

    private void searchNorthEdge() {
        int j = this.yMaxInd;
        for (int i = 0; i < this.xMaxInd; ++i) {
            if (this.contourOnHorizEdge[this.numLevel][j + i * this.dimX] != 1) continue;
            ContourLine cline = new ContourLine(this.followContour('N', i, j - 1), this.conLevel);
            this.contourLines.add(cline);
            this.contourOnHorizEdge[this.numLevel][j + i * this.dimX] = 0;
        }
    }

    private void searchSouthEdge() {
        int j = 0;
        for (int i = 0; i < this.xMaxInd; ++i) {
            if (this.contourOnHorizEdge[this.numLevel][j + i * this.dimX] != 1) continue;
            ContourLine cline = new ContourLine(this.followContour('S', i, j), this.conLevel);
            this.contourLines.add(cline);
            this.contourOnHorizEdge[this.numLevel][j + i * this.dimX] = 0;
        }
    }

    private void sweepfromTop() {
        for (int j = 1; j < this.yMaxInd; ++j) {
            for (int i = 0; i <= this.xMaxInd; ++i) {
                if (this.contourOnHorizEdge[this.numLevel][j + i * this.dimX] != 1) continue;
                ContourLine cline = new ContourLine(this.followContour('S', i, j), this.conLevel);
                this.contourLines.add(cline);
                this.contourOnHorizEdge[this.numLevel][j + i * this.dimX] = 0;
            }
        }
    }

    private void sweepfromWest() {
        for (int i = 0; i < this.xMaxInd; ++i) {
            for (int j = 0; j < this.yMaxInd; ++j) {
                if (this.contourOnVertlEdge[this.numLevel][j + i * this.dimX] != 1) continue;
                ContourLine cline = new ContourLine(this.followContour('W', i, j), this.conLevel);
                this.contourLines.add(cline);
                this.contourOnVertlEdge[this.numLevel][j + i * this.dimX] = 0;
            }
        }
    }

    private List<Point2D.Double> followContour(char firstSide, int i, int j) {
        ArrayList<Point2D.Double> cLinePts = new ArrayList<Point2D.Double>();
        char startSide = firstSide;
        if (Debug.isSet("contour/debugContours")) {
            System.out.println("  NEW CONTOUR starting at " + i + "," + j);
            System.out.println("   startside =" + startSide);
        }
        Point2D.Double startGridPoint = this.contourEdgeIntersection(startSide, i, j);
        if (Debug.isSet("contour/debugContours")) {
            System.out.println("    point 1 x = " + (float)startGridPoint.getX() + "  y = " + (float)startGridPoint.getY());
        }
        Point2D.Double dob = new Point2D.Double(startGridPoint.getX(), startGridPoint.getY());
        cLinePts.add(dob);
        double oldx = startGridPoint.getX();
        double oldy = startGridPoint.getY();
        boolean match = false;
        boolean onedge = false;
        boolean atMissing = false;
        do {
            char heading;
            if ((heading = this.directionToGoFrom(startSide, i, j)) == startSide) {
                if (cLinePts.size() <= 1) {
                    ArrayList<Point2D.Double> empty = new ArrayList<Point2D.Double>();
                    return empty;
                }
                return cLinePts;
            }
            if (Debug.isSet("contour/debugContours")) {
                System.out.println("    new cell; exit side = " + heading);
            }
            Point2D.Double mainGridPoint = this.contourEdgeIntersection(heading, i, j);
            Point2D.Double dob2 = new Point2D.Double(mainGridPoint.getX(), mainGridPoint.getY());
            cLinePts.add(dob2);
            if (Debug.isSet("contour/debugContours")) {
                System.out.println("    next position on contour = " + (float)mainGridPoint.getX() + "," + (float)mainGridPoint.getY());
            }
            oldx = mainGridPoint.getX();
            oldy = mainGridPoint.getY();
            if (heading == 'N') {
                startSide = 'S';
                this.contourOnHorizEdge[this.numLevel][++j + i * this.dimX] = 0;
            } else if (heading == 'S') {
                startSide = 'N';
                this.contourOnHorizEdge[this.numLevel][--j + 1 + i * this.dimX] = 0;
            } else if (heading == 'E') {
                startSide = 'W';
                this.contourOnVertlEdge[this.numLevel][j + ++i * this.dimX] = 0;
            } else if (heading == 'W') {
                startSide = 'E';
                this.contourOnVertlEdge[this.numLevel][j + (--i + 1) * this.dimX] = 0;
            }
            if (Debug.isSet("contour/debugContours")) {
                System.out.println("    new startside =" + startSide + "  i,j =" + i + "," + j + "  old heading =" + heading + " xMaxInd=" + this.xMaxInd + "  yMaxInd=" + this.yMaxInd);
            }
            if (mainGridPoint.getX() == startGridPoint.getX() && mainGridPoint.getY() == startGridPoint.getY()) {
                match = true;
            }
            if (!(heading == 'N' && j >= this.yMaxInd || heading == 'S' && j < 0 || heading == 'E' && i >= this.xMaxInd) && (heading != 'W' || i >= 0)) continue;
            onedge = true;
        } while (!match && !onedge && !atMissing);
        if (Debug.isSet("contour/debugContours")) {
            if (match) {
                System.out.println("  END contour at " + i + ", " + j + " by match");
            }
            if (onedge) {
                System.out.println("  END contour at " + i + ", " + j + " on edge");
            }
        }
        return cLinePts;
    }

    private Point2D.Double contourEdgeIntersection(char side, int i, int j) {
        Point2D.Double intersection = new Point2D.Double();
        switch (side) {
            case 'N': {
                intersection.setLocation(this.xpositions[i] + (this.xpositions[i + 1] - this.xpositions[i]) * this.interpPosition(this.conLevel, this.value(i, j + 1), this.value(i + 1, j + 1)), this.ypositions[j + 1]);
                break;
            }
            case 'S': {
                intersection.setLocation(this.xpositions[i] + (this.xpositions[i + 1] - this.xpositions[i]) * this.interpPosition(this.conLevel, this.value(i, j), this.value(i + 1, j)), this.ypositions[j]);
                break;
            }
            case 'E': {
                intersection.setLocation(this.xpositions[i + 1], this.ypositions[j] + (this.ypositions[j + 1] - this.ypositions[j]) * this.interpPosition(this.conLevel, this.value(i + 1, j), this.value(i + 1, j + 1)));
                break;
            }
            case 'W': {
                intersection.setLocation(this.xpositions[i], this.ypositions[j] + (this.ypositions[j + 1] - this.ypositions[j]) * this.interpPosition(this.conLevel, this.value(i, j), this.value(i, j + 1)));
                break;
            }
            default: {
                System.out.println("Impossible direction in contourEdgeIntersection  i=" + i + "  j=" + j + " direction=" + side);
            }
        }
        return intersection;
    }

    private char directionToGoFrom(char startSide, int i, int j) {
        switch (startSide) {
            case 'N': {
                if (this.contourOnVertlEdge[this.numLevel][j + i * this.dimX] == 1 && this.contourOnHorizEdge[this.numLevel][j + i * this.dimX] == 1 && this.contourOnVertlEdge[this.numLevel][j + (i + 1) * this.dimX] == 1) {
                    if (Math.abs(this.conLevel - this.value(i, j + 1)) > Math.abs(this.conLevel - this.value(i + 1, j + 1))) {
                        return 'E';
                    }
                    return 'W';
                }
                if (this.contourOnVertlEdge[this.numLevel][j + i * this.dimX] == 1) {
                    return 'W';
                }
                if (this.contourOnVertlEdge[this.numLevel][j + (i + 1) * this.dimX] == 1) {
                    return 'E';
                }
                if (this.contourOnHorizEdge[this.numLevel][j + i * this.dimX] != 1) break;
                return 'S';
            }
            case 'S': {
                if (this.contourOnVertlEdge[this.numLevel][j + (i + 1) * this.dimX] == 1 && this.contourOnHorizEdge[this.numLevel][j + 1 + i * this.dimX] == 1 && this.contourOnVertlEdge[this.numLevel][j + i * this.dimX] == 1) {
                    if (Math.abs(this.conLevel - this.value(i + 1, j)) > Math.abs(this.conLevel - this.value(i, j))) {
                        return 'W';
                    }
                    return 'E';
                }
                if (this.contourOnVertlEdge[this.numLevel][j + i * this.dimX] == 1) {
                    return 'W';
                }
                if (this.contourOnVertlEdge[this.numLevel][j + (i + 1) * this.dimX] == 1) {
                    return 'E';
                }
                if (this.contourOnHorizEdge[this.numLevel][j + 1 + i * this.dimX] != 1) break;
                return 'N';
            }
            case 'E': {
                if (this.contourOnHorizEdge[this.numLevel][j + 1 + i * this.dimX] == 1 && this.contourOnVertlEdge[this.numLevel][j + i * this.dimX] == 1 && this.contourOnHorizEdge[this.numLevel][j + i * this.dimX] == 1) {
                    if (Math.abs(this.conLevel - this.value(i + 1, j + 1)) > Math.abs(this.conLevel - this.value(i + 1, j))) {
                        return 'S';
                    }
                    return 'N';
                }
                if (this.contourOnHorizEdge[this.numLevel][j + 1 + i * this.dimX] == 1) {
                    return 'N';
                }
                if (this.contourOnHorizEdge[this.numLevel][j + i * this.dimX] == 1) {
                    return 'S';
                }
                if (this.contourOnVertlEdge[this.numLevel][j + i * this.dimX] != 1) break;
                return 'W';
            }
            case 'W': {
                if (this.contourOnHorizEdge[this.numLevel][j + i * this.dimX] == 1 && this.contourOnVertlEdge[this.numLevel][j + (i + 1) * this.dimX] == 1 && this.contourOnHorizEdge[this.numLevel][j + 1 + i * this.dimX] == 1) {
                    if (Math.abs(this.conLevel - this.value(i, j)) > Math.abs(this.conLevel - this.value(i, j + 1))) {
                        return 'N';
                    }
                    return 'S';
                }
                if (this.contourOnHorizEdge[this.numLevel][j + i * this.dimX] == 1) {
                    return 'S';
                }
                if (this.contourOnHorizEdge[this.numLevel][j + 1 + i * this.dimX] == 1) {
                    return 'N';
                }
                if (this.contourOnVertlEdge[this.numLevel][j + (i + 1) * this.dimX] != 1) break;
                return 'E';
            }
            default: {
                System.out.println("Impossible direction " + startSide + " in directionToGoFrom()");
            }
        }
        if (Debug.isSet("contour/debugContours")) {
            System.out.println("   Contour does not exit from cell i=" + i + " j=" + j + "   start side is " + startSide + "  level = " + this.conLevel);
        }
        return startSide;
    }

    private double interpPosition(double cv, double v1, double v2) {
        if (v2 == v1) {
            return 0.5;
        }
        return (cv - v1) / (v2 - v1);
    }
}

