/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.Component;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.util.Formatter;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasetInfo;
import ucar.nc2.ui.OpPanel;
import ucar.nc2.ui.op.CoordSysTable;
import ucar.ui.widget.BAMutil;
import ucar.util.prefs.PreferencesExt;

public class CoordSysPanel
extends OpPanel {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private NetcdfDataset ds;
    private CoordSysTable coordSysTable;

    public CoordSysPanel(PreferencesExt p) {
        super(p, "dataset:", true, false);
        this.coordSysTable = new CoordSysTable(this.prefs, this.buttPanel);
        this.add((Component)this.coordSysTable, "Center");
        AbstractButton summaryButton = BAMutil.makeButtcon("Information", "Summary Info", false);
        summaryButton.addActionListener(e -> {
            Formatter f = new Formatter();
            this.coordSysTable.summaryInfo(f);
            this.detailTA.setText(f.toString());
            this.detailWindow.show();
        });
        this.buttPanel.add(summaryButton);
        AbstractButton infoButton = BAMutil.makeButtcon("Information", "Parse Info", false);
        infoButton.addActionListener(e -> {
            if (this.ds != null) {
                try (NetcdfDatasetInfo info = new NetcdfDatasetInfo(this.ds);){
                    this.detailTA.appendLine(info.getParseInfo());
                    this.detailTA.gotoTop();
                }
                catch (Exception e1) {
                    StringWriter sw = new StringWriter(5000);
                    e1.printStackTrace(new PrintWriter(sw));
                    this.detailTA.setText(sw.toString());
                }
                this.detailWindow.show();
            }
        });
        this.buttPanel.add(infoButton);
        JButton dsButton = new JButton("Object dump");
        dsButton.addActionListener(e -> {
            if (this.ds != null) {
                StringWriter sw = new StringWriter(5000);
                NetcdfDataset.debugDump(new PrintWriter(sw), this.ds);
                this.detailTA.setText(sw.toString());
                this.detailTA.gotoTop();
                this.detailWindow.show();
            }
        });
        this.buttPanel.add(dsButton);
    }

    @Override
    public boolean process(Object o) {
        String command = (String)o;
        boolean err = false;
        try {
            if (this.ds != null) {
                this.ds.close();
            }
        }
        catch (IOException ioe) {
            logger.warn("close failed");
        }
        try {
            this.ds = NetcdfDataset.openDataset(command, true, -1, null, null);
            if (this.ds == null) {
                JOptionPane.showMessageDialog(null, "Failed to open <" + command + ">");
            } else {
                this.coordSysTable.setDataset(this.ds);
            }
        }
        catch (FileNotFoundException ioe) {
            JOptionPane.showMessageDialog(null, "NetcdfDataset cannot open " + command + "\n" + ioe.getMessage());
            err = true;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter(5000);
            e.printStackTrace(new PrintWriter(sw));
            this.detailTA.setText(sw.toString());
            this.detailWindow.show();
            err = true;
            e.printStackTrace();
        }
        return !err;
    }

    @Override
    public void closeOpenFiles() throws IOException {
        if (this.ds != null) {
            this.ds.close();
        }
        this.ds = null;
        this.coordSysTable.clear();
    }

    public void setDataset(NetcdfDataset ncd) {
        try {
            if (this.ds != null) {
                this.ds.close();
            }
            this.ds = null;
        }
        catch (IOException ioe) {
            logger.warn("close failed");
        }
        this.ds = ncd;
        this.coordSysTable.setDataset(this.ds);
        this.setSelectedItem(this.ds.getLocation());
    }

    @Override
    public void save() {
        this.coordSysTable.save();
        super.save();
    }
}

