/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileSubclass;
import ucar.nc2.stream.NcStreamIosp;
import ucar.ui.prefs.BeanTable;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.TextHistoryPane;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;

public class NcStreamPanel
extends JPanel {
    private PreferencesExt prefs;
    private BeanTable messTable;
    private JSplitPane split;
    private TextHistoryPane infoTA;
    private TextHistoryPane infoPopup2;
    private TextHistoryPane infoPopup3;
    private IndependentWindow infoWindow2;
    private IndependentWindow infoWindow3;
    private RandomAccessFile raf;
    private NetcdfFile ncd;
    private NcStreamIosp iosp;

    public NcStreamPanel(PreferencesExt prefs) {
        this.prefs = prefs;
        this.messTable = new BeanTable<MessBean>(MessBean.class, (PreferencesExt)prefs.node("NcStreamPanel"), false);
        this.messTable.addListSelectionListener(e -> {
            MessBean bean = (MessBean)this.messTable.getSelectedBean();
            if (bean == null) {
                return;
            }
            this.infoTA.setText(bean.getDesc());
        });
        PopupMenu varPopup = new PopupMenu(this.messTable.getJTable(), "Options");
        varPopup.addAction("Show deflate", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessBean bean = (MessBean)NcStreamPanel.this.messTable.getSelectedBean();
                if (bean == null) {
                    return;
                }
                NcStreamPanel.this.infoTA.setText(bean.m.showDeflate());
            }
        });
        this.infoTA = new TextHistoryPane();
        this.infoPopup2 = new TextHistoryPane();
        this.infoWindow2 = new IndependentWindow("Extra Information", BAMutil.getImage("nj22/NetcdfUI"), this.infoPopup2);
        this.infoWindow2.setBounds((Rectangle)prefs.getBean("InfoWindowBounds2", new Rectangle(300, 300, 500, 300)));
        this.infoPopup3 = new TextHistoryPane();
        this.infoWindow3 = new IndependentWindow("Extra Information", BAMutil.getImage("nj22/NetcdfUI"), this.infoPopup3);
        this.infoWindow3.setBounds((Rectangle)prefs.getBean("InfoWindowBounds3", new Rectangle(300, 300, 500, 300)));
        this.setLayout(new BorderLayout());
        this.split = new JSplitPane(0, false, this.messTable, this.infoTA);
        this.split.setDividerLocation(prefs.getInt("splitPos", 800));
        this.add((Component)this.split, "Center");
    }

    public void save() {
        this.messTable.saveState(false);
        if (this.split != null) {
            this.prefs.putInt("splitPos", this.split.getDividerLocation());
        }
    }

    public void closeOpenFiles() throws IOException {
        if (this.ncd != null) {
            this.ncd.close();
        }
        this.ncd = null;
        this.raf = null;
        this.iosp = null;
    }

    public void showInfo(Formatter f) {
        if (this.ncd == null) {
            return;
        }
        try {
            f.format("%s%n", this.raf.getLocation());
            f.format(" file length = %d%n", this.raf.length());
            f.format(" version = %d%n", this.iosp.getVersion());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        f.format("%n%s", this.ncd.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNcStreamFile(String filename) throws IOException {
        this.closeOpenFiles();
        ArrayList<MessBean> messages = new ArrayList<MessBean>();
        this.ncd = new NetcdfFileSubclass();
        this.iosp = new NcStreamIosp();
        try {
            this.raf = new RandomAccessFile(filename, "r");
            ArrayList<NcStreamIosp.NcsMess> ncm = new ArrayList<NcStreamIosp.NcsMess>();
            this.iosp.openDebug(this.raf, this.ncd, ncm);
            for (NcStreamIosp.NcsMess m3 : ncm) {
                messages.add(new MessBean(m3));
            }
        }
        finally {
            if (this.raf != null) {
                this.raf.close();
            }
        }
        this.messTable.setBeans(messages);
    }

    public static class MessBean {
        private NcStreamIosp.NcsMess m;

        MessBean() {
        }

        MessBean(NcStreamIosp.NcsMess m3) {
            this.m = m3;
        }

        public String getObjClass() {
            return this.m.what.getClass().toString();
        }

        public String getDesc() {
            return this.m.what.toString();
        }

        public int getSize() {
            return this.m.len;
        }

        public int getNelems() {
            return this.m.nelems;
        }

        public String getDataType() {
            return this.m.dataType == null ? "" : this.m.dataType.toString();
        }

        public String getVarname() {
            return this.m.varName;
        }

        public long getFilePos() {
            return this.m.filePos;
        }
    }
}

